/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.updater;

import com.iscobol.updater.Messages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.DefaultCaret;

public class NotificationWindow
extends JFrame {
    private boolean interrupted;
    private boolean showDetails;
    private JTextArea logTxt;
    private JScrollPane scrollPane;
    private JButton interruptBtn;
    private JButton detailBtn;
    private JCheckBox closeChk;
    private JLabel activityLbl;
    private JLabel locationLbl;
    private JLabel fileNameLbl;
    private JLabel customIconLbl;
    private JProgressBar progress;
    private static final int PREF_WIDTH = 550;

    public NotificationWindow(String title, boolean closeWhenFinish) {
        this.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosed(WindowEvent evt) {
                NotificationWindow notificationWindow = NotificationWindow.this;
                synchronized (notificationWindow) {
                    NotificationWindow.this.notify();
                }
                NotificationWindow.this.interrupted = true;
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                NotificationWindow.this.dispose();
            }
        });
        this.setTitle(title);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel topPanel = new JPanel(new BorderLayout(5, 10));
        this.activityLbl = new JLabel();
        this.activityLbl.setFont(new Font("Dialog", 1, 20));
        topPanel.add((Component)this.activityLbl, "Center");
        this.customIconLbl = new JLabel(new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("deficon64x64.png"))));
        topPanel.add((Component)this.customIconLbl, "East");
        topPanel.setPreferredSize(new Dimension(550, 100));
        topPanel.setBackground(Color.white);
        topPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.darkGray), BorderFactory.createEmptyBorder(8, 10, 8, 10)));
        this.getContentPane().add((Component)topPanel, "North");
        JPanel centerPanel = new JPanel(new BorderLayout(5, 10));
        JPanel infoPanel = new JPanel(new GridLayout(2, 0, 5, 10));
        infoPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        this.locationLbl = new JLabel();
        this.locationLbl.setFont(new Font("Dialog", 0, 12));
        this.setLocation("");
        infoPanel.add(this.locationLbl);
        this.fileNameLbl = new JLabel();
        this.fileNameLbl.setFont(new Font("Dialog", 0, 12));
        this.setFilename("");
        infoPanel.add(this.fileNameLbl);
        centerPanel.add((Component)infoPanel, "North");
        this.progress = new JProgressBar(0);
        this.progress.setPreferredSize(new Dimension(0, 25));
        this.progress.setIndeterminate(true);
        centerPanel.add((Component)this.progress, "Center");
        JPanel p = new JPanel(new FlowLayout(2, 15, 10));
        this.detailBtn = new JButton(this.msg(Messages.SHOW_DETAILS) + " >>");
        this.detailBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NotificationWindow.this.showDetails) {
                    NotificationWindow.this.detailBtn.setText(NotificationWindow.this.msg(Messages.SHOW_DETAILS) + " >>");
                    NotificationWindow.this.showDetails = false;
                    NotificationWindow.this.scrollPane.setVisible(false);
                    NotificationWindow.this.pack();
                } else {
                    NotificationWindow.this.detailBtn.setText("<< " + NotificationWindow.this.msg(Messages.HIDE_DETAILS));
                    NotificationWindow.this.showDetails = true;
                    NotificationWindow.this.scrollPane.setVisible(true);
                    NotificationWindow.this.pack();
                }
                NotificationWindow.this.setLocationRelativeTo(null);
            }
        });
        Dimension d1 = this.detailBtn.getPreferredSize();
        this.interruptBtn = new JButton(this.msg(Messages.INTERRUPT));
        this.interruptBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotificationWindow.this.dispose();
            }
        });
        Dimension d2 = this.interruptBtn.getPreferredSize();
        Dimension prefSize = new Dimension(Math.max(d1.width, d2.width), Math.max(d1.height, d2.height));
        this.detailBtn.setPreferredSize(prefSize);
        this.interruptBtn.setPreferredSize(prefSize);
        p.add(this.detailBtn);
        p.add(this.interruptBtn);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        this.closeChk = new JCheckBox(this.msg(Messages.CLOSE_WHEN_FINISH));
        this.closeChk.setSelected(closeWhenFinish);
        bottomPanel.add((Component)this.closeChk, "West");
        bottomPanel.add((Component)p, "Center");
        centerPanel.add((Component)bottomPanel, "South");
        centerPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.getContentPane().add((Component)centerPanel, "Center");
        this.logTxt = new JTextArea();
        this.logTxt.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.logTxt.setEditable(false);
        DefaultCaret caret = (DefaultCaret)this.logTxt.getCaret();
        caret.setUpdatePolicy(2);
        this.scrollPane = new JScrollPane(this.logTxt, 22, 32);
        this.scrollPane.setPreferredSize(new Dimension(0, 500));
        this.getContentPane().add((Component)this.scrollPane, "South");
        this.scrollPane.setVisible(false);
        this.rootPane.setDefaultButton(this.interruptBtn);
        this.interruptBtn.requestFocus();
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public boolean getCloseWhenFinish() {
        return this.closeChk.isSelected();
    }

    public void setActivityName(String name) {
        this.activityLbl.setText(name);
    }

    public void setCustomIcon(String imageFile) {
        this.customIconLbl.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().createImage(imageFile)));
    }

    public void setLocation(String loc) {
        this.locationLbl.setText("<html><b>" + this.msg(Messages.LOCATION) + ":</b> " + loc + "</html>");
    }

    public void setFilename(String fn) {
        this.fileNameLbl.setText("<html><b>" + this.msg(Messages.FILENAME) + ":</b> " + fn + "</html>");
    }

    private String msg(Messages message) {
        return message.msg();
    }

    public void log(String msg) throws Interrupt {
        this.logTxt.append(msg);
        this.logTxt.append("\n");
        if (this.interrupted) {
            throw new Interrupt();
        }
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public void showMessage(String msg, String title, int msgType) {
        this.progress.setIndeterminate(false);
        if (this.isVisible()) {
            JOptionPane.showMessageDialog(this, msg, title, msgType);
        } else if (msgType == 0) {
            System.err.println(msg);
        } else {
            System.out.println(msg);
        }
    }

    public void ko(String msg) {
        this.showMessage(msg, this.getTitle(), 0);
    }

    public void oo(String msg) {
        this.showMessage(msg, this.getTitle(), 2);
    }

    public void ok(String msg) {
        this.showMessage(msg, this.getTitle(), 1);
    }

    public static void main(String[] args) throws Exception {
        NotificationWindow w = new NotificationWindow("Test", true);
        w.setActivityName("Download application...");
        w.setLocation("https://update.veryant.com");
        w.setFilename("iscobol_setup.zip");
        w.setVisible(true);
        for (int i = 0; i < 100; ++i) {
            System.out.println(">>> " + i);
            w.log(">>> " + i);
            Thread.sleep(1000L);
        }
    }

    public static class Interrupt
    extends Exception {
    }
}

