/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.updater;

import com.iscobol.logger.IscobolFormatter;
import com.iscobol.rts.OSValidator;
import com.iscobol.rts.RtsUtil;
import com.iscobol.rts.RuntimeProperties;
import com.iscobol.rts.SoftwareUpdaterIntf;
import com.iscobol.updater.DirectoryCleaner;
import com.iscobol.updater.Messages;
import com.iscobol.updater.NotificationWindow;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.JOptionPane;

public class SoftwareUpdater
implements SoftwareUpdaterIntf {
    private static final Class CLEANER_CLASS = DirectoryCleaner.class;
    private Properties locProps = new Properties();
    private final Properties remProps = new Properties();
    private File propsFile;
    private NotificationWindow nWin;
    private int updateOk;
    private int updateTot;
    private int exitCode = 3;
    private int connectionTimeout;
    private Logger logger;
    private Handler loggerHandler;
    private boolean logging;
    private long timestamp;
    private Set<String> directoriesToClean = new HashSet<String>();
    private boolean trustedAllCerts;
    private String updSiteName;
    private final String[][] localVariables = new String[][]{{"${iscobol.home}", RtsUtil.getIscobolInstallLocation()}, {"${java.home}", System.getProperty("java.home", "${java.home}")}, {"${user.home}", System.getProperty("user.home", "${user.home}")}, {"${user.temp}", System.getProperty("java.io.tmpdir", "${user.temp}")}};

    private void trustAllCertificates() throws Exception {
        if (!this.trustedAllCerts) {
            String h;
            this.trustedAllCerts = true;
            try {
                h = new URL(this.updSiteName).getHost();
            }
            catch (MalformedURLException ex) {
                h = "";
            }
            final String hostname = h;
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, null);
            SSLSocketFactory sslSocketFactory = sc.getSocketFactory();
            HostnameVerifier hostnameVerifier = new HostnameVerifier(){

                @Override
                public boolean verify(String host, SSLSession session) {
                    return host.equals(hostname);
                }
            };
            HttpsURLConnection.setDefaultSSLSocketFactory(sslSocketFactory);
            HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
        }
    }

    private String msg(Messages message) {
        return message.msg();
    }

    private void end(Messages message, String descr) {
        String m = this.msg(message);
        if (descr != null) {
            m = m + descr;
        }
        if (this.logging) {
            this.logger.severe(m);
        }
        this.nWin.ko(m);
        this.exitCode = 2;
    }

    private void alert(Messages message, String descr) {
        if (descr != null) {
            JOptionPane.showMessageDialog(null, this.msg(message) + descr, this.msg(Messages.ALERT), 0);
        } else {
            JOptionPane.showMessageDialog(null, this.msg(message), this.msg(Messages.ALERT), 0);
        }
    }

    private void log(String mesg) throws NotificationWindow.Interrupt {
        if (this.logging) {
            this.logger.info(mesg);
        }
        this.nWin.log(mesg);
    }

    private void logError(String mesg) throws NotificationWindow.Interrupt {
        if (this.logging) {
            this.logger.severe(mesg);
        }
        this.nWin.log(mesg);
    }

    private void log(Properties props) throws NotificationWindow.Interrupt {
        this.nWin.log("#-----------------");
        Enumeration<Object> en = props.keys();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            Object value = props.get(key);
            this.nWin.log("" + key + "=" + value);
        }
        this.nWin.log("#-----------------");
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String propFileName, String customIcon, boolean stop, boolean notificationWindowVisible) {
        String mainclass;
        if (propFileName != null) {
            this.propsFile = new File(propFileName);
        }
        this.nWin = new NotificationWindow(this.msg(Messages.CHECKING), !stop);
        this.nWin.setActivityName(this.msg(Messages.DOWNLOAD_APP));
        if (customIcon != null) {
            this.nWin.setCustomIcon(customIcon);
        }
        this.nWin.setVisible(notificationWindowVisible);
        try {
            this.doCheck();
            if (!this.nWin.getCloseWhenFinish() && this.exitCode <= 1) {
                if (this.exitCode == 0) {
                    this.nWin.ok(this.msg(Messages.OK_MESSAGE) + ": " + this.updateOk + "/" + this.updateTot);
                } else if (this.updateOk == 0) {
                    this.nWin.ko(this.msg(Messages.OK_MESSAGE) + ": " + this.updateOk + "/" + this.updateTot);
                } else {
                    this.nWin.oo(this.msg(Messages.OK_MESSAGE) + ": " + this.updateOk + "/" + this.updateTot);
                }
            }
        }
        catch (NotificationWindow.Interrupt interrupt) {
        }
        finally {
            this.nWin.dispose();
        }
        if ((mainclass = this.getLocalProperty("swupdater.mainclass", false)) != null) {
            String[] cmdArray = mainclass.split(" ");
            if (cmdArray.length == 0) {
                return;
            }
            String[] opts = new String[cmdArray.length - 1];
            for (int i = 1; i < cmdArray.length; ++i) {
                opts[i - 1] = cmdArray[i];
            }
            try {
                this.runMainClass(cmdArray[0], opts);
            }
            catch (Exception ex) {
                this.alert(Messages.IO_ERROR, ex.toString());
            }
        }
    }

    public String findPropertiesFileName() {
        String propFileName = "isupdater.properties";
        File f = new File("isupdater.properties");
        if (f.exists() && f.isFile()) {
            return "isupdater.properties";
        }
        String classpath = System.getProperty("java.class.path");
        StringTokenizer stn = new StringTokenizer(classpath, Character.toString(File.pathSeparatorChar));
        while (stn.hasMoreTokens()) {
            String fn = stn.nextToken() + File.separator + "isupdater.properties";
            f = new File(fn);
            if (!f.exists() || !f.isFile()) continue;
            return fn;
        }
        return null;
    }

    public void runMainClass(String className, String[] args) throws Exception {
        if (this.updateOk > 0 || SoftwareUpdater.isTrue(this.getLocalProperty("swupdater.new_jvm_always", false))) {
            String jvmOpt;
            String arg;
            RuntimeMXBean mxbean;
            String separator = System.getProperty("file.separator");
            String classpath = System.getProperty("java.class.path");
            String path = System.getProperty("java.home") + separator + "bin" + separator + "java";
            ArrayList<String> argList = new ArrayList<String>();
            argList.add(path);
            if (classpath != null && classpath.length() > 0) {
                argList.add("-cp");
                argList.add(classpath);
            }
            if ((mxbean = ManagementFactory.getRuntimeMXBean()) != null) {
                List<String> inputArgs = mxbean.getInputArguments();
                ListIterator<String> lit = inputArgs.listIterator();
                while (lit.hasNext()) {
                    arg = lit.next();
                    if ("-cp".equals(arg) || "-classpath".equals(arg)) {
                        lit.next();
                        continue;
                    }
                    argList.add(arg);
                }
            }
            if ((jvmOpt = this.getLocalProperty("swupdater.jvm_options", true)) != null) {
                String[] stn = new StringTokenizer(jvmOpt);
                while (stn.hasMoreTokens()) {
                    arg = stn.nextToken();
                    if ("-cp".equals(arg) || "-classpath".equals(arg)) continue;
                    argList.add(arg);
                }
            }
            argList.add(className);
            for (String a : args) {
                argList.add(a);
            }
            ProcessBuilder processBuilder = new ProcessBuilder(argList.toArray(new String[argList.size()])).redirectErrorStream(true);
            Process process = processBuilder.start();
            new StreamDreaner(process.getInputStream(), System.out).start();
            new StreamDreaner(process.getErrorStream(), System.err).start();
            try {
                process.waitFor();
            }
            catch (InterruptedException e) {
                process.destroy();
            }
        } else {
            Class<?> clazz = Class.forName(className);
            Method main = clazz.getMethod("main", String[].class);
            main.invoke(null, new Object[]{args});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCheck() throws NotificationWindow.Interrupt {
        Object curVersion;
        String swp;
        String key;
        InputStream isProp;
        String prop;
        if (this.propsFile != null) {
            this.log(this.msg(Messages.OPEN_LOC_CONF_FILE) + ": " + this.propsFile);
            try {
                this.log(this.msg(Messages.LOAD_PROPS) + ": " + this.propsFile);
                RtsUtil.loadProperties((Properties)this.locProps, (File)this.propsFile);
                this.log(this.msg(Messages.LOCAL_PROPS) + ": ");
                this.log(this.locProps);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.logError(this.msg(Messages.FILE_CAN_WRITTEN) + ": " + this.propsFile.canWrite());
            if (!this.propsFile.canWrite()) {
                this.end(Messages.NOT_WRITABLE, ": " + this.propsFile.getPath());
                return;
            }
        }
        this.updSiteName = this.getLocalProperty("swupdater.site", true);
        this.nWin.setLocation(this.updSiteName);
        if (this.updSiteName == null) {
            this.end(Messages.MISSING_SITE, ": swupdater.site");
            return;
        }
        if (this.updSiteName.startsWith("https://") && (prop = this.getLocalProperty("swupdater.net.ssl.trust_store", true)) != null && prop.length() > 0 && !"*".equals(prop)) {
            System.setProperty("javax.net.ssl.trustStore", prop);
            prop = this.getLocalProperty("swupdater.net.ssl.trust_store_password", false);
            if (prop != null) {
                System.setProperty("javax.net.ssl.trustStorePassword", prop);
            }
        }
        String propFileUrl = this.updSiteName + "/" + "swupdater.properties";
        this.logging = SoftwareUpdater.isTrue(this.getLocalProperty("swupdater.logging", false));
        if (this.logging) {
            this.logger = Logger.getAnonymousLogger();
            String logfile = this.getLocalProperty("swupdater.logfile", true);
            try {
                this.logger.setLevel(Level.FINEST);
                this.logger.setUseParentHandlers(false);
                this.loggerHandler = new FileHandler(logfile, false);
                this.logger.addHandler(this.loggerHandler);
                this.loggerHandler.setFormatter((Formatter)new IscobolFormatter());
            }
            catch (IOException e) {
                this.logger.warning("SoftwareUpdater :" + e.getMessage());
            }
        }
        if ((isProp = this.download(propFileUrl, this.connectionTimeout)) == null) {
            return;
        }
        try {
            this.log(this.msg(Messages.DOWNLOAD) + ": " + propFileUrl);
            RtsUtil.loadProperties((Properties)this.remProps, (InputStream)isProp);
        }
        catch (IOException _ex) {
            System.out.println(_ex);
            this.end(Messages.CANNOT_DOWNLOAD, ": " + propFileUrl);
            return;
        }
        this.log(this.msg(Messages.REM_PROPS) + ": ");
        this.log(this.remProps);
        String javaVersion = this.remProps.getProperty("swupdater.version.java");
        this.log(this.msg(Messages.REQ_JV) + ": " + javaVersion);
        if (javaVersion != null) {
            String thisVersion = System.getProperty("java.version");
            this.log(this.msg(Messages.CURR_JV) + ": " + thisVersion);
            if (RtsUtil.revisionCmp((String)thisVersion, (String)javaVersion) < 0) {
                this.end(Messages.NEW_JVM_REQUIRED, ": " + javaVersion);
                return;
            }
        }
        LinkedHashMap<String, String[]> updateMap = new LinkedHashMap<String, String[]>();
        Enumeration<Object> en = this.locProps.keys();
        while (en.hasMoreElements()) {
            key = en.nextElement().toString();
            if (!key.startsWith("swupdater.version.")) continue;
            swp = key.substring("swupdater.version.".length());
            curVersion = this.getLocalProperty("swupdater.version." + swp, false);
            String newVersion = this.remProps.getProperty("swupdater.version." + swp);
            if (newVersion != null) {
                if (curVersion == null || RtsUtil.revisionCmp((String)curVersion, (String)newVersion) < 0) {
                    updateMap.put(swp, new String[]{curVersion, newVersion});
                    continue;
                }
                this.log(this.msg(Messages.SW_PKG) + ": " + swp);
                this.log(this.msg(Messages.CURR_V) + ": " + newVersion);
                this.log(this.msg(Messages.AVAIL_V) + ": " + newVersion);
                this.log(this.msg(Messages.NO_UPDT_REQUIRED));
                continue;
            }
            this.log(this.msg(Messages.SW_PKG) + ": " + swp);
            this.log(this.msg(Messages.NO_MATCH));
        }
        en = this.remProps.keys();
        while (en.hasMoreElements()) {
            key = en.nextElement().toString();
            if (!key.startsWith("swupdater.version.")) continue;
            swp = key.substring("swupdater.version.".length());
            curVersion = this.getLocalProperty("swupdater.version." + swp, false);
            if (curVersion != null) continue;
            this.log(this.msg(Messages.SW_PKG) + ": " + swp);
            this.log(this.msg(Messages.NO_MATCH));
        }
        if (!updateMap.isEmpty() && !this.nWin.isVisible()) {
            this.nWin.setVisible(true);
        }
        String os = OSValidator.isLinux() ? "linux" : (OSValidator.isMac() ? "mac" : (OSValidator.isWindows() ? "win" : (OSValidator.isSolaris() ? "solaris" : null)));
        String arch = OSValidator.is64bit() ? "64" : "32";
        this.timestamp = System.currentTimeMillis();
        for (String swp2 : updateMap.keySet()) {
            String[] ss = (String[])updateMap.get(swp2);
            this.log(this.msg(Messages.SW_PKG) + ": " + swp2);
            this.log(this.msg(Messages.CURR_V) + ": " + ss[0]);
            this.log(this.msg(Messages.AVAIL_V) + ": " + ss[1]);
            ++this.updateTot;
            if (!this.update(this.updSiteName, swp2, os, arch)) continue;
            this.locProps.setProperty("swupdater.version." + swp2, ss[1]);
            ++this.updateOk;
        }
        if (this.updateOk > 0 && this.propsFile != null) {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(this.propsFile);
                this.locProps.store(out, "Automatically updated");
            }
            catch (FileNotFoundException ex) {
                this.end(Messages.MISSING_FILE, ": " + ex.getMessage());
            }
            catch (IOException ex) {
                this.end(Messages.IO_ERROR, ": " + ex.getMessage());
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException ex) {}
            }
        }
        this.exitCode = this.updateOk == this.updateTot ? 0 : 1;
    }

    static boolean isTrue(String rs) {
        if (rs != null && rs.length() > 0) {
            switch (rs.charAt(0)) {
                case 'T': 
                case 't': {
                    return true;
                }
                case 'Y': 
                case 'y': {
                    return true;
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean update(String updSiteName, String swp, String os, String arch) throws NotificationWindow.Interrupt {
        String libraryName;
        String propName;
        this.nWin.setActivityName(this.msg(Messages.DOWNLOAD_APP));
        boolean failed = true;
        ArrayList<String> propNames = new ArrayList<String>();
        ArrayList<String> libraryNames = new ArrayList<String>();
        if (os != null) {
            propName = "swupdater.lib." + os + "." + arch + "." + swp;
            libraryName = this.remProps.getProperty(propName);
            if (libraryName != null) {
                propNames.add(propName);
                libraryNames.add(libraryName);
            }
            if ((libraryName = this.remProps.getProperty(propName = "swupdater.lib." + os + "." + swp)) != null) {
                propNames.add(propName);
                libraryNames.add(libraryName);
            }
        }
        if ((libraryName = this.remProps.getProperty(propName = "swupdater.lib." + swp)) != null) {
            propNames.add(propName);
            libraryNames.add(libraryName);
        }
        this.nWin.setFilename(swp);
        this.log("library: " + swp);
        File file = null;
        for (int i = 0; i < libraryNames.size(); ++i) {
            String ln = (String)libraryNames.get(i);
            String pn = (String)propNames.get(i);
            if (ln.trim().length() == 0) {
                ln = updSiteName + "/" + pn;
            } else if (!ln.toLowerCase().startsWith("http://")) {
                ln = updSiteName + "/" + ln;
            }
            ZipInputStream isZip = new ZipInputStream(this.download(ln, 0));
            String directory = this.getLocalProperty("swupdater.directory." + swp, true);
            ZipEntry ze = null;
            try {
                failed = false;
                byte[] postUpdate = null;
                byte[] buff = new byte[4096];
                while ((ze = isZip.getNextEntry()) != null && !this.nWin.isInterrupted()) {
                    file = directory != null ? new File(directory + File.separator + ze.getName()) : new File(ze.getName());
                    if (ze.isDirectory()) {
                        file.mkdirs();
                    } else if (postUpdate == null && "POSTUPDATE.class".equals(ze.getName())) {
                        int size = (int)ze.getSize();
                        if (size < 0) {
                            ByteArrayOutputStream bout = new ByteArrayOutputStream();
                            int c = isZip.read();
                            while (c != -1) {
                                bout.write(c);
                                c = isZip.read();
                            }
                            bout.close();
                            postUpdate = bout.toByteArray();
                            size = postUpdate.length;
                            this.log(this.msg(Messages.LOAD) + ": " + file + ", " + this.msg(Messages.SIZE) + "=" + size);
                        } else {
                            this.log(this.msg(Messages.LOAD) + ": " + file + ", " + this.msg(Messages.SIZE) + "=" + size);
                            postUpdate = new byte[size];
                            int c = 0;
                            while ((c += isZip.read(postUpdate, c, size - c)) < size) {
                            }
                        }
                    } else {
                        if (file.getParentFile() != null) {
                            file.getParentFile().mkdirs();
                        }
                        this.log(this.msg(Messages.UNZIP) + ": " + file);
                        FileOutputStream out = new FileOutputStream(file);
                        int c = isZip.read(buff);
                        while (c != -1 && !this.nWin.isInterrupted()) {
                            out.write(buff, 0, c);
                            c = isZip.read(buff);
                        }
                        out.close();
                    }
                    isZip.closeEntry();
                }
                if (this.nWin.isInterrupted()) {
                    throw new NotificationWindow.Interrupt();
                }
                if (directory != null && SoftwareUpdater.isTrue(this.getLocalProperty("swupdater.directory.clean." + swp, false))) {
                    this.directoriesToClean.add(directory);
                }
                this.log(this.msg(Messages.OPERATION_SUCCESSFUL) + ".");
                if (postUpdate != null) {
                    this.exec("POSTUPDATE.class", postUpdate, directory);
                }
            }
            catch (FileNotFoundException ex) {
                this.end(Messages.MISSING_FILE, ": " + file);
                failed = true;
            }
            catch (IOException ex) {
                this.end(Messages.IO_ERROR, ": " + ex.getMessage());
                failed = true;
            }
            try {
                isZip.close();
                continue;
            }
            catch (IOException ex) {
                this.end(Messages.IO_ERROR, ": " + ex.getMessage());
            }
        }
        return !failed;
    }

    private InputStream download(String urlName, int connectionTimeout) throws NotificationWindow.Interrupt {
        URL url;
        InputStream Return = null;
        try {
            this.log("URL: " + urlName);
            url = new URL(urlName);
        }
        catch (MalformedURLException _ex) {
            this.end(Messages.MALFORMED_URL, ": " + urlName);
            return Return;
        }
        try {
            this.log(this.msg(Messages.TRY_CONNECT) + ": " + url);
            URLConnection conn = url.openConnection();
            if (connectionTimeout > 0) {
                conn.setConnectTimeout(connectionTimeout);
            }
            try {
                Return = conn.getInputStream();
            }
            catch (SSLHandshakeException _ex) {
                if (this.updSiteName.startsWith("https://") && SoftwareUpdater.isTrue(this.getLocalProperty("swupdater.http.ignore_certificates", false))) {
                    try {
                        this.trustAllCertificates();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw _ex;
                    }
                    conn = url.openConnection();
                    Return = conn.getInputStream();
                }
                throw _ex;
            }
            this.log(this.msg(Messages.CONNECTED) + ".");
        }
        catch (ConnectException _ex) {
            this.end(Messages.CANNOT_CONNECT, ": " + url);
        }
        catch (FileNotFoundException _ex) {
            this.end(Messages.MISSING_FILE, ": " + url);
        }
        catch (IOException _ex) {
            this.end(Messages.CANNOT_DOWNLOAD, ": " + url + " (" + _ex.getMessage() + ")");
        }
        return Return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exec(String className, byte[] classArray, String arg) {
        this.nWin.setActivityName(this.msg(Messages.INSTALL_APP));
        className = className.substring(0, className.length() - 6);
        MyClassLoader mcl = new MyClassLoader(this.getClass().getClassLoader());
        final SecurityManager csm = System.getSecurityManager();
        try {
            SecurityManager sm = new SecurityManager(){

                @Override
                public void checkExit(int status) {
                    throw new MySecurityException();
                }

                @Override
                public void checkPermission(Permission perm) {
                    if (csm != null) {
                        csm.checkPermission(perm);
                    }
                }
            };
            Class clazz = mcl.defineClass(className, classArray);
            Method main = clazz.getMethod("main", String[].class);
            System.setSecurityManager(sm);
            if (arg == null) {
                arg = ".";
            }
            main.invoke(null, new Object[]{new String[]{arg}});
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (!(cause instanceof MySecurityException)) {
                this.alert(Messages.IO_ERROR, ex.toString());
            }
        }
        catch (IllegalAccessException ex) {
            this.alert(Messages.IO_ERROR, ex.toString());
        }
        catch (NoSuchMethodException ex) {
            this.alert(Messages.IO_ERROR, ex.toString());
        }
        catch (ClassFormatError ex) {
            this.alert(Messages.IO_ERROR, ex.toString());
        }
        finally {
            System.setSecurityManager(csm);
        }
        return false;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public int getUpdateCount() {
        return this.updateTot;
    }

    public int getSuccessfulUpdateCount() {
        return this.updateOk;
    }

    public static void main(String[] args) {
        boolean help = false;
        boolean stop = false;
        String propFileName = null;
        String customIcon = null;
        if (args.length == 1 && args[0].equals("-v")) {
            String version = RuntimeProperties.getFullVersionNumber();
            if (version.startsWith("isCOBOL")) {
                version = "isCOBOL-SoftwareUpdater" + version.substring(7);
            }
            System.out.println(version);
            System.exit(0);
        }
        for (int i = 0; i < args.length; ++i) {
            if ("-stop".equals(args[i])) {
                stop = true;
                continue;
            }
            if (args[i].equals("-c")) {
                propFileName = args[++i];
                continue;
            }
            if (args[i].equals("-icon")) {
                customIcon = args[++i];
                continue;
            }
            help = true;
        }
        SoftwareUpdater su = new SoftwareUpdater();
        if (help) {
            JOptionPane.showMessageDialog(null, su.msg(Messages.HELP), "Help", 1);
            return;
        }
        if (propFileName == null) {
            propFileName = su.findPropertiesFileName();
        }
        su.start(propFileName, customIcon, stop, true);
        su.cleanDirectories();
        su.closeLogger();
        System.exit(su.getExitCode());
    }

    public void cleanDirectories() {
        if (!this.directoriesToClean.isEmpty()) {
            String separator = System.getProperty("file.separator");
            String path = System.getProperty("java.home") + separator + "bin" + separator + "java";
            ArrayList<String> argList = new ArrayList<String>();
            argList.add(path);
            argList.add("-cp");
            argList.add(new File(CLEANER_CLASS.getProtectionDomain().getCodeSource().getLocation().getPath().replace("%20", " ")).getAbsolutePath());
            argList.add(CLEANER_CLASS.getName());
            argList.add(Long.toString(this.timestamp));
            for (String directory : this.directoriesToClean) {
                if (this.logging) {
                    this.logger.info(this.msg(Messages.CLEAN) + " " + directory);
                }
                argList.add(directory);
            }
            ProcessBuilder processBuilder = new ProcessBuilder(argList.toArray(new String[argList.size()])).redirectErrorStream(true);
            try {
                processBuilder.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void closeLogger() {
        if (this.logger != null && this.loggerHandler != null) {
            this.logger.removeHandler(this.loggerHandler);
            this.loggerHandler.close();
        }
    }

    private String getLocalProperty(String propName, boolean expandVariables) {
        String propValue = this.locProps.getProperty(propName);
        if (expandVariables && propValue != null) {
            for (String[] var : this.localVariables) {
                propValue = propValue.replace(var[0], var[1]);
            }
        }
        return propValue;
    }

    public Properties getLocalProperties() {
        return this.locProps;
    }

    public void setLocalProperties(Properties props) {
        this.locProps = props;
    }

    static {
        StreamDreaner.class.getName();
    }

    private static class StreamDreaner
    extends Thread {
        final InputStream in;
        final PrintStream out;

        StreamDreaner(InputStream in, PrintStream out) {
            this.in = in;
            this.out = out;
        }

        @Override
        public void run() {
            try {
                BufferedReader r = new BufferedReader(new InputStreamReader(this.in));
                String s = r.readLine();
                while (s != null) {
                    this.out.println(s);
                    s = r.readLine();
                }
                r.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    class MySecurityException
    extends SecurityException {
        private static final long serialVersionUID = 1L;

        MySecurityException() {
        }
    }

    class MyClassLoader
    extends ClassLoader {
        public MyClassLoader(ClassLoader cl) {
            super(cl);
        }

        public Class defineClass(String n, byte[] a) {
            return super.defineClass(n, a, 0, a.length);
        }
    }
}

