/*
 * Decompiled with CFR 0.152.
 */
package calendarpanel;

import java.util.Calendar;
import java.util.Date;
import javax.swing.Icon;
import org.jbundle.util.calendarpanel.model.CalendarItem;

public class CalendarPanelItem
implements CalendarItem,
Comparable<CalendarPanelItem> {
    private static Calendar calendar = Calendar.getInstance();
    private Date startDate;
    private Date endDate;
    private String description;
    private String mealDescription;
    private Icon iconStart;
    private Icon iconEnd;
    private int highlightColor;
    private int selectColor;

    public CalendarPanelItem(Date date, String string) {
        this(date, null, string, null, null, null, 0, 0);
    }

    public CalendarPanelItem(Date date, Date date2, String string, String string2, Icon icon, Icon icon2, int n, int n2) {
        this.setStartDate(date);
        this.setEndDate(date2);
        this.setDescription(string);
        this.setMealDescription(string2);
        this.setIcon(icon, 1000);
        this.setIcon(icon2, 1010);
        this.setHighlightColor(n);
        this.setSelectColor(n2);
    }

    public boolean remove() {
        return false;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public String getMealDesc(Date date) {
        if (!date.before(this.startDate) && !date.after(this.endDate)) {
            return this.mealDescription;
        }
        return null;
    }

    public Object getIcon(int n) {
        if (n == 1000) {
            return this.iconStart;
        }
        if (n == 1010) {
            return this.iconEnd;
        }
        return null;
    }

    public int getHighlightColor() {
        return this.highlightColor;
    }

    public int getSelectColor() {
        return this.selectColor;
    }

    public Date setStartDate(Date date) {
        this.startDate = date;
        return date;
    }

    public Date setEndDate(Date date) {
        this.endDate = date;
        if (this.endDate == null) {
            calendar.setTime(this.startDate);
            calendar.add(5, 1);
            this.endDate = calendar.getTime();
        }
        return this.endDate;
    }

    public void setIcon(Object object, int n) {
        if (object instanceof Icon) {
            if (n == 1000) {
                this.iconStart = (Icon)object;
            } else if (n == 1010) {
                this.iconEnd = (Icon)object;
            }
        } else if (object == null) {
            if (n == 1000) {
                this.iconStart = null;
            } else if (n == 1010) {
                this.iconEnd = null;
            }
        }
    }

    public Object getVisualJavaBean(int n) {
        return null;
    }

    public int getStatus() {
        return 1;
    }

    public int setStatus(int n) {
        return 0;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setMealDescription(String string) {
        this.mealDescription = string;
    }

    public void setHighlightColor(int n) {
        this.highlightColor = n;
    }

    public void setSelectColor(int n) {
        this.selectColor = n;
    }

    public boolean equals(Object object) {
        if (object instanceof CalendarPanelItem) {
            CalendarPanelItem calendarPanelItem = (CalendarPanelItem)object;
            return this.startDate.equals(calendarPanelItem.startDate) && this.description.equals(calendarPanelItem.description);
        }
        return false;
    }

    @Override
    public int compareTo(CalendarPanelItem calendarPanelItem) {
        int n = this.startDate.compareTo(calendarPanelItem.startDate);
        if (n == 0) {
            n = this.description.compareTo(calendarPanelItem.description);
        }
        return n;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.startDate.toString() + "/" + this.description;
    }
}

