/*
 * Decompiled with CFR 0.152.
 */
package calendarpanel;

import calendarpanel.CalendarPanelItem;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventListener;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.ImageIcon;
import org.jbundle.util.calendarpanel.event.MyListSelectionListener;
import org.jbundle.util.calendarpanel.model.CalendarItem;
import org.jbundle.util.calendarpanel.model.swing.AbstractCalendarModel;

public class CalendarPanelModel
extends AbstractCalendarModel {
    private static final long serialVersionUID = 1L;
    private Vector<CalendarPanelItem> items = new Vector();
    private Set<CalendarPanelItem> itemSet = new TreeSet<CalendarPanelItem>();
    private Date startDate;
    private Date endDate;

    public void addMySelectionListener(EventListener eventListener) {
        if (!this.contains(eventListener)) {
            this.listenerList.add(MyListSelectionListener.class, (MyListSelectionListener)eventListener);
        }
    }

    private boolean contains(EventListener eventListener) {
        EventListener[] eventListenerArray = this.listenerList.getListeners(MyListSelectionListener.class);
        if (eventListenerArray == null) {
            return false;
        }
        for (EventListener eventListener2 : eventListenerArray) {
            if (eventListener2 != eventListener) continue;
            return true;
        }
        return false;
    }

    public void free() {
        this.items.clear();
        this.itemSet.clear();
    }

    public CalendarItem getItem(int n) {
        return this.items.elementAt(n);
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date date) {
        this.startDate = date;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date date) {
        this.endDate = date;
    }

    public Date getSelectDate() {
        return this.startDate;
    }

    public ImageIcon getHeaderIcon() {
        return null;
    }

    public int getRowCount() {
        return this.items.size();
    }

    public void addItem(CalendarPanelItem calendarPanelItem) {
        if (this.itemSet.contains(calendarPanelItem)) {
            this.items.remove(calendarPanelItem);
            this.itemSet.remove(calendarPanelItem);
        }
        this.items.addElement(calendarPanelItem);
        this.itemSet.add(calendarPanelItem);
    }

    public CalendarPanelItem[] getItems() {
        return this.items.toArray(new CalendarPanelItem[this.items.size()]);
    }

    public CalendarPanelItem[] getItems(Date date) {
        ArrayList<CalendarPanelItem> arrayList = new ArrayList<CalendarPanelItem>();
        for (CalendarPanelItem calendarPanelItem : this.items) {
            if (!calendarPanelItem.getStartDate().equals(date)) continue;
            arrayList.add(calendarPanelItem);
        }
        return arrayList.toArray(new CalendarPanelItem[arrayList.size()]);
    }

    public CalendarPanelItem removeItem(int n) {
        CalendarPanelItem calendarPanelItem = this.items.remove(n);
        if (calendarPanelItem != null) {
            this.itemSet.remove(calendarPanelItem);
        }
        return calendarPanelItem;
    }

    public void removeItem(CalendarPanelItem calendarPanelItem) {
        this.items.remove(calendarPanelItem);
        this.itemSet.remove(calendarPanelItem);
    }
}

