/*
 * Decompiled with CFR 0.152.
 */
package calendarpanel;

import calendarpanel.CalendarPanelEvent;
import calendarpanel.CalendarPanelItem;
import calendarpanel.CalendarPanelListener;
import calendarpanel.CalendarPanelModel;
import com.toedter.calendar.JCalendar;
import com.toedter.calendar.JMonthChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jbundle.util.calendarpanel.CalendarPane;
import org.jbundle.util.calendarpanel.CalendarPanel;
import org.jbundle.util.calendarpanel.event.MyListSelectionEvent;
import org.jbundle.util.calendarpanel.model.CalendarItem;
import org.jbundle.util.calendarpanel.model.CalendarModel;
import org.jbundle.util.calendarpanel.util.CalendarCache;

public class JCalendarPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JCalendar jcalendar;
    private Calendar calendar = Calendar.getInstance();
    private CalendarPanel calendarPanel;
    private Date lastDate;
    private CalendarPanelModel model = new CalendarPanelModel();
    private Vector<CalendarPanelListener> listeners = new Vector();
    private Icon defaultIconStart;
    private Icon defaultIconEnd;
    private int defaultHighlightColor = 0xE0FFFF;
    private int defaultSelectColor = 0xC0FFFF;

    public JCalendarPanel() {
        super(new BorderLayout());
        this.jcalendar = new JCalendar(){
            private static final long serialVersionUID = 1L;

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                super.propertyChange(propertyChangeEvent);
                if (JCalendarPanel.this.listeners != null && (propertyChangeEvent.getPropertyName().equals("date") || propertyChangeEvent.getPropertyName().equals("day") || propertyChangeEvent.getPropertyName().equals("month") || propertyChangeEvent.getPropertyName().equals("year"))) {
                    int n = -1;
                    int n2 = -1;
                    if (JCalendarPanel.this.lastDate != null) {
                        JCalendarPanel.this.calendar.setTime(JCalendarPanel.this.lastDate);
                        n = JCalendarPanel.this.calendar.get(2);
                        n2 = JCalendarPanel.this.calendar.get(1);
                    }
                    Date date = JCalendarPanel.this.jcalendar.getDate();
                    JCalendarPanel.this.calendar.setTime(date);
                    int n3 = JCalendarPanel.this.calendar.get(2);
                    int n4 = JCalendarPanel.this.calendar.get(1);
                    JCalendarPanel.this.lastDate = date;
                    if (n != n3 || n2 != n4) {
                        JCalendarPanel.this.setupCalendarPanel(JCalendarPanel.this.lastDate);
                    }
                    JCalendarPanel.this.fireDateChangedEvent(date);
                }
            }
        };
        this.calendarPanel = new CalendarPanel((CalendarModel)this.model, true, null){
            private static final long serialVersionUID = 1L;

            public void selectionChanged(MyListSelectionEvent myListSelectionEvent) {
                CalendarCache calendarCache;
                super.selectionChanged(myListSelectionEvent);
                if (myListSelectionEvent.getType() == 35 && (calendarCache = JCalendarPanel.this.calendarPanel.getSelectedItem()) != null) {
                    CalendarItem calendarItem = calendarCache.getItem();
                    JCalendarPanel.this.fireItemClickedEvent(calendarItem.getStartDate(), calendarItem.getDescription());
                }
            }
        };
        this.calendarPanel.addPropertyChangeListener("date", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                CalendarPane calendarPane = JCalendarPanel.this.calendarPanel.getComponentAtDate((Date)propertyChangeEvent.getNewValue());
                if (calendarPane != null) {
                    JCalendarPanel.this.firePanelClickedEvent(calendarPane.getThisDate());
                }
            }
        });
        this.calendarPanel.setFocusable(false);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.jcalendar, "North");
        jPanel.add((Component)new JLabel(), "Center");
        this.add((Component)jPanel, "West");
        this.add((Component)this.calendarPanel, "Center");
        this.lastDate = this.jcalendar.getDate();
        this.setupCalendarPanel(this.lastDate);
    }

    private void setupCalendarPanel(Date date) {
        this.calendar.setTime(date);
        int n = this.calendar.get(2);
        int n2 = this.calendar.get(1);
        this.calendar.set(n2, n, 1);
        Date date2 = this.calendar.getTime();
        this.calendar.set(n2, n, this.calendar.getActualMaximum(5));
        Date date3 = this.calendar.getTime();
        this.calendarPanel.setupCalendar(date2, date3, false);
        this.model.setStartDate(date2);
        this.model.setEndDate(date3);
        this.calendarPanel.setModel((CalendarModel)this.model, true);
    }

    public void addCalendarPanelListener(CalendarPanelListener calendarPanelListener) {
        if (!this.listeners.contains(calendarPanelListener)) {
            this.listeners.addElement(calendarPanelListener);
        }
    }

    public void removeCalendarPanelListener(CalendarPanelListener calendarPanelListener) {
        this.listeners.removeElement(calendarPanelListener);
    }

    protected void fireDateChangedEvent(Date date) {
        CalendarPanelEvent calendarPanelEvent = new CalendarPanelEvent(this, date, null, 1);
        for (CalendarPanelListener calendarPanelListener : this.listeners) {
            calendarPanelListener.dateChanged(calendarPanelEvent);
        }
    }

    protected void firePanelClickedEvent(Date date) {
        CalendarPanelEvent calendarPanelEvent = new CalendarPanelEvent(this, date, null, 3);
        for (CalendarPanelListener calendarPanelListener : this.listeners) {
            calendarPanelListener.panelClicked(calendarPanelEvent);
        }
    }

    protected void fireItemClickedEvent(Date date, String string) {
        CalendarPanelEvent calendarPanelEvent = new CalendarPanelEvent(this, date, string, 2);
        for (CalendarPanelListener calendarPanelListener : this.listeners) {
            calendarPanelListener.itemClicked(calendarPanelEvent);
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.jcalendar != null) {
            this.jcalendar.setFont(font);
            JMonthChooser jMonthChooser = this.jcalendar.getMonthChooser();
            if (jMonthChooser != null) {
                jMonthChooser.setPreferredSize(new Dimension(jMonthChooser.getPreferredSize().width, this.getFontMetrics(font).getHeight() + 10));
            }
            this.calendarPanel.setFont(font);
        }
    }

    public void setDate(Date date) {
        this.jcalendar.setDate(date);
    }

    public Date getDate() {
        return this.jcalendar.getDate();
    }

    public void addItem(Date date, String string) {
        this.model.addItem(new CalendarPanelItem(date, null, string, null, this.getDefaultIconStart(), this.getDefaultIconEnd(), this.getDefaultHighlightColor(), this.getDefaultSelectColor()));
        this.model.fireTableRowsInserted(this.model.getRowCount() - 1, this.model.getRowCount() - 1);
    }

    public void addItem(Date date, Date date2, String string, String string2, Icon icon, Icon icon2, int n, int n2) {
        this.model.addItem(new CalendarPanelItem(date, date2, string, string2, icon, icon2, n, n2));
        this.model.fireTableRowsInserted(this.model.getRowCount() - 1, this.model.getRowCount() - 1);
    }

    public CalendarPanelItem[] getItems(Date date) {
        return this.model.getItems(date);
    }

    public CalendarPanelItem[] getItems() {
        return this.model.getItems();
    }

    public void removeAllItems() {
        this.model.free();
    }

    public CalendarPanelItem[] removeItems(Date date) {
        CalendarPanelItem[] calendarPanelItemArray;
        for (CalendarPanelItem calendarPanelItem : calendarPanelItemArray = this.model.getItems(date)) {
            this.model.removeItem(calendarPanelItem);
        }
        return calendarPanelItemArray;
    }

    public void removeItem(Date date, String string) {
        this.model.removeItem(new CalendarPanelItem(date, string));
    }

    public Icon getDefaultIconStart() {
        return this.defaultIconStart;
    }

    public void setDefaultIconStart(Icon icon) {
        this.defaultIconStart = icon;
    }

    public Icon getDefaultIconEnd() {
        return this.defaultIconEnd;
    }

    public void setDefaultIconEnd(Icon icon) {
        this.defaultIconEnd = icon;
    }

    public int getDefaultHighlightColor() {
        return this.defaultHighlightColor;
    }

    public void setDefaultHighlightColor(int n) {
        this.defaultHighlightColor = n;
    }

    public int getDefaultSelectColor() {
        return this.defaultSelectColor;
    }

    public void setDefaultSelectColor(int n) {
        this.defaultSelectColor = n;
    }

    @Override
    public void requestFocus() {
        this.jcalendar.requestFocus();
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.jcalendar.requestFocusInWindow();
    }

    @Override
    public void addKeyListener(KeyListener keyListener) {
        this.jcalendar.addKeyListener(keyListener);
    }

    @Override
    public void removeKeyListener(KeyListener keyListener) {
        this.jcalendar.removeKeyListener(keyListener);
    }

    @Override
    public void addFocusListener(FocusListener focusListener) {
        this.jcalendar.addFocusListener(focusListener);
    }

    @Override
    public void removeFocusListener(FocusListener focusListener) {
        this.jcalendar.removeFocusListener(focusListener);
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        this.jcalendar.addMouseListener(mouseListener);
        this.calendarPanel.addMouseListener(mouseListener);
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
        this.jcalendar.removeMouseListener(mouseListener);
        this.calendarPanel.removeMouseListener(mouseListener);
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.jcalendar.addMouseMotionListener(mouseMotionListener);
        this.calendarPanel.addMouseMotionListener(mouseMotionListener);
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.jcalendar.removeMouseMotionListener(mouseMotionListener);
        this.calendarPanel.removeMouseMotionListener(mouseMotionListener);
    }
}

