/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.wow.gui.client.AxCTGRIDLib;

import com.veryant.wow.gui.client.AxCTGRIDLib.AxctGrid;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public class GridRowHeaderRenderer
extends JComponent
implements ListCellRenderer {
    final AxctGrid grid;
    private ImageIcon rightArrow;
    private Color backColor;
    private Color foreColor;
    private Font font;
    private Color backSelColor;
    private Color foreSelColor;
    private int type = 1;
    private int borderType = 2;
    private int borderSelType = 2;
    private ImageIcon icon;
    private final JLabel label = new JLabel();
    private final JLabel marker = new JLabel(){

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(4, ((GridRowHeaderRenderer)GridRowHeaderRenderer.this).label.getPreferredSize().height);
        }
    };

    GridRowHeaderRenderer(AxctGrid grid) {
        this.grid = grid;
        this.rightArrow = new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("right_arrow.png")));
        this.setLayout(new BorderLayout(0, 0));
        this.label.setOpaque(true);
        this.label.setHorizontalAlignment(0);
        this.label.setVerticalAlignment(0);
        this.marker.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, Color.darkGray));
        this.marker.setOpaque(true);
        this.add((Component)this.label, "Center");
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (isSelected) {
            if (this.backSelColor != null) {
                this.label.setBackground(this.backSelColor);
                this.marker.setBackground(this.backSelColor);
            } else if (this.backColor != null) {
                this.label.setBackground(this.backColor);
                this.marker.setBackground(this.backColor);
            }
            if (this.foreSelColor != null) {
                this.label.setForeground(this.foreSelColor);
            } else if (this.foreColor != null) {
                this.label.setForeground(this.foreColor);
            }
            this.updateBorder(this.borderSelType);
        } else {
            if (this.backColor != null) {
                this.label.setBackground(this.backColor);
                this.marker.setBackground(this.backColor);
            }
            if (this.foreColor != null) {
                this.label.setForeground(this.foreColor);
            }
            this.updateBorder(this.borderType);
        }
        if (this.font != null) {
            this.label.setFont(this.font);
        }
        switch (this.type) {
            default: {
                this.label.setText("");
                this.label.setIcon(isSelected ? this.rightArrow : null);
                break;
            }
            case 2: {
                this.label.setText(Integer.toString(index));
                this.label.setIcon(null);
                break;
            }
            case 3: {
                this.label.setText(Integer.toString(index + 1));
                this.label.setIcon(null);
                break;
            }
            case 4: {
                this.label.setText("");
                this.label.setIcon(isSelected ? this.icon : null);
            }
        }
        return this;
    }

    private void updateBorder(int bt) {
        switch (bt) {
            case 0: {
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                break;
            }
            case 3: {
                this.setBorder(BorderFactory.createLoweredBevelBorder());
                break;
            }
            case 5: {
                this.setBorder(BorderFactory.createLoweredSoftBevelBorder());
                break;
            }
            case 1: {
                this.setBorder(null);
                break;
            }
            default: {
                this.setBorder(BorderFactory.createRaisedBevelBorder());
                break;
            }
            case 4: {
                this.setBorder(BorderFactory.createRaisedSoftBevelBorder());
            }
        }
    }

    void setType(int t) {
        if (this.type != t) {
            this.type = t;
            this.grid.rowHeader.repaint();
        }
    }

    void setBackColor(Color c) {
        if (c != null) {
            this.backColor = c;
            this.grid.rowHeader.repaint();
        }
    }

    void setForeColor(Color c) {
        if (c != null) {
            this.foreColor = c;
            this.grid.rowHeader.repaint();
        }
    }

    void setBackSelColor(Color c) {
        if (c != null) {
            this.backSelColor = c;
            this.grid.rowHeader.repaint();
        }
    }

    void setForeSelColor(Color c) {
        if (c != null) {
            this.foreSelColor = c;
            this.grid.rowHeader.repaint();
        }
    }

    void setHeaderFont(Font f) {
        if (f != null) {
            this.font = f;
            this.grid.rowHeader.repaint();
        }
    }

    void setBorderType(int bt) {
        if (this.borderType != bt) {
            this.borderType = bt;
            this.grid.rowHeader.repaint();
        }
    }

    void setBorderSelType(int bt) {
        if (this.borderSelType != bt) {
            this.borderSelType = bt;
            this.grid.rowHeader.repaint();
        }
    }

    void setImage(Image im) {
        this.icon = im != null ? new ImageIcon(im) : null;
        if (this.type == 4) {
            this.grid.rowHeader.repaint();
        }
    }

    void setMarker(boolean b) {
        if (b && this.getComponentCount() == 1) {
            this.add((Component)this.marker, "East");
            this.doLayout();
            this.grid.rowHeader.repaint();
        } else if (!b && this.getComponentCount() == 2) {
            this.remove(this.marker);
            this.doLayout();
            this.grid.rowHeader.repaint();
        }
    }
}

