/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.wow.gui.client.AxCTGRIDLib;

import com.veryant.wow.gui.client.AxCTGRIDLib.AxctGrid;
import com.veryant.wow.gui.client.AxCTGRIDLib.GridCell;
import com.veryant.wow.gui.client.AxCTGRIDLib.GridColumn;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class GridTable
extends JTable {
    protected final AxctGrid grid;

    protected GridTable(AxctGrid grid) {
        super(grid.tableModel);
        this.setAutoCreateColumnsFromModel(false);
        this.grid = grid;
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        GridColumn c = this.grid.tableModel.getGridColumn(column);
        switch (c.dataType) {
            case 6: {
                return this.grid.tableBooleanCellRenderer;
            }
            case 3: {
                return this.grid.tableDateCellRenderer;
            }
        }
        return this.grid.tableCellRenderer;
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        GridColumn c = this.grid.tableModel.getGridColumn(column);
        switch (c.dataType) {
            case 3: {
                return this.grid.tableDateCellEditor;
            }
        }
        return super.getCellEditor(row, column);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        int colIdx;
        int rowIdx;
        if ((this.grid.getTipsType() == 2 || this.grid.getTipsType() == 3) && (rowIdx = this.grid.table.rowAtPoint(event.getPoint())) >= 0 && rowIdx < this.grid.values.size() && (colIdx = this.grid.table.columnAtPoint(event.getPoint())) >= 0 && colIdx < this.grid.values.elementAt(rowIdx).size() && colIdx < this.grid.columns.size()) {
            TableCellRenderer rdr;
            Component c;
            GridCell cell = this.grid.values.elementAt(rowIdx).elementAt(colIdx);
            if (cell.data != null && (c = (rdr = this.getCellRenderer(rowIdx, colIdx)).getTableCellRendererComponent(this.grid.table, cell.data, false, false, rowIdx, colIdx)) instanceof JLabel) {
                JLabel lbl = (JLabel)c;
                GridColumn gc = this.grid.columns.elementAt(colIdx);
                Insets ins = lbl.getInsets();
                if (ins == null) {
                    ins = new Insets(0, 0, 0, 0);
                }
                int prefWidth = lbl.getPreferredSize().width + ins.left + ins.right;
                if (gc.column != null && gc.column.getWidth() <= prefWidth) {
                    return lbl.getText();
                }
            }
        }
        return super.getToolTipText(event);
    }
}

