/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.wow.gui.client.AxCTGRIDLib;

import com.veryant.wow.gui.client.AxCTGRIDLib.AxctGrid;
import com.veryant.wow.gui.client.AxCTGRIDLib.GridColumn;
import com.veryant.wow.gui.client.AxCTGRIDLib.GridUtils;
import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

class GridTableBooleanRenderer
implements TableCellRenderer,
Serializable {
    final AxctGrid grid;
    private Color backColor;
    private JCheckBox checkBox;

    GridTableBooleanRenderer(AxctGrid g) {
        this.grid = g;
        this.checkBox = new JCheckBox();
        this.checkBox.setHorizontalAlignment(0);
        this.checkBox.setBorderPainted(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.checkBox.setSelected(value == Boolean.TRUE);
        if (hasFocus) {
            this.checkBox.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        } else {
            this.checkBox.setBorder(GridUtils.noFocusBorder);
        }
        GridColumn c = this.grid.tableModel.getGridColumn(column);
        this.backColor = GridUtils.getColor(this.grid, row, this.grid.tableModel.getGridColumn(column), isSelected)[0];
        this.checkBox.setBackground(this.backColor);
        return this.checkBox;
    }
}

