/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.wow.gui.client.AxCTGRIDLib;

import com.toedter.calendar.IDateEditor;
import com.toedter.calendar.JDateChooser;
import com.toedter.calendar.JSpinnerDateEditor;
import com.veryant.wow.gui.client.AxCTGRIDLib.AxctGrid;
import com.veryant.wow.gui.client.AxCTGRIDLib.GridColumn;
import com.veryant.wow.gui.client.AxCTGRIDLib.GridUtils;
import java.awt.Color;
import java.awt.Component;
import java.util.Date;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

class GridTableDateCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    final AxctGrid grid;
    private JDateChooser dateChooser;
    private Color backColor;
    private Color foreColor;
    private static final DefaultCellEditor target = new DefaultCellEditor(new JTextField());

    GridTableDateCellEditor(AxctGrid grid) {
        this.grid = grid;
        this.dateChooser = new JDateChooser((IDateEditor)new JSpinnerDateEditor());
    }

    @Override
    public Object getCellEditorValue() {
        return this.dateChooser.getDate();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        GridColumn c = this.grid.tableModel.getGridColumn(column);
        Color[] col = GridUtils.getColor(this.grid, row, c, isSelected);
        this.backColor = col[0];
        this.foreColor = col[1];
        this.dateChooser.setBackground(this.backColor);
        this.dateChooser.setForeground(this.foreColor);
        this.dateChooser.getCalendarButton().setVisible(c.dropCalendar);
        switch (c.dataFormatType) {
            case 0: {
                this.dateChooser.setDateFormatString("MM/dd/yyyy");
                break;
            }
            default: {
                this.dateChooser.setDateFormatString("dd/MM/yyyy");
                break;
            }
            case 2: {
                this.dateChooser.setDateFormatString("MMMM d/yyyy");
                break;
            }
            case 3: {
                this.dateChooser.setDateFormatString("EEE. MMMM d/yyyy");
            }
        }
        if (value instanceof Date) {
            this.dateChooser.setDate((Date)value);
        } else {
            this.dateChooser.setDate(null);
        }
        return this.dateChooser;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return target.isCellEditable(anEvent);
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return target.shouldSelectCell(anEvent);
    }
}

