/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.wow.gui.client.AxCTGRIDLib;

import com.veryant.wow.gui.client.AxCTGRIDLib.AxctGrid;
import com.veryant.wow.gui.client.AxCTGRIDLib.GridCell;
import com.veryant.wow.gui.client.AxCTGRIDLib.GridColumn;
import com.veryant.wow.gui.client.AxCTGRIDLib.GridStyle;
import com.veryant.wow.gui.client.AxCTGRIDLib.GridUtils;
import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

class GridTableDefaultRenderer
extends DefaultTableCellRenderer
implements TableCellRenderer,
Serializable {
    final AxctGrid grid;
    private Color backColor;
    private Color foreColor;

    GridTableDefaultRenderer(AxctGrid g) {
        this.grid = g;
    }

    @Override
    public Color getBackground() {
        return this.backColor != null ? this.backColor : super.getBackground();
    }

    @Override
    public Color getForeground() {
        return this.foreColor != null ? this.foreColor : super.getForeground();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        GridStyle style;
        GridColumn c = this.grid.tableModel.getGridColumn(column);
        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, c.index);
        Color[] col = GridUtils.getColor(this.grid, row, c, isSelected);
        this.backColor = col[0];
        this.foreColor = col[1];
        GridCell cell = this.grid.values.elementAt(row).elementAt(c.index);
        GridStyle gridStyle = style = cell.style != null ? this.grid.getStyle(cell.style.shortValue(), false) : null;
        Short align = style != null && style.align != null ? style.align : (c.textAlign != null ? c.textAlign : Short.valueOf((short)this.grid.getItemAlign()));
        switch (align) {
            default: {
                label.setHorizontalAlignment(2);
                break;
            }
            case 1: {
                label.setHorizontalAlignment(4);
                break;
            }
            case 2: {
                label.setHorizontalAlignment(0);
            }
        }
        return label;
    }
}

