/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.wow.gui.client.AxCTGRIDLib;

import com.veryant.wow.gui.client.AxCTGRIDLib.AxctGrid;
import com.veryant.wow.gui.client.AxCTGRIDLib.GridColumn;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;

class GridTableHeaderRenderer
extends DefaultTableCellRenderer {
    final AxctGrid grid;
    private Color backColor;
    private Color foreColor;
    private Font font;
    private int borderType = 2;
    private int align = 2;

    GridTableHeaderRenderer(AxctGrid g) {
        this.grid = g;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        GridColumn c = this.grid.tableModel.getGridColumn(column);
        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, c.index);
        label.setOpaque(true);
        switch (this.borderType) {
            default: {
                label.setBorder(BorderFactory.createRaisedBevelBorder());
                break;
            }
            case 3: {
                label.setBorder(BorderFactory.createLoweredBevelBorder());
                break;
            }
            case 1: {
                label.setBorder(null);
                break;
            }
            case 0: {
                label.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            }
        }
        if (c.headerAlign != null) {
            this.updateAlign(label, c.headerAlign.shortValue());
        } else {
            this.updateAlign(label, this.align);
        }
        if (this.backColor != null) {
            label.setBackground(this.backColor);
        }
        if (this.foreColor != null) {
            label.setForeground(this.foreColor);
        }
        if (this.font != null) {
            label.setFont(this.font);
        }
        return label;
    }

    private void updateAlign(JLabel label, int a) {
        switch (a) {
            case 0: {
                label.setHorizontalAlignment(2);
                break;
            }
            case 1: {
                label.setHorizontalAlignment(4);
                break;
            }
            default: {
                label.setHorizontalAlignment(0);
            }
        }
    }

    void setBackColor(Color c) {
        if (c != null) {
            this.backColor = c;
            this.grid.table.getTableHeader().repaint();
        }
    }

    void setForeColor(Color c) {
        if (c != null) {
            this.foreColor = c;
            this.grid.table.getTableHeader().repaint();
        }
    }

    void setHeaderFont(Font f) {
        if (f != null) {
            this.font = f;
            this.grid.table.getTableHeader().repaint();
        }
    }

    void setAlign(int a) {
        if (this.align != a) {
            this.align = a;
            this.grid.table.getTableHeader().repaint();
        }
    }

    void setBorderType(int bt) {
        if (this.borderType != bt) {
            this.borderType = bt;
            this.grid.table.getTableHeader().repaint();
        }
    }
}

