/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.wow.gui.client.AxCTGRIDLib;

import com.veryant.wow.gui.client.AxCTGRIDLib.AxctGrid;
import com.veryant.wow.gui.client.AxCTGRIDLib.GridCell;
import com.veryant.wow.gui.client.AxCTGRIDLib.GridColumn;
import com.veryant.wow.gui.client.AxCTGRIDLib.GridStyle;
import java.util.Date;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class GridTableModel
implements TableModel {
    protected final AxctGrid grid;
    private int hiddenColumnCount;
    Vector<TableModelListener> listeners = new Vector();

    public GridTableModel(AxctGrid g) {
        this.grid = g;
    }

    @Override
    public int getRowCount() {
        return this.grid.values.size();
    }

    @Override
    public int getColumnCount() {
        return this.grid.columns.size() - this.hiddenColumnCount;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex >= 0 && columnIndex < this.grid.columns.size()) {
            return this.grid.columns.elementAt((int)columnIndex).text;
        }
        return "";
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex >= 0 && columnIndex < this.grid.columns.size()) {
            switch (this.grid.columns.elementAt((int)columnIndex).dataType) {
                case 6: {
                    return Boolean.class;
                }
                case 3: {
                    return Date.class;
                }
            }
            return String.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        Vector<GridCell> row;
        boolean readOnly = this.grid.getReadOnly();
        if (rowIndex < this.grid.values.size() && columnIndex < (row = this.grid.values.elementAt(rowIndex)).size()) {
            GridStyle style;
            GridCell cell = row.elementAt(columnIndex);
            if (cell.style != null && (style = this.grid.getStyle(cell.style.shortValue(), false)) != null && style.readOnly != null) {
                readOnly = style.readOnly;
            }
        }
        return !readOnly;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < this.grid.values.size() && columnIndex < this.grid.values.elementAt(rowIndex).size()) {
            return this.grid.values.elementAt((int)rowIndex).elementAt((int)columnIndex).data;
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex < this.grid.values.size() && columnIndex < this.grid.values.elementAt(rowIndex).size()) {
            this.grid.values.elementAt((int)rowIndex).elementAt((int)columnIndex).data = aValue;
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.addElement(l);
        }
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.removeElement(l);
    }

    public void fireTableChanged() {
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void fireTableChanged(TableModelEvent e) {
        if (!this.listeners.isEmpty()) {
            for (TableModelListener l : this.listeners) {
                l.tableChanged(e);
            }
        }
    }

    public int getHiddenColumnCount() {
        return this.hiddenColumnCount;
    }

    public void setHiddenColumnCount(int hiddenColumnCount) {
        this.hiddenColumnCount = hiddenColumnCount;
    }

    public GridColumn getGridColumn(int column) {
        if (this.getHiddenColumnCount() > 0) {
            if (column < this.grid.table.getColumnModel().getColumnCount()) {
                TableColumn tc = this.grid.table.getColumnModel().getColumn(column);
                return this.grid.columnsMap.get(tc);
            }
            return this.grid.columns.elementAt(column);
        }
        return this.grid.columns.elementAt(column);
    }
}

