/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.wow.gui.client.AxCTGRIDLib;

import com.veryant.wow.gui.client.AxCTGRIDLib.AxctGrid;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.border.Border;

class GridTitle
extends JComponent {
    final AxctGrid grid;
    private int align = 0;
    private Color backColor = new Color(240, 240, 240);
    private Color foreColor = new Color(0, 0, 0);
    private Image backImage;
    private int offset;
    private int xOffset;
    private int yOffset;
    private int style = 0;
    private String text = "";
    private Font textFont;
    private FontMetrics textFM;
    private int preferredHeight;

    GridTitle(AxctGrid g) {
        this.grid = g;
        this.setTextFont(this.grid.table.getFont());
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        d.height = this.preferredHeight;
        return d;
    }

    @Override
    public void paintComponent(Graphics g) {
        Rectangle clip = g.getClipBounds();
        g.setColor(this.backColor);
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
        if (this.text != null && this.text.length() > 0) {
            int textW = this.textFM.stringWidth(this.text);
            int textH = this.textFM.getHeight();
            int y = clip.y + Math.max(0, (clip.height - textH) / 2) + this.textFM.getAscent() + this.yOffset;
            int x = clip.x;
            if (this.align == 2) {
                x += Math.max(0, (clip.width - textW) / 2);
            } else if (this.align == 1) {
                x += Math.max(0, clip.width - textW);
            }
            x += this.xOffset;
            g.setFont(this.textFont);
            switch (this.style) {
                default: {
                    g.setColor(this.foreColor);
                    g.drawString(this.text, x, y);
                    break;
                }
                case 1: {
                    g.setColor(this.foreColor.brighter());
                    g.drawString(this.text, x - 2, y - 2);
                    g.drawString(this.text, x - 1, y - 1);
                    g.setColor(this.foreColor);
                    g.drawString(this.text, x, y);
                    break;
                }
                case 2: {
                    g.setColor(this.foreColor);
                    g.drawString(this.text, x, y);
                    g.setColor(this.foreColor.brighter());
                    g.drawString(this.text, x + 1, y + 1);
                    g.drawString(this.text, x + 2, y + 2);
                }
            }
        }
    }

    void setTextFont(Font f) {
        Insets ins;
        this.textFont = f;
        this.textFM = this.getFontMetrics(this.textFont);
        this.preferredHeight = 0;
        Border b = this.getBorder();
        if (b != null && (ins = b.getBorderInsets(this)) != null) {
            this.preferredHeight += ins.top;
            this.preferredHeight += ins.bottom;
        }
        this.preferredHeight += this.offset;
        this.preferredHeight += this.textFM.getHeight();
        this.repaint();
    }

    void setText(String text) {
        this.text = text;
        this.repaint();
    }

    void setAlign(int a) {
        this.align = a;
        this.repaint();
    }

    void setBackColor(Color c) {
        this.backColor = c;
        this.repaint();
    }

    void setForeColor(Color c) {
        this.foreColor = c;
        this.repaint();
    }

    void setBackImage(Image im) {
        this.backImage = im;
        this.repaint();
    }

    void setOffset(int offs) {
        this.offset = offs;
        this.setTextFont(this.textFont);
    }

    void setXOffset(int offs) {
        this.xOffset = offs;
        this.repaint();
    }

    void setYOffset(int offs) {
        this.yOffset = offs;
        this.repaint();
    }

    void setStyle(int st) {
        this.style = st;
        this.repaint();
    }

    @Override
    public void setBorder(Border b) {
        super.setBorder(b);
        this.setTextFont(this.textFont);
    }
}

