/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.agent;

import com.iscobol.agent.CoverageTransformer;
import com.iscobol.agent.ProfilerTransformer;
import java.io.File;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.util.StringTokenizer;

public class Agent {
    public static void premain(String agentArgs, Instrumentation inst) {
        try {
            boolean profilerEnabled = false;
            File profilerHtmlDir = null;
            File profilerXmlFile = null;
            File profilerTxtFile = null;
            String profilerIncl = null;
            String profilerExcl = null;
            boolean coverageEnabled = false;
            File coverageHtmlDir = null;
            File coverageXmlFile = null;
            String coverageIncl = null;
            String coverageExcl = null;
            String coverageSessionName = null;
            String coverageAppend = null;
            String coverageSourceFiles = null;
            String coverageClassFiles = null;
            String attrType = null;
            if (agentArgs == null) {
                agentArgs = "";
            }
            StringTokenizer stn1 = new StringTokenizer(agentArgs, ";");
            while (stn1.hasMoreTokens()) {
                String v;
                String p;
                String tk = stn1.nextToken();
                int idx = tk.indexOf(61);
                if (idx >= 0) {
                    p = tk.substring(0, idx);
                    v = idx < tk.length() - 1 ? tk.substring(idx + 1) : "";
                } else {
                    p = tk;
                    v = "";
                }
                if ("profiler".equals(p)) {
                    attrType = "p";
                    if (coverageEnabled) {
                        System.err.println("coverage and profiler can't be used together; profiler settings ignored");
                        continue;
                    }
                    profilerEnabled = true;
                    continue;
                }
                if ("coverage".equals(p)) {
                    attrType = "c";
                    if (profilerEnabled) {
                        System.err.println("coverage and profiler can't be used together; coverage settings ignored");
                        continue;
                    }
                    coverageEnabled = true;
                    continue;
                }
                if ("includes".equals(p)) {
                    if (attrType == "c") {
                        coverageIncl = v;
                        continue;
                    }
                    profilerIncl = v;
                    continue;
                }
                if ("excludes".equals(p)) {
                    if (attrType == "c") {
                        coverageExcl = v;
                        continue;
                    }
                    profilerExcl = v;
                    continue;
                }
                if ("xml".equals(p)) {
                    if (attrType == "c") {
                        coverageXmlFile = new File(v);
                        continue;
                    }
                    profilerXmlFile = new File(v);
                    continue;
                }
                if ("html".equals(p)) {
                    if (attrType == "c") {
                        coverageHtmlDir = new File(v);
                        continue;
                    }
                    profilerHtmlDir = new File(v);
                    continue;
                }
                if ("txt".equals(p)) {
                    if (attrType == "c") continue;
                    profilerTxtFile = new File(v);
                    continue;
                }
                if ("sourcefiles".equals(p)) {
                    if (attrType != "c") continue;
                    coverageSourceFiles = v;
                    continue;
                }
                if ("append".equals(p)) {
                    if (attrType != "c") continue;
                    coverageAppend = v;
                    continue;
                }
                if ("classfiles".equals(p)) {
                    if (attrType != "c") continue;
                    coverageClassFiles = v;
                    continue;
                }
                if (!"sessionname".equals(p) || attrType != "c") continue;
                coverageSessionName = v;
            }
            if (!profilerEnabled && !coverageEnabled) {
                profilerEnabled = true;
            }
            if (profilerEnabled) {
                inst.addTransformer(new ProfilerTransformer(profilerHtmlDir, profilerXmlFile, profilerTxtFile, profilerIncl, profilerExcl));
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    try {
                        Class<?> cls = Class.forName("com.iscobol.profiler.Profiler");
                        Object prof = cls.getMethod("getProfiler", new Class[0]).invoke(null, new Object[0]);
                        cls.getMethod("shutdownAndPrintReports", new Class[0]).invoke(prof, new Object[0]);
                    }
                    catch (Throwable e) {
                        System.err.println("Profiler.shutdownAndPrintReports: " + e);
                    }
                }));
            }
            if (coverageEnabled) {
                inst.addTransformer(new CoverageTransformer(coverageSessionName, coverageHtmlDir, coverageXmlFile, coverageIncl, coverageExcl, coverageAppend, coverageSourceFiles, coverageClassFiles));
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    try {
                        Class<?> cls = Class.forName("com.iscobol.coverage.Coverage");
                        Object cvg = cls.getMethod("getCoverage", new Class[0]).invoke(null, new Object[0]);
                        cls.getMethod("shutdownAndPrintReports", new Class[0]).invoke(cvg, new Object[0]);
                    }
                    catch (Throwable e) {
                        System.err.println("Coverage.shutdownAndPrintReports: " + e);
                    }
                }));
            }
        }
        catch (Exception _ex) {
            System.err.println("Exception: " + _ex);
            _ex.printStackTrace();
        }
    }

    public static ClassFileTransformer getProfilerTransformer(ClassLoader cl, File htmlDir, File xmlFile, File txtFile, String incl, String excl) {
        try {
            Class<?> cls = Class.forName("com.iscobol.profiler.Profiler", true, cl);
            Object prof = cls.getMethod("getSharedInstance", File.class, File.class, File.class, String.class, String.class).invoke(null, htmlDir, xmlFile, txtFile, incl, excl);
            return (ClassFileTransformer)cls.getMethod("getTransformer", new Class[0]).invoke(prof, new Object[0]);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
        catch (Throwable e) {
            System.err.println("getProfilerTransformer: " + e);
            return null;
        }
    }

    public static ClassFileTransformer getCoverageTransformer(ClassLoader cl, String sessionName, File htmlDir, File xmlFile, String includes, String excludes, String append, String sourceFiles, String classFiles) {
        try {
            Class<?> cls = Class.forName("com.iscobol.coverage.Coverage", true, cl);
            Object cvg = cls.getMethod("getSharedInstance", String.class, File.class, File.class, String.class, String.class, String.class, String.class, String.class).invoke(null, sessionName, htmlDir, xmlFile, includes, excludes, append, sourceFiles, classFiles);
            return (ClassFileTransformer)cls.getMethod("getTransformer", new Class[0]).invoke(cvg, new Object[0]);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
        catch (Throwable e) {
            System.err.println("getCoverageTransformer: " + e);
            return null;
        }
    }
}

