/*
 * Decompiled with CFR 0.152.
 */
package IT.picosoft.iiop;

public class IORHelper {
    private String ior = "";

    public IORHelper(String string, String string2, int n2, String string3) {
        this.buildHead(string);
        this.buildProfile(string2, n2, string3);
        this.ior = "IOR:" + this.ior;
    }

    private static String intToHex(int n2, int n3) {
        String string = Integer.toHexString(n2).toUpperCase();
        while (string.length() < 2 * n3) {
            string = "0" + string;
        }
        return string;
    }

    private static String charToHexString(char c2) {
        return Integer.toHexString(c2).toUpperCase();
    }

    private static String stringToHexString(String string) {
        String string2 = "";
        int n2 = 0;
        while (n2 < string.length()) {
            string2 = string2 + IORHelper.charToHexString(string.charAt(n2++));
        }
        return string2 + "00";
    }

    private void addPad(int n2) {
        while (this.ior.length() % (2 * n2) > 0) {
            this.ior = this.ior + "00";
        }
    }

    private void addInt(int n2, int n3) {
        this.addPad(n3);
        this.ior = this.ior + IORHelper.intToHex(n2, n3);
    }

    private void addString(String string) {
        this.addInt(string.length() + 1, 4);
        this.ior = this.ior + IORHelper.stringToHexString(string);
    }

    private void buildHead(String string) {
        this.addInt(0, 1);
        this.addString(string);
        this.addInt(1, 4);
    }

    private void buildProfile(String string, int n2, String string2) {
        this.addInt(0, 4);
        int n3 = this.ior.length();
        this.addInt(0, 1);
        this.addInt(1, 1);
        this.addInt(0, 1);
        this.addString(string);
        this.addInt(n2, 2);
        this.addString(string2);
        this.ior = this.ior.substring(0, n3) + IORHelper.intToHex((this.ior.length() - n3) / 2, 4) + this.ior.substring(n3);
    }

    public String toString() {
        return this.ior;
    }
}

