/*
 * Decompiled with CFR 0.152.
 */
package IT.picosoft.iiop;

import IT.picosoft.iiop.Corba;
import IT.picosoft.iiop.CorbaAny;
import IT.picosoft.iiop.CorbaException;
import IT.picosoft.iiop.CorbaTypeCode;
import IT.picosoft.iiop.Principal;
import IT.picosoft.iiop.TCKindDesc;
import IT.picosoft.iiop.Util;

public class Message
implements Corba {
    public static final String rcsid = "$Id: Message.java,v 1.5 2014/02/21 16:41:17 marco Exp $";
    private static final int DEFAULT_SIZE = 1430;
    private byte[] phisicBuffer = new byte[1430];
    private int unusedSpace = this.phisicBuffer.length;
    private int currPnt = 0;
    boolean msgByteOrder;
    private boolean myByteOrder = false;

    public static void testInt() {
        int n2;
        Message message = new Message();
        int[] nArray = new int[]{-2122284672, 2139127680, 0x7F7E7F7E, 0x7E7F7E7F, -2139127681, -2138996607};
        for (n2 = 0; n2 < nArray.length; ++n2) {
            message.putByte((byte)nArray[n2]);
            message.putBoolean((nArray[n2] & 1) == 1);
            message.putShort((short)nArray[n2]);
            message.putLong(nArray[n2]);
        }
        byte[] byArray = message.getBuffer(message.getSize(), false);
        int n3 = message.getSize();
        message = new Message();
        Util.arraycopy(byArray, 0, message.getBuffer(n3, false), 0, n3);
        for (n2 = 0; n2 < nArray.length; ++n2) {
            System.out.println("byte=" + message.getByte() + ",boolean=" + message.getBoolean() + ",short=" + message.getShort() + ",long=" + message.getLong());
        }
        message = new Message();
        Util.arraycopy(byArray, 0, message.getBuffer(n3, true), 0, n3);
        for (n2 = 0; n2 < nArray.length; ++n2) {
            System.out.println("byte=" + message.getByte() + ",boolean=" + message.getBoolean() + ",short=" + message.getShort() + ",long=" + message.getLong());
        }
    }

    public static void testULong() {
        int n2;
        Message message = new Message();
        long[] lArray = new long[]{0x81808180L, 2139127680L, 0x7F7E7F7EL, 0x7E7F7E7FL, 2155839615L, 0x80818081L};
        for (n2 = 0; n2 < lArray.length; ++n2) {
            message.putByte((byte)lArray[n2]);
            message.putBoolean((lArray[n2] & 1L) == 1L);
            message.putShort((short)lArray[n2]);
            message.putULong(lArray[n2]);
        }
        byte[] byArray = message.getBuffer(message.getSize(), false);
        int n3 = message.getSize();
        message = new Message();
        Util.arraycopy(byArray, 0, message.getBuffer(n3, false), 0, n3);
        for (n2 = 0; n2 < lArray.length; ++n2) {
            System.out.println("byte=" + message.getByte() + ",boolean=" + message.getBoolean() + ",short=" + message.getShort() + ",Ulong=" + message.getULong());
        }
        message = new Message();
        Util.arraycopy(byArray, 0, message.getBuffer(n3, true), 0, n3);
        for (n2 = 0; n2 < lArray.length; ++n2) {
            System.out.println("byte=" + message.getByte() + ",boolean=" + message.getBoolean() + ",short=" + message.getShort() + ",Ulong=" + message.getULong());
        }
    }

    public static void testString() {
        int n2;
        Message message = new Message();
        String[] stringArray = new String[]{"Hello", "", null, "World"};
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            message.putString(stringArray[n2]);
        }
        byte[] byArray = message.getBuffer(message.getSize(), false);
        int n3 = message.getSize();
        message = new Message();
        Util.arraycopy(byArray, 0, message.getBuffer(n3, false), 0, n3);
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            System.out.println("string=[" + message.getString() + "]");
        }
    }

    public static void main(String[] stringArray) {
        Message.testString();
    }

    Message() {
    }

    private static int calcAlign(int n2, int n3) {
        return n3 - n2 % n3 & n3 - 1;
    }

    private void grow(int n2) {
        boolean bl = true;
        if (n2 < 1430) {
            n2 = 1430;
        }
        byte[] byArray = new byte[this.phisicBuffer.length + n2];
        Util.arraycopy(this.phisicBuffer, 0, byArray, 0, this.phisicBuffer.length);
        this.phisicBuffer = byArray;
        this.unusedSpace += n2;
    }

    boolean getMyByteOrder() {
        return this.myByteOrder;
    }

    int getSize() {
        return this.currPnt;
    }

    byte[] getBuffer(int n2, boolean bl) {
        this.msgByteOrder = bl;
        if (n2 > this.phisicBuffer.length) {
            this.grow(n2 - this.phisicBuffer.length);
        }
        return this.phisicBuffer;
    }

    byte[] getBuffer() {
        return this.phisicBuffer;
    }

    int skipBytes(int n2) {
        if (this.unusedSpace < n2) {
            this.grow(n2 - this.unusedSpace);
        }
        int n3 = this.currPnt;
        this.currPnt += n2;
        this.unusedSpace -= n2;
        return n3;
    }

    boolean putByte(byte by) {
        if (this.unusedSpace < 1) {
            this.grow(1);
        }
        this.phisicBuffer[this.currPnt++] = by;
        --this.unusedSpace;
        return true;
    }

    boolean putBoolean(boolean bl) {
        if (this.unusedSpace < 1) {
            this.grow(1);
        }
        this.phisicBuffer[this.currPnt++] = bl ? (byte)1 : 0;
        --this.unusedSpace;
        return true;
    }

    boolean putShort(short s2) {
        int n2 = Message.calcAlign(this.currPnt, 2);
        if (this.unusedSpace < 2 + n2) {
            this.grow(2 + n2);
        }
        this.currPnt += n2;
        this.phisicBuffer[this.currPnt++] = (byte)(s2 >>> 8 & 0xFF);
        this.phisicBuffer[this.currPnt++] = (byte)(s2 & 0xFF);
        this.unusedSpace -= n2 + 2;
        return true;
    }

    boolean putUShort(int n2) {
        this.putShort((short)n2);
        return true;
    }

    boolean putLongAt(int n2, int n3) {
        this.phisicBuffer[n3++] = (byte)(n2 >>> 24 & 0xFF);
        this.phisicBuffer[n3++] = (byte)(n2 >>> 16 & 0xFF);
        this.phisicBuffer[n3++] = (byte)(n2 >>> 8 & 0xFF);
        this.phisicBuffer[n3++] = (byte)(n2 & 0xFF);
        return true;
    }

    boolean putLong(int n2) {
        int n3 = Message.calcAlign(this.currPnt, 4);
        if (this.unusedSpace < 4 + n3) {
            this.grow(4 + n3);
        }
        this.currPnt += n3;
        this.phisicBuffer[this.currPnt++] = (byte)(n2 >>> 24 & 0xFF);
        this.phisicBuffer[this.currPnt++] = (byte)(n2 >>> 16 & 0xFF);
        this.phisicBuffer[this.currPnt++] = (byte)(n2 >>> 8 & 0xFF);
        this.phisicBuffer[this.currPnt++] = (byte)(n2 & 0xFF);
        this.unusedSpace -= n3 + 4;
        return true;
    }

    boolean putULong(long l2) {
        this.putLong((int)l2);
        return true;
    }

    boolean putAtULong(int n2, long l2) {
        this.phisicBuffer[n2++] = (byte)(l2 >>> 24 & 0xFFL);
        this.phisicBuffer[n2++] = (byte)(l2 >>> 16 & 0xFFL);
        this.phisicBuffer[n2++] = (byte)(l2 >>> 8 & 0xFFL);
        this.phisicBuffer[n2++] = (byte)(l2 & 0xFFL);
        return true;
    }

    boolean putLongLong(long l2) {
        int n2 = Message.calcAlign(this.currPnt, 8);
        if (this.unusedSpace < 8 + n2) {
            this.grow(8 + n2);
        }
        this.currPnt += n2;
        this.phisicBuffer[this.currPnt++] = (byte)(l2 >>> 56 & 0xFFL);
        this.phisicBuffer[this.currPnt++] = (byte)(l2 >>> 48 & 0xFFL);
        this.phisicBuffer[this.currPnt++] = (byte)(l2 >>> 40 & 0xFFL);
        this.phisicBuffer[this.currPnt++] = (byte)(l2 >>> 32 & 0xFFL);
        this.phisicBuffer[this.currPnt++] = (byte)(l2 >>> 24 & 0xFFL);
        this.phisicBuffer[this.currPnt++] = (byte)(l2 >>> 16 & 0xFFL);
        this.phisicBuffer[this.currPnt++] = (byte)(l2 >>> 8 & 0xFFL);
        this.phisicBuffer[this.currPnt++] = (byte)(l2 & 0xFFL);
        this.unusedSpace -= n2 + 8;
        return true;
    }

    boolean putULongLong(long l2) {
        this.putLongLong(l2);
        return true;
    }

    boolean putFloat(float f2) {
        this.putLong(Float.floatToRawIntBits(f2));
        return true;
    }

    boolean putDouble(double d2) {
        this.putLongLong(Double.doubleToRawLongBits(d2));
        return true;
    }

    boolean putString(String string) {
        if (string == null) {
            this.putLong(0);
        } else {
            byte[] byArray = string.getBytes();
            int n2 = byArray.length + 1;
            this.putLong(n2);
            int n3 = this.skipBytes(n2);
            if (n2 >= 1) {
                Util.arraycopy(string.getBytes(), 0, this.phisicBuffer, n3, n2 - 1);
            }
        }
        return true;
    }

    boolean putPrincipal(Principal principal) {
        if (principal == null) {
            this.putULong(0L);
        } else if (this.putLong(principal.length)) {
            int n2 = this.skipBytes(principal.length);
            if (principal.length >= 1) {
                Util.arraycopy(principal.data, principal.offset, this.phisicBuffer, n2, principal.length);
            }
        }
        return true;
    }

    boolean putStruct(Object object, TCKindDesc[] tCKindDescArray) throws CorbaException {
        Object[] objectArray;
        boolean bl = false;
        if (!(object instanceof Object[]) || (objectArray = (Object[])object).length < tCKindDescArray.length) {
            throw new CorbaException(9);
        }
        for (int i2 = 0; i2 < tCKindDescArray.length; ++i2) {
            bl = tCKindDescArray[i2].kind == 15 ? this.putStruct(objectArray[i2], tCKindDescArray[i2].suppl) : this.encode(tCKindDescArray[i2], objectArray[i2]);
        }
        return bl;
    }

    boolean putSequence(TCKindDesc tCKindDesc, Object object) throws CorbaException {
        boolean bl = true;
        if (tCKindDesc.suppl != null) {
            Object[] objectArray = (Object[])object;
            bl = this.putULong(objectArray.length);
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                bl = this.encode(tCKindDesc.suppl[0], objectArray[i2]);
            }
        } else {
            bl = false;
        }
        return bl;
    }

    byte getByte() {
        --this.unusedSpace;
        return this.phisicBuffer[this.currPnt++];
    }

    boolean getBoolean() {
        --this.unusedSpace;
        return this.phisicBuffer[this.currPnt++] == 1;
    }

    short getShort() {
        int n2 = Message.calcAlign(this.currPnt, 2);
        this.currPnt += n2;
        short s2 = this.msgByteOrder ? (short)(this.phisicBuffer[this.currPnt++] & 0xFF | this.phisicBuffer[this.currPnt++] << 8) : (short)(this.phisicBuffer[this.currPnt++] << 8 | this.phisicBuffer[this.currPnt++] & 0xFF);
        this.unusedSpace -= n2 + 2;
        return s2;
    }

    int getUShort() {
        return this.getShort() & 0xFFFF;
    }

    int getLong() {
        int n2 = Message.calcAlign(this.currPnt, 4);
        this.currPnt += n2;
        int n3 = this.msgByteOrder ? this.phisicBuffer[this.currPnt++] & 0xFF | (this.phisicBuffer[this.currPnt++] & 0xFF) << 8 | (this.phisicBuffer[this.currPnt++] & 0xFF) << 16 | (this.phisicBuffer[this.currPnt++] & 0xFF) << 24 : this.phisicBuffer[this.currPnt++] << 24 | (this.phisicBuffer[this.currPnt++] & 0xFF) << 16 | (this.phisicBuffer[this.currPnt++] & 0xFF) << 8 | this.phisicBuffer[this.currPnt++] & 0xFF;
        this.unusedSpace -= n2 + 4;
        return n3;
    }

    long getULong() {
        return (long)this.getLong() & 0xFFFFFFFFL;
    }

    long getLongLong() {
        int n2 = Message.calcAlign(this.currPnt, 8);
        this.currPnt += n2;
        long l2 = this.msgByteOrder ? (long)this.phisicBuffer[this.currPnt++] & 0xFFL | ((long)this.phisicBuffer[this.currPnt++] & 0xFFL) << 8 | ((long)this.phisicBuffer[this.currPnt++] & 0xFFL) << 16 | ((long)this.phisicBuffer[this.currPnt++] & 0xFFL) << 24 | ((long)this.phisicBuffer[this.currPnt++] & 0xFFL) << 32 | ((long)this.phisicBuffer[this.currPnt++] & 0xFFL) << 40 | ((long)this.phisicBuffer[this.currPnt++] & 0xFFL) << 48 | ((long)this.phisicBuffer[this.currPnt++] & 0xFFL) << 56 : (long)this.phisicBuffer[this.currPnt++] << 56 | ((long)this.phisicBuffer[this.currPnt++] & 0xFFL) << 48 | ((long)this.phisicBuffer[this.currPnt++] & 0xFFL) << 40 | ((long)this.phisicBuffer[this.currPnt++] & 0xFFL) << 32 | ((long)this.phisicBuffer[this.currPnt++] & 0xFFL) << 24 | ((long)this.phisicBuffer[this.currPnt++] & 0xFFL) << 16 | ((long)this.phisicBuffer[this.currPnt++] & 0xFFL) << 8 | (long)this.phisicBuffer[this.currPnt++] & 0xFFL;
        this.unusedSpace -= n2 + 8;
        return l2;
    }

    long getULongLong() {
        return this.getULongLong();
    }

    float getFloat() {
        return Float.intBitsToFloat(this.getLong());
    }

    double getDouble() {
        return Double.longBitsToDouble(this.getLongLong());
    }

    String getString() {
        String string;
        int n2 = this.getLong();
        if (n2 > 0) {
            int n3 = this.skipBytes(n2);
            string = new String(this.phisicBuffer, n3, n2 - 1);
        } else {
            string = null;
        }
        return string;
    }

    Principal getPrincipal(Object object) {
        Principal principal;
        int n2 = this.getLong();
        if (object instanceof Principal) {
            principal = (Principal)object;
            principal.length = n2;
        } else {
            principal = new Principal(new byte[n2]);
        }
        int n3 = this.skipBytes(n2);
        Util.arraycopy(this.phisicBuffer, n3, principal.data, principal.offset, n2);
        return principal;
    }

    Object getStruct(Object[] objectArray, TCKindDesc[] tCKindDescArray) {
        Object var3_3 = null;
        for (int i2 = 0; i2 < tCKindDescArray.length; ++i2) {
            if (tCKindDescArray[i2].kind == 15) {
                Object[] objectArray2 = new Object[tCKindDescArray[i2].suppl.length];
                this.getStruct(objectArray2, tCKindDescArray[i2].suppl);
                objectArray[i2] = objectArray2;
                continue;
            }
            objectArray[i2] = this.decode(tCKindDescArray[i2], objectArray[i2]);
        }
        return var3_3;
    }

    Object getSequence(TCKindDesc tCKindDesc) {
        Object[] objectArray = null;
        if (tCKindDesc.suppl != null) {
            int n2 = (int)this.getULong();
            objectArray = new Object[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                objectArray[i2] = this.decode(tCKindDesc.suppl[0], objectArray[i2]);
            }
        }
        return objectArray;
    }

    boolean encode(TCKindDesc tCKindDesc, Object object) throws CorbaException {
        boolean bl;
        block38: {
            bl = true;
            switch (tCKindDesc.kind) {
                case 0: 
                case 1: {
                    break;
                }
                case 9: 
                case 10: {
                    bl = this.putByte((Byte)object);
                    break;
                }
                case 2: {
                    bl = this.putShort((Short)object);
                    break;
                }
                case 4: {
                    bl = this.putUShort((Integer)object);
                    break;
                }
                case 3: 
                case 17: {
                    bl = this.putLong((Integer)object);
                    break;
                }
                case 5: {
                    bl = this.putULong((Long)object);
                    break;
                }
                case 23: {
                    bl = this.putLongLong((Long)object);
                    break;
                }
                case 24: {
                    bl = this.putULongLong((Long)object);
                    break;
                }
                case 6: {
                    bl = this.putFloat(((Float)object).floatValue());
                    break;
                }
                case 7: {
                    bl = this.putDouble((Double)object);
                    break;
                }
                case 8: {
                    bl = this.putBoolean((Boolean)object);
                    break;
                }
                case 18: {
                    bl = this.putString((String)object);
                    break;
                }
                case 13: {
                    bl = this.putPrincipal((Principal)object);
                    break;
                }
                case 15: {
                    if (tCKindDesc.suppl == null) break;
                    bl = this.putStruct(object, tCKindDesc.suppl);
                    break;
                }
                case 19: {
                    bl = this.putSequence(tCKindDesc, object);
                    break;
                }
                case 11: {
                    if (object == null) break;
                    CorbaAny corbaAny = (CorbaAny)object;
                    CorbaTypeCode corbaTypeCode = new CorbaTypeCode(corbaAny.tcIn, null);
                    bl = this.encode(TCD_TypeCode, corbaTypeCode);
                    if (!bl) break;
                    bl = this.encode(corbaAny.tcIn, corbaAny.data);
                    break;
                }
                case 12: {
                    if (object == null) break;
                    CorbaTypeCode corbaTypeCode = (CorbaTypeCode)object;
                    bl = this.putLong(corbaTypeCode.kdesc.kind);
                    if (!bl) break;
                    switch (corbaTypeCode.kdesc.kind) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 17: 
                        case 23: 
                        case 24: {
                            break;
                        }
                        case 18: {
                            bl = this.putULong(0L);
                            break;
                        }
                        case 15: {
                            long l2 = this.skipBytes(4);
                            this.putBoolean(this.myByteOrder);
                            bl = this.putString(corbaTypeCode.repositoryId);
                            if (!bl || !(bl = this.putString(corbaTypeCode.kdesc.name))) break;
                            if (corbaTypeCode.kdesc.suppl != null) {
                                this.putULong(corbaTypeCode.kdesc.suppl.length);
                                for (int i2 = 0; i2 < corbaTypeCode.kdesc.suppl.length && bl; ++i2) {
                                    bl = this.putString(corbaTypeCode.kdesc.suppl[i2].name);
                                    if (!bl) continue;
                                    CorbaTypeCode corbaTypeCode2 = new CorbaTypeCode(corbaTypeCode.kdesc.suppl[i2], null);
                                    bl = this.encode(TCD_TypeCode, corbaTypeCode2);
                                }
                            } else {
                                this.putULong(0L);
                            }
                            this.putLongAt((int)((long)this.currPnt - l2 - 4L), (int)l2);
                            break;
                        }
                        case 19: {
                            long l3 = this.skipBytes(4);
                            this.putBoolean(this.myByteOrder);
                            if (corbaTypeCode.kdesc.suppl != null) {
                                CorbaTypeCode corbaTypeCode3 = new CorbaTypeCode(corbaTypeCode.kdesc.suppl[0], null);
                                bl = this.encode(TCD_TypeCode, corbaTypeCode3);
                            } else {
                                bl = this.encode(TCD_TypeCode, TCD_null);
                            }
                            if (bl) {
                                bl = this.putULong(0L);
                                this.putLongAt((int)((long)this.currPnt - l3 - 4L), (int)l3);
                                break;
                            }
                            break block38;
                        }
                        case 20: {
                            long l4 = this.skipBytes(4);
                            this.putBoolean(this.myByteOrder);
                            if (corbaTypeCode.kdesc.suppl != null) {
                                CorbaTypeCode corbaTypeCode4 = new CorbaTypeCode(corbaTypeCode.kdesc.suppl[0], null);
                                bl = this.encode(TCD_TypeCode, corbaTypeCode4);
                            } else {
                                bl = this.encode(TCD_TypeCode, TCD_null);
                            }
                            if (bl) {
                                bl = this.putULong(corbaTypeCode.kdesc.len);
                                this.putLongAt((int)((long)this.currPnt - l4 - 4L), (int)l4);
                                break;
                            } else {
                                break;
                            }
                        }
                    }
                    break;
                }
                case 20: {
                    if (tCKindDesc.suppl != null) {
                        Object[] objectArray = (Object[])object;
                        for (int i3 = 0; i3 < tCKindDesc.len; ++i3) {
                            bl = this.encode(tCKindDesc.suppl[0], objectArray[i3]);
                        }
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    bl = false;
                }
            }
        }
        return bl;
    }

    Object decode(TCKindDesc tCKindDesc, Object object) {
        Object object2;
        switch (tCKindDesc.kind) {
            case 0: 
            case 1: {
                object2 = null;
                break;
            }
            case 9: 
            case 10: {
                object2 = new Byte(this.getByte());
                break;
            }
            case 2: {
                object2 = new Short(this.getShort());
                break;
            }
            case 4: {
                object2 = new Integer(this.getUShort());
                break;
            }
            case 3: 
            case 17: {
                object2 = new Integer(this.getLong());
                break;
            }
            case 5: {
                object2 = new Long(this.getULong());
                break;
            }
            case 23: {
                object2 = new Long(this.getLongLong());
                break;
            }
            case 24: {
                object2 = new Long(this.getULongLong());
                break;
            }
            case 6: {
                object2 = new Float(this.getFloat());
                break;
            }
            case 7: {
                object2 = new Double(this.getDouble());
                break;
            }
            case 8: {
                object2 = new Boolean(this.getBoolean());
                break;
            }
            case 18: {
                object2 = this.getString();
                break;
            }
            case 13: {
                object2 = this.getPrincipal(object);
                break;
            }
            case 15: {
                if (tCKindDesc.suppl != null) {
                    Object[] objectArray = new Object[tCKindDesc.suppl.length];
                    this.getStruct(objectArray, tCKindDesc.suppl);
                    object2 = objectArray;
                    break;
                }
                object2 = null;
                break;
            }
            case 19: {
                object2 = this.getSequence(tCKindDesc);
                break;
            }
            case 11: {
                CorbaAny corbaAny = new CorbaAny();
                CorbaTypeCode corbaTypeCode = (CorbaTypeCode)this.decode(TCD_TypeCode, null);
                if (corbaTypeCode != null) {
                    corbaAny.tcOut = corbaTypeCode.kdesc;
                    corbaAny.tcIn = corbaTypeCode.kdesc;
                    corbaTypeCode.kdesc = null;
                    corbaAny.data = this.decode(corbaAny.tcOut, corbaAny.data);
                    object2 = corbaAny;
                    break;
                }
                object2 = null;
                break;
            }
            case 12: {
                String string = null;
                int n2 = this.getLong();
                CorbaTypeCode corbaTypeCode = new CorbaTypeCode();
                switch (n2) {
                    case 0: {
                        corbaTypeCode.kdesc = TCD_null.dup();
                        break;
                    }
                    case 1: {
                        corbaTypeCode.kdesc = TCD_void.dup();
                        break;
                    }
                    case 9: {
                        corbaTypeCode.kdesc = TCD_char.dup();
                        break;
                    }
                    case 10: {
                        corbaTypeCode.kdesc = TCD_octet.dup();
                        break;
                    }
                    case 2: {
                        corbaTypeCode.kdesc = TCD_short.dup();
                        break;
                    }
                    case 4: {
                        corbaTypeCode.kdesc = TCD_ushort.dup();
                        break;
                    }
                    case 3: {
                        corbaTypeCode.kdesc = TCD_long.dup();
                        break;
                    }
                    case 5: {
                        corbaTypeCode.kdesc = TCD_ulong.dup();
                        break;
                    }
                    case 23: {
                        corbaTypeCode.kdesc = TCD_longlong.dup();
                        break;
                    }
                    case 24: {
                        corbaTypeCode.kdesc = TCD_ulonglong.dup();
                        break;
                    }
                    case 17: {
                        corbaTypeCode.kdesc = TCD_enum.dup();
                        break;
                    }
                    case 6: {
                        corbaTypeCode.kdesc = TCD_float.dup();
                        break;
                    }
                    case 7: {
                        corbaTypeCode.kdesc = TCD_double.dup();
                        break;
                    }
                    case 8: {
                        corbaTypeCode.kdesc = TCD_boolean.dup();
                        break;
                    }
                    case 13: {
                        corbaTypeCode.kdesc = TCD_Principal.dup();
                        break;
                    }
                    case 12: {
                        corbaTypeCode.kdesc = TCD_TypeCode.dup();
                        break;
                    }
                    case 11: {
                        corbaTypeCode.kdesc = TCD_any.dup();
                        break;
                    }
                    case 18: {
                        corbaTypeCode.kdesc = TCD_string.dup();
                        long l2 = this.getULong();
                        break;
                    }
                    case 15: {
                        corbaTypeCode.kdesc = TCD_struct.dup();
                        corbaTypeCode.seqLen = this.getULong();
                        corbaTypeCode.endian = this.getBoolean();
                        corbaTypeCode.repositoryId = this.getString();
                        corbaTypeCode.kdesc.name = this.getString();
                        long l3 = this.getULong();
                        corbaTypeCode.kdesc.suppl = new TCKindDesc[(int)l3];
                        for (long i2 = 0L; i2 < l3; ++i2) {
                            String string2 = this.getString();
                            CorbaTypeCode corbaTypeCode2 = (CorbaTypeCode)this.decode(TCD_TypeCode, null);
                            corbaTypeCode.kdesc.suppl[(int)i2] = corbaTypeCode2.kdesc;
                            corbaTypeCode.kdesc.suppl[(int)i2].name = string2;
                            corbaTypeCode2.kdesc = null;
                        }
                        break;
                    }
                    case 19: {
                        corbaTypeCode.kdesc = TCD_sequence.dup();
                        corbaTypeCode.kdesc.suppl = new TCKindDesc[1];
                        corbaTypeCode.seqLen = this.getULong();
                        corbaTypeCode.endian = this.getBoolean();
                        CorbaTypeCode corbaTypeCode3 = (CorbaTypeCode)this.decode(TCD_TypeCode, null);
                        corbaTypeCode.kdesc.suppl[0] = corbaTypeCode3.kdesc;
                        long l4 = this.getULong();
                        break;
                    }
                    case 20: {
                        corbaTypeCode.kdesc = TCD_array.dup();
                        corbaTypeCode.kdesc.suppl = new TCKindDesc[1];
                        corbaTypeCode.seqLen = this.getULong();
                        corbaTypeCode.endian = this.getBoolean();
                        CorbaTypeCode corbaTypeCode4 = (CorbaTypeCode)this.decode(TCD_TypeCode, null);
                        corbaTypeCode.kdesc.suppl[0] = corbaTypeCode4.kdesc;
                        corbaTypeCode.kdesc.len = (int)this.getULong();
                        corbaTypeCode4.kdesc = null;
                        break;
                    }
                    case 21: {
                        corbaTypeCode.seqLen = this.getULong();
                        corbaTypeCode.endian = this.getBoolean();
                        string = this.getString();
                        String string3 = this.getString();
                        CorbaTypeCode corbaTypeCode5 = (CorbaTypeCode)this.decode(TCD_TypeCode, null);
                        corbaTypeCode.kdesc = corbaTypeCode5.kdesc;
                        corbaTypeCode.repositoryId = string;
                        corbaTypeCode.kdesc.name = string3;
                        corbaTypeCode5.kdesc = null;
                        break;
                    }
                }
                object2 = corbaTypeCode;
                break;
            }
            case 20: {
                if (tCKindDesc.suppl != null) {
                    Object[] objectArray = new Object[tCKindDesc.len];
                    for (int i3 = 0; i3 < tCKindDesc.len; ++i3) {
                        objectArray[i3] = this.decode(tCKindDesc.suppl[0], objectArray[i3]);
                    }
                    object2 = objectArray;
                    break;
                }
                object2 = null;
                break;
            }
            default: {
                object2 = null;
            }
        }
        return object2;
    }
}

