/*
 * Decompiled with CFR 0.152.
 */
package IT.picosoft.isam;

import IT.picosoft.isam.ByteArrayCmp;

public class ByteArrayCmpCollating
implements ByteArrayCmp {
    private final int[] colSeq;

    public ByteArrayCmpCollating(byte[] byArray) {
        if (byArray == null || byArray.length < 256) {
            throw new IllegalArgumentException(byArray == null ? "Collating sequence missing" : "Collating sequence too short");
        }
        this.colSeq = new int[256];
        for (int i2 = 0; i2 < 256; ++i2) {
            this.colSeq[i2] = byArray[i2] & 0xFF;
        }
    }

    @Override
    public final int memcmp(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        n4 += n2;
        while (n2 < n4) {
            int n5 = this.colSeq[byArray[n2] & 0xFF] - this.colSeq[byArray2[n3] & 0xFF];
            if (n5 != 0) {
                return n5;
            }
            ++n2;
            ++n3;
        }
        return 0;
    }

    @Override
    public byte[] getCollatingSequence() {
        byte[] byArray = new byte[256];
        for (int i2 = 0; i2 < 256; ++i2) {
            byArray[i2] = (byte)this.colSeq[i2];
        }
        return byArray;
    }
}

