/*
 * Decompiled with CFR 0.152.
 */
package IT.picosoft.isam;

import IT.picosoft.isam.DictInfo;
import IT.picosoft.isam.FLock;
import IT.picosoft.isam.IsamConst;
import IT.picosoft.isam.IsamException;
import IT.picosoft.isam.KeyDesc;
import IT.picosoft.isam.NodeItemDesc;
import IT.picosoft.isam.OSFile;
import IT.picosoft.isam.RecordLock;
import IT.picosoft.isam.SharedFile;
import IT.picosoft.isam.TreeManager;
import IT.picosoft.isam.Util;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;

public class Isam
implements IsamConst {
    public static final String revision = "r2.42 ($Revision: 25561 $)";
    public static final short NULLSHORT = Short.MIN_VALUE;
    public static final int NULLLONG = Integer.MIN_VALUE;
    private static final int MASK_LOCK = 3840;
    private static final int MASK_OPEN = 3;
    private static final long MAXRECNUM = Long.MAX_VALUE;
    private static final short MAXNODESIZE = 1024;
    private static final short HEADERSIZE = 1024;
    private static String DEFAULT_INDEX_EXT = ".idx";
    private static String DEFAULT_DATA_EXT = ".dat";
    public static boolean LOCK_READ_ANYHOW;
    private long recNum;
    private final String indexName;
    private final String dataName;
    private TreeManager tree;
    private OSFile fdData;
    private int openMode;
    private int osMode;
    private byte[] irecord;
    private short currIndex;
    private NodeItemDesc curr;
    private boolean fileLock;
    private long lastRecordLock;
    private SharedFile dataShFile;
    private SharedFile indxShFile;
    boolean inWriteFlag;
    private boolean isOpen = false;
    private static Vector sharedFiles;
    private boolean strictLock;
    final String encrPasswd;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void setFileNameExtension(String string, String string2) {
        Class<Isam> clazz = Isam.class;
        synchronized (Isam.class) {
            if (string == null) {
                string = DEFAULT_DATA_EXT;
            }
            if (string2 == null) {
                string2 = DEFAULT_INDEX_EXT;
            }
            if (string.equals(string2)) {
                throw new IllegalArgumentException("Extensions data=" + string + ",index=" + string2 + " invalid");
            }
            DEFAULT_DATA_EXT = string;
            DEFAULT_INDEX_EXT = string2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Isam(String string, String string2) throws IsamException {
        this.encrPasswd = string2;
        Isam.checkFileName(string);
        Class<Isam> clazz = Isam.class;
        synchronized (Isam.class) {
            this.indexName = string + DEFAULT_INDEX_EXT;
            this.dataName = string + DEFAULT_DATA_EXT;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.fileLock = false;
            this.lastRecordLock = 0L;
            this.currIndex = 0;
            return;
        }
    }

    public Isam(String string, int n2, boolean bl) throws IsamException {
        this(string, n2, bl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Isam(String string, int n2, boolean bl, String string2) throws IsamException {
        this(string, string2);
        this.checkMode(n2);
        this.openMode = n2;
        this.strictLock = bl;
        try {
            this.dataShFile = Isam.sharedOpen(this.dataName, this.osMode, 438, this.encrPasswd);
            this.fdData = this.dataShFile.fd;
            this.indxShFile = Isam.sharedOpen(this.indexName, this.osMode, 438, this.encrPasswd);
            String string3 = this.indxShFile.canonicalPath;
            synchronized (string3) {
                boolean bl2 = (n2 & 0xF00) == 2048;
                this.tree = TreeManager.get(this.indxShFile.fd, bl2, 0, this);
                if (bl2) {
                    this.fileExLock();
                } else {
                    this.testFileLock();
                }
                this.tree.init();
                this.irecord = new byte[this.tree.getRecSize() + 1];
                this.curr = new NodeItemDesc(this.tree.getIndexSize());
                this.isOpen = true;
            }
        }
        catch (IsamException isamException) {
            this.finalize();
            throw isamException;
        }
    }

    public static Isam build(String string, short s2, KeyDesc keyDesc, int n2) throws IsamException {
        return Isam.buildNodeSize(string, s2, keyDesc, n2, null, (short)1024, (short)1024, 0);
    }

    public static Isam build(String string, int n2, KeyDesc keyDesc, int n3) throws IsamException {
        return Isam.buildNodeSize(string, n2, keyDesc, n3, null, (short)1024, (short)1024, 0);
    }

    public static Isam build(String string, int n2, KeyDesc keyDesc, int n3, byte[] byArray) throws IsamException {
        return Isam.buildNodeSize(string, n2, keyDesc, n3, byArray, (short)1024, (short)1024, 0);
    }

    public static Isam build(String string, int n2, KeyDesc keyDesc, int n3, byte[] byArray, String string2) throws IsamException {
        return Isam.buildNodeSize(string, n2, keyDesc, n3, byArray, string2, (short)1024, (short)1024, 0);
    }

    public static Isam buildNodeSize(String string, short s2, KeyDesc keyDesc, int n2, short s3, short s4) throws IsamException {
        return Isam.buildNodeSize(string, s2, keyDesc, n2, null, s3, s4, 0);
    }

    public static Isam buildNodeSize(String string, int n2, KeyDesc keyDesc, int n3, short s2, short s3, int n4) throws IsamException {
        return Isam.buildNodeSize(string, n2, keyDesc, n3, null, s2, s3, n4);
    }

    public static Isam buildNodeSize(String string, int n2, KeyDesc keyDesc, int n3, byte[] byArray, short s2, short s3, int n4) throws IsamException {
        return Isam.buildNodeSize(string, n2, keyDesc, n3, byArray, null, s2, s3, n4);
    }

    public static Isam buildNodeSize(String string, int n2, KeyDesc keyDesc, int n3, byte[] byArray, String string2, short s2, short s3, int n4) throws IsamException {
        Isam isam = new Isam(string, string2);
        isam.checkMode(n3);
        keyDesc.check();
        if (s2 == 0) {
            s2 = (short)1024;
        }
        if (s3 == 0) {
            s3 = (short)1024;
        }
        try {
            isam.dataShFile = Isam.sharedOpen(isam.dataName, isam.osMode | 0x40 | 0x80, 438, string2);
            isam.fdData = isam.dataShFile.fd;
            isam.indxShFile = Isam.sharedOpen(isam.indexName, isam.osMode | 0x40 | 0x80, 438, string2);
            isam.openMode = n3;
            isam.fileLock = (n3 & 0xF00) == 2048;
            isam.tree = TreeManager.get(isam.indxShFile.fd, isam.fileLock, n4, isam);
            isam.tree.newIndex(n2, keyDesc, s2, s3, byArray);
            isam.irecord = new byte[n2 + 1];
            isam.curr = new NodeItemDesc(isam.tree.getIndexSize());
            if (isam.fileLock) {
                isam.fileExLock();
            } else {
                isam.testFileLock();
            }
            isam.isOpen = true;
            return isam;
        }
        catch (IsamException isamException) {
            isam.finalize();
            throw isamException;
        }
    }

    public int getRecNum() {
        return (int)this.recNum;
    }

    public long getLRecNum() {
        return this.recNum;
    }

    public void setRecNum(int n2) {
        this.recNum = n2;
    }

    public short getIndexSize() {
        return this.tree.getIndexSize();
    }

    public int getRecSize() {
        return this.tree.getRecSize();
    }

    public static Isam open(String string, int n2) throws IsamException {
        return new Isam(string, n2, false);
    }

    public static Isam open(String string, int n2, String string2) throws IsamException {
        return new Isam(string, n2, false, string2);
    }

    public static Isam open(String string, int n2, boolean bl) throws IsamException {
        return new Isam(string, n2, bl, null);
    }

    public static Isam open(String string, int n2, boolean bl, String string2) throws IsamException {
        return new Isam(string, n2, bl, string2);
    }

    public void lock() throws IsamException {
        if (!this.isOpen) {
            throw new IsamException(101);
        }
        if ((this.openMode & 0xF00) != 1024) {
            throw new IsamException(125);
        }
        this.fileLock();
    }

    public void unlock() throws IsamException {
        if (!this.isOpen) {
            throw new IsamException(101);
        }
        if ((this.openMode & 0xF00) != 1024) {
            throw new IsamException(125);
        }
        this.fileUnlock();
    }

    public void release() throws IsamException {
        if (!this.isOpen) {
            throw new IsamException(101);
        }
        this.allRecordUnlock();
    }

    public void close() throws IsamException {
        if (!this.isOpen) {
            throw new IsamException(101);
        }
        this.tree.cacheClear();
        this.tree.headerUnlock();
        Isam.sharedClose(this.tree.getFd(), this);
        this.tree.finalize();
        if (this.fdData != null) {
            Isam.sharedClose(this.fdData, this);
        }
        this.dataShFile = null;
        this.indxShFile = null;
        this.fdData = null;
        this.tree = null;
        this.isOpen = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexInfo(DictInfo dictInfo) throws IsamException {
        if (!this.isOpen) {
            throw new IsamException(101);
        }
        String string = this.indxShFile.canonicalPath;
        synchronized (string) {
            this.tree.indexInfo(dictInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexInfo(KeyDesc keyDesc, int n2) throws IsamException {
        if (!this.isOpen) {
            throw new IsamException(101);
        }
        String string = this.indxShFile.canonicalPath;
        synchronized (string) {
            this.tree.indexInfo(keyDesc, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDeletedRecords() throws IsamException {
        long l2 = 0L;
        String string = this.indxShFile.canonicalPath;
        synchronized (string) {
            try {
                this.tree.readHeader(false);
                l2 = this.tree.getDelRecNum();
            }
            finally {
                this.tree.headerUnlock();
            }
        }
        return l2;
    }

    public byte[] getCollatingSequence() throws IsamException {
        if (!this.isOpen) {
            throw new IsamException(101);
        }
        return this.tree.getCollatingSequence();
    }

    public void start(KeyDesc keyDesc, int n2, byte[] byArray, int n3) throws IsamException {
        this.start(keyDesc, n2, byArray, 0, n3);
    }

    public void start(KeyDesc keyDesc, int n2, byte[] byArray, int n3, int n4) throws IsamException {
        if (keyDesc == null || keyDesc.k_nparts == 0) {
            this.start((short)-1, n2, byArray, n3, n4);
        } else {
            this.start(this.tree.getKeyNum(keyDesc), n2, byArray, n3, n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void start(short s2, int n2, byte[] byArray, int n3, int n4) throws IsamException {
        int n5 = 0;
        n4 &= 0xFF;
        if (!this.isOpen) {
            throw new IsamException(101);
        }
        if ((this.openMode & 3) == 1) {
            throw new IsamException(125);
        }
        String string = this.indxShFile.canonicalPath;
        // MONITORENTER : string
        try {
            this.tree.readHeader(false);
            this.recNum = 0L;
            this.currIndex = s2;
            if (this.currIndex == -1) {
                switch (n4) {
                    case 0: {
                        this.curr.numRec = 1L;
                        this.curr.positioned = true;
                        while (n5 == 0 && this.curr.numRec <= this.tree.getNRecords()) {
                            n5 = this.checkDeleted(this.curr.numRec);
                            if (n5 != 0) continue;
                            ++this.curr.numRec;
                        }
                        if (n5 != 10) {
                            this.curr.numRec = Long.MAX_VALUE;
                            throw new IsamException(110);
                        }
                        this.recNum = this.curr.numRec;
                        return;
                    }
                    case 1: {
                        this.curr.numRec = this.tree.getNRecords();
                        this.curr.positioned = true;
                        while (n5 == 0 && this.curr.numRec > 0L) {
                            n5 = this.checkDeleted(this.curr.numRec);
                            if (n5 != 0) continue;
                            --this.curr.numRec;
                        }
                        if (n5 != 10) {
                            this.curr.numRec = 0L;
                            throw new IsamException(110);
                        }
                        this.recNum = this.curr.numRec;
                        return;
                    }
                    case 5: {
                        if (this.recNum <= 0L) throw new IsamException(111);
                        if (this.recNum > this.tree.getNRecords()) throw new IsamException(111);
                        n5 = this.checkDeleted(this.recNum);
                        if (n5 != 10) {
                            throw new IsamException(111);
                        }
                        this.curr.numRec = this.recNum;
                        this.curr.positioned = true;
                        return;
                    }
                }
                throw new IsamException(102);
            }
            short s3 = this.tree.getKeyLen(this.currIndex);
            byte[] byArray2 = new byte[s3];
            if (n4 == 0) {
                Util.memset(byArray2, (byte)0, s3);
                n2 = s3;
            } else if (n4 == 1) {
                Util.memset(byArray2, (byte)-1, s3);
                n2 = s3;
            } else {
                this.tree.buildKey(this.currIndex, byArray, n3, byArray2);
                if (n2 <= 0 || n2 > s3) {
                    n2 = s3;
                }
            }
            NodeItemDesc nodeItemDesc = this.tree.findKey(byArray2, this.currIndex, n2, n4);
            if (nodeItemDesc != null) {
                this.curr.assign(nodeItemDesc);
                this.curr.positioned = true;
                this.recNum = nodeItemDesc.numRec;
                return;
            }
            this.curr.numRec = Long.MAX_VALUE;
            throw new IsamException(111);
        }
        finally {
            this.tree.headerUnlock();
        }
    }

    public void read(byte[] byArray, int n2) throws IsamException {
        this.read(byArray, 0, n2);
    }

    public void read(byte[] byArray, int n2, int n3) throws IsamException {
        if (!this.isOpen) {
            throw new IsamException(101);
        }
        if ((this.openMode & 3) == 1) {
            throw new IsamException(125);
        }
        if ((n3 & 0x1000) == 4096) {
            int n4;
            do {
                try {
                    this.pIread(byArray, n2, n3);
                    n4 = 0;
                }
                catch (IsamException isamException) {
                    n4 = isamException.getIserrno();
                    if (n4 != 107) {
                        throw isamException;
                    }
                    this.recordLock(this.recNum, true, true);
                    this.recordUnlock(this.recNum);
                }
            } while (n4 == 107);
        } else {
            this.pIread(byArray, n2, n3);
        }
    }

    public void write(byte[] byArray) throws IsamException {
        this.write(byArray, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] byArray, int n2) throws IsamException {
        if (!this.isOpen) {
            throw new IsamException(101);
        }
        if ((this.openMode & 3) == 0) {
            throw new IsamException(125);
        }
        String string = this.indxShFile.canonicalPath;
        synchronized (string) {
            try {
                this.tree.readHeader(true);
                byte[][] byArray2 = this.tree.buildAllKeys(byArray, n2, 0L);
                long l2 = this.tree.getNewRecNum();
                try {
                    this.tree.insertKeys(byArray2, l2);
                }
                catch (IsamException isamException) {
                    this.tree.resetGetNewRecNum(l2);
                    this.recordUnlock(l2);
                    throw isamException;
                }
                int n3 = this.tree.getRecSize();
                this.fdData.seek((l2 - 1L) * (long)(n3 + 1));
                if (n3 > byArray.length) {
                    System.arraycopy(byArray, 0, this.irecord, 0, byArray.length);
                    Arrays.fill(this.irecord, byArray.length, this.irecord.length, (byte)0);
                    this.writeData(this.irecord, n2);
                } else {
                    this.writeData(byArray, n2);
                }
                this.recNum = l2;
                this.recordUnlock(l2);
            }
            finally {
                this.tree.headerUnlock();
            }
        }
    }

    public void wrcurr(byte[] byArray) throws IsamException {
        this.write(byArray);
        this.currIndex = (short)-1;
        this.curr.numRec = this.recNum;
    }

    public void delrec(int n2) throws IsamException {
        this.delrec((long)n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delrec(long l2) throws IsamException {
        if (!this.isOpen) {
            throw new IsamException(101);
        }
        if ((this.openMode & 3) == 0) {
            throw new IsamException(125);
        }
        String string = this.indxShFile.canonicalPath;
        synchronized (string) {
            try {
                this.tree.readHeader(true);
                if (l2 == 0L || l2 > this.tree.getNRecords()) {
                    throw new IsamException(102);
                }
                this.recNum = l2;
                this.delByNumrec();
            }
            finally {
                this.tree.headerUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delcurr() throws IsamException {
        NodeItemDesc nodeItemDesc = new NodeItemDesc(this.tree.getIndexSize());
        if (!this.isOpen) {
            throw new IsamException(101);
        }
        if ((this.openMode & 3) == 0) {
            throw new IsamException(125);
        }
        String string = this.indxShFile.canonicalPath;
        synchronized (string) {
            try {
                this.tree.readHeader(true);
                if (this.curr.numRec == 0L || this.curr.numRec > this.tree.getNRecords()) {
                    throw new IsamException(112);
                }
                this.recNum = this.curr.numRec;
                this.delByNumrec();
                this.curr.numRec = 0L;
            }
            finally {
                this.tree.headerUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(byte[] byArray, int n2) throws IsamException {
        NodeItemDesc nodeItemDesc = new NodeItemDesc(this.tree.getIndexSize());
        if (!this.isOpen) {
            throw new IsamException(101);
        }
        if ((this.openMode & 3) == 0) {
            throw new IsamException(125);
        }
        String string = this.indxShFile.canonicalPath;
        synchronized (string) {
            block9: {
                try {
                    this.tree.readHeader(true);
                    byte[] byArray2 = new byte[255];
                    this.tree.buildKey((short)0, byArray, n2, byArray2);
                    nodeItemDesc = this.tree.findKey(byArray2, (short)0, 0, 5);
                    if (nodeItemDesc != null) {
                        this.recNum = nodeItemDesc.numRec;
                        this.delByNumrec();
                        break block9;
                    }
                    throw new IsamException(111);
                }
                finally {
                    this.tree.headerUnlock();
                }
            }
        }
    }

    public void rewrec(int n2, byte[] byArray, int n3) throws IsamException {
        this.rewrec((long)n2, byArray, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rewrec(long l2, byte[] byArray, int n2) throws IsamException {
        if (!this.isOpen) {
            throw new IsamException(101);
        }
        if ((this.openMode & 3) == 0) {
            throw new IsamException(125);
        }
        if (l2 <= 0L) {
            throw new IsamException(102);
        }
        if (l2 > this.tree.getNRecords()) {
            throw new IsamException(110);
        }
        String string = this.indxShFile.canonicalPath;
        synchronized (string) {
            try {
                this.tree.readHeader(true);
                byte[][] byArray2 = this.tree.buildAllKeys(byArray, n2, l2);
                this.recNum = l2;
                boolean bl = false;
                try {
                    bl = this.recordLock(this.recNum, false, false);
                    this.fdData.seek((l2 - 1L) * (long)(this.tree.getRecSize() + 1));
                    byte by = this.readData(this.irecord);
                    if (by == 0) {
                        throw new IsamException(111);
                    }
                    if (by != 10) {
                        throw new IsamException(105);
                    }
                    this.tree.rewriteAllKeys(this.irecord, byArray, n2, this.recNum, byArray2);
                    int n3 = this.tree.getRecSize();
                    this.fdData.seek((l2 - 1L) * (long)(n3 + 1));
                    if (n3 > byArray.length) {
                        System.arraycopy(byArray, 0, this.irecord, 0, byArray.length);
                        Arrays.fill(this.irecord, byArray.length, this.irecord.length, (byte)0);
                        this.fdData.writeBlk(this.irecord, n2, n3);
                    } else {
                        this.fdData.writeBlk(byArray, n2, n3);
                    }
                }
                finally {
                    if ((this.openMode & 0xF00) != 1024) {
                        this.recordUnlock(this.recNum);
                    } else if (bl) {
                        Isam.recordUnlockIsfd(this, this.recNum, this.dataShFile);
                    }
                }
            }
            finally {
                this.tree.headerUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rewrite(byte[] byArray, int n2) throws IsamException {
        if (!this.isOpen) {
            throw new IsamException(101);
        }
        if ((this.openMode & 3) == 0) {
            throw new IsamException(125);
        }
        String string = this.indxShFile.canonicalPath;
        synchronized (string) {
            block9: {
                try {
                    this.tree.readHeader(true);
                    byte[] byArray2 = new byte[255];
                    this.tree.buildKey((short)0, byArray, n2, byArray2);
                    NodeItemDesc nodeItemDesc = this.tree.findKey(byArray2, (short)0, 0, 5);
                    if (nodeItemDesc != null) {
                        this.rewrec(nodeItemDesc.numRec, byArray, n2);
                        break block9;
                    }
                    throw new IsamException(111);
                }
                finally {
                    this.tree.headerUnlock();
                }
            }
        }
    }

    public void rewcurr(byte[] byArray, int n2) throws IsamException {
        if (!this.isOpen) {
            throw new IsamException(101);
        }
        if (this.curr.numRec == 0L || this.curr.numRec > this.tree.getNRecords()) {
            throw new IsamException(112);
        }
        this.rewrec(this.curr.numRec, byArray, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addindex(KeyDesc keyDesc) throws IsamException {
        if (!this.isOpen) {
            throw new IsamException(101);
        }
        if ((this.openMode & 3) == 0) {
            throw new IsamException(125);
        }
        String string = this.indxShFile.canonicalPath;
        synchronized (string) {
            try {
                this.tree.readHeader(true);
                this.tree.addIndex(keyDesc, this.fdData);
                this.tree.writeHeader(false);
            }
            finally {
                this.tree.headerUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delindex(KeyDesc keyDesc) throws IsamException {
        if (!this.isOpen) {
            throw new IsamException(101);
        }
        if ((this.openMode & 3) == 0) {
            throw new IsamException(125);
        }
        String string = this.indxShFile.canonicalPath;
        synchronized (string) {
            try {
                this.tree.readHeader(true);
                short s2 = this.tree.getKeyNum(keyDesc);
                if (s2 == 0) {
                    throw new IsamException(109);
                }
                this.tree.delTree(s2);
                this.tree.writeHeader(false);
            }
            finally {
                this.tree.headerUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void erase(String string) throws IsamException {
        IsamException isamException = null;
        Class<Isam> clazz = Isam.class;
        synchronized (Isam.class) {
            try {
                OSFile.unlink(string + DEFAULT_INDEX_EXT);
            }
            catch (IsamException isamException2) {
                isamException = isamException2;
            }
            try {
                OSFile.unlink(string + DEFAULT_DATA_EXT);
            }
            catch (IsamException isamException3) {
                isamException = isamException3;
            }
            if (isamException != null) {
                throw isamException;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rename(String string, String string2) throws IsamException {
        Class<Isam> clazz = Isam.class;
        synchronized (Isam.class) {
            OSFile.rename(string + DEFAULT_INDEX_EXT, string2 + DEFAULT_INDEX_EXT);
            OSFile.rename(string + DEFAULT_DATA_EXT, string2 + DEFAULT_DATA_EXT);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    static String getTemporaryFile(String string) throws IsamException {
        String string2;
        int n2 = 1;
        try {
            File file;
            while (!(file = new File(string2 = string + n2++)).createNewFile()) {
            }
        }
        catch (IOException iOException) {
            throw new IsamException(iOException);
        }
        return string2;
    }

    public static String version() {
        return "JIsam; 2; r2.42 ($Revision: 25561 $)";
    }

    public int getVersion() {
        return this.tree.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long checkDeleteRecords() throws IsamException {
        if (!this.isOpen) {
            throw new IsamException(101);
        }
        String string = this.indxShFile.canonicalPath;
        synchronized (string) {
            return this.tree.checkDeleteRecords();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long checkDeleteNodes() throws IsamException {
        if (!this.isOpen) {
            throw new IsamException(101);
        }
        String string = this.indxShFile.canonicalPath;
        synchronized (string) {
            return this.tree.checkDeleteNodes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuild(boolean bl, PrintStream printStream) throws IsamException {
        if (!this.isOpen) {
            throw new IsamException(101);
        }
        if ((this.openMode & 3) == 0) {
            throw new IsamException(125);
        }
        if ((this.openMode & 0xF00) != 2048) {
            throw new IsamException(106);
        }
        String string = this.indxShFile.canonicalPath;
        synchronized (string) {
            try {
                this.indxShFile.fd = this.tree.rebuild(this.fdData, this.indexName, bl, printStream);
            }
            finally {
                this.tree.headerUnlock();
            }
        }
    }

    public void rebuild() throws IsamException {
        this.rebuild(false, null);
    }

    public long getDataLength() throws IsamException {
        return this.fdData.length();
    }

    public synchronized void finalize() {
        try {
            this.tree.headerUnlock();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.indxShFile != null && this.indxShFile.fd != null) {
            try {
                Isam.sharedClose(this.indxShFile.fd, this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.fdData != null) {
            try {
                Isam.sharedClose(this.fdData, this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.dataShFile = null;
        this.indxShFile = null;
        this.fdData = null;
        this.tree = null;
    }

    private static synchronized SharedFile sharedOpen(String string, int n2, int n3, String string2) throws IsamException {
        SharedFile sharedFile;
        try {
            string = new File(string).getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Enumeration enumeration = sharedFiles.elements();
        while (enumeration.hasMoreElements()) {
            sharedFile = (SharedFile)enumeration.nextElement();
            if (sharedFile == null || !string.equals(sharedFile.canonicalPath)) continue;
            string = sharedFile.canonicalPath;
            if (sharedFile.mode != 2 && sharedFile.mode != n2) continue;
            ++sharedFile.cnt;
            return sharedFile;
        }
        sharedFile = new SharedFile(string);
        sharedFile.fd = OSFile.get(string2);
        if (string2 != null && string2.length() > 0) {
            sharedFile.fd.setEncrypt();
        }
        int n4 = n2 & 0xFFFFFFFC;
        n2 &= 3;
        try {
            sharedFile.fd.open(string, 2 | n4);
            sharedFile.mode = 2;
        }
        catch (IsamException isamException) {
            if (n2 != 2 && isamException.getIserrno() == 131) {
                sharedFile.fd.open(string, n2 | n4);
                sharedFile.mode = n2;
            }
            throw isamException;
        }
        sharedFile.cnt = 1;
        sharedFile.lckChain = null;
        sharedFiles.addElement(sharedFile);
        return sharedFile;
    }

    static synchronized void sharedClose(OSFile oSFile, Isam isam) throws IsamException {
        Enumeration enumeration = sharedFiles.elements();
        while (enumeration.hasMoreElements()) {
            SharedFile sharedFile = (SharedFile)enumeration.nextElement();
            if (sharedFile == null || sharedFile.fd != oSFile) continue;
            if (!isam.fileLock) {
                RecordLock recordLock = sharedFile.lckChain;
                while (recordLock != null) {
                    if (recordLock.isfd == isam) {
                        long l2 = recordLock.numRec;
                        Isam.recordUnlockIsfd(isam, l2, sharedFile);
                    }
                    recordLock = recordLock.next;
                }
            }
            if (--sharedFile.cnt != 0) break;
            oSFile.close();
            sharedFiles.remove(sharedFile);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delByNumrec() throws IsamException {
        String string = this.indxShFile.canonicalPath;
        synchronized (string) {
            try {
                this.fdData.seek((this.recNum - 1L) * (long)(this.tree.getRecSize() + 1));
                byte by = this.readData(this.irecord);
                if (by == 0) {
                    throw new IsamException(111);
                }
                if (by != 10) {
                    throw new IsamException(105);
                }
                this.tree.deleteKeys(this.irecord, 0, this.recNum);
                this.deleteData(this.recNum);
            }
            finally {
                this.recordUnlock(this.recNum);
            }
        }
    }

    private void deleteData(long l2) throws IsamException {
        byte[] byArray = new byte[]{0};
        this.fdData.seek(this.recNum * (long)(this.tree.getRecSize() + 1) - 1L);
        this.fdData.write(byArray, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void pIread(byte[] var1_1, int var2_2, int var3_3) throws IsamException {
        var4_4 = 0;
        this.recNum = 0L;
        var6_5 = this.indxShFile.canonicalPath;
        synchronized (var6_5) {
            block88: {
                try {
                    this.tree.readHeader(false);
                    if (this.currIndex == -1 || this.tree.getKeyParts(this.currIndex) == 0) {
                        this.currIndex = (short)-1;
                        switch (var3_3 & 255) {
                            case 4: {
                                if (this.curr.numRec == 0L || this.curr.numRec > this.tree.getNRecords()) {
                                    throw new IsamException(112);
                                }
                                var4_4 = this.lockAndReadData(var3_3, this.curr.numRec, var1_1, var2_2);
                                if (var4_4 == 10) {
                                    this.recNum = this.curr.numRec;
                                    this.curr.positioned = false;
                                    break block88;
                                }
                                this.unlockData(var3_3, this.curr.numRec);
                                throw new IsamException(112);
                            }
                            case 2: {
                                if (this.curr.numRec > this.tree.getNRecords()) {
                                    this.curr.positioned = false;
                                    throw new IsamException(112);
                                }
                                if (this.curr.numRec <= 0L) {
                                    this.curr.numRec = 1L;
                                    this.curr.positioned = true;
                                } else if (!this.curr.positioned) {
                                    ++this.curr.numRec;
                                }
                                while (var4_4 == 0 && this.curr.numRec <= this.tree.getNRecords()) {
                                    var4_4 = this.lockAndReadData(var3_3, this.curr.numRec, var1_1, var2_2);
                                    if (var4_4 == 10) {
                                        this.recNum = this.curr.numRec;
                                        this.curr.positioned = false;
                                        continue;
                                    }
                                    if (var4_4 != 0) continue;
                                    this.unlockData(var3_3, this.curr.numRec);
                                    ++this.curr.numRec;
                                }
                                if (var4_4 != 10) {
                                    this.curr.numRec = 0x7FFFFFFFFFFFFFFFL;
                                    this.curr.positioned = true;
                                    throw new IsamException(110);
                                }
                                break block88;
                            }
                            case 3: {
                                if (this.curr.numRec > this.tree.getNRecords()) {
                                    if (this.curr.positioned) {
                                        this.curr.numRec = this.tree.getNRecords();
                                    } else {
                                        throw new IsamException(112);
                                    }
                                }
                                if (!this.curr.positioned) {
                                    --this.curr.numRec;
                                    this.curr.positioned = true;
                                }
                                if (this.curr.numRec <= 0L) {
                                    if (this.curr.positioned) {
                                        this.curr.positioned = false;
                                        throw new IsamException(110);
                                    }
                                    throw new IsamException(112);
                                }
                                while (var4_4 == 0 && this.curr.numRec > 0L) {
                                    var4_4 = this.lockAndReadData(var3_3, this.curr.numRec, var1_1, var2_2);
                                    if (var4_4 == 10) {
                                        this.recNum = this.curr.numRec;
                                        continue;
                                    }
                                    if (var4_4 != 0) continue;
                                    this.unlockData(var3_3, this.curr.numRec);
                                    --this.curr.numRec;
                                }
                                if (var4_4 != 10) {
                                    this.curr.numRec = 0L;
                                    this.curr.positioned = true;
                                    throw new IsamException(110);
                                }
                                break block88;
                            }
                            case 0: {
                                this.curr.numRec = 1L;
                                while (var4_4 == 0 && this.curr.numRec <= this.tree.getNRecords()) {
                                    var4_4 = this.lockAndReadData(var3_3, this.curr.numRec, var1_1, var2_2);
                                    if (var4_4 != 0) continue;
                                    this.unlockData(var3_3, this.curr.numRec);
                                    ++this.curr.numRec;
                                }
                                if (var4_4 != 10) {
                                    this.curr.positioned = false;
                                    throw new IsamException(110);
                                }
                                this.curr.positioned = false;
                                this.recNum = this.curr.numRec;
                                break block88;
                            }
                            case 1: {
                                this.curr.numRec = this.tree.getNRecords();
                                while (var4_4 == 0 && this.curr.numRec > 0L) {
                                    var4_4 = this.lockAndReadData(var3_3, this.curr.numRec, var1_1, var2_2);
                                    if (var4_4 != 0) continue;
                                    this.unlockData(var3_3, this.curr.numRec);
                                    --this.curr.numRec;
                                }
                                if (var4_4 != 10) {
                                    this.curr.positioned = false;
                                    throw new IsamException(110);
                                }
                                this.curr.positioned = false;
                                this.recNum = this.curr.numRec;
                                break block88;
                            }
                            default: {
                                throw new IsamException(102);
                            }
                        }
                    }
                    switch (var3_3 & 255) {
                        case 4: {
                            if (this.curr.numRec != 0L) ** GOTO lbl113
                            if (this.curr.positioned) {
                                this.start(this.currIndex, 0, var1_1, var2_2, 0);
                                this.pIread(var1_1, var2_2, var3_3);
                                ** break;
lbl111:
                                // 1 sources

                            } else {
                                throw new IsamException(112);
lbl113:
                                // 1 sources

                                if (this.curr.numRec > this.tree.getNRecords()) {
                                    this.curr.positioned = false;
                                    throw new IsamException(112);
                                }
                                if (this.tree.unchangedNode(this.currIndex, this.curr)) {
                                    var4_4 = this.lockAndReadData(var3_3, this.curr.numRec, var1_1, var2_2);
                                    if (var4_4 != 10) {
                                        this.curr.positioned = false;
                                        throw new IsamException(112);
                                    }
                                } else {
                                    var5_6 = this.tree.findKey(this.curr.keyVal, this.currIndex, 0, 7);
                                    if (var5_6 != null) {
                                        var5_6 = this.tree.next(this.currIndex, this.curr.keyVal, var5_6.keyPos - 1, var5_6.nodeAddr, this.curr.keyProg, true);
                                    }
                                    if (var5_6 != null) {
                                        var4_4 = this.lockAndReadData(var3_3, var5_6.numRec, var1_1, var2_2);
                                        if (var4_4 != 10) {
                                            this.curr.positioned = false;
                                            throw new IsamException(112);
                                        }
                                        this.curr.assign(var5_6);
                                    } else {
                                        this.curr.positioned = false;
                                        throw new IsamException(112);
                                    }
                                }
                                this.recNum = this.curr.numRec;
                                ** break;
                            }
lbl136:
                            // 1 sources

                            break;
                        }
                        case 2: {
                            if (this.curr.numRec > this.tree.getNRecords()) {
                                this.curr.positioned = false;
                                throw new IsamException(112);
                            }
                            if (this.curr.numRec <= 0L) {
                                try {
                                    this.start(this.currIndex, 0, var1_1, var2_2, 0);
                                }
                                catch (IsamException var7_9) {
                                    if (var7_9.getIserrno() == 111) {
                                        throw new IsamException(110);
                                    }
                                    throw var7_9;
                                }
                                this.pIread(var1_1, var2_2, var3_3);
                                ** break;
lbl151:
                                // 1 sources

                                break;
                            }
                            if (this.curr.positioned) {
                                if (this.tree.unchangedNode(this.currIndex, this.curr)) {
                                    var5_7 = this.curr;
                                } else {
                                    var5_7 = this.tree.findKey(this.curr.keyVal, this.currIndex, 0, 7);
                                    if (var5_7 != null) {
                                        var5_7 = this.tree.next(this.currIndex, this.curr.keyVal, var5_7.keyPos - 1, var5_7.nodeAddr, this.curr.keyProg, true);
                                    }
                                }
                            } else {
                                var5_7 = this.tree.unchangedNode(this.currIndex, this.curr) != false ? this.curr : this.tree.findKey(this.curr.keyVal, this.currIndex, 0, 7);
                                if (var5_7 != null) {
                                    var5_7 = this.tree.next(this.currIndex, this.curr.keyVal, var5_7.keyPos - 1, var5_7.nodeAddr, this.curr.keyProg, false);
                                }
                            }
                            if (var5_7 != null) {
                                var4_4 = this.lockAndReadData(var3_3, var5_7.numRec, var1_1, var2_2);
                                if (var4_4 != 10) {
                                    throw new IsamException(105);
                                }
                            } else {
                                this.curr.numRec = 0x7FFFFFFFFFFFFFFFL;
                                this.curr.positioned = true;
                                throw new IsamException(110);
                            }
                            this.curr.assign(var5_7);
                            this.curr.positioned = false;
                            this.recNum = this.curr.numRec;
                            ** break;
lbl175:
                            // 1 sources

                            break;
                        }
                        case 3: {
                            if (this.curr.numRec <= 0L) {
                                if (this.curr.positioned) {
                                    this.curr.positioned = false;
                                    throw new IsamException(110);
                                }
                                throw new IsamException(112);
                            }
                            if (this.curr.numRec > this.tree.getNRecords()) {
                                if (this.curr.positioned) {
                                    try {
                                        this.start(this.currIndex, 0, var1_1, var2_2, 1);
                                    }
                                    catch (IsamException var7_10) {
                                        if (var7_10.getIserrno() == 111) {
                                            throw new IsamException(110);
                                        }
                                        throw var7_10;
                                    }
                                    this.pIread(var1_1, var2_2, var3_3);
                                    ** break;
lbl193:
                                    // 1 sources

                                    break;
                                }
                                throw new IsamException(112);
                            }
                            if (this.curr.positioned) {
                                if (this.tree.unchangedNode(this.currIndex, this.curr)) {
                                    var5_8 = this.curr;
                                } else {
                                    var5_8 = this.tree.findKey(this.curr.keyVal, this.currIndex, 0, 9);
                                    if (var5_8 != null) {
                                        var5_8 = this.tree.prev(this.currIndex, this.curr.keyVal, var5_8.keyPos + 1, var5_8.nodeAddr, this.curr.keyProg, true);
                                    }
                                }
                            } else {
                                var5_8 = this.tree.unchangedNode(this.currIndex, this.curr) != false ? this.curr : this.tree.findKey(this.curr.keyVal, this.currIndex, 0, 9);
                                if (var5_8 != null) {
                                    var5_8 = this.tree.prev(this.currIndex, this.curr.keyVal, var5_8.keyPos + 1, var5_8.nodeAddr, this.curr.keyProg, false);
                                }
                            }
                            if (var5_8 != null) {
                                var4_4 = this.lockAndReadData(var3_3, var5_8.numRec, var1_1, var2_2);
                                if (var4_4 != 10) {
                                    throw new IsamException(105);
                                }
                            } else {
                                this.curr.numRec = 0L;
                                this.curr.positioned = false;
                                throw new IsamException(110);
                            }
                            this.curr.assign(var5_8);
                            this.curr.positioned = false;
                            this.recNum = this.curr.numRec;
                            ** break;
lbl218:
                            // 1 sources

                            break;
                        }
                        case 0: {
                            this.start(this.currIndex, 0, var1_1, var2_2, 0);
                            this.read(var1_1, var2_2, 2 | var3_3 & 3840);
                            ** break;
lbl223:
                            // 1 sources

                            break;
                        }
                        case 1: {
                            this.start(this.currIndex, 0, var1_1, var2_2, 1);
                            this.read(var1_1, var2_2, 3 | var3_3 & 3840);
                            ** break;
lbl228:
                            // 1 sources

                            break;
                        }
                        case 5: {
                            this.start(this.currIndex, 0, var1_1, var2_2, 5);
                            this.read(var1_1, var2_2, 2 | var3_3 & 3840);
                            ** break;
lbl233:
                            // 1 sources

                            break;
                        }
                        case 6: {
                            this.start(this.currIndex, 0, var1_1, var2_2, 6);
                            this.read(var1_1, var2_2, 2 | var3_3 & 3840);
                            ** break;
lbl238:
                            // 1 sources

                            break;
                        }
                        case 7: {
                            this.start(this.currIndex, 0, var1_1, var2_2, 7);
                            this.read(var1_1, var2_2, 2 | var3_3 & 3840);
                            ** break;
lbl243:
                            // 1 sources

                            break;
                        }
                        case 8: {
                            this.start(this.currIndex, 0, var1_1, var2_2, 8);
                            this.read(var1_1, var2_2, 3 | var3_3 & 3840);
                            ** break;
lbl248:
                            // 1 sources

                            break;
                        }
                        case 9: {
                            this.start(this.currIndex, 0, var1_1, var2_2, 9);
                            this.read(var1_1, var2_2, 3 | var3_3 & 3840);
                            ** break;
lbl253:
                            // 1 sources

                            break;
                        }
                        default: {
                            throw new IsamException(102);
                        }
                    }
                }
                finally {
                    this.tree.headerUnlock();
                }
            }
        }
    }

    private byte readData(byte[] byArray) throws IsamException {
        int n2 = this.tree.getRecSize();
        this.fdData.readBlk(byArray, 0, n2);
        try {
            this.fdData.read(byArray, n2, 1);
        }
        catch (IsamException isamException) {
            byArray[n2] = 10;
        }
        return byArray[n2];
    }

    private byte _readData(byte[] byArray, int n2) throws IsamException {
        int n3 = this.tree.getRecSize();
        this.fdData.readBlk(this.irecord, 0, n3);
        try {
            this.fdData.read(this.irecord, n3, 1);
        }
        catch (IsamException isamException) {
            this.irecord[n3] = 10;
        }
        if (this.irecord[n3] == 10) {
            Util.memcpy(byArray, n2, this.irecord, 0, n3);
        }
        return this.irecord[n3];
    }

    private byte checkDeleted(long l2) throws IsamException {
        byte[] byArray = new byte[]{0};
        this.fdData.seek((l2 - 1L) * (long)(this.tree.getRecSize() + 1) + (long)this.tree.getRecSize());
        try {
            this.fdData.read(byArray, 0, 1);
        }
        catch (IsamException isamException) {
            byArray[0] = 10;
        }
        return byArray[0];
    }

    private void writeData(byte[] byArray, int n2) throws IsamException {
        byte[] byArray2 = new byte[]{10};
        this.fdData.writeBlk(byArray, n2, this.tree.getRecSize());
        this.fdData.write(byArray2, 0, 1);
    }

    private void checkMode(int n2) throws IsamException {
        switch (n2 & 3) {
            case 0: {
                this.osMode = 0;
                break;
            }
            case 1: {
                this.osMode = 1;
                break;
            }
            case 2: {
                this.osMode = 2;
                break;
            }
            default: {
                throw new IsamException(102);
            }
        }
        switch (n2 & 0xF00) {
            case 512: 
            case 1024: {
                break;
            }
            case 2048: {
                this.osMode = 2;
                break;
            }
            default: {
                throw new IsamException(102);
            }
        }
    }

    private static void checkFileName(String string) throws IsamException {
        if (string == null || string.length() == 0) {
            throw new IsamException(102);
        }
    }

    private short lockType() {
        return (short)((this.openMode & 3) != 0 ? 1 : 0);
    }

    private void fileExLock() throws IsamException {
        if (!this.fileLock) {
            if (this.indxShFile.cnt > 0 && this.indxShFile.fileLock != null) {
                throw new IsamException(113);
            }
            FLock fLock = new FLock();
            this.tree.fileExLock(fLock, this.lockType());
            this.indxShFile.fileLock = fLock;
            this.fileLock = true;
        }
    }

    private void testFileLock() throws IsamException {
        if (this.indxShFile.cnt > 0 && this.indxShFile.fileLock != null) {
            if (this.indxShFile.fileLock.l_type != 0) {
                throw new IsamException(113);
            }
        } else {
            FLock fLock = new FLock();
            this.tree.testFileLock(fLock);
            this.indxShFile.fileLock = fLock;
        }
    }

    static void recordUnlockIsfd(Isam isam, long l2, SharedFile sharedFile) throws IsamException {
        boolean bl = false;
        RecordLock recordLock = sharedFile.lckChain;
        RecordLock recordLock2 = null;
        RecordLock recordLock3 = null;
        RecordLock recordLock4 = null;
        while (recordLock != null) {
            if (recordLock.numRec == l2) {
                if (recordLock.isfd == isam) {
                    recordLock4 = recordLock2;
                    recordLock3 = recordLock;
                } else {
                    bl = true;
                }
            }
            recordLock2 = recordLock;
            recordLock = recordLock.next;
        }
        if (!bl) {
            FLock fLock = new FLock();
            fLock.l_whence = 0;
            fLock.l_start = l2 * (long)(isam.tree.getRecSize() + 1) - 1L;
            fLock.l_len = 1;
            fLock.l_type = (short)2;
            isam.fdData.fcntl(6, fLock);
        }
        if (recordLock4 == null) {
            sharedFile.lckChain = recordLock3.next;
        } else {
            recordLock4.next = recordLock3.next;
        }
    }

    private void fileLock() throws IsamException {
        if (!this.fileLock) {
            FLock fLock = new FLock();
            fLock.l_whence = 0;
            fLock.l_start = 0L;
            fLock.l_len = 0;
            fLock.l_type = this.lockType();
            this.fdData.fcntl(6, fLock);
            this.fileLock = true;
        }
    }

    private void fileUnlock() throws IsamException {
        if (this.fileLock) {
            FLock fLock = new FLock();
            fLock.l_whence = 0;
            fLock.l_start = 0L;
            fLock.l_len = 0;
            fLock.l_type = (short)2;
            this.fdData.fcntl(6, fLock);
            this.fileLock = false;
        }
    }

    private void unlockData(int n2, long l2) throws IsamException {
        if ((this.openMode & 0xF00) == 512 || (n2 & 0xF00) == 256) {
            this.recordUnlock(l2);
        }
    }

    private byte lockAndReadData(int n2, long l2, byte[] byArray, int n3) throws IsamException {
        byte by;
        if (LOCK_READ_ANYHOW || (n2 & 0x2000) == 8192) {
            this.fdData.seek((l2 - 1L) * (long)(this.tree.getRecSize() + 1));
            by = this._readData(byArray, n3);
            this._lockData(n2, l2);
        } else {
            this._lockData(n2, l2);
            this.fdData.seek((l2 - 1L) * (long)(this.tree.getRecSize() + 1));
            by = this._readData(byArray, n3);
        }
        return by;
    }

    private void _lockData(int n2, long l2) throws IsamException {
        if ((this.openMode & 0xF00) == 512 || (n2 & 0xF00) == 256) {
            if ((this.openMode & 0xF00) == 512) {
                this.allRecordUnlock();
            }
            this.recNum = l2;
            boolean bl = this.recordLock(l2, false, true);
            if ((n2 & 0x2000) == 8192 && bl) {
                this.recordUnlock(l2);
            }
        }
    }

    private boolean recordLock(long l2, boolean bl, boolean bl2) throws IsamException {
        boolean bl3 = false;
        if (!this.fileLock) {
            SharedFile sharedFile = this.dataShFile;
            boolean bl4 = false;
            boolean bl5 = false;
            RecordLock recordLock = sharedFile.lckChain;
            short s2 = this.lockType();
            while (recordLock != null) {
                if (recordLock.numRec == l2) {
                    if (recordLock.isfd == this) {
                        bl4 = true;
                        bl5 = false;
                        break;
                    }
                    if (recordLock.readLock && s2 == 0) {
                        bl4 = true;
                        bl5 = true;
                    } else {
                        if (bl2 && this.strictLock) {
                            throw new IsamException(107);
                        }
                        bl4 = true;
                        if (recordLock.isfd == this) break;
                        if (this.strictLock) {
                            throw new IsamException(107);
                        }
                    }
                }
                recordLock = recordLock.next;
            }
            if (!bl4) {
                FLock fLock = new FLock();
                fLock.l_whence = 0;
                fLock.l_start = l2 * (long)(this.tree.getRecSize() + 1) - 1L;
                fLock.l_len = 1;
                fLock.l_type = s2;
                try {
                    this.fdData.fcntl(bl ? 7 : 6, fLock);
                }
                catch (IsamException isamException) {
                    if (isamException.getIserrno() == 113) {
                        throw new IsamException(107);
                    }
                    throw isamException;
                }
                this.lastRecordLock = l2;
            }
            if (recordLock == null || bl5) {
                recordLock = new RecordLock(this, l2, s2 == 0);
                recordLock.next = sharedFile.lckChain;
                sharedFile.lckChain = recordLock;
                this.lastRecordLock = l2;
                bl3 = true;
            }
        }
        return bl3;
    }

    private void recordUnlock(long l2) throws IsamException {
        if (!this.fileLock) {
            SharedFile sharedFile = this.dataShFile;
            boolean bl = false;
            RecordLock recordLock = sharedFile.lckChain;
            RecordLock recordLock2 = null;
            while (recordLock != null) {
                if (recordLock.numRec == l2) {
                    bl = true;
                    RecordLock recordLock3 = recordLock.next;
                    if (recordLock2 == null) {
                        sharedFile.lckChain = recordLock.next;
                    } else {
                        recordLock2.next = recordLock.next;
                    }
                    recordLock = recordLock3;
                    continue;
                }
                recordLock2 = recordLock;
                recordLock = recordLock.next;
            }
            if (bl) {
                FLock fLock = new FLock();
                fLock.l_whence = 0;
                fLock.l_start = l2 * (long)(this.tree.getRecSize() + 1) - 1L;
                fLock.l_len = 1;
                fLock.l_type = (short)2;
                this.fdData.fcntl(6, fLock);
            }
        }
    }

    private void allRecordUnlock() throws IsamException {
        if (this.lastRecordLock != 0L) {
            SharedFile sharedFile = this.dataShFile;
            RecordLock recordLock = sharedFile.lckChain;
            while (recordLock != null && recordLock.isfd == this) {
                this.recordUnlock(recordLock.numRec);
                recordLock = sharedFile.lckChain;
            }
            this.lastRecordLock = 0L;
        }
    }

    NodeItemDesc getCurr() {
        return this.curr;
    }

    OSFile getFd() {
        return this.tree.getFd();
    }

    int getFirstNodeAddr() {
        return this.tree.getFirstNodeAddr();
    }

    static {
        sharedFiles = new Vector();
    }
}

