/*
 * Decompiled with CFR 0.152.
 */
package IT.picosoft.isam;

import IT.picosoft.isam.DictInfo;
import IT.picosoft.isam.Isam;
import IT.picosoft.isam.IsamException;
import IT.picosoft.isam.KeyDesc;
import IT.picosoft.isam.KeyPart;
import IT.picosoft.isam.Util;
import java.io.IOException;

public class IsamTest {
    static final int ISBUILD = 0;
    static final int ISOPEN = 1;
    static final int ISWRITE = 2;
    static final int ISREWRITE = 3;
    static final int ISSTART = 4;
    static final int ISREAD = 5;
    static final int ISDELCURR = 6;
    static final int ISDELETE = 7;
    static final int ISDELREC = 8;
    static final int IS_LOCK = 9;
    static final int ISUNLOCK = 10;
    static final int ISRELEASE = 11;
    static final int ISINDEXINFO = 12;
    static final int ISADDINDEX = 13;
    static final int ISDELINDEX = 14;
    static final int ISREWCURR = 15;
    static final int ISREWREC = 16;
    static final int ISWRCURR = 17;
    static final int ISAUDIT = 18;
    static final int ISCLOSE = 19;
    static final int ISERASE = 20;
    static final int ISWRITELOCK = 21;
    static final int ISRENAME = 22;
    static final int ISLOGOPEN = 23;
    static final int ISLOGCLOSE = 24;
    static final int ISBEGIN = 25;
    static final int ISCOMMIT = 26;
    static final int ISROLLBACK = 27;
    static final int ISREBUILD = 28;
    static final int ISCHECKDELETERECORDS = 29;
    String[][] operArray = new String[][]{{"isbuild      ", "0"}, {"isopen       ", "1"}, {"iswrite      ", "2"}, {"isrewrite    ", "3"}, {"isstart      ", "4"}, {"isread       ", "5"}, {"isdelcurr    ", "6"}, {"isdelete     ", "7"}, {"isdelrec     ", "8"}, {"lock         ", "9"}, {"unlock      ", "10"}, {"isrelease   ", "11"}, {"isindexinfo ", "12"}, {"isaddindex  ", "13"}, {"isdelindex  ", "14"}, {"isrewcurr   ", "15"}, {"isrewrec    ", "16"}, {"iswrcurr    ", "17"}, {"isclose     ", "19"}, {"isrebuild   ", "28"}};
    Isam isfld;

    public static void main(String[] stringArray) {
        new IsamTest();
    }

    void printEx(Exception exception) {
        System.out.println(exception);
        exception.printStackTrace();
    }

    void help() {
        for (int i2 = 0; i2 < this.operArray.length; ++i2) {
            System.out.print(this.operArray[i2][0] + " - " + this.operArray[i2][1] + "  ");
            if ((i2 + 1) % 4 != 0) continue;
            System.out.println("");
        }
        System.out.println("");
    }

    int readInt() {
        int n2 = 0;
        while (true) {
            int n3;
            try {
                n3 = System.in.read();
            }
            catch (IOException iOException) {
                n3 = 10;
            }
            if (n3 >= 48 && n3 <= 57) {
                n2 *= 10;
                n2 += n3 - 48;
                continue;
            }
            if (n3 == 10) break;
        }
        return n2;
    }

    String readString() {
        String string = "";
        while (true) {
            char c2;
            try {
                c2 = (char)System.in.read();
            }
            catch (IOException iOException) {
                c2 = '\n';
            }
            if (c2 >= ' ') {
                string = string + c2;
                continue;
            }
            if (c2 == '\n') break;
        }
        return string;
    }

    public IsamTest() {
        byte[] byArray = new byte[1024];
        block32: while (true) {
            this.help();
            int n2 = this.readInt();
            System.out.println("Scelta = " + n2);
            switch (n2) {
                case 0: {
                    this.isBuild();
                    continue block32;
                }
                case 1: {
                    this.isOpen();
                    continue block32;
                }
                case 2: {
                    this.isWrite();
                    continue block32;
                }
                case 12: {
                    this.isIndexInfo();
                    continue block32;
                }
                case 29: {
                    this.isCheckDeleteRecords();
                    continue block32;
                }
                case 13: {
                    this.isAddIndex();
                    continue block32;
                }
                case 14: {
                    this.isDelIndex();
                    continue block32;
                }
                case 19: {
                    this.isClose();
                    continue block32;
                }
                case 4: {
                    this.isStart();
                    continue block32;
                }
                case 5: {
                    this.isRead();
                    continue block32;
                }
                case 6: {
                    this.isDelCurr();
                    continue block32;
                }
                case 3: {
                    this.isRewrite();
                    continue block32;
                }
                case 7: {
                    this.isDelete();
                    continue block32;
                }
                case 8: {
                    this.isDelRec();
                    continue block32;
                }
                case 9: {
                    this.isLock();
                    continue block32;
                }
                case 10: {
                    this.isUnlock();
                    continue block32;
                }
                case 11: {
                    this.isRelease();
                    continue block32;
                }
                case 15: {
                    this.isRewCurr();
                    continue block32;
                }
                case 16: {
                    this.isRewRec();
                    continue block32;
                }
                case 17: {
                    this.isWrCurr();
                    continue block32;
                }
                case 21: {
                    continue block32;
                }
                case 18: {
                    continue block32;
                }
                case 20: {
                    continue block32;
                }
                case 22: {
                    continue block32;
                }
                case 23: {
                    continue block32;
                }
                case 24: {
                    continue block32;
                }
                case 25: {
                    continue block32;
                }
                case 26: {
                    continue block32;
                }
                case 27: {
                    continue block32;
                }
                case 28: {
                    this.isRebuild();
                    continue block32;
                }
            }
            System.exit(0);
        }
    }

    boolean conferma() {
        System.out.print("conferma(s/n) ");
        String string = this.readString();
        return string.length() > 0 && (string.charAt(0) == 'y' || string.charAt(0) == 's' || string.charAt(0) == 'Y' || string.charAt(0) == 'S');
    }

    void isOpen() {
        System.out.print("filename         ? ");
        String string = this.readString();
        System.out.print("mode             ? ");
        int n2 = this.readInt();
        System.out.print("strictLock (0/1) ? ");
        boolean bl = this.readInt() != 0;
        System.out.println("filename         = " + string);
        System.out.println("mode             = " + n2);
        System.out.println("strictLock       = " + bl);
        if (this.conferma()) {
            try {
                this.isfld = new Isam(string, n2, bl);
            }
            catch (IsamException isamException) {
                this.printEx(isamException);
            }
        }
    }

    void isStart() {
        int n2;
        int n3 = 0;
        KeyDesc keyDesc = new KeyDesc();
        System.out.print("key npart? ");
        keyDesc.k_nparts = (short)this.readInt();
        if (keyDesc.k_nparts == 0) {
            System.out.print("pIsrecnum? ");
            n3 = this.readInt();
            this.isfld.setRecNum(n3);
        }
        for (n2 = 0; n2 < keyDesc.k_nparts; ++n2) {
            keyDesc.k_part[n2] = new KeyPart();
            System.out.print("start[" + n2 + "] ? ");
            keyDesc.k_part[n2].kp_start = (short)this.readInt();
            System.out.print("leng [" + n2 + "] ? ");
            keyDesc.k_part[n2].kp_leng = (short)this.readInt();
        }
        System.out.print("key len  ? ");
        int n4 = this.readInt();
        System.out.print("----+----1----+----2----+----3----+----4");
        System.out.println("----+----5----+----6----+----7----+----");
        byte[] byArray = this.readString().getBytes();
        System.out.print("mode     ? ");
        int n5 = this.readInt();
        if (keyDesc.k_nparts == 0) {
            System.out.println("pIsrecnum== " + n3);
        } else {
            System.out.println("key npart= " + keyDesc.k_nparts);
            for (n2 = 0; n2 < keyDesc.k_nparts; ++n2) {
                System.out.println("start[" + n2 + "] = " + keyDesc.k_part[n2].kp_start);
                System.out.println("leng [" + n2 + "] = " + keyDesc.k_part[n2].kp_leng);
            }
        }
        System.out.println("length   = " + n4);
        System.out.println(new String(byArray));
        System.out.println("mode     = " + n5);
        if (this.conferma()) {
            try {
                this.isfld.start(keyDesc, n4, byArray, n5);
                System.out.println("isrecnum = " + this.isfld.getRecNum());
            }
            catch (IsamException isamException) {
                System.out.println(isamException);
            }
        }
    }

    void isCheckDeleteRecords() {
        try {
            this.isfld.checkDeleteRecords();
            System.out.println("Check OK");
        }
        catch (IsamException isamException) {
            this.printEx(isamException);
        }
    }

    void isIndexInfo() {
        DictInfo dictInfo = new DictInfo();
        KeyDesc keyDesc = new KeyDesc();
        try {
            this.isfld.indexInfo(dictInfo);
            System.out.println("nkeys=" + dictInfo.di_nkeys + ", recsize=" + dictInfo.di_recsize + ", idxsize=" + dictInfo.di_idxsize + ", nrecords=" + dictInfo.di_nrecords);
            int n2 = 1;
            while (true) {
                try {
                    this.isfld.indexInfo(keyDesc, n2);
                    System.out.println("   key=" + n2 + ", flags=" + keyDesc.k_flags + ", nparts=" + keyDesc.k_nparts);
                    for (int i2 = 0; i2 < keyDesc.k_nparts; ++i2) {
                        System.out.println("      part=" + i2 + ", start=" + keyDesc.k_part[i2].kp_start + ", leng=" + keyDesc.k_part[i2].kp_leng + ",type=" + keyDesc.k_part[i2].kp_type);
                    }
                }
                catch (IsamException isamException) {
                    break;
                }
                ++n2;
            }
        }
        catch (IsamException isamException) {
            this.printEx(isamException);
        }
    }

    void isRead() {
        byte[] byArray = new byte[this.isfld.getRecSize()];
        System.out.print("----+----1----+----2----+----3----+----4");
        System.out.println("----+----5----+----6----+----7----+----");
        byte[] byArray2 = this.readString().getBytes();
        Util.memcpy(byArray, 0, byArray2, 0, byArray2.length);
        System.out.print("mode     ? ");
        int n2 = this.readInt();
        System.out.println(new String(byArray));
        System.out.println("mode     = " + n2);
        if (this.conferma()) {
            try {
                this.isfld.read(byArray, n2);
                System.out.println("isread isrecnum=" + this.isfld.getRecNum());
                System.out.println(new String(byArray));
            }
            catch (IsamException isamException) {
                this.printEx(isamException);
            }
        }
    }

    void isBuild() {
        int n2;
        KeyDesc keyDesc = new KeyDesc();
        System.out.print("filename ? ");
        String string = this.readString();
        System.out.print("rec len  ? ");
        short s2 = (short)this.readInt();
        System.out.print("key flags? ");
        keyDesc.k_flags = (short)this.readInt();
        System.out.print("key npart? ");
        keyDesc.k_nparts = (short)this.readInt();
        for (n2 = 0; n2 < keyDesc.k_nparts; ++n2) {
            keyDesc.k_part[n2] = new KeyPart();
            System.out.print("start[" + n2 + "] ? ");
            keyDesc.k_part[n2].kp_start = (short)this.readInt();
            System.out.print("leng [" + n2 + "] ? ");
            keyDesc.k_part[n2].kp_leng = (short)this.readInt();
            System.out.print("type [" + n2 + "] ? ");
            keyDesc.k_part[n2].kp_type = (short)this.readInt();
        }
        System.out.print("mode     ? ");
        int n3 = this.readInt();
        System.out.print("header   ? ");
        short s3 = (short)this.readInt();
        System.out.print("node     ? ");
        short s4 = (short)this.readInt();
        System.out.print("rel (1,2)? ");
        int n4 = this.readInt();
        if (n4 != 1) {
            n4 = 2;
        }
        System.out.println("filename = " + string);
        System.out.println("rec len  = " + s2);
        System.out.println("key flags= " + keyDesc.k_flags);
        System.out.println("key npart= " + keyDesc.k_nparts);
        for (n2 = 0; n2 < keyDesc.k_nparts; ++n2) {
            System.out.println("start[" + n2 + "] = " + keyDesc.k_part[n2].kp_start);
            System.out.println("leng [" + n2 + "] = " + keyDesc.k_part[n2].kp_leng);
        }
        System.out.println("mode     = " + n3);
        System.out.println("header   = " + s3);
        System.out.println("node     = " + s4);
        System.out.println("rel      = " + n4);
        if (this.conferma()) {
            try {
                this.isfld = s3 > 0 && s4 > 0 ? Isam.buildNodeSize(string, s2, keyDesc, n3, s3, s4, n4) : Isam.build(string, s2, keyDesc, n3);
            }
            catch (Exception exception) {
                this.printEx(exception);
            }
        }
    }

    void isWrite() {
        byte[] byArray = new byte[this.isfld.getRecSize()];
        System.out.print("----+----1----+----2----+----3----+----4");
        System.out.print("----+----5----+----6----+----7----+----\n");
        byte[] byArray2 = this.readString().getBytes();
        Util.memcpy(byArray, 0, byArray2, 0, byArray2.length);
        System.out.println(new String(byArray2));
        if (this.conferma()) {
            try {
                this.isfld.write(byArray);
            }
            catch (IsamException isamException) {
                this.printEx(isamException);
            }
        }
    }

    void isWrCurr() {
        byte[] byArray = new byte[this.isfld.getRecSize()];
        System.out.print("----+----1----+----2----+----3----+----4");
        System.out.print("----+----5----+----6----+----7----+----\n");
        byte[] byArray2 = this.readString().getBytes();
        Util.memcpy(byArray, 0, byArray2, 0, byArray2.length);
        System.out.println(new String(byArray2));
        if (this.conferma()) {
            try {
                this.isfld.wrcurr(byArray);
            }
            catch (IsamException isamException) {
                this.printEx(isamException);
            }
        }
    }

    void isDelRec() {
        System.out.print("Numero di record?\n");
        int n2 = this.readInt();
        System.out.println("Numero di record=" + n2);
        if (this.conferma()) {
            try {
                this.isfld.delrec(n2);
            }
            catch (IsamException isamException) {
                this.printEx(isamException);
            }
        }
    }

    void isDelCurr() {
        if (this.conferma()) {
            try {
                this.isfld.delcurr();
            }
            catch (IsamException isamException) {
                this.printEx(isamException);
            }
        }
    }

    void isDelete() {
        byte[] byArray = new byte[this.isfld.getRecSize()];
        System.out.print("----+----1----+----2----+----3----+----4");
        System.out.println("----+----5----+----6----+----7----+----");
        byte[] byArray2 = this.readString().getBytes();
        Util.memcpy(byArray, 0, byArray2, 0, byArray2.length);
        System.out.println(new String(byArray));
        if (this.conferma()) {
            try {
                this.isfld.delete(byArray, 0);
            }
            catch (IsamException isamException) {
                this.printEx(isamException);
            }
        }
    }

    void isRewrite() {
        byte[] byArray = new byte[this.isfld.getRecSize()];
        System.out.print("----+----1----+----2----+----3----+----4");
        System.out.println("----+----5----+----6----+----7----+----");
        byte[] byArray2 = this.readString().getBytes();
        Util.memcpy(byArray, 0, byArray2, 0, byArray2.length);
        System.out.println(new String(byArray));
        if (this.conferma()) {
            try {
                this.isfld.rewrite(byArray, 0);
            }
            catch (IsamException isamException) {
                this.printEx(isamException);
            }
        }
    }

    void isRewCurr() {
        byte[] byArray = new byte[this.isfld.getRecSize()];
        System.out.print("----+----1----+----2----+----3----+----4");
        System.out.println("----+----5----+----6----+----7----+----");
        byte[] byArray2 = this.readString().getBytes();
        Util.memcpy(byArray, 0, byArray2, 0, byArray2.length);
        System.out.println(new String(byArray));
        if (this.conferma()) {
            try {
                this.isfld.rewcurr(byArray, 0);
            }
            catch (IsamException isamException) {
                this.printEx(isamException);
            }
        }
    }

    void isRewRec() {
        byte[] byArray = new byte[this.isfld.getRecSize()];
        System.out.print("----+----1----+----2----+----3----+----4");
        System.out.println("----+----5----+----6----+----7----+----");
        byte[] byArray2 = this.readString().getBytes();
        Util.memcpy(byArray, 0, byArray2, 0, byArray2.length);
        System.out.print("Numero di record?\n");
        int n2 = this.readInt();
        System.out.println(new String(byArray));
        System.out.println("Numero di record=" + n2);
        if (this.conferma()) {
            try {
                this.isfld.rewrec(n2, byArray, 0);
            }
            catch (IsamException isamException) {
                this.printEx(isamException);
            }
        }
    }

    void isAddIndex() {
        int n2;
        KeyDesc keyDesc = new KeyDesc();
        System.out.print("key flags? ");
        keyDesc.k_flags = (short)this.readInt();
        System.out.print("key npart? ");
        keyDesc.k_nparts = (short)this.readInt();
        for (n2 = 0; n2 < keyDesc.k_nparts; ++n2) {
            keyDesc.k_part[n2] = new KeyPart();
            System.out.print("start[" + n2 + "] ? ");
            keyDesc.k_part[n2].kp_start = (short)this.readInt();
            System.out.print("leng [" + n2 + "] ? ");
            keyDesc.k_part[n2].kp_leng = (short)this.readInt();
            System.out.print("type [" + n2 + "] ? ");
            keyDesc.k_part[n2].kp_type = (short)this.readInt();
        }
        System.out.println("key flags= " + keyDesc.k_flags);
        System.out.println("key npart= " + keyDesc.k_nparts);
        for (n2 = 0; n2 < keyDesc.k_nparts; ++n2) {
            System.out.println("start[" + n2 + "] = " + keyDesc.k_part[n2].kp_start);
            System.out.println("leng [" + n2 + "] = " + keyDesc.k_part[n2].kp_leng);
        }
        if (this.conferma()) {
            try {
                this.isfld.addindex(keyDesc);
            }
            catch (IsamException isamException) {
                this.printEx(isamException);
            }
        }
    }

    void isDelIndex() {
        int n2;
        KeyDesc keyDesc = new KeyDesc();
        System.out.print("key flags? ");
        keyDesc.k_flags = (short)this.readInt();
        System.out.print("key npart? ");
        keyDesc.k_nparts = (short)this.readInt();
        for (n2 = 0; n2 < keyDesc.k_nparts; ++n2) {
            keyDesc.k_part[n2] = new KeyPart();
            System.out.print("start[" + n2 + "] ? ");
            keyDesc.k_part[n2].kp_start = (short)this.readInt();
            System.out.print("leng [" + n2 + "] ? ");
            keyDesc.k_part[n2].kp_leng = (short)this.readInt();
            System.out.print("type [" + n2 + "] ? ");
            keyDesc.k_part[n2].kp_type = (short)this.readInt();
        }
        System.out.println("key flags= " + keyDesc.k_flags);
        System.out.println("key npart= " + keyDesc.k_nparts);
        for (n2 = 0; n2 < keyDesc.k_nparts; ++n2) {
            System.out.println("start[" + n2 + "] = " + keyDesc.k_part[n2].kp_start);
            System.out.println("leng [" + n2 + "] = " + keyDesc.k_part[n2].kp_leng);
        }
        if (this.conferma()) {
            try {
                this.isfld.delindex(keyDesc);
            }
            catch (IsamException isamException) {
                this.printEx(isamException);
            }
        }
    }

    void isClose() {
        if (this.conferma()) {
            try {
                this.isfld.close();
            }
            catch (IsamException isamException) {
                this.printEx(isamException);
            }
        }
    }

    void isRelease() {
        if (this.conferma()) {
            try {
                this.isfld.release();
            }
            catch (IsamException isamException) {
                this.printEx(isamException);
            }
        }
    }

    void isLock() {
        if (this.conferma()) {
            try {
                this.isfld.lock();
            }
            catch (IsamException isamException) {
                this.printEx(isamException);
            }
        }
    }

    void isUnlock() {
        if (this.conferma()) {
            try {
                this.isfld.unlock();
            }
            catch (IsamException isamException) {
                this.printEx(isamException);
            }
        }
    }

    void isRebuild() {
        if (this.conferma()) {
            try {
                this.isfld.rebuild();
            }
            catch (IsamException isamException) {
                this.printEx(isamException);
            }
        }
    }
}

