/*
 * Decompiled with CFR 0.152.
 */
package IT.picosoft.isam;

import IT.picosoft.isam.DictInfo64;
import IT.picosoft.isam.Isam;
import IT.picosoft.isam.IsamConst;
import IT.picosoft.isam.IsamException;
import IT.picosoft.isam.KeyDesc;
import IT.picosoft.isam.KeyDesc64;
import IT.picosoft.isam.OSFile;
import IT.picosoft.isam.Util;

public class JCheck
implements IsamConst {
    static final String usage = "JCheck [-e<enckey>][-crfy] <file-names>\n    -e<enckey> key for encryption\n    -c         check\n    -r         rebuild\n    -f         force rebuild\n    -y         don't ask confirmation";

    public static String skpt(int n2) {
        if ((n2 & 0x80) != 0) {
            return "char descending";
        }
        return "char ascending";
    }

    public static void exit(int n2, String string) throws ExitException {
        if (string != null) {
            throw new ExitException(n2, string);
        }
        throw new ExitException(n2, usage);
    }

    public static void exit(int n2) {
        JCheck.exit(n2, null);
    }

    public static void main(String[] stringArray) {
        try {
            JCheck.mainNoExit(stringArray);
        }
        catch (ExitException exitException) {
            System.err.println(exitException.msg);
            System.exit(exitException.code);
        }
    }

    public static int call(String[] stringArray) {
        try {
            JCheck.mainNoExit(stringArray);
        }
        catch (ExitException exitException) {
            System.err.println(exitException.msg);
            return exitException.code;
        }
        return 0;
    }

    public static void mainNoExit(String[] stringArray) throws ExitException {
        int n2;
        Isam isam = null;
        DictInfo64 dictInfo64 = new DictInfo64();
        KeyDesc64 keyDesc64 = new KeyDesc64();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        String string = null;
        for (n2 = 0; n2 < stringArray.length && stringArray[n2].length() > 0 && stringArray[n2].charAt(0) == '-' && stringArray[n2].length() > 1; ++n2) {
            block10: for (int i2 = 1; i2 < stringArray[n2].length(); ++i2) {
                switch (stringArray[n2].charAt(i2)) {
                    case 'e': {
                        if (++i2 < stringArray[n2].length()) {
                            string = stringArray[n2].substring(i2);
                        } else {
                            JCheck.exit(40, "Missing encryption key");
                        }
                        i2 = stringArray[n2].length();
                        continue block10;
                    }
                    case 'c': {
                        bl = true;
                        continue block10;
                    }
                    case 'r': {
                        bl2 = true;
                        continue block10;
                    }
                    case 'y': {
                        bl3 = true;
                        continue block10;
                    }
                    case 'f': {
                        bl4 = true;
                        continue block10;
                    }
                    default: {
                        JCheck.exit(1, null);
                    }
                }
            }
        }
        if (stringArray.length - n2 < 1) {
            JCheck.exit(1, null);
        }
        while (n2 < stringArray.length) {
            try {
                isam = new Isam(stringArray[n2], 1024, false, string);
                isam.indexInfo(dictInfo64);
                System.out.println("file " + stringArray[n2]);
                System.out.println("nkeys=" + dictInfo64.di_nkeys + ",recsize=" + dictInfo64.di_recsize64 + ",idxsize=" + dictInfo64.di_idxsize + ",nrecords=" + dictInfo64.di_nrecords64 + ",version=" + isam.getVersion());
                for (int i3 = 1; i3 <= dictInfo64.di_nkeys; ++i3) {
                    isam.indexInfo(keyDesc64, i3);
                    System.out.println("   key=" + i3 + ",flags=" + (keyDesc64.k_flags == 1 ? "ISDUPS" : "ISNODUPS") + ",nparts=" + keyDesc64.k_nparts);
                    for (int i4 = 0; i4 < keyDesc64.k_nparts; ++i4) {
                        System.out.println("      part=" + i4 + ",start=" + keyDesc64.k_part[i4].kp_start + ",leng=" + keyDesc64.k_part[i4].kp_leng + ",type=" + JCheck.skpt(keyDesc64.k_part[i4].kp_type));
                    }
                }
                if (bl) {
                    Isam isam2 = new Isam(stringArray[n2], 1024, false, string);
                    JCheck.check(isam, isam2, dictInfo64);
                    isam2.close();
                }
                isam.close();
                if (bl2) {
                    isam = new Isam(stringArray[n2], 2050, false, string);
                    JCheck.rebuild(isam, bl3, bl4);
                    isam.close();
                }
            }
            catch (IsamException isamException) {
                JCheck.exit(99, "" + isamException);
            }
            ++n2;
        }
    }

    private static void checkNodes(Isam isam, DictInfo64 dictInfo64) {
        boolean bl = true;
        OSFile oSFile = isam.getFd();
        long l2 = isam.getFirstNodeAddr();
        try {
            byte[] byArray = new byte[dictInfo64.di_idxsize];
            long l3 = (oSFile.length() - l2) / (long)dictInfo64.di_idxsize;
            System.out.println("Nodes count      ... " + l3);
            oSFile.seek(l2);
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            for (long i2 = 0L; i2 < l3; ++i2) {
                oSFile.readBlk(byArray, 0, byArray.length);
                switch (byArray[0]) {
                    case -65: {
                        ++n2;
                        break;
                    }
                    case -1: {
                        ++n3;
                        break;
                    }
                    case -33: {
                        ++n5;
                        break;
                    }
                    case -17: {
                        ++n4;
                        break;
                    }
                    case -49: {
                        ++n6;
                        break;
                    }
                    default: {
                        System.out.println("Unknown node " + Integer.toHexString(byArray[0] & 0xFF) + ",pos=" + l2);
                        bl = false;
                    }
                }
                l2 += (long)dictInfo64.di_idxsize;
            }
        }
        catch (IsamException isamException) {
            JCheck.exit(30, "" + isamException);
        }
        if (!bl) {
            JCheck.exit(31, "Invalid node(s)");
        }
    }

    public static void check(Isam isam, Isam isam2, DictInfo64 dictInfo64) {
        KeyDesc64 keyDesc64 = new KeyDesc64();
        KeyDesc64 keyDesc642 = new KeyDesc64();
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        JCheck.checkNodes(isam, dictInfo64);
        byte[] byArray = new byte[dictInfo64.di_recsize64];
        byte[] byArray2 = new byte[dictInfo64.di_recsize64];
        keyDesc642.k_flags = 0;
        keyDesc642.k_nparts = 0;
        System.out.print("Sequential read  ...");
        try {
            isam.read(byArray, 0);
            ++l2;
            while (true) {
                isam.read(byArray, 2);
                ++l2;
            }
        }
        catch (IsamException isamException) {
            if (isamException.getIserrno() != 110 && isamException.getIserrno() != 111) {
                JCheck.exit(5, "Error on read next: " + isamException);
            } else if (l2 > dictInfo64.di_nrecords64) {
                JCheck.exit(14, "Corrupted tree: found " + l2 + " record(s)");
            }
            System.out.println(" Ok (" + l2 + " record(s) found)");
            for (int i2 = 1; i2 <= dictInfo64.di_nkeys; ++i2) {
                try {
                    long l6 = System.currentTimeMillis();
                    isam.indexInfo(keyDesc64, i2);
                    Util.memset(byArray, (byte)0, dictInfo64.di_recsize64);
                    Util.memset(byArray2, (byte)0, dictInfo64.di_recsize64);
                    long l7 = 0L;
                    long l8 = 0L;
                    System.out.print("Checking index " + i2 + " phase1 ...");
                    if (l2 > 0L) {
                        isam.start(keyDesc64, 0, byArray, 0);
                        while (true) {
                            try {
                                isam.read(byArray, 2);
                            }
                            catch (IsamException isamException2) {
                                if (isamException2.getIserrno() == 110) break;
                                JCheck.exit(9, "Error on read next: " + isamException2);
                            }
                            if (++l7 > dictInfo64.di_nrecords64) {
                                JCheck.exit(16, "Corrupted tree: found " + l7 + " record(s)");
                            }
                            if (!JCheck.notEqual(byArray, byArray2, keyDesc64)) continue;
                            ++l8;
                            Util.memcpy(byArray2, 0, byArray, 0, dictInfo64.di_recsize64);
                            try {
                                isam2.read(byArray, 5);
                            }
                            catch (IsamException isamException3) {
                                JCheck.exit(9, "Error on read equal: " + isamException3);
                            }
                            if (Util.memcmp(byArray, 0, byArray2, 0, dictInfo64.di_recsize64) == 0) continue;
                            JCheck.exit(6, "Corrupted tree, recnum=" + isam.getRecNum());
                        }
                    }
                    if (l7 != l2) {
                        JCheck.exit(18, " Invalid record(s) count idx: expected " + l2 + " found " + l7);
                        continue;
                    }
                    System.out.println(" Ok (time=" + (System.currentTimeMillis() - l6) + " ms, " + l8 + " unique key(s))");
                    continue;
                }
                catch (IsamException isamException4) {
                    JCheck.exit(11, "Error : " + isamException4);
                }
            }
            System.out.print("Checking del.rec.chain  ...");
            try {
                l3 = isam.checkDeleteRecords();
            }
            catch (IsamException isamException5) {
                JCheck.exit(20, "Error " + isamException5);
            }
            System.out.println(" Ok (" + l3 + " record(s))");
            if (l2 != dictInfo64.di_nrecords64) {
                JCheck.exit(21, "Tree inconsistency: rec=" + l2 + "!= totrec=" + dictInfo64.di_nrecords64);
            }
            System.out.print("Checking del.node.chain ...");
            try {
                l4 = isam.checkDeleteNodes();
            }
            catch (IsamException isamException6) {
                JCheck.exit(20, "Error " + isamException6);
            }
            System.out.println(" Ok (" + l4 + " node(s))");
            try {
                l5 = isam.getDataLength();
            }
            catch (IsamException isamException7) {
                JCheck.exit(20, "Error " + isamException7);
            }
            System.out.print("Checking datafile length...");
            long l9 = (l2 + l3) * (long)(dictInfo64.di_recsize64 + 1);
            if (l5 != l9) {
                JCheck.exit(22, "Data file inconsistency: expected=" + l9 + ", actual=" + l5);
            }
            System.out.println(" Ok (" + l5 + ")");
            return;
        }
    }

    public static void rebuild(Isam isam) {
        JCheck.rebuild(isam, false, false);
    }

    public static void rebuild(Isam isam, boolean bl, boolean bl2) {
        int n2 = 0;
        if (bl) {
            n2 = 121;
        } else {
            System.out.println("WARNING!! This operation will delete and rebuild the index");
            System.out.println("Do you want to continue? (y/n)");
            try {
                n2 = System.in.read();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (n2 == 121 || n2 == 89) {
            try {
                System.out.print("rebuilding ... ");
                if (bl2) {
                    isam.rebuild(bl2, System.out);
                } else {
                    isam.rebuild();
                }
                System.out.println("Ok");
            }
            catch (IsamException isamException) {
                JCheck.exit(9, "Error in rebuilding: " + isamException);
            }
        }
    }

    static boolean notEqual(byte[] byArray, byte[] byArray2, KeyDesc keyDesc) {
        if (keyDesc.k_nparts > 0) {
            for (int i2 = 0; i2 < keyDesc.k_nparts; ++i2) {
                if (Util.memcmp(byArray, keyDesc.k_part[i2].kp_start, byArray2, keyDesc.k_part[i2].kp_start, keyDesc.k_part[i2].kp_leng) == 0) continue;
                return true;
            }
        }
        return false;
    }

    public static class ExitException
    extends RuntimeException {
        public final int code;
        public final String msg;

        public ExitException(int n2, String string) {
            this.code = n2;
            this.msg = string;
        }
    }
}

