/*
 * Decompiled with CFR 0.152.
 */
package IT.picosoft.isam;

import IT.picosoft.isam.IsamConst;
import IT.picosoft.isam.IsamException;
import IT.picosoft.isam.KeyPart;
import IT.picosoft.isam.Util;

public class KeyDesc
implements IsamConst {
    public static final int NPARTS = 8;
    public short k_flags;
    public short k_nparts;
    public KeyPart[] k_part;
    protected short k_len;
    protected long k_rootnode;
    protected int tksz;
    protected int btksz;
    protected int psz;

    protected KeyDesc(boolean bl) {
    }

    public KeyDesc() {
        this.k_part = new KeyPart[8];
    }

    public void assign(KeyDesc keyDesc) {
        int n2;
        this.k_flags = keyDesc.k_flags;
        this.k_nparts = keyDesc.k_nparts;
        for (n2 = 0; n2 < this.k_nparts; ++n2) {
            this.k_part[n2] = new KeyPart(keyDesc.k_part[n2]);
        }
        while (n2 < 8) {
            this.k_part[n2] = null;
            ++n2;
        }
        this.k_len = keyDesc.k_len;
        this.k_rootnode = keyDesc.k_rootnode;
        this.psz = keyDesc.psz;
        this.btksz = keyDesc.btksz;
        this.tksz = keyDesc.tksz;
    }

    void setRootNode(long l2) {
        this.k_rootnode = l2;
        this.psz = (this.k_flags & 1) == 1 ? 4 : 0;
        this.btksz = this.k_len + 4;
        this.tksz = this.k_len + 4 + this.psz;
    }

    int getRootNode() {
        return (int)this.k_rootnode;
    }

    void check() throws IsamException {
        switch (this.k_flags & 1) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IsamException(103);
            }
        }
        if (this.k_nparts < 0 || this.k_nparts > 8) {
            throw new IsamException(103);
        }
        for (int i2 = 0; i2 < this.k_nparts; ++i2) {
            if ((this.k_part[i2].kp_type & 0xFFFFFF7F) < 2) continue;
            throw new IsamException(103);
        }
    }

    void buildKey(byte[] byArray, int n2, byte[] byArray2) {
        int n3;
        int n4 = 0;
        for (int i2 = 0; n4 < this.k_nparts && byArray2.length > i2; i2 += n3, ++n4) {
            n3 = byArray2.length - i2;
            if (n3 > this.k_part[n4].kp_leng) {
                n3 = this.k_part[n4].kp_leng;
            }
            Util.memcpy(byArray2, i2, byArray, this.k_part[n4].kp_start + n2, n3);
        }
    }
}

