/*
 * Decompiled with CFR 0.152.
 */
package IT.picosoft.isam;

import IT.picosoft.isam.IsamException;
import IT.picosoft.isam.KeyDesc;
import IT.picosoft.isam.KeyPart;

public class KeyDesc64
extends KeyDesc {
    public static final int NPARTS64 = 16;

    public KeyDesc64() {
        this.k_part = new KeyPart[16];
    }

    @Override
    public void assign(KeyDesc keyDesc) {
        int n2;
        this.k_flags = keyDesc.k_flags;
        this.k_nparts = keyDesc.k_nparts;
        for (n2 = 0; n2 < this.k_nparts; ++n2) {
            this.k_part[n2] = new KeyPart(keyDesc.k_part[n2]);
        }
        while (n2 < 16) {
            this.k_part[n2] = null;
            ++n2;
        }
        this.k_len = keyDesc.k_len;
        this.k_rootnode = keyDesc.k_rootnode;
        if (keyDesc instanceof KeyDesc64) {
            this.psz = keyDesc.psz;
            this.btksz = keyDesc.btksz;
            this.tksz = keyDesc.tksz;
        } else {
            this.psz = (this.k_flags & 1) == 1 ? 4 : 0;
            this.btksz = this.k_len + 8;
            this.tksz = this.k_len + 8 + this.psz;
        }
    }

    @Override
    void setRootNode(long l2) {
        this.k_rootnode = l2;
        this.psz = (this.k_flags & 1) == 1 ? 4 : 0;
        this.btksz = this.k_len + 8;
        this.tksz = this.k_len + 8 + this.psz;
    }

    long getRootNode64() {
        return this.k_rootnode;
    }

    @Override
    void check() throws IsamException {
        switch (this.k_flags & 1) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IsamException(103);
            }
        }
        if (this.k_nparts < 0 || this.k_nparts > 16) {
            throw new IsamException(103);
        }
        for (int i2 = 0; i2 < this.k_nparts; ++i2) {
            if ((this.k_part[i2].kp_type & 0xFFFFFF7F) < 2) continue;
            throw new IsamException(103);
        }
    }
}

