/*
 * Decompiled with CFR 0.152.
 */
package IT.picosoft.isam;

import IT.picosoft.isam.FLock;
import IT.picosoft.isam.ILocking;
import IT.picosoft.isam.IsamException;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class OSFile {
    public static final int O_RDONLY = 0;
    public static final int O_WRONLY = 1;
    public static final int O_RDWR = 2;
    public static final int O_CREAT = 64;
    public static final int O_EXCL = 128;
    public static final int O_TRUNC = 512;
    public static final int O_SYNC = 4096;
    private RandomAccessFile osFile;
    private ILocking channel;
    private String jMode;
    private File theFile;
    public boolean encrypt = false;
    public static final Class LOCK_CLASS;

    private void checkReopen() throws IsamException {
        int n2 = 0;
        try {
            n2 = this.osFile.getFD().valid() ? 1 : 0;
            n2 += this.channel.isOpen() ? 2 : 0;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            switch (n2) {
                case 0: {
                    this.osFile = new RandomAccessFile(this.theFile, this.jMode);
                    this.channel.init(this.osFile);
                    break;
                }
                case 2: {
                    this.channel.close();
                    this.osFile = new RandomAccessFile(this.theFile, this.jMode);
                    this.channel.init(this.osFile);
                    break;
                }
                case 1: {
                    try {
                        this.osFile.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.osFile = new RandomAccessFile(this.theFile, this.jMode);
                    this.channel.init(this.osFile);
                    break;
                }
            }
        }
        catch (IOException iOException) {
            throw new IsamException(iOException);
        }
    }

    public synchronized void open(String string, int n2) throws IsamException {
        switch (n2 & 3) {
            default: {
                this.jMode = "r";
                break;
            }
            case 1: 
            case 2: {
                this.jMode = (n2 & 0x1000) != 0 ? "rws" : "rw";
            }
        }
        this.theFile = new File(string);
        try {
            if ((n2 & 0x40) != 0) {
                if ((n2 & 0x200) != 0) {
                    this.theFile.delete();
                }
                boolean bl = this.theFile.createNewFile();
                if ((n2 & 0x280) != 0 && !bl) {
                    throw new IsamException(132);
                }
            }
            if (!this.theFile.exists()) {
                throw new IsamException(130);
            }
            this.osFile = new RandomAccessFile(this.theFile, this.jMode);
            this.channel = (ILocking)LOCK_CLASS.newInstance();
            this.channel.init(this.osFile);
        }
        catch (NullPointerException nullPointerException) {
            throw new IsamException(133, nullPointerException);
        }
        catch (InstantiationException instantiationException) {
            throw new IsamException(133, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IsamException(133, illegalAccessException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (this.theFile.exists()) {
                throw new IsamException(113, fileNotFoundException);
            }
            throw new IsamException(130, fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new IsamException(133, iOException);
        }
    }

    public int read(byte[] byArray) throws IsamException {
        return this.read(byArray, 0, byArray.length);
    }

    public synchronized int read(byte[] byArray, int n2, int n3) throws IsamException {
        try {
            return this.osFile.read(byArray, n2, n3);
        }
        catch (EOFException eOFException) {
            throw new IsamException(110, eOFException);
        }
        catch (IOException iOException) {
            throw new IsamException(iOException);
        }
    }

    public synchronized int readBlk(byte[] byArray, int n2, int n3) throws IsamException {
        try {
            return this.osFile.read(byArray, n2, n3);
        }
        catch (EOFException eOFException) {
            throw new IsamException(110, eOFException);
        }
        catch (IOException iOException) {
            throw new IsamException(iOException);
        }
    }

    public synchronized char readChar() throws IsamException {
        try {
            return this.osFile.readChar();
        }
        catch (EOFException eOFException) {
            throw new IsamException(110, eOFException);
        }
        catch (IOException iOException) {
            throw new IsamException(iOException);
        }
    }

    public synchronized int readInt() throws IsamException {
        try {
            return this.osFile.readInt();
        }
        catch (EOFException eOFException) {
            throw new IsamException(110, eOFException);
        }
        catch (IOException iOException) {
            throw new IsamException(iOException);
        }
    }

    public synchronized long tell() throws IsamException {
        try {
            return this.osFile.getFilePointer();
        }
        catch (EOFException eOFException) {
            throw new IsamException(110, eOFException);
        }
        catch (IOException iOException) {
            throw new IsamException(iOException);
        }
    }

    public synchronized long length() throws IsamException {
        try {
            return this.osFile.length();
        }
        catch (IOException iOException) {
            throw new IsamException(iOException);
        }
    }

    public synchronized void setLength(long l2) throws IsamException {
        try {
            this.osFile.setLength(l2);
        }
        catch (IOException iOException) {
            throw new IsamException(iOException);
        }
    }

    public synchronized void seek(long l2) throws IsamException {
        try {
            this.osFile.seek(l2);
        }
        catch (EOFException eOFException) {
            throw new IsamException(110, eOFException);
        }
        catch (IOException iOException) {
            throw new IsamException(iOException);
        }
    }

    public void write(byte[] byArray) throws IsamException {
        this.write(byArray, 0, byArray.length);
    }

    public synchronized void write(byte[] byArray, int n2, int n3) throws IsamException {
        try {
            this.osFile.write(byArray, n2, n3);
        }
        catch (IOException iOException) {
            throw new IsamException(iOException);
        }
    }

    public synchronized void writeBlk(byte[] byArray, int n2, int n3) throws IsamException {
        try {
            this.osFile.write(byArray, n2, n3);
        }
        catch (IOException iOException) {
            throw new IsamException(iOException);
        }
    }

    public synchronized void writeChar(int n2) throws IsamException {
        try {
            this.osFile.writeChar(n2);
        }
        catch (IOException iOException) {
            throw new IsamException(iOException);
        }
    }

    public synchronized void writeInt(int n2) throws IsamException {
        try {
            this.osFile.writeInt(n2);
        }
        catch (IOException iOException) {
            throw new IsamException(iOException);
        }
    }

    public synchronized void close() throws IsamException {
        try {
            this.channel.close();
            this.osFile.close();
        }
        catch (IOException iOException) {
            throw new IsamException(iOException);
        }
    }

    public synchronized void fcntl(int n2, FLock fLock) throws IsamException {
        try {
            this.channel.fcntl(n2, fLock);
        }
        finally {
            this.checkReopen();
        }
    }

    public static void unlink(String string) throws IsamException {
        File file = new File(string);
        if (!file.exists()) {
            throw new IsamException(130);
        }
        if (!file.delete()) {
            throw new IsamException(133);
        }
    }

    public static void rename(String string, String string2) throws IsamException {
        File file = new File(string);
        File file2 = new File(string2);
        if (!file.exists()) {
            throw new IsamException(130);
        }
        if (!file.renameTo(file2)) {
            throw new IsamException(133);
        }
    }

    public static OSFile get() {
        return new OSFile();
    }

    public static OSFile get(String string) {
        if (string != null && string.length() > 0) {
            return new Encrypted(string);
        }
        return new OSFile();
    }

    public byte[] decrypt(byte[] byArray, int n2, int n3) throws IsamException {
        if (this instanceof Encrypted) {
            return ((Encrypted)this).realDecrypt(byArray, n2, n3);
        }
        return byArray;
    }

    public void setEncrypt() {
        this.encrypt = true;
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("IT.picosoft.isam.RealLocking");
        }
        catch (Throwable throwable) {
            try {
                clazz = Class.forName("IT.picosoft.isam.DummyLocking");
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = null;
            }
        }
        LOCK_CLASS = clazz;
    }

    static class Encrypted
    extends OSFile {
        private int blkLen = 0;
        private final Cipher cipher;
        private final SecretKeySpec password;
        private final IvParameterSpec iv = new IvParameterSpec(new byte[]{126, -56, -18, -103, -57, 115, 33, -116});

        private Encrypted(String string) {
            try {
                this.cipher = Cipher.getInstance("Blowfish/CFB/NoPadding");
                byte[] byArray = string.getBytes();
                this.password = new SecretKeySpec(byArray, 0, byArray.length, "Blowfish");
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public void writeBlk(byte[] byArray, int n2, int n3) throws IsamException {
            if (this.blkLen != n3) {
                if (this.blkLen == 0) {
                    this.blkLen = n3;
                } else {
                    throw new IsamException(102, "" + n3 + "!=" + this.blkLen);
                }
            }
            try {
                this.cipher.init(1, (Key)this.password, this.iv);
                super.writeBlk(this.cipher.doFinal(byArray, n2, n3), 0, n3);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new IsamException(invalidKeyException);
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                throw new IsamException(illegalBlockSizeException);
            }
            catch (BadPaddingException badPaddingException) {
                throw new IsamException(badPaddingException);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new IsamException(invalidAlgorithmParameterException);
            }
        }

        @Override
        public int readBlk(byte[] byArray, int n2, int n3) throws IsamException {
            int n4 = 0;
            if (this.blkLen != n3) {
                if (this.blkLen == 0) {
                    this.blkLen = n3;
                } else {
                    throw new IsamException(102, "" + n3 + "!=" + this.blkLen);
                }
            }
            try {
                byte[] byArray2 = new byte[n3];
                this.cipher.init(2, (Key)this.password, this.iv);
                n4 = super.readBlk(byArray2, 0, n3);
                if (n4 > 0) {
                    this.cipher.doFinal(byArray2, 0, n4, byArray, n2);
                }
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new IsamException(invalidKeyException);
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                throw new IsamException(illegalBlockSizeException);
            }
            catch (BadPaddingException badPaddingException) {
                throw new IsamException(badPaddingException);
            }
            catch (ShortBufferException shortBufferException) {
                throw new IsamException(shortBufferException);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new IsamException(invalidAlgorithmParameterException);
            }
            return n4;
        }

        public byte[] realDecrypt(byte[] byArray, int n2, int n3) throws IsamException {
            byte[] byArray2 = new byte[n3];
            try {
                this.cipher.init(2, (Key)this.password, this.iv);
                this.cipher.doFinal(byArray, n2, n3, byArray2, 0);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new IsamException(invalidKeyException);
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                throw new IsamException(illegalBlockSizeException);
            }
            catch (BadPaddingException badPaddingException) {
                throw new IsamException(badPaddingException);
            }
            catch (ShortBufferException shortBufferException) {
                throw new IsamException(shortBufferException);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new IsamException(invalidAlgorithmParameterException);
            }
            return byArray2;
        }
    }
}

