/*
 * Decompiled with CFR 0.152.
 */
package IT.picosoft.isam;

import IT.picosoft.isam.DictInfo;
import IT.picosoft.isam.FLock;
import IT.picosoft.isam.Isam;
import IT.picosoft.isam.IsamConst;
import IT.picosoft.isam.IsamException;
import IT.picosoft.isam.KeyDesc;
import IT.picosoft.isam.NewNodes;
import IT.picosoft.isam.NodeDesc;
import IT.picosoft.isam.NodeItemDesc;
import IT.picosoft.isam.OSFile;
import IT.picosoft.isam.TreeManager32;
import IT.picosoft.isam.TreeManager64;
import java.io.PrintStream;

public abstract class TreeManager
implements IsamConst {
    static final int NODE_CACHE_SIZE = 32;
    protected final NodeDesc[] nodeCache = new NodeDesc[32];
    static final int ISNOLCK = 0;
    static final int ISRDLCK = 1;
    static final int ISWRLCK = 2;
    static final byte BRANCH_NODE = -65;
    static final byte LEAF_NODE = -1;
    static final byte DELETED_NODE = -33;
    static final byte RECDEL_NODE = -17;
    static final byte KEY_NODE = -49;
    private int headerLock = 0;
    private FLock lock = new FLock();
    protected OSFile fdIndex;
    protected Isam par;

    static TreeManager get(OSFile oSFile, boolean bl, int n2, Isam isam) throws IsamException {
        TreeManager treeManager;
        if (n2 == 1) {
            treeManager = new TreeManager32(oSFile, bl);
        } else if (n2 == 2 || oSFile.length() == 0L) {
            treeManager = new TreeManager64(oSFile, bl);
        } else {
            byte[] byArray = new byte[1];
            oSFile.seek(7L);
            oSFile.read(byArray);
            treeManager = byArray[0] == 1 ? new TreeManager32(oSFile, bl) : new TreeManager64(oSFile, bl);
        }
        treeManager.par = isam;
        return treeManager;
    }

    abstract void init() throws IsamException;

    abstract void newIndex(int var1, KeyDesc var2, short var3, short var4, byte[] var5) throws IsamException;

    abstract short getIndexSize();

    abstract int getRecSize();

    abstract short getKeyParts(int var1);

    abstract long getNRecords();

    abstract void readHeader(boolean var1) throws IsamException;

    abstract void writeHeader(boolean var1) throws IsamException;

    abstract void write(NodeDesc var1) throws IsamException;

    abstract boolean unchangedNode(short var1, NodeItemDesc var2) throws IsamException;

    abstract NodeItemDesc findKey(byte[] var1, short var2, int var3, int var4) throws IsamException;

    abstract NodeItemDesc prev(short var1, byte[] var2, int var3, long var4, int var6, boolean var7) throws IsamException;

    abstract NodeItemDesc next(short var1, byte[] var2, int var3, long var4, int var6, boolean var7) throws IsamException;

    abstract void insertKeys(byte[][] var1, long var2) throws IsamException;

    abstract long getNewRecNum() throws IsamException;

    abstract void resetGetNewRecNum(long var1) throws IsamException;

    abstract void insertKey(byte[] var1, short var2, long var3) throws IsamException;

    abstract long newRoot(NewNodes var1, short var2) throws IsamException;

    abstract short getKeyNum(KeyDesc var1) throws IsamException;

    abstract short getKeyLen(int var1);

    abstract byte[][] buildAllKeys(byte[] var1, int var2, long var3) throws IsamException;

    abstract void rewriteAllKeys(byte[] var1, byte[] var2, int var3, long var4, byte[][] var6) throws IsamException;

    abstract void buildKey(short var1, byte[] var2, int var3, byte[] var4);

    abstract void delTree(short var1) throws IsamException;

    abstract void deleteKeys(byte[] var1, int var2, long var3) throws IsamException;

    abstract long checkDeleteRecords() throws IsamException;

    abstract long checkDeleteNodes() throws IsamException;

    abstract long addIndex(KeyDesc var1, OSFile var2) throws IsamException;

    abstract OSFile rebuild(OSFile var1, String var2, boolean var3, PrintStream var4) throws IsamException;

    abstract void indexInfo(DictInfo var1) throws IsamException;

    abstract void indexInfo(KeyDesc var1, int var2) throws IsamException;

    abstract long getDelRecNum() throws IsamException;

    abstract int getVersion();

    abstract int getFirstNodeAddr();

    abstract byte[] getCollatingSequence() throws IsamException;

    final OSFile getFd() {
        return this.fdIndex;
    }

    protected final void finalize() throws IsamException {
        this.cacheClear();
        this.fdIndex = null;
    }

    final void headerLock(boolean bl) throws IsamException {
        if (this.headerLock == 0 || this.headerLock == 1 && bl) {
            this.lock.l_whence = 0;
            this.lock.l_start = 0L;
            this.lock.l_len = 1;
            this.lock.l_type = (short)(bl ? 1 : 0);
            this.fdIndex.fcntl(7, this.lock);
            this.headerLock = bl ? 2 : 1;
        }
    }

    final void headerUnlock() throws IsamException {
        if (this.headerLock != 0) {
            this.lock.l_whence = 0;
            this.lock.l_start = 0L;
            this.lock.l_len = 1;
            this.lock.l_type = (short)2;
            this.fdIndex.fcntl(6, this.lock);
            this.headerLock = 0;
        }
    }

    final void fileExLock(FLock fLock, short s2) throws IsamException {
        fLock.l_whence = 0;
        fLock.l_start = 1L;
        fLock.l_len = 1;
        fLock.l_type = s2;
        this.fdIndex.fcntl(6, fLock);
    }

    final void testFileLock(FLock fLock) throws IsamException {
        fLock.l_whence = 0;
        fLock.l_start = 1L;
        fLock.l_len = 1;
        fLock.l_type = 0;
        this.fdIndex.fcntl(6, fLock);
    }

    final boolean isHeadUnlk() {
        return this.headerLock == 0;
    }

    final void cacheClear() throws IsamException {
        for (int i2 = 0; i2 < 32 && this.nodeCache[i2] != null; ++i2) {
            if (this.nodeCache[i2].cached) {
                this.write(this.nodeCache[i2]);
            }
            this.nodeCache[i2] = null;
        }
    }

    final void cachePut(NodeDesc nodeDesc) throws IsamException {
        int n2;
        int n3 = 0;
        int n4 = Integer.MAX_VALUE;
        for (n2 = 0; n2 < 32; ++n2) {
            if (this.nodeCache[n2] == null) {
                n4 = Integer.MIN_VALUE;
                n3 = n2;
                break;
            }
            if (this.nodeCache[n2].nodeAddr != nodeDesc.nodeAddr) continue;
            this.nodeCache[n2] = nodeDesc;
            return;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.nodeCache[i2].mru < n4) {
                n4 = this.nodeCache[i2].mru;
                n3 = i2;
            }
            --this.nodeCache[i2].mru;
        }
        if (this.nodeCache[n3] != null && this.nodeCache[n3].cached) {
            this.write(this.nodeCache[n3]);
        }
        nodeDesc.mru = 1;
        this.nodeCache[n3] = nodeDesc;
    }

    final NodeDesc cacheGet(long l2) {
        NodeDesc nodeDesc;
        int n2;
        NodeDesc nodeDesc2 = null;
        for (n2 = 0; n2 < 32 && (nodeDesc = this.nodeCache[n2]) != null; ++n2) {
            if (l2 != nodeDesc.nodeAddr) continue;
            nodeDesc2 = nodeDesc;
        }
        if (nodeDesc2 != null) {
            --n2;
            while (n2 >= 0) {
                if (this.nodeCache[n2].mru > nodeDesc2.mru) {
                    --this.nodeCache[n2].mru;
                }
                --n2;
            }
            nodeDesc2.mru = 1;
        }
        return nodeDesc2;
    }
}

