/*
 * Decompiled with CFR 0.152.
 */
package IT.picosoft.isam;

import IT.picosoft.isam.DictInfo;
import IT.picosoft.isam.Isam;
import IT.picosoft.isam.IsamException;
import IT.picosoft.isam.KeyDesc;
import IT.picosoft.isam.KeyPart;
import IT.picosoft.isam.NewNodes;
import IT.picosoft.isam.NodeDesc;
import IT.picosoft.isam.NodeItemDesc;
import IT.picosoft.isam.OSFile;
import IT.picosoft.isam.TreeManager;
import IT.picosoft.isam.Util;
import java.io.PrintStream;

public class TreeManager32
extends TreeManager {
    private static final int RELEASE = 1;
    private static final int FIRSTKEYDISP = 32;
    private static final int HEADERKEYSIZE = 58;
    static final int sizeOfRECNUM = 4;
    static final int sizeOfADDR = 4;
    static final int sizeOfPROG = 4;
    private static final int TYPE_POS = 0;
    private static final int NUMELEM_POS = 1;
    private static final int LEFTBROT_POS = 3;
    private static final int RIGHTBROT_POS = 7;
    private static final int KEYSTART_POS = 11;
    private DictInfo dictInfo = new DictInfo();
    private KeyDesc[] keyDesc;
    private NodeItemDesc tnid;
    private short headerSize;
    private int firstFreeNode;
    private int firstAddKeyNode;
    private int firstDeletedNode;
    private int firstDelRecNode;
    private short releaseLevel;
    private byte[] hndeArea;
    private byte[] delrecnode;
    private boolean exclLock;
    private boolean untouched;

    TreeManager32(OSFile oSFile, boolean bl) {
        this.fdIndex = oSFile;
        this.untouched = this.exclLock = bl;
    }

    @Override
    final void init() throws IsamException {
        this.fdIndex.seek(0L);
        this.readHeader1(false);
        this.hndeArea = new byte[this.dictInfo.di_idxsize];
        this.delrecnode = new byte[this.dictInfo.di_idxsize];
        this.tnid = new NodeItemDesc(this.dictInfo.di_idxsize);
        this.readHeader2();
        this.headerUnlock();
    }

    @Override
    final void newIndex(int n2, KeyDesc keyDesc, short s2, short s3, byte[] byArray) throws IsamException {
        this.releaseLevel = 1;
        this.dictInfo.di_nkeys = 1;
        this.dictInfo.di_recsize = (short)n2;
        this.dictInfo.di_idxsize = s3;
        this.dictInfo.di_nrecords = 0;
        this.firstFreeNode = s2 + s3;
        this.headerSize = s2;
        this.firstAddKeyNode = 0;
        this.firstDeletedNode = 0;
        this.firstDelRecNode = 0;
        this.hndeArea = new byte[this.dictInfo.di_idxsize];
        this.delrecnode = new byte[this.dictInfo.di_idxsize];
        this.tnid = new NodeItemDesc(this.dictInfo.di_idxsize);
        this.keyDesc = new KeyDesc[1];
        this.keyDesc[0] = new KeyDesc();
        this.keyDesc[0].assign(keyDesc);
        this.keyDesc[0].k_len = 0;
        for (int i2 = 0; i2 < this.keyDesc[0].k_nparts; ++i2) {
            this.keyDesc[0].k_part[i2].check(n2);
            this.keyDesc[0].k_len = (short)(this.keyDesc[0].k_len + this.keyDesc[0].k_part[i2].kp_leng);
        }
        if (this.keyDesc[0].k_len > 255) {
            throw new IsamException(103);
        }
        this.keyDesc[0].setRootNode(this.headerSize);
        this.writeHeader(true);
        NodeDesc nodeDesc = new NodeDesc((int)this.dictInfo.di_idxsize, this.keyDesc[0]);
        nodeDesc.nodeType = (byte)-1;
        nodeDesc.numElem = 0;
        nodeDesc.leftBrot = 0L;
        nodeDesc.rightBrot = 0L;
        nodeDesc.nodeAddr = this.keyDesc[0].getRootNode();
        this.writeNode(nodeDesc);
        this.cacheClear();
    }

    private boolean readHeader1(boolean bl) throws IsamException {
        byte[] byArray = new byte[32];
        this.headerLock(bl);
        this.fdIndex.read(byArray, 0, 32);
        if (!Util.equals(byArray, SIGN, SIGN.length)) {
            throw new IsamException(105);
        }
        this.releaseLevel = Util.getShort(byArray, 6);
        if (this.releaseLevel != 1) {
            throw new IsamException(105);
        }
        this.firstFreeNode = Util.getInt(byArray, 8);
        this.dictInfo.di_nkeys = Util.getShort(byArray, 12);
        this.dictInfo.di_recsize = Util.getShort(byArray, 14);
        this.dictInfo.di_idxsize = Util.getShort(byArray, 16);
        this.dictInfo.di_nrecords = Util.getInt(byArray, 18);
        this.headerSize = Util.getShort(byArray, 22);
        this.firstDeletedNode = Util.getInt(byArray, 24);
        this.firstDelRecNode = Util.getInt(byArray, 28);
        return true;
    }

    private void readHeader2() throws IsamException {
        int n2;
        int n3;
        int n4 = this.headerSize - 32;
        byte[] byArray = new byte[n4];
        int n5 = this.dictInfo.di_nkeys;
        this.cacheClear();
        this.fdIndex.read(byArray, 0, n4);
        int n6 = n4 - 4;
        this.firstAddKeyNode = Util.getInt(byArray, n6);
        this.keyDesc = new KeyDesc[this.dictInfo.di_nkeys];
        for (n3 = 0; n3 < n5; ++n3) {
            this.keyDesc[n3] = new KeyDesc();
        }
        if (this.dictInfo.di_nkeys * 58 > this.headerSize - 32 - 4) {
            int n7;
            long l2 = this.firstAddKeyNode;
            n6 = n7 = this.dictInfo.di_idxsize - 4;
            n5 = n3 = (this.headerSize - 32 - 4) / 58;
            while (n3 < this.dictInfo.di_nkeys) {
                if (n6 + 58 > n7) {
                    if (l2 == 0L) {
                        throw new IsamException(105);
                    }
                    this.fdIndex.seek(l2);
                    this.fdIndex.read(this.hndeArea, 0, this.dictInfo.di_idxsize);
                    l2 = Util.getInt(this.hndeArea, n7);
                    if (this.hndeArea[0] != -49) {
                        throw new IsamException(105);
                    }
                    n6 = 1;
                }
                this.keyDesc[n3].k_flags = Util.getShort(this.hndeArea, n6);
                this.keyDesc[n3].k_nparts = Util.getShort(this.hndeArea, n6 += 2);
                n6 += 2;
                if (this.keyDesc[n3].k_nparts > 8) {
                    throw new IsamException(105);
                }
                for (n2 = 0; n2 < this.keyDesc[n3].k_nparts; ++n2) {
                    this.keyDesc[n3].k_part[n2] = new KeyPart();
                    this.keyDesc[n3].k_part[n2].kp_start = Util.getShort(this.hndeArea, n6);
                    this.keyDesc[n3].k_part[n2].kp_leng = Util.getShort(this.hndeArea, n6 += 2);
                    this.keyDesc[n3].k_part[n2].kp_type = Util.getShort(this.hndeArea, n6 += 2);
                    n6 += 2;
                }
                this.keyDesc[n3].k_len = Util.getShort(this.hndeArea, n6 += 6 * (8 - n2));
                this.keyDesc[n3].setRootNode(Util.getInt(this.hndeArea, n6 += 2));
                n6 += 4;
                ++n3;
            }
        }
        n6 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            this.keyDesc[n3].k_flags = Util.getShort(byArray, n6);
            this.keyDesc[n3].k_nparts = Util.getShort(byArray, n6 += 2);
            n6 += 2;
            if (this.keyDesc[n3].k_nparts > 8) {
                throw new IsamException(105);
            }
            for (n2 = 0; n2 < this.keyDesc[n3].k_nparts; ++n2) {
                this.keyDesc[n3].k_part[n2] = new KeyPart();
                this.keyDesc[n3].k_part[n2].kp_start = Util.getShort(byArray, n6);
                this.keyDesc[n3].k_part[n2].kp_leng = Util.getShort(byArray, n6 += 2);
                this.keyDesc[n3].k_part[n2].kp_type = Util.getShort(byArray, n6 += 2);
                n6 += 2;
            }
            this.keyDesc[n3].k_len = Util.getShort(byArray, n6 += 6 * (8 - n2));
            this.keyDesc[n3].setRootNode(Util.getInt(byArray, n6 += 2));
            n6 += 4;
        }
    }

    @Override
    final void writeHeader(boolean bl) throws IsamException {
        int n2;
        int n3;
        int n4;
        int n5 = this.dictInfo.di_nkeys;
        byte[] byArray = new byte[this.headerSize];
        if (this.dictInfo.di_nkeys * 58 > this.headerSize - 32 - 4) {
            int n6;
            int n7 = this.dictInfo.di_idxsize - 4;
            n4 = (this.headerSize - 32 - 4) / 58;
            n5 = (short)n4;
            if (this.firstAddKeyNode == 0) {
                this.firstAddKeyNode = this.firstFreeNode;
                this.firstFreeNode += this.dictInfo.di_idxsize;
                n6 = 0;
                Util.memset(this.hndeArea, (byte)0, this.dictInfo.di_idxsize);
            } else {
                this.fdIndex.seek(this.firstAddKeyNode);
                this.fdIndex.read(this.hndeArea, 0, this.dictInfo.di_idxsize);
                n6 = Util.getInt(this.hndeArea, n7);
                Util.memset(this.hndeArea, (byte)0, this.dictInfo.di_idxsize - 4);
            }
            this.hndeArea[0] = -49;
            n3 = 1;
            int n8 = 1;
            this.fdIndex.seek(this.firstAddKeyNode);
            while (n4 < this.dictInfo.di_nkeys) {
                if ((n8 = (int)((short)(n8 + 58))) > n7) {
                    int n9;
                    if (n6 == 0) {
                        n9 = this.firstFreeNode;
                        this.firstFreeNode += this.dictInfo.di_idxsize;
                    } else {
                        n9 = n6;
                    }
                    Util.putInt(this.hndeArea, n7, n9);
                    this.fdIndex.write(this.hndeArea, 0, this.dictInfo.di_idxsize);
                    if (n6 == 0) {
                        Util.memset(this.hndeArea, (byte)0, this.dictInfo.di_idxsize);
                    } else {
                        this.fdIndex.seek(n9);
                        this.fdIndex.read(this.hndeArea, 0, this.dictInfo.di_idxsize);
                        n6 = Util.getInt(this.hndeArea, n7);
                        Util.memset(this.hndeArea, (byte)0, this.dictInfo.di_idxsize - 4);
                    }
                    this.hndeArea[0] = -49;
                    n3 = 1;
                    n8 = 59;
                    this.fdIndex.seek(n9);
                }
                Util.putShort(this.hndeArea, n3, this.keyDesc[n4].k_flags);
                Util.putShort(this.hndeArea, n3 += 2, this.keyDesc[n4].k_nparts);
                n3 += 2;
                for (n2 = 0; n2 < this.keyDesc[n4].k_nparts; ++n2) {
                    Util.putShort(this.hndeArea, n3, this.keyDesc[n4].k_part[n2].kp_start);
                    Util.putShort(this.hndeArea, n3 += 2, this.keyDesc[n4].k_part[n2].kp_leng);
                    Util.putShort(this.hndeArea, n3 += 2, this.keyDesc[n4].k_part[n2].kp_type);
                    n3 += 2;
                }
                Util.putShort(this.hndeArea, n3 += 6 * (8 - n2), this.keyDesc[n4].k_len);
                Util.putInt(this.hndeArea, n3 += 2, this.keyDesc[n4].getRootNode());
                n3 += 4;
                ++n4;
            }
            this.fdIndex.write(this.hndeArea, 0, this.dictInfo.di_idxsize);
        }
        if (bl) {
            this.fdIndex.seek(0L);
            Util.memcpy(byArray, 0, SIGN, 0, 6);
        } else {
            this.fdIndex.seek(6L);
        }
        Util.putShort(byArray, 6, this.releaseLevel);
        Util.putInt(byArray, 8, this.firstFreeNode);
        Util.putShort(byArray, 12, this.dictInfo.di_nkeys);
        Util.putShort(byArray, 14, this.dictInfo.di_recsize);
        Util.putShort(byArray, 16, this.dictInfo.di_idxsize);
        Util.putInt(byArray, 18, this.dictInfo.di_nrecords);
        Util.putShort(byArray, 22, this.headerSize);
        Util.putInt(byArray, 24, this.firstDeletedNode);
        Util.putInt(byArray, 28, this.firstDelRecNode);
        Util.putInt(byArray, this.headerSize - 4, this.firstAddKeyNode);
        n3 = 32;
        for (n4 = 0; n4 < n5; ++n4) {
            Util.putShort(byArray, n3, this.keyDesc[n4].k_flags);
            Util.putShort(byArray, n3 += 2, this.keyDesc[n4].k_nparts);
            n3 += 2;
            for (n2 = 0; n2 < this.keyDesc[n4].k_nparts; ++n2) {
                Util.putShort(byArray, n3, this.keyDesc[n4].k_part[n2].kp_start);
                Util.putShort(byArray, n3 += 2, this.keyDesc[n4].k_part[n2].kp_leng);
                Util.putShort(byArray, n3 += 2, this.keyDesc[n4].k_part[n2].kp_type);
                n3 += 2;
            }
            Util.putShort(byArray, n3 += 6 * (8 - n2), this.keyDesc[n4].k_len);
            Util.putInt(byArray, n3 += 2, this.keyDesc[n4].getRootNode());
            n3 += 4;
        }
        if (bl) {
            this.fdIndex.write(byArray, 0, this.headerSize);
        } else {
            this.fdIndex.write(byArray, 6, this.headerSize - 6);
        }
    }

    private void writeNode(NodeDesc nodeDesc) throws IsamException {
        byte[] byArray = nodeDesc.nodeArea;
        byArray[0] = nodeDesc.nodeType;
        Util.putShort(byArray, 1, nodeDesc.numElem);
        Util.putInt(byArray, 3, nodeDesc.leftBrot);
        Util.putInt(byArray, 7, nodeDesc.rightBrot);
        if (this.exclLock) {
            nodeDesc.cached = true;
        } else {
            this.write(nodeDesc);
        }
        nodeDesc.usableSize = this.dictInfo.di_idxsize - 11;
        nodeDesc.maxElem = nodeDesc.nodeType == -65 ? nodeDesc.usableSize / nodeDesc.kdesc.btksz : nodeDesc.usableSize / nodeDesc.kdesc.tksz;
        NodeItemDesc nodeItemDesc = this.par.getCurr();
        if (nodeItemDesc != null && nodeItemDesc.nodeAddr == nodeDesc.nodeAddr) {
            nodeItemDesc.modified = true;
        }
        this.cachePut(nodeDesc);
    }

    @Override
    final void write(NodeDesc nodeDesc) throws IsamException {
        this.fdIndex.seek(nodeDesc.nodeAddr);
        this.fdIndex.write(nodeDesc.nodeArea, 0, this.dictInfo.di_idxsize);
    }

    private NodeDesc readNode(short s2, long l2) throws IsamException {
        NodeDesc nodeDesc = this.cacheGet(l2);
        if (nodeDesc != null) {
            return nodeDesc;
        }
        nodeDesc = new NodeDesc((int)this.dictInfo.di_idxsize, this.keyDesc[s2]);
        this.fdIndex.seek(l2);
        this.fdIndex.read(nodeDesc.nodeArea, 0, this.dictInfo.di_idxsize);
        nodeDesc.nodeType = nodeDesc.nodeArea[0];
        nodeDesc.numElem = Util.getShort(nodeDesc.nodeArea, 1);
        nodeDesc.leftBrot = Util.getInt(nodeDesc.nodeArea, 3);
        nodeDesc.rightBrot = Util.getInt(nodeDesc.nodeArea, 7);
        nodeDesc.nodeAddr = (int)l2;
        nodeDesc.usableSize = this.dictInfo.di_idxsize - 11;
        nodeDesc.maxElem = nodeDesc.nodeType == -65 ? nodeDesc.usableSize / nodeDesc.kdesc.btksz : nodeDesc.usableSize / nodeDesc.kdesc.tksz;
        this.cachePut(nodeDesc);
        return nodeDesc;
    }

    @Override
    final boolean unchangedNode(short s2, NodeItemDesc nodeItemDesc) throws IsamException {
        if (nodeItemDesc.modified) {
            return false;
        }
        if (this.untouched) {
            return true;
        }
        NodeDesc nodeDesc = this.readNode(s2, nodeItemDesc.nodeAddr);
        return Util.equals(nodeItemDesc.node.nodeArea, nodeDesc.nodeArea, this.dictInfo.di_idxsize);
    }

    @Override
    final short getKeyParts(int n2) {
        return this.keyDesc[n2].k_nparts;
    }

    @Override
    final short getIndexSize() {
        return this.dictInfo.di_idxsize;
    }

    @Override
    final int getRecSize() {
        return this.dictInfo.di_recsize;
    }

    @Override
    final long getNRecords() {
        return this.dictInfo.di_nrecords;
    }

    @Override
    final void readHeader(boolean bl) throws IsamException {
        if (!this.exclLock) {
            if (this.isHeadUnlk()) {
                this.fdIndex.seek(0L);
                if (this.readHeader1(bl)) {
                    this.readHeader2();
                }
            } else if (bl) {
                this.headerLock(bl);
            }
        }
    }

    private NodeItemDesc getKeyDescNC(int n2, NodeDesc nodeDesc) {
        NodeItemDesc nodeItemDesc;
        if (n2 >= 0 && n2 < nodeDesc.numElem) {
            nodeItemDesc = this.tnid;
            nodeItemDesc.keyPos = n2;
            nodeItemDesc.nodeAddr = nodeDesc.nodeAddr;
            nodeItemDesc.node = nodeDesc;
            if (nodeDesc.nodeType == -65) {
                Util.memcpy(nodeItemDesc.keyVal, 0, nodeDesc.nodeArea, 11 + n2 * nodeDesc.kdesc.btksz, nodeDesc.kdesc.k_len);
                nodeItemDesc.numRec = Util.getInt(nodeDesc.nodeArea, 11 + n2 * nodeDesc.kdesc.btksz + nodeDesc.kdesc.k_len);
                nodeItemDesc.keyProg = 0;
            } else {
                Util.memcpy(nodeItemDesc.keyVal, 0, nodeDesc.nodeArea, 11 + n2 * nodeDesc.kdesc.tksz, nodeDesc.kdesc.k_len);
                nodeItemDesc.numRec = Util.getInt(nodeDesc.nodeArea, 11 + n2 * nodeDesc.kdesc.tksz + nodeDesc.kdesc.k_len + nodeDesc.kdesc.psz);
                nodeItemDesc.keyProg = Util.getInt(nodeDesc.nodeArea, 11 + n2 * nodeDesc.kdesc.tksz + nodeDesc.kdesc.k_len);
            }
        } else {
            nodeItemDesc = null;
        }
        return nodeItemDesc;
    }

    @Override
    final NodeItemDesc next(short s2, byte[] byArray, int n2, long l2, int n3, boolean bl) throws IsamException {
        if ((this.keyDesc[s2].k_flags & 0xE) == 14) {
            return this.nextCP(s2, byArray, n2, l2, n3, bl);
        }
        return this.nextNC(s2, byArray, n2, l2, n3, bl);
    }

    @Override
    final NodeItemDesc prev(short s2, byte[] byArray, int n2, long l2, int n3, boolean bl) throws IsamException {
        if ((this.keyDesc[s2].k_flags & 0xE) == 14) {
            return this.prevCP(s2, byArray, n2, l2, n3, bl);
        }
        return this.prevNC(s2, byArray, n2, l2, n3, bl);
    }

    private NodeItemDesc nextCP(short s2, byte[] byArray, int n2, long l2, int n3, boolean bl) throws IsamException {
        return null;
    }

    private NodeItemDesc nextNC(short s2, byte[] byArray, int n2, long l2, int n3, boolean bl) throws IsamException {
        NodeItemDesc nodeItemDesc = null;
        boolean bl2 = (this.keyDesc[s2].k_flags & 1) == 1;
        NodeDesc nodeDesc = this.readNode(s2, l2);
        if (nodeDesc.nodeType == -1) {
            int n4;
            for (n4 = n2 + 1; n4 < nodeDesc.numElem; ++n4) {
                int n5 = Util.memcmp(nodeDesc.nodeArea, 11 + n4 * nodeDesc.kdesc.tksz, byArray, 0, nodeDesc.kdesc.k_len);
                if (n5 < 0) continue;
                if (n5 > 0) break;
                if (bl2) {
                    n5 = Util.getInt(nodeDesc.nodeArea, 11 + n4 * nodeDesc.kdesc.tksz + nodeDesc.kdesc.k_len) - n3;
                    if (n5 < 0) continue;
                    if (n5 > 0) break;
                }
                if (bl) break;
            }
            if (n4 < nodeDesc.numElem) {
                nodeItemDesc = this.getKeyDescNC(n4, nodeDesc);
            } else if (nodeDesc.rightBrot != 0L) {
                nodeItemDesc = this.nextNC(s2, byArray, -1, nodeDesc.rightBrot, n3, bl);
            }
        } else {
            throw new IsamException(105);
        }
        return nodeItemDesc;
    }

    private NodeItemDesc prevNC(short s2, byte[] byArray, int n2, long l2, int n3, boolean bl) throws IsamException {
        NodeItemDesc nodeItemDesc = null;
        boolean bl2 = (this.keyDesc[s2].k_flags & 1) == 1;
        NodeDesc nodeDesc = this.readNode(s2, l2);
        if (n2 > nodeDesc.numElem) {
            n2 = nodeDesc.numElem;
        }
        if (nodeDesc.nodeType == -1) {
            int n4;
            for (n4 = n2 - 1; n4 >= 0; --n4) {
                int n5 = Util.memcmp(nodeDesc.nodeArea, 11 + n4 * nodeDesc.kdesc.tksz, byArray, 0, nodeDesc.kdesc.k_len);
                if (n5 > 0) continue;
                if (n5 < 0) break;
                if (bl2) {
                    n5 = Util.getInt(nodeDesc.nodeArea, 11 + n4 * nodeDesc.kdesc.tksz + nodeDesc.kdesc.k_len) - n3;
                    if (n5 > 0) continue;
                    if (n5 < 0) break;
                }
                if (bl) break;
            }
            if (n4 >= 0) {
                nodeItemDesc = this.getKeyDescNC(n4, nodeDesc);
            } else if (nodeDesc.leftBrot != 0L) {
                nodeItemDesc = this.prevNC(s2, byArray, nodeDesc.maxElem, nodeDesc.leftBrot, n3, bl);
            }
        } else {
            throw new IsamException(105);
        }
        return nodeItemDesc;
    }

    private NodeItemDesc prevCP(short s2, byte[] byArray, int n2, long l2, int n3, boolean bl) throws IsamException {
        return null;
    }

    private short searchGeBranchNC(NodeDesc nodeDesc, byte[] byArray, KeyDesc keyDesc, int n2) {
        int n3;
        for (n3 = 0; n3 < nodeDesc.numElem - 1 && Util.memcmp(nodeDesc.nodeArea, 11 + n3 * keyDesc.btksz, byArray, 0, n2) < 0; ++n3) {
        }
        return (short)n3;
    }

    private short searchGtBranchNC(NodeDesc nodeDesc, byte[] byArray, KeyDesc keyDesc, int n2) {
        int n3;
        for (n3 = 0; n3 < nodeDesc.numElem - 1 && Util.memcmp(nodeDesc.nodeArea, 11 + n3 * keyDesc.btksz, byArray, 0, n2) <= 0; ++n3) {
        }
        return (short)n3;
    }

    private NodeItemDesc searchEqInNodeNC(NodeDesc nodeDesc, byte[] byArray, KeyDesc keyDesc, int n2, int[] nArray) {
        NodeItemDesc nodeItemDesc = null;
        nArray[0] = -1;
        for (int i2 = 0; i2 < nodeDesc.numElem && nArray[0] < 0; ++i2) {
            nArray[0] = Util.memcmp(nodeDesc.nodeArea, 11 + i2 * keyDesc.tksz, byArray, 0, n2);
            if (nArray[0] != 0) continue;
            nodeItemDesc = this.getKeyDescNC(i2, nodeDesc);
            break;
        }
        return nodeItemDesc;
    }

    private NodeItemDesc searchGeInNodeNC(NodeDesc nodeDesc, byte[] byArray, KeyDesc keyDesc, int n2, int[] nArray) {
        NodeItemDesc nodeItemDesc = null;
        nArray[0] = -1;
        for (int i2 = 0; i2 < nodeDesc.numElem && nArray[0] < 0; ++i2) {
            nArray[0] = Util.memcmp(nodeDesc.nodeArea, 11 + i2 * keyDesc.tksz, byArray, 0, n2);
            if (nArray[0] < 0) continue;
            nodeItemDesc = this.getKeyDescNC(i2, nodeDesc);
            break;
        }
        return nodeItemDesc;
    }

    private NodeItemDesc searchGtInNodeNC(NodeDesc nodeDesc, byte[] byArray, KeyDesc keyDesc, int n2) {
        NodeItemDesc nodeItemDesc = null;
        for (int i2 = 0; i2 < nodeDesc.numElem; ++i2) {
            if (Util.memcmp(nodeDesc.nodeArea, 11 + i2 * keyDesc.tksz, byArray, 0, n2) <= 0) continue;
            nodeItemDesc = this.getKeyDescNC(i2, nodeDesc);
            break;
        }
        return nodeItemDesc;
    }

    private NodeItemDesc searchLeInNodeNC(NodeDesc nodeDesc, byte[] byArray, KeyDesc keyDesc, int n2) {
        NodeItemDesc nodeItemDesc = null;
        for (int i2 = nodeDesc.numElem - 1; i2 >= 0; --i2) {
            if (Util.memcmp(nodeDesc.nodeArea, 11 + i2 * keyDesc.tksz, byArray, 0, n2) > 0) continue;
            nodeItemDesc = this.getKeyDescNC(i2, nodeDesc);
            break;
        }
        return nodeItemDesc;
    }

    private NodeItemDesc searchLtInNodeNC(NodeDesc nodeDesc, byte[] byArray, KeyDesc keyDesc, int n2) {
        NodeItemDesc nodeItemDesc = null;
        for (int i2 = nodeDesc.numElem - 1; i2 >= 0; --i2) {
            if (Util.memcmp(nodeDesc.nodeArea, 11 + i2 * keyDesc.tksz, byArray, 0, n2) >= 0) continue;
            nodeItemDesc = this.getKeyDescNC(i2, nodeDesc);
            break;
        }
        return nodeItemDesc;
    }

    private NodeItemDesc searchRevEqInNodeNC(NodeDesc nodeDesc, byte[] byArray, KeyDesc keyDesc, int n2, int[] nArray) {
        NodeItemDesc nodeItemDesc = null;
        for (int i2 = nodeDesc.numElem - 1; i2 >= 0; --i2) {
            nArray[0] = Util.memcmp(nodeDesc.nodeArea, 11 + i2 * keyDesc.tksz, byArray, 0, n2);
            if (nArray[0] > 0) continue;
            if (nArray[0] != 0) break;
            nodeItemDesc = this.getKeyDescNC(i2, nodeDesc);
            break;
        }
        return nodeItemDesc;
    }

    private NodeItemDesc searchLastInNodeNC(NodeDesc nodeDesc, int n2) {
        int n3 = nodeDesc.numElem - 1;
        NodeItemDesc nodeItemDesc = null;
        if (nodeDesc.numElem > 0) {
            nodeItemDesc = this.getKeyDescNC(n3, nodeDesc);
        }
        return nodeItemDesc;
    }

    private short searchGtLeaf(NodeDesc nodeDesc, byte[] byArray, KeyDesc keyDesc, int n2) {
        int n3;
        for (n3 = 0; n3 < nodeDesc.numElem && Util.memcmp(nodeDesc.nodeArea, 11 + n3 * keyDesc.tksz, byArray, 0, n2) <= 0; ++n3) {
        }
        return (short)n3;
    }

    private int getNumRecBranch(NodeDesc nodeDesc, int n2) {
        return Util.getInt(nodeDesc.nodeArea, 11 + n2 * nodeDesc.kdesc.btksz + nodeDesc.kdesc.k_len);
    }

    private NodeItemDesc findKeyNC(byte[] byArray, long l2, short s2, KeyDesc keyDesc, int n2, int n3) throws IsamException {
        NodeItemDesc nodeItemDesc;
        block25: {
            NodeDesc nodeDesc;
            block23: {
                int[] nArray;
                block24: {
                    nodeItemDesc = null;
                    nArray = new int[]{0};
                    if (l2 == 0L) {
                        return nodeItemDesc;
                    }
                    nodeDesc = this.readNode(s2, l2);
                    if (nodeDesc.nodeType != -1) break block23;
                    if (nodeDesc.numElem != 0) break block24;
                    nodeItemDesc = n3 == 1 || n3 == 9 ? this.findKeyNC(byArray, nodeDesc.leftBrot, s2, keyDesc, n2, n3) : this.findKeyNC(byArray, nodeDesc.rightBrot, s2, keyDesc, n2, n3);
                    break block25;
                }
                switch (n3) {
                    case 1: {
                        nodeItemDesc = this.getKeyDescNC(nodeDesc.numElem - 1, nodeDesc);
                        break block25;
                    }
                    case 0: {
                        nodeItemDesc = this.getKeyDescNC(0, nodeDesc);
                        break block25;
                    }
                    case 5: {
                        nodeItemDesc = this.searchEqInNodeNC(nodeDesc, byArray, keyDesc, n2, nArray);
                        if (nodeItemDesc == null && nArray[0] < 0 && nodeDesc.rightBrot != 0L) {
                            nodeItemDesc = this.findKeyNC(byArray, nodeDesc.rightBrot, s2, keyDesc, n2, n3);
                        }
                        break block25;
                    }
                    case 7: {
                        nodeItemDesc = this.searchGeInNodeNC(nodeDesc, byArray, keyDesc, n2, nArray);
                        if (nodeItemDesc == null && nArray[0] < 0 && nodeDesc.rightBrot != 0L) {
                            nodeItemDesc = this.findKeyNC(byArray, nodeDesc.rightBrot, s2, keyDesc, n2, n3);
                        }
                        break block25;
                    }
                    case 6: {
                        nodeItemDesc = this.searchGtInNodeNC(nodeDesc, byArray, keyDesc, n2);
                        if (nodeItemDesc == null && nodeDesc.rightBrot != 0L) {
                            nodeItemDesc = this.findKeyNC(byArray, nodeDesc.rightBrot, s2, keyDesc, n2, n3);
                        }
                        break block25;
                    }
                    case 9: {
                        nodeItemDesc = this.searchLeInNodeNC(nodeDesc, byArray, keyDesc, n2);
                        if (nodeItemDesc == null && nodeDesc.leftBrot != 0L) {
                            nodeItemDesc = this.findKeyNC(byArray, nodeDesc.leftBrot, s2, keyDesc, n2, n3);
                        }
                        break block25;
                    }
                    case 8: {
                        nodeItemDesc = this.searchLtInNodeNC(nodeDesc, byArray, keyDesc, n2);
                        if (nodeItemDesc == null && nodeDesc.leftBrot != 0L) {
                            nodeItemDesc = this.findKeyNC(byArray, nodeDesc.leftBrot, s2, keyDesc, n2, n3);
                        }
                        break block25;
                    }
                    default: {
                        throw new IsamException(102);
                    }
                }
            }
            if (nodeDesc.nodeType == -65) {
                int n4 = 0;
                switch (n3) {
                    case 1: {
                        n4 = nodeDesc.numElem - 1;
                        nodeItemDesc = this.findKeyNC(byArray, this.getNumRecBranch(nodeDesc, n4), s2, keyDesc, n2, n3);
                        break;
                    }
                    case 0: {
                        n4 = 0;
                        nodeItemDesc = this.findKeyNC(byArray, this.getNumRecBranch(nodeDesc, n4), s2, keyDesc, n2, n3);
                        break;
                    }
                    case 5: 
                    case 7: 
                    case 8: {
                        n4 = this.searchGeBranchNC(nodeDesc, byArray, keyDesc, n2);
                        nodeItemDesc = this.findKeyNC(byArray, this.getNumRecBranch(nodeDesc, n4), s2, keyDesc, n2, n3);
                        break;
                    }
                    case 6: 
                    case 9: {
                        n4 = this.searchGtBranchNC(nodeDesc, byArray, keyDesc, n2);
                        nodeItemDesc = this.findKeyNC(byArray, this.getNumRecBranch(nodeDesc, n4), s2, keyDesc, n2, n3);
                        break;
                    }
                    default: {
                        throw new IsamException(102);
                    }
                }
            } else {
                throw new IsamException(105);
            }
        }
        return nodeItemDesc;
    }

    private NodeItemDesc findKeyCP(byte[] byArray, int n2, short s2, KeyDesc keyDesc, int n3, int n4) throws IsamException {
        return null;
    }

    @Override
    final void buildKey(short s2, byte[] byArray, int n2, byte[] byArray2) {
        this.keyDesc[s2].buildKey(byArray, n2, byArray2);
    }

    @Override
    final byte[][] buildAllKeys(byte[] byArray, int n2, long l2) throws IsamException {
        byte[][] byArrayArray = new byte[this.dictInfo.di_nkeys][];
        for (short s2 = 0; s2 < this.dictInfo.di_nkeys; s2 = (short)(s2 + 1)) {
            NodeItemDesc nodeItemDesc;
            byArrayArray[s2] = new byte[this.keyDesc[s2].k_len];
            if (this.keyDesc[s2].k_nparts <= 0) continue;
            this.keyDesc[s2].buildKey(byArray, n2, byArrayArray[s2]);
            if ((this.keyDesc[s2].k_flags & 1) != 0 || (nodeItemDesc = this.findKey(byArrayArray[s2], s2, this.keyDesc[s2].k_len, 5)) == null || nodeItemDesc.numRec == l2) continue;
            throw new IsamException(100);
        }
        return byArrayArray;
    }

    @Override
    final void rewriteAllKeys(byte[] byArray, byte[] byArray2, int n2, long l2, byte[][] byArray3) throws IsamException {
        byte[] byArray4 = new byte[259];
        for (short s2 = 0; s2 < this.dictInfo.di_nkeys; s2 = (short)(s2 + 1)) {
            this.keyDesc[s2].buildKey(byArray, 0, byArray3[s2]);
            this.keyDesc[s2].buildKey(byArray2, n2, byArray4);
            if (Util.equals(byArray3[s2], byArray4, this.keyDesc[s2].k_len)) continue;
            this.deleteKey(byArray3[s2], this.keyDesc[s2].getRootNode(), s2, this.keyDesc[s2], l2);
            this.insertKey(byArray4, s2, l2);
        }
        this.writeHeader(false);
    }

    @Override
    final NodeItemDesc findKey(byte[] byArray, short s2, int n2, int n3) throws IsamException {
        KeyDesc keyDesc = this.keyDesc[s2];
        int n4 = keyDesc.getRootNode();
        if (n2 == 0) {
            n2 = this.keyDesc[s2].k_len;
        }
        if ((this.keyDesc[s2].k_flags & 0xE) == 14) {
            return this.findKeyCP(byArray, n4, s2, keyDesc, n2, n3);
        }
        return this.findKeyNC(byArray, n4, s2, keyDesc, n2, n3);
    }

    @Override
    final long newRoot(NewNodes newNodes, short s2) throws IsamException {
        int n2 = this.getFreeNode();
        NodeDesc nodeDesc = new NodeDesc((int)this.dictInfo.di_idxsize, this.keyDesc[s2]);
        nodeDesc.nodeType = (byte)-65;
        nodeDesc.numElem = (short)2;
        nodeDesc.leftBrot = 0L;
        nodeDesc.rightBrot = 0L;
        nodeDesc.nodeAddr = n2;
        nodeDesc.usableSize = this.dictInfo.di_idxsize - 11;
        nodeDesc.maxElem = nodeDesc.usableSize / (nodeDesc.kdesc.k_len + 4);
        if ((this.keyDesc[s2].k_flags & 0xE) != 14) {
            int n3 = 11;
            Util.memcpy(nodeDesc.nodeArea, n3, newNodes.keyValMin, 0, this.keyDesc[s2].k_len);
            Util.putInt(nodeDesc.nodeArea, n3 += this.keyDesc[s2].k_len, newNodes.nodeAddrKMin);
            Util.memset(nodeDesc.nodeArea, n3 += 4, (byte)-1, this.keyDesc[s2].k_len);
            Util.putInt(nodeDesc.nodeArea, n3 += this.keyDesc[s2].k_len, newNodes.nodeAddrKMax);
        }
        this.writeNode(nodeDesc);
        return n2;
    }

    private NewNodes breakNode(NodeDesc nodeDesc, short s2, short s3, byte[] byArray, long l2, byte by, boolean bl, int n2) throws IsamException {
        short s4 = (short)((nodeDesc.numElem + 1) / 2);
        short s5 = (short)(nodeDesc.numElem - s4 + 1);
        NewNodes newNodes = new NewNodes();
        NewNodes newNodes2 = null;
        KeyDesc keyDesc = this.keyDesc[s2];
        boolean bl2 = false;
        boolean bl3 = false;
        int n3 = nodeDesc.nodeType == -65 ? nodeDesc.kdesc.btksz : nodeDesc.kdesc.tksz;
        NodeDesc nodeDesc2 = new NodeDesc(this.dictInfo.di_idxsize + keyDesc.tksz, nodeDesc);
        newNodes.nodeAddrKMin = this.getFreeNode();
        newNodes.nodeAddrKMax = nodeDesc.nodeAddr;
        boolean bl4 = false;
        if (nodeDesc.nodeType == -1) {
            this.leafInsertNC(nodeDesc2, byArray, l2, bl, n2);
        } else {
            this.nodeInsert(nodeDesc2, s3, byArray, l2, bl, n2);
        }
        Util.memset(nodeDesc.nodeArea, (byte)0, this.dictInfo.di_idxsize);
        int n4 = s4 - 1;
        while (s4 < nodeDesc.maxElem && Util.equals(nodeDesc2.nodeArea, 11 + n4 * n3, nodeDesc2.nodeArea, 11 + (n4 + 1) * n3, nodeDesc.kdesc.k_len)) {
            s4 = (short)(s4 + 1);
            ++n4;
        }
        s5 = (short)(nodeDesc.numElem - s4 + 1);
        Util.memcpy(newNodes.keyValMin, 0, nodeDesc2.nodeArea, 11 + (s4 - 1) * n3, nodeDesc.kdesc.k_len);
        if (nodeDesc.leftBrot != 0L) {
            this.changeLeftBrother(nodeDesc.leftBrot, s2, newNodes.nodeAddrKMin, by);
        }
        nodeDesc.nodeType = by;
        nodeDesc.numElem = s5;
        nodeDesc.leftBrot = newNodes.nodeAddrKMin;
        Util.memcpy(nodeDesc.nodeArea, 11, nodeDesc2.nodeArea, 11 + s4 * n3, s5 * n3);
        nodeDesc.nodeAddr = newNodes.nodeAddrKMax;
        this.writeNode(nodeDesc);
        nodeDesc2.nodeType = by;
        nodeDesc2.numElem = s4;
        nodeDesc2.rightBrot = newNodes.nodeAddrKMax;
        Util.memset(nodeDesc2.nodeArea, 11 + s4 * n3, (byte)0, s5 * n3);
        nodeDesc2.nodeAddr = newNodes.nodeAddrKMin;
        this.writeNode(nodeDesc2);
        newNodes2 = newNodes;
        return newNodes2;
    }

    private void changeLeftBrother(long l2, short s2, long l3, byte by) throws IsamException {
        NodeDesc nodeDesc = this.readNode(s2, l2);
        if (nodeDesc.nodeType != by) {
            throw new IsamException(105);
        }
        nodeDesc.rightBrot = l3;
        this.writeNode(nodeDesc);
    }

    private void changeRightBrother(long l2, short s2, long l3, byte by) throws IsamException {
        NodeDesc nodeDesc = this.readNode(s2, l2);
        if (nodeDesc.nodeType != by) {
            throw new IsamException(105);
        }
        nodeDesc.leftBrot = l3;
        this.writeNode(nodeDesc);
    }

    private void delNode(int n2, byte[] byArray) throws IsamException {
        byArray[0] = -33;
        Util.putInt(byArray, 1, this.firstDeletedNode);
        this.firstDeletedNode = n2;
        this.fdIndex.seek(n2);
        this.fdIndex.write(byArray, 0, this.dictInfo.di_idxsize);
        this.cacheClear();
    }

    private short deleteKey(byte[] byArray, int n2, short s2, KeyDesc keyDesc, long l2) throws IsamException {
        if ((this.keyDesc[s2].k_flags & 0xE) == 14) {
            throw new IsamException(126);
        }
        return this.deleteKeyNC(byArray, n2, s2, keyDesc, l2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private short deleteKeyNC(byte[] byArray, int n2, short s2, KeyDesc keyDesc, long l2) throws IsamException {
        short s3 = -1;
        if (n2 == 0) {
            return s3;
        }
        NodeDesc nodeDesc = this.readNode(s2, n2);
        if (nodeDesc.nodeType == -1) {
            int n3 = 0;
            while (n3 < nodeDesc.numElem) {
                if (l2 == (long)Util.getInt(nodeDesc.nodeArea, 11 + n3 * keyDesc.tksz + keyDesc.k_len + keyDesc.psz)) {
                    if (nodeDesc.numElem == 1 && n2 != this.keyDesc[s2].getRootNode()) {
                        this.delNode(n2, nodeDesc.nodeArea);
                        if (nodeDesc.rightBrot != 0L) {
                            this.changeRightBrother(nodeDesc.rightBrot, s2, nodeDesc.leftBrot, (byte)-1);
                        }
                        if (nodeDesc.leftBrot == 0L) return 0;
                        this.changeLeftBrother(nodeDesc.leftBrot, s2, nodeDesc.rightBrot, (byte)-1);
                        return 0;
                    }
                    s3 = nodeDesc.numElem;
                    this.deleteKeyFromNodeNC(nodeDesc, n3, keyDesc.tksz, (keyDesc.k_flags & 1) == 1);
                    this.writeNode(nodeDesc);
                    return s3;
                }
                ++n3;
            }
            return s3;
        }
        if (nodeDesc.nodeType != -65) throw new IsamException(105);
        short s4 = this.searchGeBranchNC(nodeDesc, byArray, keyDesc, keyDesc.k_len);
        while (true) {
            int n4;
            if ((s3 = this.deleteKeyNC(byArray, this.getNumRec(nodeDesc, s4), s2, keyDesc, l2)) >= 0) {
                if (s3 != 0) return s3;
                if (nodeDesc.numElem == 1) {
                    if (n2 == this.keyDesc[s2].getRootNode()) {
                        nodeDesc.nodeType = (byte)-1;
                        nodeDesc.numElem = 0;
                        nodeDesc.leftBrot = 0L;
                        nodeDesc.rightBrot = 0L;
                        this.writeNode(nodeDesc);
                        return s3;
                    }
                    this.delNode(n2, nodeDesc.nodeArea);
                    if (nodeDesc.rightBrot != 0L) {
                        this.changeRightBrother(nodeDesc.rightBrot, s2, nodeDesc.leftBrot, (byte)-65);
                    }
                    if (nodeDesc.leftBrot == 0L) return 0;
                    this.changeLeftBrother(nodeDesc.leftBrot, s2, nodeDesc.rightBrot, (byte)-65);
                    return 0;
                }
                if (nodeDesc.numElem - 1 == s4) {
                    n4 = keyDesc.k_len + 4;
                    this.deleteKeyFromNodeNC(nodeDesc, s4, n4, false);
                    Util.memset(nodeDesc.nodeArea, 11 + (nodeDesc.numElem - 1) * n4, (byte)-1, nodeDesc.kdesc.k_len);
                    this.writeNode(nodeDesc);
                    return nodeDesc.numElem;
                }
                n4 = keyDesc.k_len + 4;
                this.deleteKeyFromNodeNC(nodeDesc, s4, n4, false);
                this.writeNode(nodeDesc);
                return nodeDesc.numElem;
            }
            n4 = keyDesc.k_len + 4;
            if ((s4 = (short)(s4 + 1)) >= nodeDesc.numElem) return s3;
            if (Util.memcmp(nodeDesc.nodeArea, 11 + (s4 - 1) * n4, byArray, 0, keyDesc.k_len) > 0) throw new IsamException(105);
        }
    }

    private void deleteKeyFromNodeNC(NodeDesc nodeDesc, int n2, int n3, boolean bl) {
        int n4 = 11 + (nodeDesc.numElem - 1) * n3;
        for (int i2 = 11 + (n2 + 1) * n3; i2 <= n4; i2 += n3) {
            Util.memcpy(nodeDesc.nodeArea, i2 - n3, nodeDesc.nodeArea, i2, n3);
        }
        Util.memset(nodeDesc.nodeArea, n4, (byte)-1, nodeDesc.kdesc.k_len);
        n4 += nodeDesc.kdesc.k_len;
        if (bl) {
            Util.putInt(nodeDesc.nodeArea, n4, 0);
            n4 += 4;
        }
        Util.putInt(nodeDesc.nodeArea, n4, 0);
        nodeDesc.numElem = (short)(nodeDesc.numElem - 1);
    }

    private int getFreeNode() throws IsamException {
        int n2;
        int n3 = 5;
        byte[] byArray = new byte[n3];
        if (this.firstDeletedNode == 0) {
            n2 = this.firstFreeNode;
            this.firstFreeNode += this.dictInfo.di_idxsize;
        } else {
            n2 = this.firstDeletedNode;
            this.fdIndex.seek(n2);
            this.fdIndex.read(byArray, 0, n3);
            if (this.fdIndex.encrypt) {
                byArray = this.fdIndex.decrypt(byArray, 0, byArray.length);
            }
            this.firstDeletedNode = Util.getInt(byArray, 1);
        }
        return n2;
    }

    private long leafInsertNC(NodeDesc nodeDesc, byte[] byArray, long l2, boolean bl, int n2) {
        long l3 = l2;
        if (nodeDesc.numElem == 0) {
            Util.memcpy(nodeDesc.nodeArea, 11, byArray, 0, nodeDesc.kdesc.k_len);
            int n3 = 11 + nodeDesc.kdesc.k_len;
            if (bl) {
                Util.putInt(nodeDesc.nodeArea, n3, n2);
                n3 += 4;
            }
            Util.putInt(nodeDesc.nodeArea, n3, l3);
            nodeDesc.numElem = (short)(nodeDesc.numElem + 1);
        } else {
            short s2 = this.searchGtLeaf(nodeDesc, byArray, nodeDesc.kdesc, nodeDesc.kdesc.k_len);
            this.nodeInsert(nodeDesc, s2, byArray, l3, bl, n2);
        }
        return l3;
    }

    private void nodeInsert(NodeDesc nodeDesc, short s2, byte[] byArray, long l2, boolean bl, int n2) {
        int n3 = nodeDesc.nodeType == -65 ? nodeDesc.kdesc.btksz : nodeDesc.kdesc.tksz;
        int n4 = 11 + s2 * n3;
        for (int i2 = 11 + nodeDesc.numElem * n3; i2 > n4; i2 -= n3) {
            Util.memcpy(nodeDesc.nodeArea, i2, nodeDesc.nodeArea, i2 - n3, n3);
        }
        Util.memcpy(nodeDesc.nodeArea, n4, byArray, 0, nodeDesc.kdesc.k_len);
        n4 += nodeDesc.kdesc.k_len;
        if (bl) {
            Util.putInt(nodeDesc.nodeArea, n4, n2);
            n4 += 4;
        }
        Util.putInt(nodeDesc.nodeArea, n4, l2);
        nodeDesc.numElem = (short)(nodeDesc.numElem + 1);
    }

    private NewNodes insertKeyNC(byte[] byArray, int n2, short s2, long l2) throws IsamException {
        NewNodes newNodes = null;
        boolean bl = (this.keyDesc[s2].k_flags & 1) == 1;
        NodeDesc nodeDesc = this.readNode(s2, n2);
        if (nodeDesc.nodeType == -1) {
            int n3;
            int[] nArray = new int[]{0};
            NodeItemDesc nodeItemDesc = this.searchRevEqInNodeNC(nodeDesc, byArray, nodeDesc.kdesc, nodeDesc.kdesc.k_len, nArray);
            if (bl) {
                if (nodeItemDesc == null) {
                    if (nArray[0] >= 0 && nodeDesc.leftBrot != 0L) {
                        NodeDesc nodeDesc2;
                        long l3 = nodeDesc.leftBrot;
                        byte[] byArray2 = new byte[this.dictInfo.di_idxsize];
                        do {
                            nodeDesc2 = this.readNode(s2, l3);
                            l3 = nodeDesc2.leftBrot;
                        } while (nodeDesc2.numElem == 0 && l3 != 0L);
                        NodeItemDesc nodeItemDesc2 = this.searchLastInNodeNC(nodeDesc2, 1);
                        n3 = nodeItemDesc2 != null ? nodeItemDesc2.keyProg + 1 : 0;
                    } else {
                        n3 = 0;
                    }
                } else {
                    n3 = nodeItemDesc.keyProg + 1;
                }
            } else {
                if (nodeItemDesc != null) {
                    throw new IsamException(100, "#" + nodeItemDesc.numRec);
                }
                n3 = 0;
            }
            if (nodeDesc.maxElem > nodeDesc.numElem) {
                l2 = this.leafInsertNC(nodeDesc, byArray, l2, bl, n3);
                this.writeNode(nodeDesc);
                newNodes = null;
            } else {
                newNodes = this.breakNode(nodeDesc, s2, (short)0, byArray, l2, (byte)-1, bl, n3);
            }
        } else if (nodeDesc.nodeType == -65) {
            short s3 = bl ? this.searchGtBranchNC(nodeDesc, byArray, nodeDesc.kdesc, nodeDesc.kdesc.k_len) : this.searchGeBranchNC(nodeDesc, byArray, nodeDesc.kdesc, nodeDesc.kdesc.k_len);
            newNodes = this.insertKeyNC(byArray, this.getNumRec(nodeDesc, s3), s2, l2);
            if (newNodes != null) {
                nodeDesc = this.readNode(s2, n2);
                if (nodeDesc.maxElem > nodeDesc.numElem) {
                    this.nodeInsert(nodeDesc, s3, newNodes.keyValMin, newNodes.nodeAddrKMin, false, 0);
                    this.writeNode(nodeDesc);
                    newNodes = null;
                } else {
                    newNodes = this.breakNode(nodeDesc, s2, s3, newNodes.keyValMin, newNodes.nodeAddrKMin, (byte)-65, false, 0);
                }
            }
        } else {
            throw new IsamException(105);
        }
        return newNodes;
    }

    private int getNumRec(NodeDesc nodeDesc, int n2) {
        return Util.getInt(nodeDesc.nodeArea, 11 + n2 * (nodeDesc.kdesc.k_len + 4) + nodeDesc.kdesc.k_len);
    }

    @Override
    final void deleteKeys(byte[] byArray, int n2, long l2) throws IsamException {
        byte[] byArray2 = new byte[255];
        for (short s2 = 0; s2 < this.dictInfo.di_nkeys; s2 = (short)(s2 + 1)) {
            if (this.keyDesc[s2].k_nparts <= 0) continue;
            this.keyDesc[s2].buildKey(byArray, n2, byArray2);
            this.deleteKey(byArray2, this.keyDesc[s2].getRootNode(), s2, this.keyDesc[s2], l2);
        }
        this.storeRecDel(l2);
        this.writeHeader(false);
    }

    @Override
    final void insertKeys(byte[][] byArray, long l2) throws IsamException {
        for (short s2 = 0; s2 < this.dictInfo.di_nkeys; s2 = (short)(s2 + 1)) {
            if (this.keyDesc[s2].k_nparts <= 0) continue;
            this.insertKey(byArray[s2], s2, l2);
        }
        this.writeHeader(false);
    }

    @Override
    final void insertKey(byte[] byArray, short s2, long l2) throws IsamException {
        int n2;
        NewNodes newNodes;
        if ((this.keyDesc[s2].k_flags & 0xE) != 14 && (newNodes = this.insertKeyNC(byArray, this.keyDesc[s2].getRootNode(), s2, l2)) != null && (n2 = (int)this.newRoot(newNodes, s2)) != 0) {
            this.keyDesc[s2].setRootNode(n2);
        }
    }

    @Override
    final long getDelRecNum() throws IsamException {
        long l2 = 0L;
        if (this.firstDelRecNode == 0) {
            l2 = 0L;
        } else {
            int n2 = this.firstDelRecNode;
            l2 = 0L;
            do {
                this.fdIndex.seek(n2);
                this.fdIndex.read(this.delrecnode, 0, this.dictInfo.di_idxsize);
                if (this.delrecnode[0] != -17) {
                    throw new IsamException(105);
                }
                l2 += (long)Util.getShort(this.delrecnode, 1);
            } while ((n2 = Util.getInt(this.delrecnode, 3)) != 0);
        }
        return l2;
    }

    @Override
    final long getNewRecNum() throws IsamException {
        long l2 = 0L;
        int n2 = 7;
        int n3 = this.firstDelRecNode;
        if (this.firstDelRecNode == 0) {
            l2 = ++this.dictInfo.di_nrecords;
        } else {
            this.fdIndex.seek(this.firstDelRecNode);
            this.fdIndex.read(this.delrecnode, 0, this.dictInfo.di_idxsize);
            if (this.delrecnode[0] != -17) {
                throw new IsamException(105);
            }
            short s2 = Util.getShort(this.delrecnode, 1);
            s2 = (short)(s2 - 1);
            int n4 = n2 + s2 * 4;
            l2 = Util.getInt(this.delrecnode, n4);
            Util.putInt(this.delrecnode, n4, 0);
            if (s2 == 0) {
                this.firstDelRecNode = Util.getInt(this.delrecnode, 3);
                this.delrecnode[0] = -33;
                Util.putInt(this.delrecnode, 1, this.firstDeletedNode);
                this.firstDeletedNode = n3;
            } else {
                Util.putShort(this.delrecnode, 1, s2);
            }
            this.fdIndex.seek(n3);
            this.fdIndex.write(this.delrecnode, 0, this.dictInfo.di_idxsize);
        }
        return l2;
    }

    @Override
    final void resetGetNewRecNum(long l2) throws IsamException {
        if (l2 == (long)(this.dictInfo.di_nrecords - 1)) {
            --this.dictInfo.di_nrecords;
        } else {
            this.storeRecDel(l2);
        }
    }

    private void storeRecDel(long l2) throws IsamException {
        int n2;
        int n3 = 0;
        int n4 = 7;
        int n5 = (this.dictInfo.di_idxsize - n4) / 4;
        if (this.firstDelRecNode == 0) {
            n2 = this.allocRecDel();
            n3 = 0;
        } else {
            this.fdIndex.seek(this.firstDelRecNode);
            this.fdIndex.read(this.delrecnode, 0, this.dictInfo.di_idxsize);
            n2 = this.firstDelRecNode;
            if (this.delrecnode[0] != -17) {
                throw new IsamException(105);
            }
            n3 = Util.getShort(this.delrecnode, 1);
            if (n3 == n5) {
                n2 = this.allocRecDel();
                n3 = 0;
            }
        }
        int n6 = n4 + n3 * 4;
        Util.putInt(this.delrecnode, n6, l2);
        n3 = (short)(n3 + 1);
        Util.putShort(this.delrecnode, 1, (short)n3);
        this.fdIndex.seek(n2);
        this.fdIndex.write(this.delrecnode, 0, this.dictInfo.di_idxsize);
    }

    private int allocRecDel() throws IsamException {
        int n2 = this.getFreeNode();
        Util.memset(this.delrecnode, (byte)0, this.dictInfo.di_idxsize);
        this.delrecnode[0] = -17;
        Util.putShort(this.delrecnode, 1, (short)0);
        Util.putInt(this.delrecnode, 3, this.firstDelRecNode);
        this.firstDelRecNode = n2;
        return n2;
    }

    final short newKey(KeyDesc keyDesc) throws IsamException {
        int n2;
        KeyDesc keyDesc2 = new KeyDesc();
        keyDesc.check();
        keyDesc2.assign(keyDesc);
        keyDesc2.k_len = 0;
        for (n2 = 0; n2 < keyDesc2.k_nparts; ++n2) {
            keyDesc2.k_part[n2].check(this.dictInfo.di_recsize);
            keyDesc2.k_len = (short)(keyDesc2.k_len + keyDesc2.k_part[n2].kp_leng);
        }
        if (keyDesc2.k_len > 255) {
            throw new IsamException(103);
        }
        for (int i2 = 0; i2 < this.dictInfo.di_nkeys; ++i2) {
            if (keyDesc2.k_nparts <= 0 || keyDesc2.k_nparts != this.keyDesc[i2].k_nparts) continue;
            boolean bl = true;
            for (n2 = 0; n2 < keyDesc2.k_nparts; ++n2) {
                if (keyDesc2.k_part[n2].kp_start == this.keyDesc[i2].k_part[n2].kp_start && keyDesc2.k_part[n2].kp_leng == this.keyDesc[i2].k_part[n2].kp_leng) continue;
                bl = false;
            }
            if (!bl) continue;
            throw new IsamException(108);
        }
        int n3 = this.dictInfo.di_nkeys;
        this.dictInfo.di_nkeys = (short)(n3 + 1);
        int n4 = n3;
        KeyDesc[] keyDescArray = this.keyDesc;
        KeyDesc[] keyDescArray2 = new KeyDesc[this.dictInfo.di_nkeys];
        for (n2 = 0; n2 < n4; ++n2) {
            keyDescArray2[n2] = keyDescArray[n2];
        }
        keyDescArray2[n2] = keyDesc2;
        this.keyDesc = keyDescArray2;
        keyDesc2.setRootNode(this.getFreeNode());
        this.writeHeader(false);
        this.fdIndex.seek(keyDesc2.getRootNode());
        Util.memset(this.hndeArea, (byte)0, this.dictInfo.di_idxsize);
        this.hndeArea[0] = -1;
        this.fdIndex.write(this.hndeArea, 0, this.dictInfo.di_idxsize);
        return (short)n4;
    }

    @Override
    final short getKeyNum(KeyDesc keyDesc) throws IsamException {
        short s2;
        for (s2 = 0; s2 < this.dictInfo.di_nkeys; s2 = (short)(s2 + 1)) {
            short s3;
            if (keyDesc.k_nparts != this.keyDesc[s2].k_nparts) continue;
            for (s3 = 0; s3 < keyDesc.k_nparts && keyDesc.k_part[s3].kp_start == this.keyDesc[s2].k_part[s3].kp_start && keyDesc.k_part[s3].kp_leng == this.keyDesc[s2].k_part[s3].kp_leng; s3 = (short)(s3 + 1)) {
            }
            if (s3 == keyDesc.k_nparts) break;
        }
        if (s2 == this.dictInfo.di_nkeys) {
            throw new IsamException(103);
        }
        return s2;
    }

    @Override
    final short getKeyLen(int n2) {
        return this.keyDesc[n2].k_len;
    }

    @Override
    final void delTree(short s2) throws IsamException {
        this.delTree(this.keyDesc[s2].getRootNode(), s2);
        byte[][] byArrayArray = new byte[this.dictInfo.di_nkeys][];
        byArrayArray[s2] = new byte[this.keyDesc[s2].k_len];
        KeyDesc keyDesc = this.keyDesc[s2];
        int n2 = s2 + 1;
        while (n2 < this.dictInfo.di_nkeys) {
            this.keyDesc[s2] = this.keyDesc[n2];
            ++n2;
            s2 = (short)(s2 + 1);
        }
        this.keyDesc[s2] = keyDesc;
        this.keyDesc[s2].k_nparts = 0;
        this.dictInfo.di_nkeys = (short)(this.dictInfo.di_nkeys - 1);
    }

    private void delTree(int n2, short s2) throws IsamException {
        byte[] byArray = new byte[this.dictInfo.di_idxsize];
        NodeDesc nodeDesc = this.readNode(s2, n2);
        if (nodeDesc.nodeType == -65) {
            int n3 = nodeDesc.kdesc.k_len + 4;
            for (int i2 = 0; i2 < nodeDesc.numElem; ++i2) {
                int n4 = Util.getInt(nodeDesc.nodeArea, 11 + i2 * n3 + nodeDesc.kdesc.k_len);
                this.delTree(n4, s2);
            }
        }
        if (nodeDesc.nodeType != -65 && nodeDesc.nodeType != -1) {
            throw new IsamException(105);
        }
        this.delNode(n2, byArray);
    }

    @Override
    final long checkDeleteNodes() throws IsamException {
        long l2;
        byte[] byArray = new byte[5];
        if (this.firstDeletedNode == 0) {
            l2 = 0L;
        } else {
            l2 = 0L;
            int n2 = this.firstDeletedNode;
            while (n2 != 0) {
                this.fdIndex.seek(n2);
                this.fdIndex.read(byArray, 0, byArray.length);
                if (this.fdIndex.encrypt) {
                    byArray = this.fdIndex.decrypt(byArray, 0, byArray.length);
                }
                if (byArray[0] != -33) {
                    throw new IsamException(105);
                }
                n2 = Util.getInt(byArray, 1);
                ++l2;
            }
        }
        return l2;
    }

    @Override
    final long checkDeleteRecords() throws IsamException {
        int n2 = this.firstDelRecNode;
        int n3 = 0;
        while (n2 != 0) {
            this.fdIndex.seek(n2);
            this.fdIndex.read(this.delrecnode, 0, this.dictInfo.di_idxsize);
            if (this.delrecnode[0] != -17) {
                throw new IsamException(105);
            }
            short s2 = Util.getShort(this.delrecnode, 1);
            n3 += s2;
            n2 = Util.getInt(this.delrecnode, 3);
        }
        return n3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final long addIndex(KeyDesc keyDesc, OSFile oSFile, boolean bl, PrintStream printStream) throws IsamException {
        oSFile.seek(0L);
        short s2 = this.dictInfo.di_recsize;
        s2 = (short)(s2 + 1);
        byte[] byArray = new byte[s2];
        short s3 = this.newKey(keyDesc);
        long l2 = 0L;
        keyDesc = this.keyDesc[s3];
        try {
            if (keyDesc.k_nparts <= 0) return l2;
            byte[] byArray2 = new byte[keyDesc.k_len];
            long l3 = 1L;
            while (oSFile.read(byArray, 0, s2) == s2) {
                block11: {
                    if (byArray[this.dictInfo.di_recsize] == 10) {
                        keyDesc.buildKey(byArray, 0, byArray2);
                        try {
                            this.insertKey(byArray2, s3, l3);
                        }
                        catch (IsamException isamException) {
                            String string = isamException.getMessage();
                            string = string + ",#";
                            string = string + l3;
                            string = string + ",k=";
                            for (int i2 = 0; i2 < keyDesc.k_nparts; ++i2) {
                                string = string + "[";
                                string = string + keyDesc.k_part[i2].kp_start;
                                string = string + ",";
                                string = string + keyDesc.k_part[i2].kp_leng;
                                string = string + "]";
                            }
                            if (!bl) throw new IsamException(isamException.getIserrno(), string);
                            byArray[this.dictInfo.di_recsize] = 0;
                            oSFile.seek((long)s2 * (l3 - 1L));
                            oSFile.write(byArray, 0, s2);
                            if (printStream != null) {
                                printStream.println("removed " + string);
                            }
                            break block11;
                        }
                    }
                    if (byArray[this.dictInfo.di_recsize] != 0) {
                        String string = "#";
                        string = string + l3;
                        throw new IsamException(105, string);
                    }
                }
                ++l2;
                ++l3;
            }
            return l2;
        }
        catch (IsamException isamException) {
            try {
                this.delTree(s3);
                throw isamException;
            }
            catch (IsamException isamException2) {
                // empty catch block
            }
            throw isamException;
        }
    }

    @Override
    final long addIndex(KeyDesc keyDesc, OSFile oSFile) throws IsamException {
        return this.addIndex(keyDesc, oSFile, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void indexInfo(DictInfo dictInfo) {
        long l2 = 0L;
        try {
            this.readHeader(false);
            l2 = this.getDelRecNum();
            dictInfo.assign(this.dictInfo, l2);
        }
        catch (IsamException isamException) {
            dictInfo.assign(this.dictInfo, l2);
        }
        finally {
            try {
                this.headerUnlock();
            }
            catch (IsamException isamException) {}
        }
    }

    @Override
    public void indexInfo(KeyDesc keyDesc, int n2) throws IsamException {
        try {
            this.readHeader(false);
            if (n2 <= 0 || n2 > this.dictInfo.di_nkeys) {
                throw new IsamException(102);
            }
            keyDesc.assign(this.keyDesc[n2 - 1]);
        }
        finally {
            this.headerUnlock();
        }
    }

    @Override
    final byte[] getCollatingSequence() throws IsamException {
        return null;
    }

    private final boolean storeDelRecords(OSFile oSFile) throws IsamException {
        boolean bl = false;
        int n2 = this.dictInfo.di_recsize;
        byte[] byArray = new byte[++n2];
        oSFile.seek(0L);
        int n3 = 1;
        while (oSFile.read(byArray, 0, n2) == n2) {
            if (byArray[this.dictInfo.di_recsize] != 10) {
                this.storeRecDel(n3);
                bl = true;
            }
            ++n3;
        }
        return bl;
    }

    @Override
    final OSFile rebuild(OSFile oSFile, String string, boolean bl, PrintStream printStream) throws IsamException {
        int n2 = string.length();
        OSFile oSFile2 = this.fdIndex;
        OSFile oSFile3 = new OSFile();
        byte[] byArray = new byte[this.headerSize];
        this.readHeader(true);
        String string2 = Isam.getTemporaryFile(string);
        oSFile3.open(string2, 578);
        this.fdIndex = oSFile3;
        this.firstFreeNode = this.headerSize;
        this.firstAddKeyNode = 0;
        this.firstDeletedNode = 0;
        this.firstDelRecNode = 0;
        int n3 = this.dictInfo.di_nkeys;
        this.dictInfo.di_nkeys = 0;
        this.dictInfo.di_nrecords = 0;
        this.fdIndex.seek(0L);
        Util.memcpy(byArray, 0, SIGN, 0, 6);
        Util.putShort(byArray, 6, this.releaseLevel);
        Util.putInt(byArray, 8, this.firstFreeNode);
        Util.putShort(byArray, 12, this.dictInfo.di_nkeys);
        Util.putShort(byArray, 14, this.dictInfo.di_recsize);
        Util.putShort(byArray, 16, this.dictInfo.di_idxsize);
        Util.putInt(byArray, 18, this.dictInfo.di_nrecords);
        Util.putShort(byArray, 22, this.headerSize);
        Util.putInt(byArray, 24, this.firstDeletedNode);
        Util.putInt(byArray, 28, this.firstDelRecNode);
        Util.putInt(byArray, this.headerSize - 4, this.firstAddKeyNode);
        this.fdIndex.write(byArray);
        this.readHeader(true);
        KeyDesc[] keyDescArray = this.keyDesc;
        this.keyDesc = null;
        try {
            for (int i2 = 0; i2 < n3; ++i2) {
                int n4 = (int)this.addIndex(keyDescArray[i2], oSFile, bl, printStream);
                if (n4 > 0) {
                    this.dictInfo.di_nrecords = n4;
                }
                this.writeHeader(false);
            }
        }
        catch (IsamException isamException) {
            OSFile.unlink(string2);
            throw isamException;
        }
        if (this.storeDelRecords(oSFile)) {
            this.writeHeader(false);
        }
        oSFile2.close();
        OSFile.unlink(string);
        this.fdIndex.close();
        oSFile2 = this.fdIndex;
        OSFile.rename(string2, string);
        this.fdIndex.open(string, 2);
        return this.fdIndex;
    }

    @Override
    int getVersion() {
        return 1;
    }

    @Override
    int getFirstNodeAddr() {
        return this.headerSize;
    }
}

