/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.as;

import com.iscobol.as.ClientThread;
import com.iscobol.as.IDESettings;
import com.iscobol.as.Login;
import com.iscobol.as.UserData;
import com.iscobol.interfaces.runtime.IIDESettings;
import com.iscobol.rpc.dualrpc.common.CallException;
import com.iscobol.rpc.dualrpc.server.AbstractServerRpcHandler;
import com.iscobol.rpc.dualrpc.server.DualRpcServerDispatcher;
import com.iscobol.rts.Auth;
import com.iscobol.rts.Config;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.RtsUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class IDEHandler
extends AbstractServerRpcHandler {
    private static final String SETTINGS_FILE_NAME = "ide_configuration";
    public static final String OPTION_CHECKED = "___iscobol.option.true";
    public static final String OPTION_NOT_CHECKED = "___iscobol.option.false";
    private final int auth;
    private final byte[] challenge;
    private final DualRpcServerDispatcher caller;

    public IDEHandler(DualRpcServerDispatcher dualRpcServerDispatcher) {
        super(dualRpcServerDispatcher);
        dualRpcServerDispatcher.setDefaultCallTimeoutInSeconds(0);
        this.auth = Config.a("iscobol.as.authentication", 1);
        this.challenge = this.auth == 0 ? Auth.nullChallenge() : Auth.newChallenge();
        this.caller = dualRpcServerDispatcher;
    }

    public IIDESettings getConfiguration() {
        return IDEHandler.getConfigurationFile();
    }

    public void setConfiguration() {
        if (this.auth != 0) {
            this.checkLogin();
        }
        try {
            IIDESettings iIDESettings = (IIDESettings)this.caller.call("com.iscobol.gui.client.IDEClientHandler", "getNewConfiguration");
            this.setConfigurationFile(iIDESettings);
        }
        catch (CallException callException) {
            throw new IscobolRuntimeException(3, "getNewConfiguration");
        }
    }

    public String[] list(String string, boolean bl, String[] stringArray) {
        if (string == null) {
            string = ".";
        }
        FileFilter fileFilter = bl ? file -> file.isDirectory() : (stringArray != null && stringArray.length > 0 ? file -> {
            if (file.isDirectory()) {
                return true;
            }
            for (String string : stringArray) {
                if (!file.getName().endsWith("." + string)) continue;
                return true;
            }
            return false;
        } : null);
        File[] fileArray = new File(string).listFiles(fileFilter);
        String[] stringArray2 = new String[fileArray.length];
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            stringArray2[i2] = fileArray[i2].getName();
            if (!fileArray[i2].isDirectory()) continue;
            int n2 = i2;
            stringArray2[n2] = stringArray2[n2] + "/";
            if (fileArray[i2].listFiles(fileFilter).length <= 0) continue;
            int n3 = i2;
            stringArray2[n3] = stringArray2[n3] + ">";
        }
        return stringArray2;
    }

    public final boolean isIDE() {
        return true;
    }

    private void checkLogin() {
        try {
            boolean bl = false;
            while (true) {
                Object[] objectArray;
                if ((objectArray = (Object[])this.caller.call("com.iscobol.gui.client.IDEClientHandler", "login", this.challenge, (Object)bl)) == null || objectArray.length < 2 || objectArray[0] == null || objectArray[1] == null) {
                    throw new IscobolRuntimeException(146, "");
                }
                Login login = new Login();
                String string = (String)objectArray[0];
                byte[] byArray = (byte[])objectArray[1];
                UserData userData = login.checkLogin(string, byArray, this.challenge, ClientThread.AUTH_FILE);
                if (userData != null) {
                    if (userData.id != 0) {
                        throw new IscobolRuntimeException(146, "operation not permitted");
                    }
                    break;
                }
                bl = true;
            }
        }
        catch (IscobolRuntimeException iscobolRuntimeException) {
            throw iscobolRuntimeException;
        }
        catch (Exception exception) {
            throw new IscobolRuntimeException(146, "");
        }
    }

    public static IIDESettings getConfigurationFile() {
        IIDESettings iIDESettings;
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(new FileInputStream(SETTINGS_FILE_NAME));
            iIDESettings = (IIDESettings)objectInputStream.readObject();
            if (iIDESettings.getModes().get("Default") == null) {
                iIDESettings.getModes().put("Default", new LinkedHashMap());
            }
        }
        catch (Exception exception) {
            iIDESettings = IDEHandler.createAndSaveSettings();
        }
        finally {
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return iIDESettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IIDESettings createAndSaveSettings() {
        IDESettings iDESettings = new IDESettings();
        LinkedHashMap<String, Map<String, String>> linkedHashMap = new LinkedHashMap<String, Map<String, String>>();
        linkedHashMap.put("Debug", new LinkedHashMap());
        linkedHashMap.put("Release", new LinkedHashMap());
        ((Map)linkedHashMap.get("Release")).put("-smat", OPTION_CHECKED);
        ((Map)linkedHashMap.get("Debug")).put("-smat", OPTION_CHECKED);
        ((Map)linkedHashMap.get("Debug")).put("-d", OPTION_CHECKED);
        ((Map)linkedHashMap.get("Debug")).put("-dx", OPTION_CHECKED);
        LinkedHashMap<String, Map<String, String>> linkedHashMap2 = new LinkedHashMap<String, Map<String, String>>();
        linkedHashMap2.put("Run", new LinkedHashMap());
        iDESettings.setName("ide_settings");
        iDESettings.setModes(linkedHashMap);
        iDESettings.setRuntimeModes(linkedHashMap2);
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(new FileOutputStream(SETTINGS_FILE_NAME));
            objectOutputStream.writeObject(iDESettings);
        }
        catch (Exception exception) {
        }
        finally {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return iDESettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setConfigurationFile(IIDESettings iIDESettings) {
        if (iIDESettings == null) {
            return;
        }
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(new FileOutputStream(SETTINGS_FILE_NAME));
            objectOutputStream.writeObject(iIDESettings);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String[] getIscobolLibraryFiles() {
        String string2 = RtsUtil.getIscobolInstallLocation();
        ArrayList<String> arrayList = new ArrayList<String>();
        File file2 = new File(string2 + "/lib");
        if (file2.exists() && file2.isDirectory()) {
            File[] fileArray;
            for (File file3 : fileArray = file2.listFiles((file, string) -> string.endsWith(".jar") && !string.startsWith("wow"))) {
                arrayList.add(file3.getName());
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

