/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.as;

import com.iscobol.as.AbstractClientThread;
import com.iscobol.as.AppServerImpl;
import com.iscobol.as.ClientInfo;
import com.iscobol.gui.AppFactory;
import com.iscobol.rts.Config;
import com.iscobol.rts.IscobolSystem;
import java.util.logging.Logger;

public abstract class ProgramRunnerThread
extends AbstractClientThread {
    protected AppFactory af;
    protected String prog;
    protected String[] args;
    protected volatile boolean stopped;
    protected boolean stopEnabled = true;

    protected ProgramRunnerThread(ThreadGroup threadGroup, int n2, String string, String string2, int n3, String[] stringArray) {
        super(threadGroup, n2, string2, n3);
        this.getThreadGroup().setDaemon(true);
        this.prog = string;
        this.args = stringArray;
    }

    protected ProgramRunnerThread(ThreadGroup threadGroup, String string, int n2, String string2, String string3, int n3, String[] stringArray) {
        super(threadGroup, string, n2, string3, n3);
        this.getThreadGroup().setDaemon(true);
        this.prog = string2;
        this.args = stringArray;
    }

    @Override
    public ClientInfo getClientInfo() {
        ClientInfo clientInfo = super.getClientInfo();
        clientInfo.setStartProgram(this.prog);
        return clientInfo;
    }

    @Override
    public AppFactory getAppFactory() {
        return this.af;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void shutdown(Boolean[] booleanArray) {
        if (!this.stopEnabled) {
            this.stopEnabled = true;
            return;
        }
        if (this.stopped) {
            return;
        }
        ProgramRunnerThread programRunnerThread = this;
        // MONITORENTER : programRunnerThread
        if (this.stopped) {
            // MONITOREXIT : programRunnerThread
            return;
        }
        Thread thread = Thread.currentThread();
        this.stopped = true;
        ThreadGroup threadGroup = this.getThreadGroup();
        if (threadGroup != null) {
            Object[] objectArray;
            Logger logger = AppServerImpl.getLogger();
            Config config = (Config)IscobolSystem.get(this, Config.class);
            int n2 = config != null ? Config.a(config, ".as.stop_thread", -1) : -1;
            if (n2 != 0) {
                objectArray = booleanArray;
                // MONITORENTER : booleanArray
                if (booleanArray[0] == null) {
                    try {
                        booleanArray.wait(n2 < 0 ? 0L : (long)(n2 * 1000));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                // MONITOREXIT : objectArray
            }
            objectArray = new Thread[threadGroup.activeCount()];
            int n3 = threadGroup.enumerate((Thread[])objectArray);
            for (int i2 = 0; i2 < n3; ++i2) {
                Object object = objectArray[i2];
                if (object == thread) continue;
                if (n2 != 0) {
                    ((Thread)object).interrupt();
                }
                if (n2 >= 0 && ((Thread)object).isAlive()) {
                    ((Thread)object).stop();
                }
                logger.info("Thread " + i2 + " isAlive=" + ((Thread)object).isAlive());
            }
            this.closeSession();
        }
        // MONITOREXIT : programRunnerThread
    }

    protected abstract void closeSession();
}

