/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.as;

import com.iscobol.as.ServerHandler;
import com.iscobol.gui.ServerCall;
import com.iscobol.logger.Logger;
import com.iscobol.logger.LoggerFactory;
import com.iscobol.rmi.IscobolMessageSerializer;
import com.iscobol.rmi.RemoteRegistry;
import com.iscobol.rmi.client.ClientCaller;
import com.iscobol.rpc.dualrpc.client.AbstractClientRpcHandler;
import com.iscobol.rpc.dualrpc.client.DualRpcClient;
import com.iscobol.rpc.dualrpc.client.IClientCallbackHandler;
import com.iscobol.rpc.dualrpc.common.CallException;
import com.iscobol.rts.Auth;
import com.iscobol.rts.Config;
import com.iscobol.rts.Factory;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.Version;
import com.iscobol.types.CobolVar;
import com.iscobol.types.PicN;
import com.iscobol.types.PicXAnyLength;
import java.io.IOException;

public class ServerCallHandler
extends AbstractClientRpcHandler
implements IClientCallbackHandler {
    private String host;
    private String port;
    private ServerCall serverCall;
    private DualRpcClient client;
    private int sessionId;

    @Override
    public void brokenConnection() {
        Logger logger = RemoteRegistry.getClientProblemLogger();
        if (logger != null) {
            logger.info(ServerCallHandler.class.getName() + ": disconnected from " + this.host + ", port " + this.port);
        }
    }

    public static ServerCallHandler init(String string, String string2) {
        return ServerCallHandler.init(string, string2, null);
    }

    public static ServerCallHandler init(String string, String string2, String string3) {
        String string4 = Version.getCsVersion();
        try {
            String string5;
            Object object;
            ServerCallHandler serverCallHandler = new ServerCallHandler();
            while (true) {
                serverCallHandler.host = string == null || string.length() == 0 ? "localhost" : string;
                try {
                    serverCallHandler.port = Integer.parseInt(string2) <= 0 ? Integer.toString(ServerHandler.getDefaultPort()) : string2;
                }
                catch (NumberFormatException numberFormatException) {
                    serverCallHandler.port = Integer.toString(ServerHandler.getDefaultPort());
                }
                serverCallHandler.client = new DualRpcClient(string, Integer.parseInt(serverCallHandler.port));
                serverCallHandler.sessionId = RemoteRegistry.setCaller(new ClientCaller(serverCallHandler.client));
                Logger logger = LoggerFactory.get(64);
                object = LoggerFactory.get(128);
                RemoteRegistry.setClientProblemLogger(logger);
                RemoteRegistry.setClientRpcCallLogger((Logger)object);
                serverCallHandler.client.setCallbackHandler(serverCallHandler);
                serverCallHandler.client.registerClientSideHandler(serverCallHandler);
                serverCallHandler.client.setMessageSerializer(new IscobolMessageSerializer());
                if (logger != null) {
                    logger.info(ServerCallHandler.class + ": connecting to " + serverCallHandler.host + ", port " + serverCallHandler.port);
                }
                serverCallHandler.client.connect();
                string5 = (String)serverCallHandler.client.call(ServerHandler.class.getName(), "getCSVersion");
                if (string5.charAt(0) != '@') break;
                serverCallHandler.client.disconnect();
                if (string5.charAt(1) == '!') {
                    throw new IscobolRuntimeException(3, "No server available");
                }
                int n2 = string5.indexOf(58);
                if (n2 > 0) {
                    string = string5.substring(1, n2);
                    string2 = string5.substring(n2 + 1, string5.length());
                    continue;
                }
                serverCallHandler.host = string5.substring(1, string5.length());
            }
            int n3 = string5.indexOf(59);
            if (n3 >= 0) {
                string5 = string5.substring(0, n3);
            }
            if (!string4.equals(string5)) {
                System.err.println("ERROR: Client release (" + string4 + ") is incompatible with Application Server (" + string5 + ")");
            }
            object = Config.a(".user.name", System.getProperty("user.name", null));
            String string6 = Config.a(".user.passwd", "");
            int n4 = string6.length() << 1;
            PicN picN = new PicN(new byte[n4], 0, n4, null, null, "", false, false);
            picN.set(string6, false);
            PicXAnyLength picXAnyLength = Factory.getVarXAnyLength(new byte[0], 0, 0, false, null, null, null, "rand", false, false);
            byte[] byArray = (byte[])serverCallHandler.client.call(ServerHandler.class.getName(), "initServerCallSession");
            picXAnyLength.set(byArray);
            String string7 = Auth.getAlgorithmFromChallenge(picXAnyLength);
            PicXAnyLength picXAnyLength2 = new PicXAnyLength(new byte[0], 0, 0, null, null, "", false, false);
            PicXAnyLength picXAnyLength3 = new PicXAnyLength(new byte[0], 0, 0, null, null, "", false, false);
            Auth.getDigest(new CobolVar[]{picXAnyLength2, picN}, string7);
            Auth.getDigest(new CobolVar[]{picXAnyLength3, picXAnyLength, picXAnyLength2}, string7);
            byte[] byArray2 = ((CobolVar)picXAnyLength3).getMemory();
            String[] stringArray = new String[6];
            stringArray[0] = string3;
            stringArray[1] = object;
            stringArray[2] = ServerCallHandler.toHexString(byArray2);
            serverCallHandler.serverCall = (ServerCall)serverCallHandler.client.call(ServerHandler.class.getName(), "getServerCall", Version.getVersion(), new Integer(serverCallHandler.sessionId), stringArray);
            return serverCallHandler;
        }
        catch (CallException callException) {
            String[] stringArray = callException.getMessage() != null && callException.getMessage().startsWith("getCSVersion") ? new String[]{"ERROR: Client release (" + string4 + ") is incompatible with Application Server"} : callException.getMessage().split("(\\n)|(\\r\\n)");
            throw new IscobolRuntimeException(20, stringArray.length > 0 ? stringArray[0] : "");
        }
        catch (IscobolRuntimeException iscobolRuntimeException) {
            throw iscobolRuntimeException;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            String string = Integer.toHexString(byArray[i2]);
            if (string.length() < 2) {
                stringBuffer.append("0").append(string);
                continue;
            }
            if (string.length() > 2) {
                stringBuffer.append(string.substring(string.length() - 2));
                continue;
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public ServerCall getServerCall() {
        return this.serverCall;
    }

    public void shutdown() throws IOException {
        this.serverCall.shutdown();
        try {
            this.client.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RemoteRegistry.removeCaller(this.sessionId);
    }

    public final String activateLic(byte[] byArray, String string, int n2) throws IOException {
        return Config.a(byArray, string, n2);
    }
}

