/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.as;

import com.iscobol.as.AbstractClientThread;
import com.iscobol.as.AppServerImpl;
import com.iscobol.as.ClientInfo;
import com.iscobol.as.ClientInfoRC;
import com.iscobol.gui.AppFactory;
import com.iscobol.gui.ServerCall;
import com.iscobol.gui.server.ServerCallImpl;
import com.iscobol.logger.Logger;
import com.iscobol.logger.LoggerFactory;
import com.iscobol.rmi.RemoteRegistry;
import com.iscobol.rpc.dualrpc.server.DualRpcServerDispatcher;
import com.iscobol.rts.AsKill;
import com.iscobol.rts.Config;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.RuntimeEnvironmentType;
import com.iscobol.rts.RuntimeInfo;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class ServerCallMessageLoop
extends AbstractClientThread {
    private ServerCall serverCall;
    private LinkedList messageQueue = new LinkedList();
    private boolean goOn = true;
    private int clientSessionId;
    private int sessionId;
    private DualRpcServerDispatcher disp;
    private String[] clData;
    private String logOperation = "Server Call Session [Waiting]";

    public ServerCallMessageLoop(int n2, int n3, String string, int n4, String[] stringArray, DualRpcServerDispatcher dualRpcServerDispatcher) {
        super((ThreadGroup)new SCThreadGroup(n2), n2, string, n4);
        this.sessionId = n2;
        this.clientSessionId = n3;
        this.clData = stringArray;
        this.disp = dualRpcServerDispatcher;
    }

    @Override
    public String info(String string) {
        String string2 = this.logOperation + ": UserId " + this.clInfo.getUserId() + ", User=" + this.clInfo.getUserName() + ", clienthost=" + this.hostaddress;
        return string2;
    }

    public ServerCall doStart() {
        this.start();
        return this.getServerCall();
    }

    private synchronized ServerCall getServerCall() {
        if (this.serverCall == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.serverCall;
    }

    private synchronized void createServerCall() {
        this.serverCall = new ServerCallImpl(this);
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doStop() {
        this.goOn = false;
        this.interrupt();
        LinkedList linkedList = this.messageQueue;
        synchronized (linkedList) {
            this.messageQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.clInfo = new ClientInfoRC(this.hostaddress, this.id, "WAITING", this.clData, this.disp);
        IscobolSystem.set(ClientInfo.class, this.clInfo);
        RuntimeInfo.set(RuntimeEnvironmentType.REMOTE_CALL);
        this.createServerCall();
        if (this.clData != null) {
            if (this.clData.length > 1 && this.clData[1] != null) {
                Config.b(".user.name", this.clData[1]);
            }
            if (this.clData.length > 0 && this.clData[0] != null && this.clData[0].length() > 0) {
                try {
                    Config.b(this.clData[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        Logger logger = LoggerFactory.get(64);
        Logger logger2 = LoggerFactory.get(128);
        int n2 = ((SCThreadGroup)this.getThreadGroup()).id;
        RemoteRegistry.setProblemLogger(n2, logger);
        RemoteRegistry.setRpcCallLogger(n2, logger2);
        if (logger != null) {
            logger.info(ServerCallMessageLoop.class.getName() + ": accepted client connection from " + this.getRemoteHost() + " on port " + this.getRemotePort());
        }
        while (this.goOn()) {
            Runnable runnable = null;
            Object object = this.messageQueue;
            synchronized (object) {
                if (this.messageQueue.isEmpty()) {
                    try {
                        this.messageQueue.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
                try {
                    runnable = (Runnable)this.messageQueue.removeFirst();
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
            }
            if (runnable == null) continue;
            object = runnable.toString();
            this.logOperation = "Server Call Session [" + (String)object + "]";
            int n3 = ((String)object).indexOf(" (");
            if (n3 >= 0) {
                object = ((String)object).substring(0, n3);
            }
            this.clInfo.setStartProgram("Server Call Session [" + (String)object + "]");
            runnable.run();
            this.logOperation = "Server Call Session [Waiting]";
            this.clInfo.setStartProgram("Server Call Session [Waiting]");
        }
        AppServerImpl.cleanUp(n2, AppServerImpl.getLogger());
    }

    private synchronized boolean goOn() {
        return this.goOn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putMessage(Runnable runnable) {
        LinkedList linkedList = this.messageQueue;
        synchronized (linkedList) {
            this.messageQueue.addLast(runnable);
            this.messageQueue.notify();
        }
    }

    @Override
    public void shutdown(Boolean[] booleanArray) {
        if (this.goOn()) {
            this.doStop();
            AppServerImpl.kill(this.getSessionId(), 246);
        }
    }

    @Override
    public int getSessionId() {
        return this.sessionId;
    }

    public int getClientSessionId() {
        return this.clientSessionId;
    }

    @Override
    public AppFactory getAppFactory() {
        return null;
    }

    private static class SCThreadGroup
    extends ThreadGroup
    implements AsKill {
        private int id;

        SCThreadGroup(int n2) {
            super("ServerCallThreadGroup-" + n2);
            this.setDaemon(true);
            this.id = n2;
        }

        @Override
        public void kill(final int n2) {
            new Thread(){

                @Override
                public void run() {
                    AppServerImpl.kill(id, n2);
                }
            }.start();
        }
    }
}

