/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.as;

import com.iscobol.as.AppServerImpl;
import com.iscobol.as.ClientThread;
import com.iscobol.as.IDEHandler;
import com.iscobol.as.Login;
import com.iscobol.gui.AppFactory;
import com.iscobol.gui.AppServer;
import com.iscobol.gui.GuiFactory;
import com.iscobol.gui.ServerCall;
import com.iscobol.interfaces.runtime.IIDESettings;
import com.iscobol.io.LockManagerHandler;
import com.iscobol.rmi.IscobolMessageSerializer;
import com.iscobol.rmi.RemoteRegistry;
import com.iscobol.rmi.Worker;
import com.iscobol.rmi.server.ServerCaller;
import com.iscobol.rpc.dualrpc.common.IRpcMessageDispatcher;
import com.iscobol.rpc.dualrpc.common.IRpcWorkerFactory;
import com.iscobol.rpc.dualrpc.server.AbstractServerRpcHandler;
import com.iscobol.rpc.dualrpc.server.DualRpcServer;
import com.iscobol.rpc.dualrpc.server.DualRpcServerDispatcher;
import com.iscobol.rpc.dualrpc.server.IServerCallbackHandler;
import com.iscobol.rpc.messageserver.common.Message;
import com.iscobol.rpc.messageserver.common.Session;
import com.iscobol.rts.Auth;
import com.iscobol.rts.Config;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.RtsUtil;
import com.iscobol.rts.RuntimeProperties;
import com.iscobol.rts.Version;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class ServerHandler
extends AbstractServerRpcHandler
implements AppServer,
IServerCallbackHandler {
    final Session session;
    protected final int sessionId;
    private static final long serialVersionUID = 10L;
    private byte[] challenge;

    public ServerHandler(DualRpcServerDispatcher dualRpcServerDispatcher) throws IOException {
        super(dualRpcServerDispatcher);
        AppServerImpl.getLogger().info("new AppServerImpl");
        this.getDispatcher().setCallbackHandler(this);
        ServerCaller serverCaller = new ServerCaller(dualRpcServerDispatcher, new RemoteRegistry());
        this.sessionId = RemoteRegistry.setCaller(serverCaller);
        this.session = this.getDispatcher().getSession();
        this.session.setSessionId(this.sessionId);
    }

    @Override
    public void brokenConnection() {
        Session session = this.getDispatcher().getSession();
        com.iscobol.logger.Logger logger = RemoteRegistry.getProblemLogger(session.getSessionId());
        if (logger != null) {
            logger.info(ServerHandler.class.getName() + ": closed client connection from " + session.getRemoteHost() + " on port " + session.getRemotePort());
        }
        ServerCaller serverCaller = (ServerCaller)RemoteRegistry.removeCaller(session.getSessionId());
        serverCaller.getRegistry().clear();
        session.closeSession();
        this.kill(this.sessionId, 253);
        if (logger != null) {
            logger.close();
        }
    }

    @Override
    public void info() throws IOException {
        AppServerImpl.info();
    }

    @Override
    public void kill(int n2, int n3) {
        AppServerImpl.kill(n2, n3);
    }

    public void cleanUp(int n2, Logger logger) {
        AppServerImpl.cleanUp(n2, logger);
    }

    @Override
    public void finalize() throws Throwable {
        super.finalize();
    }

    @Override
    public void unexport() {
    }

    public String getRemoteHost() {
        try {
            return this.getDispatcher().getSession().getRemoteHost();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public int getRemotePort() {
        try {
            return this.getDispatcher().getSession().getRemotePort();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @Override
    public String getCsVersion() throws IOException {
        return this.getCSVersion();
    }

    @Override
    public String getCSVersion() throws IOException {
        this.check();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Version.getCsVersion());
        String string = Config.a("iscobol.as.clientupdate.site", (String)null);
        if (string != null) {
            File file;
            stringBuffer.append(";");
            stringBuffer.append(string);
            String string2 = RuntimeProperties.getShortBuildNumber();
            stringBuffer.append(";");
            stringBuffer.append(Config.a("iscobol.as.clientupdate.version", string2));
            String string3 = Config.a("iscobol.as.clientupdate.propfile", (String)null);
            if (string3 != null && (file = new File(string3)).exists() && file.isFile() && file.canRead()) {
                Properties properties = new Properties();
                try {
                    RtsUtil.loadProperties(properties, file);
                    Enumeration<?> enumeration = properties.propertyNames();
                    while (enumeration.hasMoreElements()) {
                        String string4 = (String)enumeration.nextElement();
                        stringBuffer.append(";");
                        stringBuffer.append(string4);
                        stringBuffer.append("=");
                        stringBuffer.append(properties.getProperty(string4));
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return stringBuffer.toString();
    }

    public int getUserCount() {
        return AppServerImpl.getUserCount();
    }

    @Override
    public int start(String string, String string2, String[] stringArray, GuiFactory guiFactory) throws IOException {
        this.check();
        guiFactory.exit("ERROR: Client release is incompatible with Iscobol Application Server");
        return -1;
    }

    @Override
    public int start(String string, String string2, String[] stringArray, String string3, GuiFactory guiFactory) throws IOException {
        this.check();
        guiFactory.exit("ERROR: Client release is incompatible with Iscobol Application Server");
        return -1;
    }

    static DualRpcServer init(String string, int n2, boolean bl, Logger logger, String string2) {
        try {
            DualRpcServer dualRpcServer = new DualRpcServer(string, n2, bl, string2);
            dualRpcServer.setMaxConnections(Config.a(".as.max_connections", 512));
            dualRpcServer.setKeepAlive(Config.b(".as.keepalive", true));
            dualRpcServer.setIgnoreMaxConnectionsLimit(true);
            dualRpcServer.registerServerSideHandlerClassname(ServerHandler.class.getName());
            dualRpcServer.setRpcWorkerFactory(new IRpcWorkerFactory(){

                @Override
                public Thread getRpcWorkerThread(IRpcMessageDispatcher iRpcMessageDispatcher, Message message) {
                    ServerCaller serverCaller = (ServerCaller)RemoteRegistry.getCaller(iRpcMessageDispatcher.getSession().getSessionId());
                    return new Worker(iRpcMessageDispatcher, message, serverCaller.getRegistry());
                }
            });
            dualRpcServer.setMessageSerializer(new IscobolMessageSerializer());
            logger.info(string2 + " bound in registry");
            Class clazz = LockManagerHandler.get().theLockManager;
            logger.info("LockManager: " + (clazz == null ? "null" : LockManagerHandler.get().theLockManager.getName()));
            return dualRpcServer;
        }
        catch (Exception exception) {
            logger.severe(string2 + " err: " + exception.getMessage());
            exception.printStackTrace();
            return null;
        }
    }

    public static int getDefaultPort() {
        return 10999;
    }

    @Override
    public int start(String string, String[] stringArray, GuiFactory guiFactory) throws IOException {
        this.check();
        guiFactory.exit("ERROR: Client release is incompatible with Iscobol Application Server");
        return -1;
    }

    @Override
    public ServerCall getServerCall(String string, int n2) throws IOException {
        String[] stringArray = new String[6];
        return this.getServerCall(string, n2, stringArray);
    }

    @Override
    public ServerCall getServerCall(String string, int n2, String string2) throws IOException {
        String[] stringArray = new String[6];
        stringArray[0] = string2;
        return this.getServerCall(string, n2, stringArray);
    }

    @Override
    public ServerCall getServerCall(String string, int n2, String[] stringArray) throws IOException {
        this.check();
        int n3 = Config.a("iscobol.as.authentication", 1);
        if (n3 == 2) {
            String string2 = null;
            byte[] byArray = null;
            if (stringArray.length > 1 && stringArray[1] != null) {
                string2 = stringArray[1];
            }
            if (stringArray.length > 2 && stringArray[2] != null) {
                try {
                    byArray = ServerHandler.getBytes(stringArray[2]);
                }
                catch (NumberFormatException numberFormatException) {
                    byArray = null;
                }
            }
            Login login = new Login();
            if (string2 == null || this.challenge == null || login.checkLogin(string2, byArray, this.challenge, ClientThread.AUTH_FILE) == null) {
                throw new IscobolRuntimeException(146, string2);
            }
        }
        return AppServerImpl.getServerCall(this.getRemoteHost(), this.getRemotePort(), this.sessionId, n2, stringArray, this.getDispatcher());
    }

    private static byte[] getBytes(String string) throws NumberFormatException {
        byte[] byArray = new byte[string.length() / 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < string.length()) {
            byArray[n3] = (byte)Integer.parseInt(string.substring(n2, n2 + 2), 16);
            n2 += 2;
            ++n3;
        }
        return byArray;
    }

    private void check() throws IOException {
        if (this.getDispatcher().getSession().isMaxConnectionLimitExceeded()) {
            throw new IOException("Max number of connections reached: " + this.getDispatcher().getDualRpcServer().getMaxConnections());
        }
    }

    @Override
    public int start(String string, String[] stringArray, String string2, AppFactory appFactory) throws IOException {
        this.check();
        String[] stringArray2 = new String[6];
        stringArray2[0] = string2;
        return AppServerImpl.start(this.getRemoteHost(), this.getRemotePort(), this.session, string, stringArray, stringArray2, appFactory);
    }

    @Override
    public int start(String string, String[] stringArray, String[] stringArray2, AppFactory appFactory) throws IOException {
        this.check();
        if (string == null) {
            Object object;
            if (stringArray2.length > 0 && stringArray2[0] != null && stringArray2[0].length() > 0) {
                object = new Properties();
                try {
                    RtsUtil.loadPropertiesWithImport((Properties)object, stringArray2[0]);
                    string = ((Properties)object).getProperty("iscobol.default_program");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (string == null && AppServerImpl.defaultPrg != null) {
                string = AppServerImpl.defaultPrg;
            }
            if (string != null) {
                object = RtsUtil.parseArguments(string);
                stringArray = new String[((String[])object).length - 1];
                string = object[0];
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    stringArray[i2] = object[i2 + 1];
                }
            } else {
                appFactory.exit("Program name not specified");
                return 0;
            }
        }
        return AppServerImpl.start(this.getRemoteHost(), this.getRemotePort(), this.session, string, stringArray, stringArray2, appFactory);
    }

    public int start(String string, String string2, String string3, byte[] byArray, boolean bl, AppFactory appFactory) throws IOException {
        this.check();
        IIDESettings iIDESettings = IDEHandler.getConfigurationFile();
        if (iIDESettings != null) {
            String string4 = string2;
            Map<String, String> map = iIDESettings.getRuntimeModes().get(string3);
            if (map != null) {
                Object object;
                Object object2;
                String string5;
                map = new LinkedHashMap<String, String>(map);
                Map<String, String> map2 = iIDESettings.getModes().get("Default");
                if (map2 != null && (string5 = map2.get("iscobol.classpath")) != null) {
                    map.put("iscobol.classpath", string5);
                }
                if (byArray != null) {
                    object2 = File.createTempFile("iscobol", ".conf");
                    ((File)object2).deleteOnExit();
                    string5 = ((File)object2).getAbsolutePath();
                    object = new FileOutputStream((File)object2);
                    ((FileOutputStream)object).write(byArray);
                    ((FileOutputStream)object).close();
                } else {
                    string5 = map.get("iscobol.prog.conffile");
                }
                object2 = map.get("iscobol.prog.utilityopt");
                object = map.get("iscobol.prog.args");
                String[] stringArray = object != null ? RtsUtil.parseArguments((String)object) : new String[]{};
                String[] stringArray2 = new String[5];
                stringArray2[0] = string5;
                stringArray2[3] = "" + bl;
                stringArray2[4] = "" + "___iscobol.option.true".equals(object2);
                return AppServerImpl.start(this.getRemoteHost(), this.getRemotePort(), this.session, string, stringArray, stringArray2, map, string4, appFactory);
            }
            throw new IOException("IDE runtime mode not found: '" + string3 + "'");
        }
        throw new IOException("IDE configuration file not found");
    }

    @Override
    public byte[] initServerCallSession() throws IOException {
        int n2 = Config.a("iscobol.as.authentication", 1);
        this.challenge = n2 != 2 ? Auth.nullChallenge() : Auth.newChallenge();
        return this.challenge;
    }
}

