/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.as.fileserver;

import IT.picosoft.iiop.CorbaShutdownException;
import IT.picosoft.iiop.Principal;
import com.iscobol.as.ClientThread;
import com.iscobol.as.Login;
import com.iscobol.io.FileTypeManager;
import com.iscobol.io.IndexFile;
import com.iscobol.io.LockManagerHandler;
import com.iscobol.logger.Logger;
import com.iscobol.logger.LoggerFactory;
import com.iscobol.rts.Auth;
import com.iscobol.rts.CallOverflowException;
import com.iscobol.rts.Config;
import com.iscobol.rts.DynamicFile;
import com.iscobol.rts.Factory;
import com.iscobol.rts.HandlesManager;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IOConstants;
import com.iscobol.rts.IOUtil;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.KeyDescription;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.types.PicX;
import java.io.IOException;
import java.io.Serializable;

public class FileServerImpl
implements IOConstants,
RuntimeErrorsNumbers {
    private static final int Finput = 0;
    private static final int Foutput = 1;
    private static final int Fio = 2;
    private static final int Fextend = 3;
    private static final int Fmulti_lock = 16;
    private static final int Fread_lock = 256;
    private static final int Fwrite_lock = 512;
    private static final int Fmass_update = 1536;
    private static final int Ftrans = 16384;
    private static final int Fbulk_addition = 34304;
    private boolean connected;
    private byte[] challenge;
    private final int auth = Config.a("iscobol.as.authentication", 1);
    private static final LockManagerHandler lmh = LockManagerHandler.get();
    private final Logger log = LoggerFactory.get(8);
    private HandlesManager handles = new HandlesManager();

    public static int getFErrno(DynamicFile dynamicFile) {
        return dynamicFile.getCobErrno();
    }

    private static int getOpenMode(int n2) {
        return n2 & 0xF;
    }

    private static int getLockMode(int n2) {
        int n3 = 0;
        if ((n2 & 0x100) != 0) {
            n3 = (n2 & 0x200) != 0 ? 1 : 3;
        } else if ((n2 & 0x200) != 0) {
            n3 = 4;
        }
        if ((n2 & 0x10) != 0) {
            n3 |= 0x100;
        }
        if ((n2 & 0x600) != 0) {
            n3 |= 0x200;
        }
        if ((n2 & 0x4000) != 0) {
            n3 |= 0x800;
        }
        if ((n2 & 0x8600) != 0) {
            n3 |= 0x400;
        }
        return n3;
    }

    private DynamicFile getByHandle(Object object) {
        int n2 = (Integer)object;
        DynamicFile dynamicFile = (DynamicFile)this.handles.getObject(n2);
        if (dynamicFile == null) {
            throw new RuntimeException("Invalid handle: " + n2);
        }
        return dynamicFile;
    }

    private void returnOk(Object[] objectArray, int n2) {
        objectArray[0] = new Integer(n2);
        objectArray[1] = new Short(0);
        objectArray[2] = new Integer(0);
    }

    private void returnError(Object[] objectArray, int n2, DynamicFile dynamicFile) {
        objectArray[0] = new Integer(n2);
        if (dynamicFile != null) {
            objectArray[1] = new Short((short)FileServerImpl.getFErrno(dynamicFile));
            objectArray[2] = new Integer(FileServerImpl.getFErrno(dynamicFile));
        } else {
            objectArray[1] = new Short(134);
            objectArray[2] = new Integer(134);
        }
    }

    private boolean checkConnection(Object[] objectArray) {
        if (this.connected) {
            return false;
        }
        if (objectArray != null && objectArray.length > 2) {
            objectArray[0] = new Integer(0);
            objectArray[1] = new Short(146);
            objectArray[2] = new Integer(0);
        }
        return true;
    }

    private static DynamicFile getTheFile(String string, int[] nArray) {
        DynamicFile dynamicFile;
        if (nArray.length == 4 && nArray[2] == 0) {
            switch (nArray[3]) {
                case 4: {
                    dynamicFile = IndexFile.getDefaultDynamicFile(string, FileTypeManager.getLineSequential());
                    break;
                }
                case 2: {
                    dynamicFile = IndexFile.getDefaultDynamicFile(string, FileTypeManager.getRelative());
                    break;
                }
                default: {
                    dynamicFile = IndexFile.getDefaultDynamicFile(string, FileTypeManager.getSequential(nArray[0] != nArray[1]));
                    break;
                }
            }
        } else {
            dynamicFile = IndexFile.isIdxInConfig(string);
            if (dynamicFile == null) {
                dynamicFile = IndexFile.getDefaultDynamicFile(string, FileTypeManager.getIndex());
            }
        }
        return dynamicFile;
    }

    public void A_make(Object[] objectArray) {
        int[] nArray;
        int[] nArray2;
        int[] nArray3;
        int[] nArray4;
        int[] nArray5;
        if (this.checkConnection(objectArray)) {
            return;
        }
        String string = (String)objectArray[3];
        String string2 = (String)objectArray[4];
        if (objectArray[5] == null) {
            int[] nArray6 = new int[1];
            nArray5 = nArray6;
            nArray6[0] = 0;
        } else {
            nArray5 = nArray4 = IOUtil.csv2Int(objectArray[5].toString().getBytes());
        }
        if (objectArray[6] == null) {
            int[] nArray7 = new int[1];
            nArray3 = nArray7;
            nArray7[0] = 0;
        } else {
            nArray3 = nArray2 = IOUtil.csv2Int(objectArray[6].toString().getBytes());
        }
        if (objectArray[7] == null) {
            int[] nArray8 = new int[1];
            nArray = nArray8;
            nArray8[0] = 0;
        } else {
            nArray = IOUtil.csv2Int(objectArray[7].toString().getBytes());
        }
        int[] nArray9 = nArray;
        byte[] byArray = objectArray[8] == null ? null : ((Principal)objectArray[8]).data;
        DynamicFile dynamicFile = FileServerImpl.getTheFile(string, nArray2);
        int n2 = nArray4.length > 0 ? nArray4[0] : 0;
        int n3 = nArray4.length > 1 ? nArray4[1] : 0;
        int n4 = nArray4.length > 2 ? nArray4[2] : 0;
        int n5 = nArray4.length > 3 ? nArray4[3] : 0;
        int n6 = nArray4.length > 4 ? nArray4[4] : 0;
        int n7 = nArray2.length > 0 ? nArray2[0] : 0;
        int n8 = nArray2.length > 1 ? nArray2[1] : 0;
        int n9 = nArray2.length > 2 ? nArray2[2] : 0;
        if (byArray != null && byArray.length < 256) {
            byArray = null;
        }
        KeyDescription[] keyDescriptionArray = new KeyDescription[n9];
        int n10 = 0;
        for (int i2 = 0; i2 < n9; ++i2) {
            KeyDescription keyDescription;
            int n11 = nArray9[n10++];
            boolean bl = nArray9[n10++] == 1;
            keyDescriptionArray[i2] = keyDescription = new KeyDescription(n11, bl);
            for (int i3 = 0; i3 < n11; ++i3) {
                int n12 = nArray9[n10++];
                int n13 = nArray9[n10++];
                keyDescription.setSegment(i3, n12, n13);
            }
        }
        if (this.log != null) {
            StringBuffer stringBuffer = new StringBuffer("[FS] CREATE:");
            stringBuffer.append(string);
            stringBuffer.append(", ");
            stringBuffer.append(string2);
            stringBuffer.append(", maxRec=");
            stringBuffer.append(n7);
            stringBuffer.append(", minRec=");
            stringBuffer.append(n8);
            stringBuffer.append(", keys=");
            stringBuffer.append(objectArray[7]);
            this.log.info(stringBuffer.toString());
        }
        if (dynamicFile.build(string, string2, n2, n3, n4, n5, n6, n7, n8, keyDescriptionArray, byArray, false) != 0) {
            this.returnOk(objectArray, 1);
        } else {
            this.returnError(objectArray, 0, dynamicFile);
        }
    }

    public void B_open(Object[] objectArray) {
        int n2;
        StringBuffer stringBuffer;
        if (this.checkConnection(objectArray)) {
            return;
        }
        String string = (String)objectArray[3];
        int n3 = ((Short)objectArray[4]).intValue();
        int n4 = ((Short)objectArray[5]).intValue();
        int[] nArray = IOUtil.csv2Int(objectArray[6].toString().getBytes());
        DynamicFile dynamicFile = FileServerImpl.getTheFile(string, nArray);
        int n5 = nArray.length > 0 ? nArray[0] : 0;
        int n6 = nArray.length > 1 ? nArray[1] : 0;
        int n7 = nArray.length > 2 ? nArray[2] : 0;
        if (n7 > 0) {
            dynamicFile = lmh.get(dynamicFile);
        }
        if (this.log != null) {
            stringBuffer = new StringBuffer("[FS] OPEN:");
            stringBuffer.append(string);
            stringBuffer.append(", iomode=");
            stringBuffer.append(n3);
            stringBuffer.append(", lckmode=");
            stringBuffer.append(n4);
            stringBuffer.append(", maxRec=");
            stringBuffer.append(n5);
            stringBuffer.append(", minRec=");
            stringBuffer.append(n6);
            stringBuffer.append(", nKeys=");
            stringBuffer.append(n7);
            this.log.info(stringBuffer.toString());
        }
        if (dynamicFile.open(string, n3, n4, null, n5, n6, n7, 3, false, false) != 0) {
            n2 = this.handles.newHandle(dynamicFile);
            this.returnOk(objectArray, n2);
        } else {
            n2 = 0;
            this.returnError(objectArray, 0, dynamicFile);
        }
        if (this.log != null) {
            stringBuffer = new StringBuffer("[FS] OPEN: handle=");
            stringBuffer.append(n2);
            stringBuffer.append(", rc=");
            stringBuffer.append(objectArray[0]);
            stringBuffer.append(", errno=");
            stringBuffer.append(objectArray[1]);
            stringBuffer.append(", errio=");
            stringBuffer.append(objectArray[2]);
            this.log.info(stringBuffer.toString());
        }
    }

    public void C_close(Object[] objectArray) {
        if (this.checkConnection(objectArray)) {
            return;
        }
        DynamicFile dynamicFile = this.getByHandle(objectArray[3]);
        if (this.log != null) {
            StringBuffer stringBuffer = new StringBuffer("[FS] CLOSE: handle=");
            stringBuffer.append(objectArray[3]);
            this.log.info(stringBuffer.toString());
        }
        if (dynamicFile.close() != 0) {
            this.returnOk(objectArray, 1);
            this.handles.removeHandle((Integer)objectArray[3]);
        } else {
            this.returnError(objectArray, 0, dynamicFile);
        }
    }

    public void D_init(Object[] objectArray) {
        if (this.log != null) {
            this.log.info("[FS] INIT:");
        }
        Principal principal = (Principal)objectArray[0];
        String string = "";
        if (principal != null) {
            string = new String(principal.data);
        }
        if (!string.trim().equals("19")) {
            objectArray[0] = "";
            return;
        }
        if (this.auth != 2) {
            this.challenge = Auth.nullChallenge();
            objectArray[0] = new Principal(this.challenge);
            return;
        }
        this.challenge = Auth.newChallenge();
        objectArray[0] = new Principal(this.challenge);
    }

    public void W_login(Object[] objectArray) {
        String string = (String)objectArray[3];
        byte[] byArray = ((Principal)objectArray[4]).data;
        if (this.auth != 2) {
            this.returnOk(objectArray, 1);
            this.connected = true;
            return;
        }
        if (this.log != null) {
            this.log.info("[FS] LOGIN:" + string);
        }
        Login login = new Login();
        try {
            if (login.checkLogin(string, byArray, this.challenge, ClientThread.AUTH_FILE) == null) {
                this.checkConnection(objectArray);
                throw new IscobolRuntimeException(146, string);
            }
            this.returnOk(objectArray, 1);
            this.connected = true;
        }
        catch (IOException iOException) {
            objectArray[0] = new Integer(0);
            this.connected = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void E_exit(Object[] objectArray) {
        if (this.checkConnection(objectArray)) {
            return;
        }
        if (this.log != null) {
            this.log.info("[FS] EXIT:");
        }
        HandlesManager handlesManager = this.handles;
        synchronized (handlesManager) {
            int n2 = this.handles.length() - 1;
            while (true) {
                if (n2 <= 0) break;
                DynamicFile dynamicFile = (DynamicFile)this.handles.getObject(n2);
                if (dynamicFile != null) {
                    dynamicFile.close();
                    this.handles.removeHandle(n2);
                }
                --n2;
            }
        }
        this.connected = false;
        Factory.getCurrentMonitor().finalize();
        objectArray[0] = new Integer(1);
        throw new CorbaShutdownException();
    }

    public void F_write(Object[] objectArray) {
        int n2;
        if (this.checkConnection(objectArray)) {
            return;
        }
        DynamicFile dynamicFile = this.getByHandle(objectArray[3]);
        byte[] byArray = ((Principal)objectArray[4]).data;
        int n3 = (Integer)objectArray[5];
        boolean bl = (Boolean)objectArray[6];
        if (this.log != null) {
            StringBuffer stringBuffer = new StringBuffer("[FS] WRITE: handle=");
            stringBuffer.append(objectArray[3]);
            stringBuffer.append(", lock=");
            stringBuffer.append(bl);
            stringBuffer.append(", len=");
            stringBuffer.append(n3);
            this.log.info(stringBuffer.toString());
            if (LoggerFactory.get(32) != null) {
                stringBuffer.delete(0, stringBuffer.capacity());
                stringBuffer.append("[FS] record-data=");
                stringBuffer.append(new String(byArray));
                this.log.info(stringBuffer.toString());
            }
        }
        if ((n2 = (int)dynamicFile.write(byArray, 0, n3, bl)) != 0) {
            this.returnOk(objectArray, n2);
        } else {
            this.returnError(objectArray, 0, dynamicFile);
        }
    }

    public void G_rewrite(Object[] objectArray) {
        int n2;
        if (this.checkConnection(objectArray)) {
            return;
        }
        DynamicFile dynamicFile = this.getByHandle(objectArray[3]);
        byte[] byArray = ((Principal)objectArray[4]).data;
        int n3 = (Integer)objectArray[5];
        boolean bl = (Boolean)objectArray[6];
        if (this.log != null) {
            StringBuffer stringBuffer = new StringBuffer("[FS] REWRITE: handle=");
            stringBuffer.append(objectArray[3]);
            stringBuffer.append(", lock=");
            stringBuffer.append(bl);
            stringBuffer.append(", len=");
            stringBuffer.append(n3);
            this.log.info(stringBuffer.toString());
            if (LoggerFactory.get(32) != null) {
                stringBuffer.delete(0, stringBuffer.capacity());
                stringBuffer.append("[FS] record-data=");
                stringBuffer.append(new String(byArray));
                this.log.info(stringBuffer.toString());
            }
        }
        if ((n2 = (int)dynamicFile.rewrite(byArray, 0, n3, bl)) != 0) {
            this.returnOk(objectArray, n2);
        } else {
            this.returnError(objectArray, 0, dynamicFile);
        }
    }

    public void H_delete(Object[] objectArray) {
        int n2;
        if (this.checkConnection(objectArray)) {
            return;
        }
        DynamicFile dynamicFile = this.getByHandle(objectArray[3]);
        byte[] byArray = ((Principal)objectArray[4]).data;
        if (this.log != null) {
            StringBuffer stringBuffer = new StringBuffer("[FS] DELETE: handle=");
            stringBuffer.append(objectArray[3]);
            this.log.info(stringBuffer.toString());
        }
        if ((n2 = (int)dynamicFile.delete(byArray, 0)) != 0) {
            this.returnOk(objectArray, n2);
        } else {
            this.returnError(objectArray, 0, dynamicFile);
        }
    }

    public void I_next(Object[] objectArray) {
        int n2;
        if (this.checkConnection(objectArray)) {
            return;
        }
        DynamicFile dynamicFile = this.getByHandle(objectArray[3]);
        int n3 = (Integer)objectArray[5];
        byte[] byArray = new byte[n3];
        short s2 = (Short)objectArray[6];
        if (this.log != null) {
            StringBuffer stringBuffer = new StringBuffer("[FS] NEXT: handle=");
            stringBuffer.append(objectArray[3]);
            stringBuffer.append(", lock=");
            stringBuffer.append(s2);
            this.log.info(stringBuffer.toString());
        }
        if ((n2 = (int)dynamicFile.next(byArray, 0, s2)) != 0 || dynamicFile.getCobErrno() == 0) {
            objectArray[4] = new Principal(byArray);
            this.returnOk(objectArray, n2);
        } else {
            this.returnError(objectArray, 0, dynamicFile);
        }
    }

    public void J_previous(Object[] objectArray) {
        int n2;
        if (this.checkConnection(objectArray)) {
            return;
        }
        DynamicFile dynamicFile = this.getByHandle(objectArray[3]);
        int n3 = (Integer)objectArray[5];
        byte[] byArray = new byte[n3];
        short s2 = (Short)objectArray[6];
        if (this.log != null) {
            StringBuffer stringBuffer = new StringBuffer("[FS] PREVIOUS: handle=");
            stringBuffer.append(objectArray[3]);
            stringBuffer.append(", lock=");
            stringBuffer.append(s2);
            this.log.info(stringBuffer.toString());
        }
        if ((n2 = (int)dynamicFile.previous(byArray, 0, s2)) != 0 || dynamicFile.getCobErrno() == 0) {
            objectArray[4] = new Principal(byArray);
            this.returnOk(objectArray, n2);
        } else {
            this.returnError(objectArray, 0, dynamicFile);
        }
    }

    public void K_read(Object[] objectArray) {
        int n2;
        if (this.checkConnection(objectArray)) {
            return;
        }
        DynamicFile dynamicFile = this.getByHandle(objectArray[3]);
        byte[] byArray = ((Principal)objectArray[4]).data;
        int n3 = (Integer)objectArray[5];
        short s2 = (Short)objectArray[6];
        if (this.log != null) {
            StringBuffer stringBuffer = new StringBuffer("[FS] READ KEY: handle=");
            stringBuffer.append(objectArray[3]);
            stringBuffer.append(", lock=");
            stringBuffer.append(s2);
            this.log.info(stringBuffer.toString());
        }
        if ((n2 = (int)dynamicFile.read(byArray, 0, n3, (int)s2)) != 0) {
            this.returnOk(objectArray, n2);
        } else {
            this.returnError(objectArray, 0, dynamicFile);
        }
    }

    public void L_start(Object[] objectArray) {
        int n2;
        if (this.checkConnection(objectArray)) {
            return;
        }
        DynamicFile dynamicFile = this.getByHandle(objectArray[3]);
        byte[] byArray = ((Principal)objectArray[4]).data;
        int n3 = (Integer)objectArray[5];
        int n4 = (Integer)objectArray[6];
        short s2 = (Short)objectArray[7];
        if (this.log != null) {
            StringBuffer stringBuffer = new StringBuffer("[FS] START: handle=");
            stringBuffer.append(objectArray[3]);
            stringBuffer.append(", mode=");
            stringBuffer.append(s2);
            stringBuffer.append(", keyNum=");
            stringBuffer.append(n3);
            stringBuffer.append(", keySize=");
            stringBuffer.append(n4);
            this.log.info(stringBuffer.toString());
        }
        if ((n2 = (int)dynamicFile.start(byArray, 0, n3, n4, (int)s2)) != 0) {
            this.returnOk(objectArray, n2);
        } else {
            this.returnError(objectArray, 0, dynamicFile);
        }
    }

    public void M_unlock(Object[] objectArray) {
        int n2;
        if (this.checkConnection(objectArray)) {
            return;
        }
        DynamicFile dynamicFile = this.getByHandle(objectArray[3]);
        if (this.log != null) {
            StringBuffer stringBuffer = new StringBuffer("[FS] UNLOCK: handle=");
            stringBuffer.append(objectArray[3]);
            this.log.info(stringBuffer.toString());
        }
        if ((n2 = dynamicFile.unlock()) != 0) {
            this.returnOk(objectArray, n2);
        } else {
            this.returnError(objectArray, 0, dynamicFile);
        }
    }

    public void N_sync(Object[] objectArray) {
        if (this.checkConnection(objectArray)) {
            return;
        }
        int n2 = (Integer)objectArray[3];
        if (this.log != null) {
            StringBuffer stringBuffer = new StringBuffer("[FS] SYNC: allFiles=");
            stringBuffer.append(n2);
            this.log.info(stringBuffer.toString());
        }
        IndexFile.sync(n2);
        this.returnOk(objectArray, 1);
    }

    public void O_remove(Object[] objectArray) {
        int n2;
        if (this.checkConnection(objectArray)) {
            return;
        }
        String string = (String)objectArray[3];
        DynamicFile dynamicFile = IndexFile.getDefaultDynamicFile(string, FileTypeManager.getIndex());
        if (this.log != null) {
            StringBuffer stringBuffer = new StringBuffer("[FS] REMOVE: name=");
            stringBuffer.append(string);
            this.log.info(stringBuffer.toString());
        }
        if ((n2 = dynamicFile.remove(string)) != 0) {
            this.returnOk(objectArray, n2);
        } else {
            this.returnError(objectArray, 0, dynamicFile);
        }
    }

    public void O_removeEx(Object[] objectArray) {
        int n2;
        if (this.checkConnection(objectArray)) {
            return;
        }
        int[] nArray = IOUtil.csv2Int(objectArray[3].toString().getBytes());
        String string = (String)objectArray[4];
        DynamicFile dynamicFile = FileServerImpl.getTheFile(string, nArray);
        if (this.log != null) {
            StringBuffer stringBuffer = new StringBuffer("[FS] REMOVE: name=");
            stringBuffer.append(string);
            this.log.info(stringBuffer.toString());
        }
        if ((n2 = dynamicFile.remove(string)) != 0) {
            this.returnOk(objectArray, n2);
        } else {
            this.returnError(objectArray, 0, dynamicFile);
        }
    }

    public void P_rename(Object[] objectArray) {
        int n2;
        if (this.checkConnection(objectArray)) {
            return;
        }
        String string = (String)objectArray[3];
        String string2 = (String)objectArray[4];
        DynamicFile dynamicFile = IndexFile.getDefaultDynamicFile(string, FileTypeManager.getIndex());
        if (this.log != null) {
            StringBuffer stringBuffer = new StringBuffer("[FS] RENAME: source=");
            stringBuffer.append(string);
            stringBuffer.append(", destination=");
            stringBuffer.append(string2);
            this.log.info(stringBuffer.toString());
        }
        if ((n2 = dynamicFile.rename(string, string2)) != 0) {
            this.returnOk(objectArray, n2);
        } else {
            this.returnError(objectArray, 0, dynamicFile);
        }
    }

    public void P_renameEx(Object[] objectArray) {
        int n2;
        if (this.checkConnection(objectArray)) {
            return;
        }
        int[] nArray = IOUtil.csv2Int(objectArray[3].toString().getBytes());
        String string = (String)objectArray[4];
        String string2 = (String)objectArray[5];
        DynamicFile dynamicFile = FileServerImpl.getTheFile(string, nArray);
        if (this.log != null) {
            StringBuffer stringBuffer = new StringBuffer("[FS] RENAME: source=");
            stringBuffer.append(string);
            stringBuffer.append(", destination=");
            stringBuffer.append(string2);
            this.log.info(stringBuffer.toString());
        }
        if ((n2 = dynamicFile.rename(string, string2)) != 0) {
            this.returnOk(objectArray, n2);
        } else {
            this.returnError(objectArray, 0, dynamicFile);
        }
    }

    public void Q_info(Object[] objectArray) {
        Serializable serializable;
        if (this.checkConnection(objectArray)) {
            return;
        }
        DynamicFile dynamicFile = this.getByHandle(objectArray[3]);
        short s2 = ((Integer)objectArray[4]).shortValue();
        int n2 = (Integer)objectArray[6];
        byte[] byArray = new byte[n2];
        if (this.log != null) {
            serializable = new StringBuffer("[FS] INFO: handle=");
            ((StringBuffer)serializable).append(objectArray[3]);
            ((StringBuffer)serializable).append(", iomode=");
            ((StringBuffer)serializable).append(s2);
            ((StringBuffer)serializable).append(", len=");
            ((StringBuffer)serializable).append(n2);
            this.log.info(((StringBuffer)serializable).toString());
        }
        if (s2 < 0) {
            switch (s2) {
                case -1: {
                    int[] nArray = new int[]{dynamicFile.getMaxRecordSize(), dynamicFile.getMinRecordSize(), dynamicFile.getNumKeys()};
                    byte[] byArray2 = IOUtil.int2Csv(nArray, new int[]{10, 10, 3});
                    System.arraycopy(byArray2, 0, byArray, 0, Math.min(n2, byArray2.length));
                    this.returnOk(objectArray, 1);
                    break;
                }
                case -4: {
                    int[] nArray = new int[]{(int)dynamicFile.getNumRecords()};
                    byte[] byArray3 = IOUtil.int2Csv(nArray, new int[]{10});
                    System.arraycopy(byArray3, 0, byArray, 0, Math.min(n2, byArray3.length));
                    this.returnOk(objectArray, 1);
                    break;
                }
                case -5: {
                    byte[] byArray4 = dynamicFile.getSequence();
                    if (byArray4 != null) {
                        System.arraycopy(byArray4, 0, byArray, 0, Math.min(n2, byArray4.length));
                        this.returnOk(objectArray, 1);
                        break;
                    }
                    this.returnError(objectArray, 0, dynamicFile);
                    break;
                }
                default: {
                    byte[] byArray5 = new byte[]{};
                    System.arraycopy(byArray5, 0, byArray, 0, Math.min(n2, byArray5.length));
                    this.returnError(objectArray, 0, dynamicFile);
                    break;
                }
            }
        } else {
            serializable = dynamicFile.getKey(s2);
            if (serializable != null) {
                byte[] byArray6 = ((KeyDescription)serializable).toString().getBytes();
                System.arraycopy(byArray6, 0, byArray, 0, Math.min(n2, byArray6.length));
                this.returnOk(objectArray, 1);
            } else {
                this.returnError(objectArray, 0, dynamicFile);
            }
        }
        objectArray[5] = new Principal(byArray);
    }

    public void R_begin(Object[] objectArray) {
        int n2;
        if (this.checkConnection(objectArray)) {
            return;
        }
        if (this.log != null) {
            StringBuffer stringBuffer = new StringBuffer("[FS] BEGIN:");
            this.log.info(stringBuffer.toString());
        }
        if ((n2 = IndexFile.begin()) != 0) {
            this.returnOk(objectArray, n2);
        } else {
            this.returnError(objectArray, 0, null);
        }
    }

    public void S_commit(Object[] objectArray) {
        int n2;
        if (this.checkConnection(objectArray)) {
            return;
        }
        int n3 = (Integer)objectArray[3];
        if (this.log != null) {
            StringBuffer stringBuffer = new StringBuffer("[FS] COMMIT: ctx=");
            stringBuffer.append(n3);
            this.log.info(stringBuffer.toString());
        }
        if ((n2 = IndexFile.commit(n3)) != 0) {
            this.returnOk(objectArray, n2);
        } else {
            this.returnError(objectArray, 0, null);
        }
    }

    public void T_rollback(Object[] objectArray) {
        int n2;
        if (this.checkConnection(objectArray)) {
            return;
        }
        if (this.log != null) {
            StringBuffer stringBuffer = new StringBuffer("[FS] ROLLBACK:");
            this.log.info(stringBuffer.toString());
        }
        if ((n2 = IndexFile.rollback()) != 0) {
            this.returnOk(objectArray, n2);
        } else {
            this.returnError(objectArray, 0, null);
        }
    }

    public void U_recover(Object[] objectArray) {
        int n2;
        if (this.checkConnection(objectArray)) {
            return;
        }
        DynamicFile dynamicFile = this.getByHandle(objectArray[3]);
        if (this.log != null) {
            StringBuffer stringBuffer = new StringBuffer("[FS] RECOVER: handle=");
            stringBuffer.append(objectArray[3]);
            this.log.info(stringBuffer.toString());
        }
        if ((n2 = dynamicFile.recover()) != 0) {
            this.returnOk(objectArray, n2);
        } else {
            this.returnError(objectArray, 0, dynamicFile);
        }
    }

    public void V_version(Object[] objectArray) {
        if (this.checkConnection(objectArray)) {
            return;
        }
        if (this.log != null) {
            StringBuffer stringBuffer = new StringBuffer("[FS] VERSION:");
            this.log.info(stringBuffer.toString());
        }
        objectArray[0] = Config.a(".file.index.version", "version unknown");
    }

    public void X_setrec(Object[] objectArray) {
        if (this.checkConnection(objectArray)) {
            return;
        }
        DynamicFile dynamicFile = this.getByHandle(objectArray[3]);
        if (this.log != null) {
            StringBuffer stringBuffer = new StringBuffer("[FS] SETREC: handle=");
            stringBuffer.append(objectArray[3]);
            this.log.info(stringBuffer.toString());
        }
        dynamicFile.setCurrentRecord((Long)objectArray[4]);
        this.returnOk(objectArray, 1);
    }

    public void Y_getrec(Object[] objectArray) {
        if (this.checkConnection(objectArray)) {
            return;
        }
        DynamicFile dynamicFile = this.getByHandle(objectArray[3]);
        if (this.log != null) {
            StringBuffer stringBuffer = new StringBuffer("[FS] GETREC: handle=");
            stringBuffer.append(objectArray[3]);
            this.log.info(stringBuffer.toString());
        }
        objectArray[4] = new Long(dynamicFile.getCurrentRecord());
        this.returnOk(objectArray, 1);
    }

    public void Z_checkver(Object[] objectArray) {
        if (this.log != null) {
            StringBuffer stringBuffer = new StringBuffer("[FS] CHECKVER: ver=");
            stringBuffer.append(19);
            this.log.info(stringBuffer.toString());
        }
        objectArray[0] = new Integer(19);
    }

    public void a_call(Object[] objectArray) {
        Object object;
        Object[] objectArray2;
        int[] nArray;
        Object[] objectArray3;
        Object[] objectArray4;
        CharSequence charSequence;
        if (this.log != null) {
            charSequence = new StringBuffer("[FS] CALL: " + objectArray[1]);
            this.log.info(((StringBuffer)charSequence).toString());
        }
        charSequence = objectArray[1].toString();
        if (objectArray[2] != null && objectArray[2] instanceof Object[]) {
            objectArray4 = (Object[])objectArray[2];
            objectArray3 = new Object[objectArray4.length];
            nArray = new int[objectArray4.length];
            for (int i2 = 0; i2 < objectArray4.length; ++i2) {
                objectArray2 = (Object[])objectArray4[i2];
                nArray[i2] = (Integer)objectArray2[0];
                object = (Principal)objectArray2[1];
                if (nArray[i2] > 0) {
                    objectArray2[1] = object = new Principal(new byte[nArray[i2]]);
                }
                objectArray3[i2] = new PicX(((Principal)object).data, false);
            }
        } else {
            objectArray3 = null;
            objectArray4 = null;
            nArray = null;
        }
        try {
            object = Factory.call((String)charSequence, null, objectArray3);
            objectArray[0] = object instanceof ICobolVar ? new Integer(((ICobolVar)object).toint()) : new Integer(0);
        }
        catch (CallOverflowException callOverflowException) {
            objectArray[0] = new Integer(-1001);
        }
        catch (Exception exception) {
            objectArray[0] = new Integer(-1002);
        }
        if (objectArray4 != null) {
            for (int i3 = 0; i3 < objectArray4.length; ++i3) {
                if (nArray[i3] >= 0) continue;
                objectArray2 = (Object[])objectArray4[i3];
                objectArray2[1] = new Principal(null, 0, 0);
            }
        }
    }
}

