/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.as.locking;

import com.iscobol.io.LockManager;
import com.iscobol.io.LockManagerHandler;
import com.iscobol.rts.DynamicFile;
import com.iscobol.rts.IsThread;
import com.iscobol.rts.KeyDescription;
import com.iscobol.rts.KeyValue;

public class BaseLockManager
implements LockManager {
    public static final String TID_PROP = ".lock.tid";
    private DynamicFile theFile;
    private int oMode;
    private int lMode;
    private int tid;
    private LockManagerHandler.FileUnique fileId;
    private KeyDescription pKey;
    private boolean lockMulti;
    private boolean exclLock;

    @Override
    public final void init(DynamicFile dynamicFile) {
        this.theFile = dynamicFile;
        Thread thread = Thread.currentThread();
        this.tid = thread instanceof IsThread ? ((IsThread)thread).getSessionId() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int open(String string, int n2, int n3, KeyDescription[] keyDescriptionArray, int n4, int n5, int n6, int n7, boolean bl, boolean bl2) {
        int n8;
        this.oMode = n2;
        this.lMode = n3;
        if (keyDescriptionArray != null && keyDescriptionArray.length > 0) {
            this.pKey = keyDescriptionArray[0];
        }
        switch (n3 & 0xF) {
            default: {
                if ((n3 & 0x100) == 0) break;
                this.lockMulti = true;
                break;
            }
            case 1: 
            case 6: {
                this.exclLock = true;
            }
        }
        LockManagerHandler.FileUnique fileUnique = this.fileId = LockManagerHandler.getFileUnique(string, bl2);
        synchronized (fileUnique) {
            n8 = this.theFile.open(string, n2, n3, keyDescriptionArray, n4, n5, n6, n7, bl, bl2);
            if (n8 != 0) {
                if (this.exclLock) {
                    this.fileId.lock(this.tid, this.theFile, this.oMode, this.lMode, NULL_KV, 1);
                } else if (this.pKey == null) {
                    this.pKey = this.theFile.getKey(0);
                }
            }
        }
        return n8;
    }

    @Override
    public final boolean isOpen() {
        return this.theFile.isOpen();
    }

    @Override
    public final String getDescription() {
        return this.theFile.getDescription();
    }

    @Override
    public final int getCobErrno() {
        return this.theFile.getCobErrno();
    }

    @Override
    public final String getSysErrno() {
        return this.theFile.getSysErrno();
    }

    @Override
    public final String getErrMsg() {
        return this.theFile.getErrMsg();
    }

    @Override
    public int close() {
        if (!this.fileId.unlockExcl(this.theFile)) {
            this.fileId.release(this.theFile);
        }
        return this.theFile.close();
    }

    @Override
    public int build(String string, String string2, int n2, int n3, int n4, int n5, int n6, int n7, int n8, KeyDescription[] keyDescriptionArray, byte[] byArray, boolean bl) {
        return this.theFile.build(string, string2, n2, n3, n4, n5, n6, n7, n8, keyDescriptionArray, byArray, bl);
    }

    @Override
    public final int getNumKeys() {
        return this.theFile.getNumKeys();
    }

    @Override
    public final int getMaxRecordSize() {
        return this.theFile.getMaxRecordSize();
    }

    @Override
    public final int getMinRecordSize() {
        return this.theFile.getMinRecordSize();
    }

    @Override
    public final KeyDescription getKey(int n2) {
        return this.theFile.getKey(n2);
    }

    @Override
    public final byte[] getSequence() {
        return this.theFile.getSequence();
    }

    @Override
    public final long getNumRecords() {
        return this.theFile.getNumRecords();
    }

    @Override
    public final void setCurrentRecord(long l2) {
        this.theFile.setCurrentRecord(l2);
    }

    @Override
    public final long getCurrentRecord() {
        return this.theFile.getCurrentRecord();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long read(byte[] byArray, int n2, int n3, int n4) {
        long l2;
        LockManagerHandler.FileUnique fileUnique = this.fileId;
        synchronized (fileUnique) {
            if (!this.exclLock && !this.lockMulti) {
                this.fileId.release(this.theFile);
            }
            l2 = this.theFile.read(byArray, n2, n3, n4);
            if (!this.exclLock && n4 > 0) {
                KeyValue keyValue = new KeyValue(this.pKey, byArray, n2);
                if (l2 != 0L) {
                    this.fileId.lock(this.tid, this.theFile, this.oMode, this.lMode, keyValue, n4);
                }
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long read(byte[] byArray, int n2, KeyDescription keyDescription, int n3) {
        long l2;
        LockManagerHandler.FileUnique fileUnique = this.fileId;
        synchronized (fileUnique) {
            if (!this.exclLock && !this.lockMulti) {
                this.fileId.release(this.theFile);
            }
            l2 = this.theFile.read(byArray, n2, keyDescription, n3);
            if (!this.exclLock && n3 > 0) {
                KeyValue keyValue = new KeyValue(this.pKey, byArray, n2);
                if (l2 != 0L) {
                    this.fileId.lock(this.tid, this.theFile, this.oMode, this.lMode, keyValue, n3);
                }
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long next(byte[] byArray, int n2, int n3) {
        long l2;
        LockManagerHandler.FileUnique fileUnique = this.fileId;
        synchronized (fileUnique) {
            if (!this.exclLock && !this.lockMulti) {
                this.fileId.release(this.theFile);
            }
            l2 = this.theFile.next(byArray, n2, n3);
            if (!this.exclLock && n3 > 0) {
                KeyValue keyValue = new KeyValue(this.pKey, byArray, n2);
                if (l2 != 0L) {
                    this.fileId.lock(this.tid, this.theFile, this.oMode, this.lMode, keyValue, n3);
                }
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long previous(byte[] byArray, int n2, int n3) {
        long l2;
        LockManagerHandler.FileUnique fileUnique = this.fileId;
        synchronized (fileUnique) {
            if (!this.exclLock && !this.lockMulti) {
                this.fileId.release(this.theFile);
            }
            l2 = this.theFile.previous(byArray, n2, n3);
            if (!this.exclLock && n3 > 0) {
                KeyValue keyValue = new KeyValue(this.pKey, byArray, n2);
                if (l2 != 0L) {
                    this.fileId.lock(this.tid, this.theFile, this.oMode, this.lMode, keyValue, n3);
                }
            }
        }
        return l2;
    }

    @Override
    public long start(byte[] byArray, int n2, int n3, int n4, int n5) {
        return this.theFile.start(byArray, n2, n3, n4, n5);
    }

    @Override
    public long start(byte[] byArray, int n2, KeyDescription keyDescription, int n3, int n4) {
        return this.theFile.start(byArray, n2, keyDescription, n3, n4);
    }

    @Override
    public long write(byte[] byArray, int n2, int n3, boolean bl) {
        if (!this.exclLock && !this.lockMulti) {
            this.fileId.release(this.theFile);
        }
        return this.theFile.write(byArray, n2, n3, bl);
    }

    @Override
    public long rewrite(byte[] byArray, int n2, int n3, boolean bl) {
        if (!this.exclLock && !this.lockMulti) {
            this.fileId.release(this.theFile);
        }
        return this.theFile.rewrite(byArray, n2, n3, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long delete(byte[] byArray, int n2) {
        long l2;
        LockManagerHandler.FileUnique fileUnique = this.fileId;
        synchronized (fileUnique) {
            l2 = this.theFile.delete(byArray, n2);
            if (!this.exclLock) {
                KeyValue keyValue = new KeyValue(this.pKey, byArray, n2);
                if (l2 != 0L) {
                    if (this.lockMulti) {
                        this.fileId.release(this.theFile, keyValue);
                    } else {
                        this.fileId.release(this.theFile);
                    }
                }
            }
        }
        return l2;
    }

    @Override
    public int unlock() {
        this.fileId.release(this.theFile);
        return this.theFile.unlock();
    }

    @Override
    public final int remove(String string) {
        return this.theFile.remove(string);
    }

    @Override
    public final int rename(String string, String string2) {
        return this.theFile.rename(string, string2);
    }

    @Override
    public final void sync(int n2) {
        this.theFile.sync(n2);
    }

    @Override
    public final int begin() {
        return this.theFile.begin();
    }

    @Override
    public final int commit(int n2) {
        return this.theFile.commit(n2);
    }

    @Override
    public final int rollback() {
        return this.theFile.rollback();
    }

    @Override
    public final int recover() {
        return this.theFile.recover();
    }

    @Override
    public final String getVersion() {
        return this.theFile.getVersion();
    }

    @Override
    public boolean isKeySelectedByNum() {
        return this.theFile.isKeySelectedByNum();
    }
}

