/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.as.locking;

import com.iscobol.io.LockManager;
import com.iscobol.io.LockManagerHandler;
import com.iscobol.rts.Config;
import com.iscobol.rts.DynamicFile;
import com.iscobol.rts.IsThread;
import com.iscobol.rts.KeyDescription;
import com.iscobol.rts.KeyValue;
import com.iscobol.rts.RuntimeErrorsNumbers;

public class InternalLockManager
implements LockManager,
RuntimeErrorsNumbers {
    public static final KeyValue NULL_KV = new KeyValue();
    private DynamicFile theFile;
    private int oMode;
    private int lMode;
    private int tid;
    private LockManagerHandler.FileUnique fileId;
    private KeyDescription pKey;
    private boolean lockMulti;
    private boolean exclLock;
    private int cobolError;
    private LockManagerHandler.Records lockRec;
    private byte[] myBuff;
    private static final boolean readLockWait = Config.b(".file.index.lock_wait", false);
    private static final boolean readLockTest = Config.b(".file.index.read_lock_test", false);
    private static final boolean lockReadAnyhow = Config.b(".file.index.lock_read_anyhow", false);
    private static final boolean autolockAllowed = Config.b(".file.index.autolock_allowed", false);

    @Override
    public final void init(DynamicFile dynamicFile) {
        this.theFile = dynamicFile;
        Thread thread = Thread.currentThread();
        this.tid = thread instanceof IsThread ? ((IsThread)thread).getSessionId() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int open(String string, int n2, int n3, KeyDescription[] keyDescriptionArray, int n4, int n5, int n6, int n7, boolean bl, boolean bl2) {
        int n8;
        this.myBuff = new byte[n4];
        this.oMode = n2;
        int n9 = this.lMode = this.oMode == 2 || this.oMode == 6 ? 1 : n3;
        if (keyDescriptionArray != null && keyDescriptionArray.length > 0) {
            this.pKey = keyDescriptionArray[0];
        }
        switch (this.lMode & 0xF) {
            default: {
                if ((n3 & 0x100) == 0) break;
                this.lockMulti = true;
                break;
            }
            case 1: 
            case 6: {
                this.exclLock = true;
            }
        }
        LockManagerHandler.FileUnique fileUnique = this.fileId = LockManagerHandler.getFileUnique(string, bl2);
        synchronized (fileUnique) {
            if (this.exclLock) {
                if (this.fileId.tryLockExcl(this.tid, this.theFile, this.oMode, this.lMode) == null) {
                    this.lockRec = this.fileId.getLockExcl();
                    n8 = 0;
                } else {
                    this.fileId.lock(this.tid, this.theFile, this.oMode, this.lMode, NULL_KV, 1);
                    n8 = 1;
                }
            } else {
                this.lockRec = this.fileId.getLockExcl();
                n8 = this.lockRec != null ? 0 : 1;
            }
            if (n8 == 1) {
                int n10 = n3 & 0xFFFFFE00;
                this.cobolError = -1;
                n8 = this.theFile.open(string, n2, n10, keyDescriptionArray, n4, n5, n6, n7, bl, bl2);
                if (this.myBuff.length == 0 && this.theFile.getMaxRecordSize() > 0) {
                    this.myBuff = new byte[this.theFile.getMaxRecordSize()];
                }
                if (n8 == 0) {
                    if (this.exclLock) {
                        this.fileId.unlockExcl(this.theFile);
                    }
                } else {
                    this.fileId.addOpened();
                    if (this.pKey == null) {
                        this.pKey = this.theFile.getKey(0);
                    }
                }
            } else {
                this.cobolError = 113;
                n8 = 0;
            }
        }
        return n8;
    }

    @Override
    public final boolean isOpen() {
        return this.theFile.isOpen();
    }

    @Override
    public final String getDescription() {
        return this.theFile.getDescription();
    }

    @Override
    public final int getCobErrno() {
        if (this.cobolError < 0) {
            return this.theFile.getCobErrno();
        }
        return this.cobolError;
    }

    @Override
    public final String getSysErrno() {
        switch (this.cobolError) {
            default: {
                return this.theFile.getSysErrno();
            }
            case 113: {
                if (this.lockRec != null) {
                    return "" + this.lockRec.threadId;
                }
                return "0";
            }
            case 107: 
        }
        if (this.lockRec != null) {
            return "" + this.lockRec.threadId;
        }
        return "0";
    }

    @Override
    public final String getErrMsg() {
        switch (this.cobolError) {
            default: {
                return this.theFile.getErrMsg();
            }
            case 113: {
                return "File locked";
            }
            case 107: 
        }
        return "Record locked";
    }

    @Override
    public int close() {
        int n2;
        if (!this.fileId.unlockExcl(this.theFile)) {
            this.fileId.release(this.theFile);
        }
        if ((n2 = this.theFile.close()) != 0) {
            this.myBuff = null;
            this.fileId.removeOpened();
        }
        return n2;
    }

    @Override
    public int build(String string, String string2, int n2, int n3, int n4, int n5, int n6, int n7, int n8, KeyDescription[] keyDescriptionArray, byte[] byArray, boolean bl) {
        return this.theFile.build(string, string2, n2, n3, n4, n5, n6, n7, n8, keyDescriptionArray, byArray, bl);
    }

    @Override
    public final int getNumKeys() {
        return this.theFile.getNumKeys();
    }

    @Override
    public final int getMaxRecordSize() {
        return this.theFile.getMaxRecordSize();
    }

    @Override
    public final int getMinRecordSize() {
        return this.theFile.getMinRecordSize();
    }

    @Override
    public final KeyDescription getKey(int n2) {
        return this.theFile.getKey(n2);
    }

    @Override
    public final byte[] getSequence() {
        return this.theFile.getSequence();
    }

    @Override
    public final long getNumRecords() {
        return this.theFile.getNumRecords();
    }

    @Override
    public final void setCurrentRecord(long l2) {
        this.theFile.setCurrentRecord(l2);
    }

    @Override
    public final long getCurrentRecord() {
        return this.theFile.getCurrentRecord();
    }

    @Override
    public long read(byte[] byArray, int n2, int n3, int n4) {
        return this.read(byArray, n2, null, n3, n4);
    }

    @Override
    public long read(byte[] byArray, int n2, KeyDescription keyDescription, int n3) {
        return this.read(byArray, n2, keyDescription, -1, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long read(byte[] byArray, int n2, KeyDescription keyDescription, int n3, int n4) {
        long l2;
        LockManagerHandler.FileUnique fileUnique = this.fileId;
        synchronized (fileUnique) {
            this.cobolError = -1;
            if (!this.exclLock && !this.lockMulti) {
                this.fileId.release(this.theFile);
            }
            if (!this.exclLock && n4 > 0) {
                KeyValue keyValue = new KeyValue(this.pKey, byArray, n2);
                if (readLockWait) {
                    n4 = 3;
                }
                this.lockRec = this.fileId.tryLock(this.tid, this.theFile, this.oMode, this.lMode, keyValue, n4);
                if (this.lockRec == null || autolockAllowed && this.lockRec.threadId == this.tid) {
                    l2 = keyDescription == null ? this.theFile.read(byArray, n2, n3, -1) : this.theFile.read(byArray, n2, keyDescription, -1);
                    if (l2 == 0L && this.lockRec == null) {
                        this.fileId.release(this.theFile, keyValue);
                    }
                } else if (lockReadAnyhow) {
                    l2 = keyDescription == null ? this.theFile.read(byArray, n2, n3, -1) : this.theFile.read(byArray, n2, keyDescription, -1);
                    if (l2 != 0L) {
                        l2 = 0L;
                        this.cobolError = 107;
                    }
                } else {
                    l2 = 0L;
                    this.cobolError = 107;
                }
            } else {
                KeyValue keyValue;
                l2 = keyDescription == null ? this.theFile.read(byArray, n2, n3, -1) : this.theFile.read(byArray, n2, keyDescription, -1);
                if (readLockTest && l2 != 0L && n4 == 0 && this.fileId.isLocked(keyValue = new KeyValue(this.pKey, byArray, n2), this.theFile)) {
                    l2 = 0L;
                    this.cobolError = 107;
                }
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long next(byte[] byArray, int n2, int n3) {
        long l2;
        LockManagerHandler.FileUnique fileUnique = this.fileId;
        synchronized (fileUnique) {
            if (!this.exclLock && !this.lockMulti) {
                this.fileId.release(this.theFile);
            }
            if (!this.exclLock && n3 > 0 && (readLockWait || n3 == 3)) {
                do {
                    l2 = this.iNext(byArray, n2, 1);
                    if (this.cobolError != 107) continue;
                    try {
                        this.fileId.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (this.cobolError == 107);
            } else {
                l2 = this.iNext(byArray, n2, n3);
            }
        }
        return l2;
    }

    private long iNext(byte[] byArray, int n2, int n3) {
        long l2;
        this.cobolError = -1;
        if (!this.exclLock && n3 > 0) {
            l2 = lockReadAnyhow ? this.theFile.next(byArray, n2, -1) : this.theFile.next(this.myBuff, 0, -1);
            if (l2 != 0L) {
                KeyValue keyValue = lockReadAnyhow ? new KeyValue(this.pKey, byArray, n2) : new KeyValue(this.pKey, this.myBuff, 0);
                this.lockRec = this.fileId.tryLock(this.tid, this.theFile, this.oMode, this.lMode, keyValue, n3);
                if (this.lockRec == null) {
                    if (!lockReadAnyhow) {
                        System.arraycopy(this.myBuff, 0, byArray, n2, this.myBuff.length);
                    }
                } else {
                    this.theFile.previous(this.myBuff, 0, -1);
                    l2 = 0L;
                    this.cobolError = 107;
                }
            }
        } else {
            KeyValue keyValue;
            l2 = this.theFile.next(byArray, n2, -1);
            if (readLockTest && l2 != 0L && n3 == 0 && this.fileId.isLocked(keyValue = new KeyValue(this.pKey, byArray, n2), this.theFile)) {
                l2 = 0L;
                this.cobolError = 107;
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long previous(byte[] byArray, int n2, int n3) {
        long l2;
        LockManagerHandler.FileUnique fileUnique = this.fileId;
        synchronized (fileUnique) {
            if (!this.exclLock && !this.lockMulti) {
                this.fileId.release(this.theFile);
            }
            if (!this.exclLock && n3 > 0 && (readLockWait || n3 == 3)) {
                do {
                    l2 = this.iPrevious(byArray, n2, 1);
                    if (this.cobolError != 107) continue;
                    try {
                        this.fileId.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (this.cobolError == 107);
            } else {
                l2 = this.iPrevious(byArray, n2, n3);
            }
        }
        return l2;
    }

    private long iPrevious(byte[] byArray, int n2, int n3) {
        long l2;
        this.cobolError = -1;
        if (!this.exclLock && n3 > 0) {
            l2 = lockReadAnyhow ? this.theFile.previous(byArray, n2, -1) : this.theFile.previous(this.myBuff, 0, -1);
            if (l2 != 0L) {
                KeyValue keyValue = lockReadAnyhow ? new KeyValue(this.pKey, byArray, n2) : new KeyValue(this.pKey, this.myBuff, 0);
                this.lockRec = this.fileId.tryLock(this.tid, this.theFile, this.oMode, this.lMode, keyValue, n3);
                if (this.lockRec == null) {
                    if (!lockReadAnyhow) {
                        System.arraycopy(this.myBuff, 0, byArray, n2, this.myBuff.length);
                    }
                } else {
                    this.theFile.next(this.myBuff, 0, -1);
                    l2 = 0L;
                    this.cobolError = 107;
                }
            }
        } else {
            KeyValue keyValue;
            l2 = this.theFile.previous(byArray, n2, -1);
            if (readLockTest && l2 != 0L && n3 == 0 && this.fileId.isLocked(keyValue = new KeyValue(this.pKey, byArray, n2), this.theFile)) {
                l2 = 0L;
                this.cobolError = 107;
            }
        }
        return l2;
    }

    @Override
    public long start(byte[] byArray, int n2, int n3, int n4, int n5) {
        return this.theFile.start(byArray, n2, n3, n4, n5);
    }

    @Override
    public long start(byte[] byArray, int n2, KeyDescription keyDescription, int n3, int n4) {
        return this.theFile.start(byArray, n2, keyDescription, n3, n4);
    }

    @Override
    public long write(byte[] byArray, int n2, int n3, boolean bl) {
        if (!this.exclLock && !this.lockMulti) {
            this.fileId.release(this.theFile);
        }
        return this.theFile.write(byArray, n2, n3, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long rewrite(byte[] byArray, int n2, int n3, boolean bl) {
        long l2;
        LockManagerHandler.FileUnique fileUnique = this.fileId;
        synchronized (fileUnique) {
            this.cobolError = -1;
            if (!this.exclLock && !this.lockMulti) {
                this.fileId.release(this.theFile);
            }
            KeyValue keyValue = new KeyValue(this.pKey, byArray, n2);
            if (!this.exclLock && this.fileId.isLocked(keyValue, this.theFile)) {
                l2 = 0L;
                this.cobolError = 107;
            } else {
                l2 = this.theFile.rewrite(byArray, n2, n3, bl);
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long delete(byte[] byArray, int n2) {
        long l2;
        LockManagerHandler.FileUnique fileUnique = this.fileId;
        synchronized (fileUnique) {
            KeyValue keyValue = new KeyValue(this.pKey, byArray, n2);
            if (!this.exclLock && this.fileId.isLocked(keyValue, this.theFile)) {
                l2 = 0L;
                this.cobolError = 107;
            } else {
                l2 = this.theFile.delete(byArray, n2);
                if (!this.exclLock && l2 != 0L) {
                    if (this.lockMulti) {
                        this.fileId.release(this.theFile, keyValue);
                    } else {
                        this.fileId.release(this.theFile);
                    }
                }
            }
        }
        return l2;
    }

    @Override
    public int unlock() {
        this.fileId.release(this.theFile);
        return this.theFile.unlock();
    }

    @Override
    public final int remove(String string) {
        return this.theFile.remove(string);
    }

    @Override
    public final int rename(String string, String string2) {
        return this.theFile.rename(string, string2);
    }

    @Override
    public final void sync(int n2) {
        this.theFile.begin();
    }

    @Override
    public final int begin() {
        int n2 = this.theFile.begin();
        return n2;
    }

    @Override
    public final int commit(int n2) {
        int n3 = this.theFile.commit(n2);
        if (n3 != 0) {
            LockManagerHandler.release(this.tid);
        }
        return n3;
    }

    @Override
    public final int rollback() {
        int n2 = this.theFile.rollback();
        if (n2 != 0) {
            LockManagerHandler.release(this.tid);
        }
        return n2;
    }

    @Override
    public final int recover() {
        return this.theFile.recover();
    }

    @Override
    public final String getVersion() {
        return this.theFile.getVersion();
    }

    @Override
    public boolean isKeySelectedByNum() {
        return this.theFile.isKeySelectedByNum();
    }
}

