/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.as.turborun;

import com.iscobol.as.AppServerImpl;
import com.iscobol.as.turborun.TRServer;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.LinkedList;
import java.util.logging.Logger;

class SocketInputReader
extends Thread {
    private LinkedList<String> lines = new LinkedList();
    private final Socket sock;
    private final InputStream sockIn;
    private final String remoteHost;
    private final int remotePort;
    private final int id;
    Logger log;

    public SocketInputReader(Socket socket, InputStream inputStream, String string, int n2, int n3) {
        this.setName("SocketInputReader-Thread-" + n3);
        this.setDaemon(true);
        this.sock = socket;
        this.sockIn = inputStream;
        this.remoteHost = string;
        this.remotePort = n2;
        this.id = n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            String string;
            if ((string = TRServer.readLine(this.sockIn, false)) == null) {
                this.log.info("Closed client connection from " + this.remoteHost + " on port " + this.remotePort);
                try {
                    this.sock.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                break;
            }
            LinkedList<String> linkedList = this.lines;
            synchronized (linkedList) {
                this.lines.addLast(string);
                this.lines.notifyAll();
            }
        }
        AppServerImpl.kill(this.id, 253);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLine() {
        LinkedList<String> linkedList = this.lines;
        synchronized (linkedList) {
            while (this.lines.isEmpty()) {
                try {
                    this.lines.wait();
                }
                catch (InterruptedException interruptedException) {
                    return null;
                }
            }
            return this.lines.removeFirst();
        }
    }

    InputStream getSockIn() {
        return this.sockIn;
    }
}

