/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.balancer;

import com.iscobol.balancer.Config;
import com.iscobol.balancer.Server;
import com.iscobol.balancer.ServerHandler;
import com.iscobol.rmi.IscobolMessageSerializer;
import com.iscobol.rmi.RemoteRegistry;
import com.iscobol.rmi.Worker;
import com.iscobol.rmi.server.ServerCaller;
import com.iscobol.rpc.dualrpc.common.IRpcMessageDispatcher;
import com.iscobol.rpc.dualrpc.common.IRpcWorkerFactory;
import com.iscobol.rpc.dualrpc.server.DualRpcServer;
import com.iscobol.rpc.messageserver.common.Message;
import com.iscobol.rts.RuntimeProperties;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class LoadBalancer {
    private static boolean logging;
    private static Logger logger;
    private static Config config;
    private static Vector servers;
    private static int updateInterval;

    static Logger getLogger() {
        if (logger == null) {
            return LoadBalancer.newLogger();
        }
        return logger;
    }

    static Logger newLogger() {
        logger = Logger.getLogger("com.iscobol.balancer");
        logging = config.getProperty("iscobol.balancer.logging", false);
        if (logging) {
            String string = config.getProperty("iscobol.balancer.logfile", "%t/iscobol_balancer.log");
            try {
                FileHandler fileHandler = new FileHandler(string);
                logger.addHandler(fileHandler);
                fileHandler.setFormatter(new SimpleFormatter());
            }
            catch (Exception exception) {
                logger.warning("LoadBalancer :" + exception.getMessage());
            }
            logger.setLevel(Level.FINEST);
        } else {
            logger.setLevel(Level.OFF);
        }
        return logger;
    }

    private static void usage() {
        System.out.println("usage: java " + LoadBalancer.class.getName() + " [options] <properties-file>");
        System.out.println("       -help");
        System.out.println("       -port <port-number>");
        System.out.println("       -hostname <hostname>");
        System.out.println("       -force");
        System.out.println("       -v");
    }

    private static void copyright() {
        String string = System.getProperty("line.separator", "\n");
        String string2 = System.getProperty("java.version") + " " + System.getProperty("java.vendor");
        String string3 = RuntimeProperties.getFullVersionNumber();
        String string4 = RuntimeProperties.getProductCopyright();
        System.out.println(string3 + string + string4 + string + string + "Java version:    " + string2 + string + "                 " + System.getProperty("java.home"));
        System.exit(0);
    }

    public static int getDefaultPort() {
        return 10999;
    }

    public static void main(String[] stringArray) {
        Object object;
        boolean bl = false;
        int n2 = -1;
        String string = null;
        String string2 = null;
        if (stringArray.length > 0 && stringArray[0].equalsIgnoreCase("-v")) {
            LoadBalancer.copyright();
            System.exit(0);
        }
        try {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2].equalsIgnoreCase("-port")) {
                    n2 = Integer.parseInt(stringArray[++i2]);
                    continue;
                }
                if (stringArray[i2].equalsIgnoreCase("-hostname")) {
                    string = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equalsIgnoreCase("-help")) {
                    LoadBalancer.usage();
                    System.exit(0);
                    continue;
                }
                if (stringArray[i2].equalsIgnoreCase("-force")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i2].equalsIgnoreCase("-info")) continue;
                if (string2 != null) {
                    System.out.println("Command line error: " + string2 + " " + stringArray[i2]);
                    LoadBalancer.usage();
                    System.exit(0);
                    continue;
                }
                string2 = stringArray[i2];
            }
        }
        catch (Exception exception) {
            System.out.println("Command line error: " + exception);
            LoadBalancer.usage();
            System.exit(0);
        }
        if (string2 == null) {
            System.out.println("Command line error: missing properties file");
            LoadBalancer.usage();
            System.exit(0);
        }
        try {
            config = new Config(string2);
        }
        catch (IOException iOException) {
            System.out.println("Command line error: " + iOException.getMessage());
            System.exit(0);
        }
        if (n2 < 0) {
            n2 = config.getProperty("iscobol.balancer.port", LoadBalancer.getDefaultPort());
        }
        if (string == null) {
            string = config.getProperty("iscobol.balancer.hostname", null);
        }
        if (stringArray.length > 0 && stringArray[0].equalsIgnoreCase("-info")) {
            System.exit(0);
        }
        LoadBalancer.loadServersConf();
        Logger logger = LoadBalancer.getLogger();
        if (logger.getLevel() != Level.OFF) {
            object = System.getProperty("line.separator");
            StringBuffer stringBuffer = new StringBuffer("Server list: ");
            stringBuffer.append((String)object);
            for (int i3 = 0; i3 < servers.size(); ++i3) {
                stringBuffer.append("   ");
                stringBuffer.append(servers.elementAt(i3));
                stringBuffer.append((String)object);
            }
            logger.info(stringBuffer.toString());
        }
        object = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int n2 = 0;
                while (true) {
                    Vector vector;
                    try {
                        Thread.sleep(updateInterval);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Vector vector2 = vector = servers;
                    synchronized (vector2) {
                        int n3;
                        if (config.isUpdated()) {
                            LoadBalancer.loadServersConf();
                        }
                        if ((n3 = vector.size()) == 0) {
                            n2 = 0;
                        } else {
                            if (n2 >= n3) {
                                n2 = 0;
                            }
                            ((Server)vector.elementAt(n2++)).checkIsAlive();
                        }
                    }
                }
            }
        };
        ((Thread)object).setDaemon(true);
        ((Thread)object).start();
        logger.info("Starting load balancer on hostname: " + string + " with port number: " + n2);
        System.out.println("Load balancer started and listening on port " + n2);
        LoadBalancer.init(string, n2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadServersConf() {
        Vector vector = servers;
        synchronized (vector) {
            for (int i2 = servers.size() - 1; i2 > 0; --i2) {
                ((Server)servers.elementAt(i2)).finalize();
            }
            servers = new Vector();
            Logger logger = LoadBalancer.newLogger();
            Enumeration enumeration = config.propertyNames("iscobol.balancer.server.");
            int n2 = config.getProperty("iscobol.balancer.update.timeout", 60);
            while (enumeration.hasMoreElements()) {
                Server server = new Server(config.getProperty((String)enumeration.nextElement()), LoadBalancer.getDefaultPort());
                server.setTimeout(n2);
                servers.addElement(server);
            }
            updateInterval = config.getProperty("iscobol.balancer.update.interval", 60);
            updateInterval *= 1000;
        }
    }

    private static void init(String string, int n2, boolean bl) {
        try {
            DualRpcServer dualRpcServer = new DualRpcServer(string, n2, bl, "LoadBalancer");
            dualRpcServer.registerServerSideHandlerClassname(ServerHandler.class.getName());
            dualRpcServer.setRpcWorkerFactory(new IRpcWorkerFactory(){

                @Override
                public Thread getRpcWorkerThread(IRpcMessageDispatcher iRpcMessageDispatcher, Message message) {
                    ServerCaller serverCaller = (ServerCaller)RemoteRegistry.getCaller(iRpcMessageDispatcher.getSession().getSessionId());
                    return new Worker(iRpcMessageDispatcher, message, serverCaller.getRegistry());
                }
            });
            dualRpcServer.setMessageSerializer(new IscobolMessageSerializer());
            LoadBalancer.getLogger().info("LoadBalancer bound in registry");
            dualRpcServer.listen();
        }
        catch (Exception exception) {
            LoadBalancer.getLogger().severe("LoadBalancer err: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    static String getServer() {
        while (true) {
            Server server;
            if ((server = LoadBalancer.myGetServer()) == null) {
                logger.info("Not server available!");
                return "@!";
            }
            logger.info(server.toString());
            if (server.checkIsAlive()) {
                return "@" + server.getHost() + ":" + server.getPort();
            }
            LoadBalancer.getLogger().info(server.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Server myGetServer() {
        double d2 = 1.0E301;
        Server server = null;
        Vector vector = servers;
        synchronized (vector) {
            int n2 = servers.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                double d3;
                Server server2 = (Server)servers.elementAt(i2);
                if (!server2.isAlive() || !((d3 = (double)server2.getCurrUsers() / (double)server2.getConfUsers()) < d2)) continue;
                server = server2;
                d2 = d3;
                if (d2 == 0.0) break;
            }
        }
        return server;
    }

    static {
        servers = new Vector();
    }
}

