/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.balancer;

import com.iscobol.as.ServerHandler;
import com.iscobol.balancer.LoadBalancer;
import com.iscobol.rmi.IscobolMessageSerializer;
import com.iscobol.rmi.Worker;
import com.iscobol.rpc.dualrpc.client.AbstractClientRpcHandler;
import com.iscobol.rpc.dualrpc.client.DualRpcClient;
import com.iscobol.rpc.dualrpc.client.NotConnectedException;
import com.iscobol.rpc.dualrpc.common.IRpcMessageDispatcher;
import com.iscobol.rpc.dualrpc.common.IRpcWorkerFactory;
import com.iscobol.rpc.messageserver.common.Message;

public class Server
extends AbstractClientRpcHandler {
    public final int DEF_USERS = 10;
    private final String host;
    private final int port;
    private final int confUsers;
    private final String server = ServerHandler.class.getName();
    private DualRpcClient client;
    private int currUsers;
    private boolean alive;
    private Exception cause;
    private int timeout = 60;

    private static int getInt(String string, int n2) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return n2;
        }
    }

    public Server(String string, int n2) {
        int n3 = string.indexOf(58);
        int n4 = string.indexOf(44);
        if (n3 >= 0) {
            this.host = n3 == 0 ? "localhost" : string.substring(0, n3);
            if (n4 < 0) {
                this.port = Server.getInt(string.substring(n3 + 1, string.length()), n2);
                this.confUsers = 10;
            } else {
                this.port = Server.getInt(string.substring(n3 + 1, n4), n2);
                this.confUsers = Server.getInt(string.substring(n4 + 1, string.length()), 10);
            }
        } else {
            this.port = n2;
            if (n4 >= 0) {
                this.host = n4 == 0 ? "localhost" : string.substring(0, n4);
                this.confUsers = Server.getInt(string.substring(n4 + 1, string.length()), 10);
            } else {
                this.host = string.trim();
                this.confUsers = 10;
            }
        }
        this.checkIsAlive();
    }

    String getHost() {
        return this.host;
    }

    int getPort() {
        return this.port;
    }

    int getConfUsers() {
        return this.confUsers;
    }

    int getCurrUsers() {
        return this.currUsers;
    }

    boolean isAlive() {
        return this.alive;
    }

    boolean checkIsAlive() {
        block5: {
            if (this.client == null) {
                this.client = new DualRpcClient(this.host, this.port);
                this.client.setMessageSerializer(new IscobolMessageSerializer());
                this.client.setDefaultCallTimeoutInSeconds(this.timeout);
                this.client.setRpcWorkerFactory(new IRpcWorkerFactory(){

                    @Override
                    public Thread getRpcWorkerThread(IRpcMessageDispatcher iRpcMessageDispatcher, Message message) {
                        return new Worker(iRpcMessageDispatcher, message, null);
                    }
                });
            }
            try {
                if (!this.alive) {
                    this.client.connect();
                }
                Integer n2 = (Integer)this.client.call(this.server, "getUserCount");
                this.currUsers = n2;
                if (!this.alive) {
                    this.alive = true;
                    LoadBalancer.getLogger().info(this.toString());
                }
            }
            catch (Exception exception) {
                this.currUsers = -1;
                this.cause = exception;
                if (!this.alive) break block5;
                this.alive = false;
                LoadBalancer.getLogger().info(this.toString());
            }
        }
        return this.alive;
    }

    public void setTimeout(int n2) {
        this.timeout = n2;
    }

    public void finalize() {
        if (this.alive) {
            try {
                this.client.disconnect();
            }
            catch (NotConnectedException notConnectedException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append(this.host);
        stringBuffer.append(':');
        stringBuffer.append(this.port);
        stringBuffer.append(',');
        stringBuffer.append(this.confUsers);
        stringBuffer.append("] ");
        stringBuffer.append(this.alive);
        if (this.alive) {
            stringBuffer.append(" currUsers=");
            stringBuffer.append(this.currUsers);
        } else {
            stringBuffer.append(" (");
            stringBuffer.append(this.cause);
            stringBuffer.append(" )");
        }
        return stringBuffer.toString();
    }
}

