/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.balancer;

import com.iscobol.balancer.LoadBalancer;
import com.iscobol.rmi.IscobolMessageSerializer;
import com.iscobol.rmi.RemoteRegistry;
import com.iscobol.rmi.Worker;
import com.iscobol.rmi.server.ServerCaller;
import com.iscobol.rpc.dualrpc.common.IRpcMessageDispatcher;
import com.iscobol.rpc.dualrpc.common.IRpcWorkerFactory;
import com.iscobol.rpc.dualrpc.server.AbstractServerRpcHandler;
import com.iscobol.rpc.dualrpc.server.DualRpcServer;
import com.iscobol.rpc.dualrpc.server.DualRpcServerDispatcher;
import com.iscobol.rpc.dualrpc.server.IMimetic;
import com.iscobol.rpc.dualrpc.server.IServerCallbackHandler;
import com.iscobol.rpc.messageserver.common.Message;
import com.iscobol.rpc.messageserver.common.Session;
import java.io.IOException;

public class ServerHandler
extends AbstractServerRpcHandler
implements IMimetic,
IServerCallbackHandler {
    protected int sessionId;

    public static void init(String string, int n2, boolean bl) {
        try {
            DualRpcServer dualRpcServer = new DualRpcServer(string, n2, bl, "LoadBalancer");
            dualRpcServer.registerServerSideHandlerClassname(ServerHandler.class.getName());
            dualRpcServer.setRpcWorkerFactory(new IRpcWorkerFactory(){

                @Override
                public Thread getRpcWorkerThread(IRpcMessageDispatcher iRpcMessageDispatcher, Message message) {
                    ServerCaller serverCaller = (ServerCaller)RemoteRegistry.getCaller(iRpcMessageDispatcher.getSession().getSessionId());
                    return new Worker(iRpcMessageDispatcher, message, serverCaller.getRegistry());
                }
            });
            dualRpcServer.setMessageSerializer(new IscobolMessageSerializer());
            dualRpcServer.listen();
        }
        catch (Exception exception) {
            LoadBalancer.getLogger().severe("LoadBalancer err: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public ServerHandler(DualRpcServerDispatcher dualRpcServerDispatcher) throws IOException {
        super(dualRpcServerDispatcher);
        this.getDispatcher().setCallbackHandler(this);
        ServerCaller serverCaller = new ServerCaller(dualRpcServerDispatcher, new RemoteRegistry());
        this.sessionId = RemoteRegistry.setCaller(serverCaller);
        this.getDispatcher().getSession().setSessionId(this.sessionId);
    }

    @Override
    public String getFakeName() {
        return "com.iscobol.as.ServerHandler";
    }

    @Override
    public void brokenConnection() {
        Session session = this.getDispatcher().getSession();
        ServerCaller serverCaller = (ServerCaller)RemoteRegistry.removeCaller(session.getSessionId());
        serverCaller.getRegistry().clear();
        session.closeSession();
    }

    public String getCSVersion() {
        return LoadBalancer.getServer();
    }

    public String getCsVersion() {
        return LoadBalancer.getServer();
    }
}

