/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.browser.dj;

import chrriis.dj.nativeswing.NSOption;
import chrriis.dj.nativeswing.swtimpl.NativeInterface;
import chrriis.dj.nativeswing.swtimpl.components.JWebBrowser;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserCommandEvent;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserEvent;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserListener;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserNavigationEvent;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserWindowOpeningEvent;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserWindowWillOpenEvent;
import com.iscobol.gui.Constants;
import com.iscobol.gui.client.KeyboardBuffer;
import com.iscobol.gui.client.PicobolWidget;
import com.iscobol.gui.client.swing.CobolEvent;
import com.iscobol.gui.client.swing.CobolEventListener;
import com.iscobol.gui.client.swing.PicobolWebBrowser;
import com.iscobol.gui.client.swing.SearchKeyEventListener;
import com.iscobol.gui.client.swing.SwingWorker;
import java.awt.AWTEvent;
import java.awt.Component;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class DJWebBrowser
extends JWebBrowser
implements Constants,
PicobolWidget,
PicobolWebBrowser {
    private static final int[] activeBrowserCount = new int[1];
    private final String[] HTML_exts_names = new String[]{"html"};
    private boolean activated;
    private boolean selfAct;
    private Vector listeners = new Vector();
    private URL Returnurl;
    private String progress = "";
    private boolean busy;
    private URL nextURL;
    private String nextURLString;
    private String saveasfilename;
    private URL saveValue;
    private boolean nomsgbeforenavigate;
    private WebBrowserListener wblistener;

    public DJWebBrowser() {
        super(new NSOption[0]);
        this.createAndAddListener();
        DJWebBrowser.openNativeInterface();
        this.startev();
        this.setMenuBarVisible(false);
        this.setButtonBarVisible(false);
        this.setBarsVisible(false);
    }

    protected DJWebBrowser(URL uRL) {
        super(new NSOption[0]);
        this.createAndAddListener();
        DJWebBrowser.openNativeInterface();
        this.startev();
        this.setURL(uRL);
    }

    private void createAndAddListener() {
        this.wblistener = new WebBrowserListener(){

            public void commandReceived(WebBrowserCommandEvent webBrowserCommandEvent) {
            }

            public void loadingProgressChanged(WebBrowserEvent webBrowserEvent) {
                DJWebBrowser.this.busy = true;
                DJWebBrowser.this.printProgress();
            }

            public void locationChangeCanceled(WebBrowserNavigationEvent webBrowserNavigationEvent) {
                DJWebBrowser.this.busy = false;
            }

            public void locationChanged(WebBrowserNavigationEvent webBrowserNavigationEvent) {
                DJWebBrowser.this.busy = false;
                DJWebBrowser.this.nextURL = null;
                DJWebBrowser.this.nextURLString = null;
                DJWebBrowser.this.saveValue = null;
            }

            public void locationChanging(WebBrowserNavigationEvent webBrowserNavigationEvent) {
                if (!DJWebBrowser.this.nomsgbeforenavigate && DJWebBrowser.this.nextURL == null && DJWebBrowser.this.nextURLString == null) {
                    try {
                        DJWebBrowser.this.nextURL = new URL(webBrowserNavigationEvent.getNewResourceLocation());
                        DJWebBrowser.this.saveValue = DJWebBrowser.this.nextURL;
                        DJWebBrowser.this.nextURLString = null;
                    }
                    catch (MalformedURLException malformedURLException) {
                        DJWebBrowser.this.nextURL = null;
                        DJWebBrowser.this.saveValue = null;
                        DJWebBrowser.this.nextURLString = webBrowserNavigationEvent.getNewResourceLocation();
                    }
                    DJWebBrowser.this.pushEvent(16429);
                    webBrowserNavigationEvent.consume();
                } else {
                    DJWebBrowser.this.busy = true;
                    DJWebBrowser.this.pushEvent(16431);
                }
            }

            public void statusChanged(WebBrowserEvent webBrowserEvent) {
                DJWebBrowser.this.printStatusText();
            }

            public void titleChanged(WebBrowserEvent webBrowserEvent) {
                DJWebBrowser.this.printTitle();
            }

            public void windowClosing(WebBrowserEvent webBrowserEvent) {
            }

            public void windowOpening(WebBrowserWindowOpeningEvent webBrowserWindowOpeningEvent) {
            }

            public void windowWillOpen(WebBrowserWindowWillOpenEvent webBrowserWindowWillOpenEvent) {
            }
        };
        this.addWebBrowserListener(this.wblistener);
    }

    private void startev() {
        if (!NativeInterface.isEventPumpRunning()) {
            new Thread(() -> NativeInterface.runEventPump()).start();
        }
    }

    @Override
    public void destroy() {
        this.stopLoading();
        if (this.wblistener != null) {
            this.removeWebBrowserListener(this.wblistener);
            this.wblistener = null;
        }
        this.setFocusable(false);
        if (this.getWebBrowserWindow() != null) {
            this.getWebBrowserWindow().dispose();
        }
        this.disposeNativePeer(true);
        while (!this.isNativePeerDisposed()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        DJWebBrowser.closeNativeInterface();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void openNativeInterface() {
        int[] nArray = activeBrowserCount;
        synchronized (activeBrowserCount) {
            if (!NativeInterface.isOpen()) {
                NativeInterface.open();
            }
            activeBrowserCount[0] = activeBrowserCount[0] + 1;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void closeNativeInterface() {
        int[] nArray = activeBrowserCount;
        synchronized (activeBrowserCount) {
            if (activeBrowserCount[0] == 1 && NativeInterface.isOpen()) {
                NativeInterface.close();
            }
            activeBrowserCount[0] = activeBrowserCount[0] - 1;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void addCobolEventListener(CobolEventListener cobolEventListener) {
        this.listeners.addElement(cobolEventListener);
    }

    @Override
    public void removeCobolEventListener(CobolEventListener cobolEventListener) {
        this.listeners.removeElement(cobolEventListener);
    }

    @Override
    public void addSearchKeyEventListener(SearchKeyEventListener searchKeyEventListener) {
    }

    @Override
    public void removeSearchKeyEventListener(SearchKeyEventListener searchKeyEventListener) {
    }

    private void pushEvent(int n2) {
        CobolEvent cobolEvent = new CobolEvent(this, 7, n2);
        for (int i2 = this.listeners.size() - 1; i2 >= 0; --i2) {
            try {
                ((CobolEventListener)this.listeners.elementAt(i2)).cobolEvent(cobolEvent);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public String getURLString() {
        return this.nextURLString;
    }

    @Override
    public URL getURL() {
        if (this.nextURL != null) {
            return this.saveValue;
        }
        new SwingWorker(true, () -> {
            try {
                this.Returnurl = new URL(this.getResourceLocation());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }).start();
        return this.Returnurl;
    }

    @Override
    public void setURL(URL uRL) {
        if (uRL != null) {
            this.saveValue = uRL.toString().indexOf("file:") >= 0 ? null : uRL;
            new SwingWorker(true, () -> this.navigate(uRL.toString())).start();
        }
        this.nextURLString = null;
    }

    @Override
    public void setValue(String string) {
        if (string != null) {
            try {
                this.saveValue = string != null && string.indexOf("file:") >= 0 ? null : new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            new SwingWorker(true, () -> this.navigate(string)).start();
        }
        this.nextURLString = null;
    }

    @Override
    public boolean isBusy() {
        return this.busy;
    }

    @Override
    public String getProgress() {
        return this.progress;
    }

    @Override
    public void back() {
        new SwingWorker(true, () -> this.navigateBack()).start();
    }

    @Override
    public void forward() {
        new SwingWorker(true, () -> this.navigateForward()).start();
    }

    @Override
    public void refresh() {
        new SwingWorker(true, () -> {
            String string = this.getResourceLocation();
            if (string != null && !string.equals("about:blank")) {
                this.reloadPage();
            }
        }).start();
    }

    @Override
    public void stop() {
        new SwingWorker(true, () -> this.stopLoading()).start();
    }

    @Override
    public void abortOpenURL() {
        this.nextURL = null;
        this.nextURLString = null;
        this.busy = false;
        new SwingWorker(true, () -> this.stopLoading()).start();
    }

    @Override
    public void doOpenURL() {
        if (this.nextURL != null) {
            this.setURL(this.nextURL);
        } else if (this.nextURLString != null) {
            String string = this.nextURLString;
            new SwingWorker(true, () -> this.navigate(string)).start();
        }
    }

    @Override
    public void setActiveAccept(boolean bl) {
        this.activated = bl;
    }

    @Override
    public void asyncProcessEvent(AWTEvent aWTEvent) {
    }

    @Override
    public boolean getActiveAccept() {
        return this.activated;
    }

    @Override
    public void setSelfAct(boolean bl) {
        this.selfAct = bl;
    }

    @Override
    public boolean getSelfAct() {
        return this.selfAct;
    }

    private void printStatusText() {
        String string = this.getStatusText();
        if (string == null || string.length() == 0) {
            this.busy = false;
        }
        this.pushEvent(16434);
    }

    private void printTitle() {
        this.pushEvent(16435);
    }

    private void printProgress() {
        this.progress = new Integer(this.getLoadingProgress()).toString();
        this.pushEvent(16433);
    }

    @Override
    public void printContent(boolean bl) {
        new SwingWorker(true, () -> this.print(bl)).start();
    }

    @Override
    public void printNoPrompt(boolean bl) {
        new SwingWorker(true, () -> this.print(!bl)).start();
    }

    @Override
    public void saveAsNoPrompt(boolean bl) {
        this.intsaveAs(false);
    }

    @Override
    public void setFileName(String string) {
        this.saveasfilename = string;
    }

    @Override
    public void saveAs(boolean bl) {
        this.intsaveAs(bl);
    }

    private void intsaveAs(boolean bl) {
        if (!this.busy) {
            new SwingWorker(true, () -> {
                FileWriter fileWriter = null;
                File file = null;
                file = this.saveasfilename == null || bl ? this.getFileFromChooser(".", 1, this.HTML_exts_names, "HTML Files") : new File(this.saveasfilename);
                if (file != null) {
                    try {
                        fileWriter = new FileWriter(file);
                        fileWriter.write(this.getHTMLContent());
                        fileWriter.flush();
                        fileWriter.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.saveasfilename = null;
            }).start();
        }
    }

    private File getFileFromChooser(String string, int n2, String[] stringArray, String string2) {
        JFileChooser jFileChooser = new JFileChooser(string);
        jFileChooser.setDialogType(n2);
        jFileChooser.setFileFilter(new ChooserFileFilter(stringArray, string2));
        int n3 = 1;
        KeyboardBuffer.enable(null);
        n3 = jFileChooser.showSaveDialog((Component)((Object)this));
        if (n3 == 0) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    @Override
    public void setNoMsgBeforeNavigate(boolean bl) {
        this.nomsgbeforenavigate = bl;
    }

    @Override
    public void selectAll() {
    }

    @Override
    public void copySelection() {
    }

    @Override
    public String getTitle() {
        return null;
    }

    private class ChooserFileFilter
    extends FileFilter {
        private String[] arrayext;
        private String descriptor;

        public ChooserFileFilter(String[] stringArray, String string) {
            StringBuffer stringBuffer = new StringBuffer(string + " (");
            this.arrayext = stringArray;
            for (int i2 = 0; i2 < this.arrayext.length; ++i2) {
                if (i2 > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append("*." + this.arrayext[i2]);
            }
            stringBuffer.append(")");
            this.descriptor = stringBuffer.toString();
        }

        @Override
        public boolean accept(File file) {
            boolean bl = false;
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            String string2 = string.substring(string.lastIndexOf(".") + 1, string.length()).toLowerCase();
            if (string2 != null) {
                for (int i2 = 0; i2 < this.arrayext.length; ++i2) {
                    if (!string2.equals(this.arrayext[i2])) continue;
                    bl = true;
                }
            }
            return bl;
        }

        @Override
        public String getDescription() {
            return this.descriptor;
        }
    }
}

