/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.browser.fx;

import com.iscobol.gui.client.KeyboardBuffer;
import com.iscobol.gui.client.PicobolWidget;
import com.iscobol.gui.client.swing.CobolEvent;
import com.iscobol.gui.client.swing.CobolEventListener;
import com.iscobol.gui.client.swing.PicobolWebBrowser;
import com.iscobol.gui.client.swing.PopupListener;
import com.iscobol.gui.client.swing.SearchKeyEvent;
import com.iscobol.gui.client.swing.SearchKeyEventListener;
import com.iscobol.rts.FindDialog;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.embed.swing.SwingNode;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Window;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.filechooser.FileFilter;
import netscape.javascript.JSObject;

public class JFXWebBrowser
extends JPanel
implements PicobolWidget,
PicobolWebBrowser,
FindDialog.FindListener {
    private static final long serialVersionUID = 1L;
    private static Class<?> javafxPrinterJob;
    private JFXPanel jfxPanel;
    private WebView browser;
    private WebEngine webEngine;
    private ContextMenu[] contextMenu;
    private MenuItem backItem;
    private MenuItem forwardItem;
    private MenuItem copyItem;
    private boolean popupMenuEnabled = true;
    private String statusText;
    private URL url;
    private String urlString;
    private String title;
    private int progress;
    private boolean busy;
    private boolean canGoBack;
    private boolean canGoForward;
    private Vector<CobolEventListener> eventListeners = new Vector();
    private Vector<SearchKeyEventListener> searchListeners = new Vector();
    private String saveAsFilename;
    private boolean activated;
    private KeyListener keyListener;
    private KeyListener myKeyListener;
    private ChangeListener<String> locationPropListener;
    private ChangeListener<String> titlePropListener;
    private ChangeListener<Number> progressPropListener;
    private ChangeListener<Boolean> runningPropListener;
    private ChangeListener<String> messagePropListener;
    private ChangeListener<Number> historyPropListener;
    private FindDialog findDialog;

    public JFXWebBrowser() {
        super(new BorderLayout());
        this.jfxPanel = new JFXPanel();
        this.createScene();
        this.add((Component)this.jfxPanel, "Center");
        this.myKeyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (!(JFXWebBrowser.this.keyListener == null || JFXWebBrowser.this.contextMenu != null && JFXWebBrowser.this.contextMenu[0] != null && JFXWebBrowser.this.contextMenu[0].isShowing())) {
                    JFXWebBrowser.this.keyListener.keyReleased(keyEvent);
                }
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (!(JFXWebBrowser.this.keyListener == null || JFXWebBrowser.this.contextMenu != null && JFXWebBrowser.this.contextMenu[0] != null && JFXWebBrowser.this.contextMenu[0].isShowing())) {
                    JFXWebBrowser.this.keyListener.keyPressed(keyEvent);
                }
            }
        };
        super.addKeyListener(this.myKeyListener);
    }

    private void createScene() {
        Platform.runLater(() -> {
            this.browser = new WebView();
            this.webEngine = this.browser.getEngine();
            this.browser.setContextMenuEnabled(false);
            this.setCallbacks();
            Scene scene = new Scene((Parent)this.browser);
            this.jfxPanel.setScene(scene);
        });
    }

    private void find() {
        JFrame jFrame = null;
        JDialog jDialog = null;
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (container instanceof JFrame) {
                jFrame = (JFrame)container;
                break;
            }
            if (!(container instanceof JDialog)) continue;
            jDialog = (JDialog)container;
            break;
        }
        if (this.findDialog == null) {
            this.findDialog = jFrame != null ? new FindDialog(jFrame, "Find", false, false) : (jDialog != null ? new FindDialog(jDialog, "Find", false, false) : new FindDialog((JFrame)null, "Find", false, false));
            this.findDialog.setFindListener(this);
        }
        if (!this.findDialog.isVisible()) {
            this.findDialog.setLocationRelativeTo(this);
            this.findDialog.open();
            this.findDialog.toFront();
        }
    }

    private void findImpl(FindDialog.FindParam findParam) {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("find.js");
            byte[] byArray = new byte[inputStream.available()];
            inputStream.read(byArray);
            inputStream.close();
            String string = new String(byArray);
            string = string + "\nmyfind(window, \"" + findParam.toSearch + "\", " + findParam.matchCase + ", " + findParam.backSearch + ")";
            this.executeScript(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void setCallbacks() {
        Worker worker = this.webEngine.getLoadWorker();
        this.browser.setOnKeyPressed(keyEvent -> {
            boolean bl = false;
            for (SearchKeyEventListener searchKeyEventListener : this.searchListeners) {
                try {
                    bl = searchKeyEventListener.isSearchKeyEvent(new SearchKeyEvent(this, this.getKeyCodeAwt(keyEvent.getCode()), keyEvent.isShiftDown(), keyEvent.isControlDown(), keyEvent.isAltDown()));
                }
                catch (Exception exception) {}
            }
            if (bl) {
                this.find();
            } else if (keyEvent.isControlDown()) {
                switch (keyEvent.getCode()) {
                    case C: {
                        this.runInBackground(() -> this.copySelection());
                        break;
                    }
                    case ADD: 
                    case PLUS: {
                        this.browser.setZoom(this.browser.getZoom() + 0.1);
                        break;
                    }
                    case SUBTRACT: 
                    case MINUS: {
                        if (!(this.browser.getZoom() >= 0.2)) break;
                        this.browser.setZoom(this.browser.getZoom() - 0.1);
                        break;
                    }
                }
            }
        });
        this.webEngine.setOnStatusChanged(webEvent -> {
            this.statusText = webEvent.getData() != null ? (String)webEvent.getData() : "";
            this.pushEvent(16434);
        });
        this.locationPropListener = (observableValue, string, string2) -> {
            this.setURLString((String)string2);
            this.pushEvent(16431);
        };
        this.webEngine.locationProperty().addListener(this.locationPropListener);
        this.titlePropListener = (observableValue, string, string2) -> {
            this.title = string2;
            this.pushEvent(16435);
        };
        this.webEngine.titleProperty().addListener(this.titlePropListener);
        this.webEngine.setConfirmHandler(string -> {
            int n2 = JOptionPane.showConfirmDialog((Component)this.jfxPanel, string, "", 0);
            return n2 == 0;
        });
        this.webEngine.setOnAlert(webEvent -> JOptionPane.showMessageDialog((Component)this.jfxPanel, webEvent.getData(), "", 2));
        this.progressPropListener = (observableValue, number, number2) -> {
            this.progress = (int)Math.round(number2.doubleValue() * 100.0);
            this.pushEvent(16433);
        };
        worker.progressProperty().addListener(this.progressPropListener);
        this.runningPropListener = (observableValue, bl, bl2) -> {
            boolean bl3 = this.busy;
            boolean bl4 = this.busy = bl2 == Boolean.TRUE;
            if (bl3 && !this.busy) {
                this.pushEvent(16432);
            }
        };
        worker.runningProperty().addListener(this.runningPropListener);
        this.messagePropListener = (observableValue, string, string2) -> {
            this.statusText = string2;
            this.pushEvent(16434);
        };
        worker.messageProperty().addListener(this.messagePropListener);
        this.historyPropListener = (observableValue, number, number2) -> {
            int n2 = this.webEngine.getHistory().getEntries().size();
            this.canGoBack = number2.intValue() > 0;
            this.canGoForward = number2.intValue() < n2 - 1;
        };
        this.webEngine.getHistory().currentIndexProperty().addListener(this.historyPropListener);
        this.browser.setOnScroll(scrollEvent -> {
            if (scrollEvent.isControlDown()) {
                if (scrollEvent.getDeltaY() > 0.0) {
                    this.browser.setZoom(this.browser.getZoom() + 0.1);
                } else if (scrollEvent.getDeltaY() < 0.0 && this.browser.getZoom() >= 0.2) {
                    this.browser.setZoom(this.browser.getZoom() - 0.1);
                }
                scrollEvent.consume();
            }
        });
        if (this.contextMenu == null) {
            this.contextMenu = new ContextMenu[]{new ContextMenu()};
            ArrayList<MenuItem> arrayList = new ArrayList<MenuItem>();
            MenuItem menuItem = new MenuItem("Reload");
            menuItem.setOnAction(actionEvent -> this.intReload());
            arrayList.add(menuItem);
            menuItem = new SeparatorMenuItem();
            arrayList.add(menuItem);
            menuItem = new MenuItem("Back");
            menuItem.setOnAction(actionEvent -> this.intBack());
            arrayList.add(menuItem);
            this.backItem = menuItem;
            menuItem = new MenuItem("Forward");
            menuItem.setOnAction(actionEvent -> this.intForward());
            arrayList.add(menuItem);
            this.forwardItem = menuItem;
            menuItem = new SeparatorMenuItem();
            arrayList.add(menuItem);
            menuItem = new MenuItem("Copy");
            menuItem.setOnAction(actionEvent -> {
                MenuItem menuItem = (MenuItem)actionEvent.getSource();
                this.intCopySelection((String)menuItem.getUserData());
            });
            arrayList.add(menuItem);
            this.copyItem = menuItem;
            menuItem = new MenuItem("Select All");
            menuItem.setOnAction(actionEvent -> this.runInBackground(() -> this.selectAll("window")));
            arrayList.add(menuItem);
            menuItem = new SeparatorMenuItem();
            arrayList.add(menuItem);
            menuItem = new MenuItem("Find");
            menuItem.setOnAction(actionEvent -> this.find());
            arrayList.add(menuItem);
            menuItem = new SeparatorMenuItem();
            arrayList.add(menuItem);
            menuItem = new MenuItem("Print");
            menuItem.setOnAction(actionEvent -> this.print(true));
            arrayList.add(menuItem);
            menuItem = new MenuItem("Save As");
            menuItem.setOnAction(actionEvent -> this.runInBackground(() -> this.save(true)));
            arrayList.add(menuItem);
            this.contextMenu[0].getItems().addAll(arrayList);
        }
        this.browser.setOnMousePressed(mouseEvent -> {
            if (!this.popupMenuEnabled) {
                return;
            }
            if (mouseEvent.getButton() == MouseButton.SECONDARY) {
                double d2 = mouseEvent.getScreenX();
                double d3 = mouseEvent.getScreenY();
                if (this.backItem != null) {
                    this.runInBackground(() -> {
                        this.backItem.setDisable(!this.canGoBack);
                        this.forwardItem.setDisable(!this.canGoForward);
                        String string = this.getSelection("window");
                        this.copyItem.setDisable(string == null || string.length() == 0);
                        this.copyItem.setUserData((Object)string);
                    });
                }
                this.contextMenu[0].show((Node)this.browser, d2, d3);
            } else {
                this.contextMenu[0].hide();
            }
        });
    }

    private void removeCallbacks() {
        this.webEngine.locationProperty().removeListener(this.locationPropListener);
        this.webEngine.titleProperty().removeListener(this.titlePropListener);
        Worker worker = this.webEngine.getLoadWorker();
        worker.progressProperty().removeListener(this.progressPropListener);
        worker.runningProperty().removeListener(this.runningPropListener);
        worker.messageProperty().removeListener(this.messagePropListener);
        this.webEngine.getHistory().currentIndexProperty().removeListener(this.historyPropListener);
    }

    @Override
    public void addCobolEventListener(CobolEventListener cobolEventListener) {
        if (!this.eventListeners.contains(cobolEventListener)) {
            this.eventListeners.addElement(cobolEventListener);
        }
    }

    @Override
    public void removeCobolEventListener(CobolEventListener cobolEventListener) {
        this.eventListeners.removeElement(cobolEventListener);
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        if (mouseListener instanceof PopupListener) {
            PopupListener popupListener = (PopupListener)mouseListener;
            JPopupMenu jPopupMenu = popupListener.getPopupMenu();
            if (this.contextMenu == null) {
                this.contextMenu = new ContextMenu[1];
            } else {
                this.copyItem = null;
                this.forwardItem = null;
                this.backItem = null;
            }
            Platform.runLater(() -> {
                if (this.contextMenu[0] == null) {
                    this.contextMenu[0] = new ContextMenu();
                }
                this.contextMenu[0].getItems().clear();
                this.contextMenu[0].getItems().addAll(this.getItems(jPopupMenu.getComponents()));
            });
            this.popupMenuEnabled = true;
        } else {
            super.addMouseListener(mouseListener);
        }
    }

    private List<MenuItem> getItems(Component[] componentArray) {
        ArrayList<MenuItem> arrayList = new ArrayList<MenuItem>();
        for (Component component : componentArray) {
            SeparatorMenuItem separatorMenuItem;
            Object object;
            JMenuItem jMenuItem;
            if (component instanceof JMenu) {
                jMenuItem = (JMenuItem)component;
                object = new Menu(jMenuItem.getText());
                separatorMenuItem = object;
                object.getItems().addAll(this.getItems(((JMenu)component).getMenuComponents()));
            } else if (component instanceof JMenuItem) {
                jMenuItem = (JMenuItem)component;
                separatorMenuItem = new MenuItem(jMenuItem.getText());
                separatorMenuItem.setOnAction(actionEvent -> jMenuItem.getActionListeners()[0].actionPerformed(null));
            } else if (component instanceof JPopupMenu.Separator) {
                separatorMenuItem = new SeparatorMenuItem();
                jMenuItem = null;
            } else {
                separatorMenuItem = null;
                jMenuItem = null;
            }
            if (separatorMenuItem == null) continue;
            if (jMenuItem != null) {
                int n2;
                separatorMenuItem.setDisable(!jMenuItem.isEnabled());
                if (jMenuItem.getIcon() != null) {
                    object = new SwingNode();
                    object.setContent((JComponent)new JLabel(jMenuItem.getIcon()));
                    separatorMenuItem.setGraphic((Node)object);
                }
                if (jMenuItem.getMnemonic() != 0 && (object = jMenuItem.getText()) != null && (n2 = ((String)object).indexOf((char)jMenuItem.getMnemonic())) >= 0) {
                    separatorMenuItem.setMnemonicParsing(true);
                    separatorMenuItem.setText(new StringBuilder((String)object).insert(n2, '_').toString());
                }
            }
            arrayList.add((MenuItem)separatorMenuItem);
        }
        return arrayList;
    }

    @Override
    public void addSearchKeyEventListener(SearchKeyEventListener searchKeyEventListener) {
        if (!this.searchListeners.contains(searchKeyEventListener)) {
            this.searchListeners.addElement(searchKeyEventListener);
        }
    }

    @Override
    public void removeSearchKeyEventListener(SearchKeyEventListener searchKeyEventListener) {
        this.searchListeners.removeElement(searchKeyEventListener);
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public String getURLString() {
        return this.urlString;
    }

    @Override
    public void setURL(URL uRL) {
        this.url = uRL;
        this.urlString = this.url != null ? this.url.toExternalForm() : null;
        this.loadURL();
    }

    public void setURL(String string) {
        this.urlString = string;
        this.url = this.urlString != null ? JFXWebBrowser.toURL(string) : null;
        this.loadURL();
    }

    @Override
    public void setValue(String string) {
        this.setURL(string);
    }

    private void loadURL() {
        if (this.url != null) {
            String string = this.urlString;
            Platform.runLater(() -> this.webEngine.load(string));
        }
    }

    @Override
    public boolean isBusy() {
        return this.busy;
    }

    @Override
    public String getStatusText() {
        return this.statusText;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getProgress() {
        return String.valueOf(this.progress);
    }

    @Override
    public void back() {
        if (this.canGoBack) {
            Platform.runLater(() -> this.intBack());
        }
    }

    private void intBack() {
        this.webEngine.getHistory().go(-1);
    }

    @Override
    public void forward() {
        if (this.canGoForward) {
            Platform.runLater(() -> this.intForward());
        }
    }

    private void intForward() {
        this.webEngine.getHistory().go(1);
    }

    @Override
    public void refresh() {
        Platform.runLater(() -> this.intReload());
    }

    private void intReload() {
        this.webEngine.reload();
    }

    @Override
    public void stop() {
        Platform.runLater(() -> this.webEngine.getLoadWorker().cancel());
    }

    @Override
    public void abortOpenURL() {
    }

    @Override
    public void doOpenURL() {
    }

    @Override
    public void destroy() {
        super.removeKeyListener(this.myKeyListener);
        Platform.runLater(() -> this.removeCallbacks());
        this.jfxPanel.removeAll();
        if (this.findDialog != null) {
            this.findDialog.dispose();
            this.findDialog = null;
        }
    }

    @Override
    public void printContent(boolean bl) {
        this.print(true);
    }

    @Override
    public void printNoPrompt(boolean bl) {
        this.print(false);
    }

    private void print(boolean bl) {
        if (javafxPrinterJob == null) {
            return;
        }
        Platform.runLater(() -> {
            try {
                Object object = javafxPrinterJob.getMethod("createPrinterJob", new Class[0]).invoke(null, new Object[0]);
                if (object != null) {
                    boolean bl2 = true;
                    if (bl) {
                        bl2 = (Boolean)javafxPrinterJob.getMethod("showPrintDialog", Window.class).invoke(object, new Object[]{null});
                    }
                    if (bl2) {
                        this.webEngine.getClass().getMethod("print", javafxPrinterJob).invoke((Object)this.webEngine, object);
                        object.getClass().getMethod("endJob", new Class[0]).invoke(object, new Object[0]);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        });
    }

    @Override
    public void saveAs(boolean bl) {
        this.save(true);
    }

    @Override
    public void saveAsNoPrompt(boolean bl) {
        this.save(false);
    }

    private File getFileFromChooser(String string, int n2, String[] stringArray, String string2) {
        JFileChooser jFileChooser = new JFileChooser(string);
        jFileChooser.setDialogType(n2);
        class ChooserFileFilter
        extends FileFilter {
            private String[] arrayext;
            private String descriptor;

            public ChooserFileFilter(String[] stringArray, String string) {
                StringBuffer stringBuffer = new StringBuffer(string + " (");
                this.arrayext = stringArray;
                for (int i2 = 0; i2 < this.arrayext.length; ++i2) {
                    if (i2 > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append("*." + this.arrayext[i2]);
                }
                stringBuffer.append(")");
                this.descriptor = stringBuffer.toString();
            }

            @Override
            public boolean accept(File file) {
                boolean bl = false;
                if (file.isDirectory()) {
                    return true;
                }
                String string = file.getName();
                String string2 = string.substring(string.lastIndexOf(".") + 1, string.length()).toLowerCase();
                if (string2 != null) {
                    for (int i2 = 0; i2 < this.arrayext.length; ++i2) {
                        if (!string2.equals(this.arrayext[i2])) continue;
                        bl = true;
                    }
                }
                return bl;
            }

            @Override
            public String getDescription() {
                return this.descriptor;
            }
        }
        jFileChooser.setFileFilter(new ChooserFileFilter(stringArray, string2));
        int n3 = 1;
        KeyboardBuffer.enable(null);
        n3 = jFileChooser.showSaveDialog(this);
        if (n3 == 0) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    private void save(boolean bl) {
        String string = this.getContents();
        if (bl) {
            File file = this.getFileFromChooser(".", 1, new String[]{"html"}, "HTML Files");
            if (file != null) {
                this.save(file, string);
            }
        } else if (this.saveAsFilename != null) {
            this.save(new File(this.saveAsFilename), string);
        }
    }

    private void save(File file, String string) {
        try {
            PrintWriter printWriter = new PrintWriter(file);
            printWriter.write(string);
            printWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    public String getContents() {
        return (String)this.executeScript("document.documentElement.outerHTML");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeScript(String string) {
        Object[] objectArray = new Object[]{Boolean.FALSE, null};
        Platform.runLater(() -> {
            Object object = this.webEngine.executeScript(string);
            Object[] objectArray2 = objectArray;
            synchronized (objectArray) {
                objectArray[0] = Boolean.TRUE;
                objectArray[1] = object;
                objectArray.notify();
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
        });
        Object[] objectArray2 = objectArray;
        synchronized (objectArray) {
            while (objectArray[0] == Boolean.FALSE) {
                try {
                    objectArray.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return objectArray[1];
        }
    }

    @Override
    public void setFileName(String string) {
        this.saveAsFilename = string;
    }

    public String getFileName() {
        return this.saveAsFilename;
    }

    private static URL toURL(String string) {
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                return new URL("http://" + string);
            }
            catch (MalformedURLException malformedURLException2) {
                return null;
            }
        }
    }

    @Override
    public void setNoMsgBeforeNavigate(boolean bl) {
    }

    @Override
    public void setActiveAccept(boolean bl) {
        this.activated = bl;
    }

    @Override
    public boolean getActiveAccept() {
        return this.activated;
    }

    @Override
    public void setSelfAct(boolean bl) {
    }

    @Override
    public boolean getSelfAct() {
        return false;
    }

    @Override
    public void asyncProcessEvent(AWTEvent aWTEvent) {
    }

    private void setURLString(String string) {
        this.urlString = string;
        try {
            this.url = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            this.url = null;
        }
    }

    private void pushEvent(int n2) {
        CobolEvent cobolEvent = new CobolEvent(this, 7, n2);
        for (CobolEventListener cobolEventListener : this.eventListeners) {
            try {
                cobolEventListener.cobolEvent(cobolEvent);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void selectAll() {
        this.selectAll("window");
    }

    private void selectAll(String string) {
        String string2 = (String)this.executeScript(string + ".document.activeElement.tagName");
        if (string2.equalsIgnoreCase("FRAME")) {
            this.selectAll(string + ".document.activeElement.contentWindow");
            return;
        }
        JSObject jSObject = (JSObject)this.executeScript(string + ".document.activeElement");
        if (string2.equalsIgnoreCase("INPUT")) {
            this.call(jSObject, "select", new Object[0]);
        } else {
            JSObject jSObject2 = (JSObject)this.executeScript(string + ".getSelection()");
            JSObject jSObject3 = (JSObject)this.executeScript(string + ".document.createRange()");
            this.call(jSObject3, "selectNodeContents", jSObject);
            this.call(jSObject2, "removeAllRanges", new Object[0]);
            this.call(jSObject2, "addRange", jSObject3);
        }
    }

    private String getSelection(String string) {
        Integer n2;
        String string2 = (String)this.executeScript(string + ".getSelection().toString()");
        if ((string2 == null || string2.length() == 0) && (n2 = (Integer)this.executeScript(string + ".frames.length")) != null) {
            for (int i2 = 0; i2 < n2 && (string2 == null || string2.length() == 0); ++i2) {
                string2 = this.getSelection(string + ".frames[" + i2 + "]");
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object call(JSObject jSObject, String string, Object ... objectArray) {
        Object[] objectArray2 = new Object[]{Boolean.FALSE, null};
        Platform.runLater(() -> {
            Object object = jSObject.call(string, objectArray);
            Object[] objectArray3 = objectArray2;
            synchronized (objectArray2) {
                objectArray2[0] = Boolean.TRUE;
                objectArray2[1] = object;
                objectArray2.notify();
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return;
            }
        });
        Object[] objectArray3 = objectArray2;
        synchronized (objectArray2) {
            while (objectArray2[0] == Boolean.FALSE) {
                try {
                    objectArray2.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return objectArray2[1];
        }
    }

    @Override
    public void copySelection() {
        String string = this.getSelection("window");
        if (string != null && string.length() > 0) {
            this.intCopySelection(string);
        }
    }

    private void intCopySelection(String string) {
        StringSelection stringSelection = new StringSelection(string);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
    }

    @Override
    public void find(FindDialog.FindParam findParam) {
        this.runInBackground(() -> this.findImpl(findParam));
    }

    protected void runInBackground(Runnable runnable) {
        new Thread(runnable).start();
    }

    @Override
    public void addKeyListener(KeyListener keyListener) {
        this.keyListener = AWTEventMulticaster.add(this.keyListener, keyListener);
    }

    @Override
    public void removeKeyListener(KeyListener keyListener) {
        this.keyListener = AWTEventMulticaster.remove(this.keyListener, keyListener);
    }

    public int getKeyCodeAwt(KeyCode keyCode) {
        if (keyCode == KeyCode.A) {
            return 65;
        }
        if (keyCode == KeyCode.B) {
            return 66;
        }
        if (keyCode == KeyCode.C) {
            return 67;
        }
        if (keyCode == KeyCode.D) {
            return 68;
        }
        if (keyCode == KeyCode.E) {
            return 69;
        }
        if (keyCode == KeyCode.F) {
            return 70;
        }
        if (keyCode == KeyCode.G) {
            return 71;
        }
        if (keyCode == KeyCode.H) {
            return 72;
        }
        if (keyCode == KeyCode.I) {
            return 73;
        }
        if (keyCode == KeyCode.J) {
            return 74;
        }
        if (keyCode == KeyCode.K) {
            return 75;
        }
        if (keyCode == KeyCode.L) {
            return 76;
        }
        if (keyCode == KeyCode.M) {
            return 77;
        }
        if (keyCode == KeyCode.N) {
            return 78;
        }
        if (keyCode == KeyCode.O) {
            return 79;
        }
        if (keyCode == KeyCode.P) {
            return 80;
        }
        if (keyCode == KeyCode.Q) {
            return 81;
        }
        if (keyCode == KeyCode.R) {
            return 82;
        }
        if (keyCode == KeyCode.S) {
            return 83;
        }
        if (keyCode == KeyCode.T) {
            return 84;
        }
        if (keyCode == KeyCode.U) {
            return 85;
        }
        if (keyCode == KeyCode.V) {
            return 86;
        }
        if (keyCode == KeyCode.W) {
            return 87;
        }
        if (keyCode == KeyCode.X) {
            return 88;
        }
        if (keyCode == KeyCode.Y) {
            return 89;
        }
        if (keyCode == KeyCode.Z) {
            return 90;
        }
        return 0;
    }

    @Override
    public void setPopupMenuEnabled(boolean bl) {
        this.popupMenuEnabled = bl;
    }

    static {
        try {
            javafxPrinterJob = Class.forName("javafx.print.PrinterJob");
        }
        catch (ClassNotFoundException classNotFoundException) {
            javafxPrinterJob = null;
        }
        Platform.setImplicitExit((boolean)false);
    }
}

