/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.browser.jx;

import com.iscobol.gui.client.PicobolWidget;
import com.iscobol.gui.client.swing.CobolEvent;
import com.iscobol.gui.client.swing.CobolEventListener;
import com.iscobol.gui.client.swing.PicobolWebBrowser;
import com.iscobol.gui.client.swing.SearchKeyEvent;
import com.iscobol.gui.client.swing.SearchKeyEventListener;
import com.iscobol.rts.FindDialog;
import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.SavePageType;
import com.teamdev.jxbrowser.browser.callback.StartDownloadCallback;
import com.teamdev.jxbrowser.browser.callback.input.PressKeyCallback;
import com.teamdev.jxbrowser.browser.callback.input.PressMouseCallback;
import com.teamdev.jxbrowser.browser.event.StatusChanged;
import com.teamdev.jxbrowser.browser.event.TitleChanged;
import com.teamdev.jxbrowser.callback.Callback;
import com.teamdev.jxbrowser.download.Download;
import com.teamdev.jxbrowser.download.event.DownloadCanceled;
import com.teamdev.jxbrowser.download.event.DownloadFinished;
import com.teamdev.jxbrowser.download.event.DownloadInterrupted;
import com.teamdev.jxbrowser.download.event.DownloadUpdated;
import com.teamdev.jxbrowser.engine.Engine;
import com.teamdev.jxbrowser.engine.EngineOptions;
import com.teamdev.jxbrowser.engine.RenderingMode;
import com.teamdev.jxbrowser.frame.EditorCommand;
import com.teamdev.jxbrowser.frame.Frame;
import com.teamdev.jxbrowser.navigation.callback.StartNavigationCallback;
import com.teamdev.jxbrowser.navigation.event.NavigationFinished;
import com.teamdev.jxbrowser.navigation.event.NavigationRedirected;
import com.teamdev.jxbrowser.navigation.event.NavigationStarted;
import com.teamdev.jxbrowser.navigation.event.NavigationStopped;
import com.teamdev.jxbrowser.search.FindOptions;
import com.teamdev.jxbrowser.ui.MouseButton;
import com.teamdev.jxbrowser.ui.Progress;
import com.teamdev.jxbrowser.ui.event.KeyPressed;
import com.teamdev.jxbrowser.ui.event.MousePressed;
import com.teamdev.jxbrowser.view.swing.BrowserView;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class JXWebBrowser
extends JPanel
implements PicobolWidget,
PicobolWebBrowser,
FindDialog.FindListener {
    private static final long serialVersionUID = 1L;
    private Engine engine;
    private Browser browser;
    private BrowserView browserComponent;
    private URL url;
    private String beforeNavigateUrl;
    private String fileName;
    private boolean noMsgBeforeNavigate;
    private boolean startNavigationCbEnabled = true;
    private boolean activeAccept;
    private boolean selfAct;
    private String statusText;
    private String progress;
    private Map<String, String> attributes;
    private Vector<CobolEventListener> listeners = new Vector();
    private Vector<SearchKeyEventListener> searchListeners = new Vector();
    private FindDialog findDialog;

    public JXWebBrowser() {
        this((Map<String, String>)null);
    }

    public JXWebBrowser(Map<String, String> map) {
        this.attributes = map;
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        this.setLayout(new BorderLayout());
        this.createBrowser();
    }

    private void createBrowser() {
        String string;
        String string2;
        Object object;
        String string3;
        String string4;
        EngineOptions.Builder builder = EngineOptions.newBuilder((RenderingMode)RenderingMode.HARDWARE_ACCELERATED);
        String string5 = this.attributes.get("licenseKey");
        if (string5 != null) {
            builder = builder.licenseKey(string5);
            System.setProperty("jxbrowser.license.key", string5);
        }
        if ((string4 = this.attributes.get("chromiumDir")) != null) {
            builder = builder.chromiumDir(new File(string4).toPath());
        }
        if ((string3 = this.attributes.get("chromiumSwitches")) != null) {
            object = string3.split("\\,");
            int n2 = ((String[])object).length;
            for (int i2 = 0; i2 < n2; ++i2) {
                string2 = object[i2];
                builder = builder.addSwitch(string2);
            }
        }
        if ((object = this.attributes.get("dataDir")) != null) {
            builder = builder.userDataDir(new File((String)object).toPath());
        }
        if ((string = this.attributes.get("userAgent")) != null) {
            builder = builder.userAgent(string);
        }
        EngineOptions engineOptions = builder.build();
        this.engine = Engine.newInstance((EngineOptions)engineOptions);
        this.browser = this.engine.newBrowser();
        this.browserComponent = BrowserView.newInstance((Browser)this.browser);
        this.browser.set(StartDownloadCallback.class, (Callback)((StartDownloadCallback)(params, action) -> {
            File file;
            Download download = params.download();
            download.on(DownloadFinished.class, downloadFinished -> {
                this.progress = "100";
                this.pushEvent(16432);
            });
            download.on(DownloadInterrupted.class, downloadInterrupted -> {
                this.progress = "0";
                this.pushEvent(16432);
            });
            download.on(DownloadCanceled.class, downloadCanceled -> {
                this.progress = "0";
                this.pushEvent(16432);
            });
            download.on(DownloadUpdated.class, downloadUpdated -> {
                this.progress = Integer.toString(downloadUpdated.progress().isPresent() ? Math.round(((Progress)downloadUpdated.progress().get()).value()) : 0);
                this.pushEvent(16433);
            });
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setSelectedFile(new File(params.download().target().suggestedFileName()));
            if (jFileChooser.showSaveDialog(this) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                action.download(file.toPath());
            }
        }));
        this.browser.on(TitleChanged.class, titleChanged -> this.pushEvent(16435));
        this.browser.on(StatusChanged.class, statusChanged -> {
            this.statusText = statusChanged.statusText();
            this.pushEvent(16434);
        });
        string2 = this.browser.navigation();
        string2.set(StartNavigationCallback.class, (Callback)((StartNavigationCallback)params -> {
            if (!this.startNavigationCbEnabled) {
                this.startNavigationCbEnabled = true;
                return StartNavigationCallback.Response.start();
            }
            if (params.isMainFrame()) {
                if (params.url().startsWith("chrome-extension://")) {
                    return StartNavigationCallback.Response.start();
                }
                if (this.noMsgBeforeNavigate) {
                    this.pushEvent(16431);
                    return StartNavigationCallback.Response.start();
                }
                if (this.beforeNavigateUrl != null) {
                    this.beforeNavigateUrl = null;
                    return StartNavigationCallback.Response.start();
                }
                this.beforeNavigateUrl = params.url();
                this.pushEvent(16429);
                return StartNavigationCallback.Response.ignore();
            }
            return StartNavigationCallback.Response.start();
        }));
        string2.on(NavigationStarted.class, navigationStarted -> this.pushEvent(16432));
        string2.on(NavigationStopped.class, navigationStopped -> {
            this.setURL();
            this.pushEvent(16430);
        });
        string2.on(NavigationFinished.class, navigationFinished -> {
            this.setURL();
            this.pushEvent(16430);
        });
        string2.on(NavigationRedirected.class, navigationRedirected -> this.pushEvent(16432));
        this.browser.set(PressKeyCallback.class, (Callback)((PressKeyCallback)params -> {
            boolean bl = false;
            KeyPressed keyPressed = params.event();
            for (SearchKeyEventListener searchKeyEventListener : this.searchListeners) {
                try {
                    bl = searchKeyEventListener.isSearchKeyEvent(new SearchKeyEvent(this, keyPressed.keyChar(), keyPressed.keyModifiers().isShiftDown(), keyPressed.keyModifiers().isControlDown(), keyPressed.keyModifiers().isAltDown()));
                }
                catch (Exception exception) {}
            }
            if (bl) {
                SwingUtilities.invokeLater(() -> this.find());
            }
            if (keyPressed.keyModifiers().isControlDown()) {
                switch (keyPressed.keyCode()) {
                    case KEY_CODE_C: {
                        this.copySelection();
                        break;
                    }
                }
            }
            return PressKeyCallback.Response.proceed();
        }));
        if (!JPopupMenu.getDefaultLightWeightPopupEnabled()) {
            this.addPopupMenu();
        }
        this.add((Component)this.browserComponent, "Center");
    }

    private void addPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Reload");
        jMenuItem.addActionListener(actionEvent -> this.refresh());
        jPopupMenu.add(jMenuItem);
        jPopupMenu.add(new JPopupMenu.Separator());
        jMenuItem = new JMenuItem("Back");
        jMenuItem.addActionListener(actionEvent -> {
            if (this.canGoBack()) {
                this.back();
            }
        });
        jPopupMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = jMenuItem;
        jMenuItem = new JMenuItem("Forward");
        jMenuItem.addActionListener(actionEvent -> {
            if (this.canGoForward()) {
                this.forward();
            }
        });
        jPopupMenu.add(jMenuItem);
        JMenuItem jMenuItem3 = jMenuItem;
        jPopupMenu.add(new JPopupMenu.Separator());
        jMenuItem = new JMenuItem("Copy");
        jMenuItem.addActionListener(actionEvent -> this.copySelection());
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Select All");
        jMenuItem.addActionListener(actionEvent -> this.selectAll());
        jPopupMenu.add(jMenuItem);
        jPopupMenu.add(new JPopupMenu.Separator());
        jMenuItem = new JMenuItem("Find");
        jMenuItem.addActionListener(actionEvent -> this.find());
        jPopupMenu.add(jMenuItem);
        jPopupMenu.add(new JPopupMenu.Separator());
        jMenuItem = new JMenuItem("Print");
        jMenuItem.addActionListener(actionEvent -> this.print());
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save As");
        jMenuItem.addActionListener(actionEvent -> this.saveAs(true));
        jPopupMenu.add(jMenuItem);
        this.browser.set(PressMouseCallback.class, (Callback)((PressMouseCallback)params -> {
            MousePressed mousePressed = params.event();
            if (mousePressed.button() == MouseButton.SECONDARY) {
                SwingUtilities.invokeLater(() -> {
                    jMenuItem2.setEnabled(this.canGoBack());
                    jMenuItem3.setEnabled(this.canGoForward());
                    jPopupMenu.show((Component)this.browserComponent, mousePressed.location().x(), mousePressed.location().y());
                });
            }
            return PressMouseCallback.Response.proceed();
        }));
    }

    private void find() {
        JFrame jFrame = null;
        JDialog jDialog = null;
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (container instanceof JFrame) {
                jFrame = (JFrame)container;
                break;
            }
            if (!(container instanceof JDialog)) continue;
            jDialog = (JDialog)container;
            break;
        }
        if (this.findDialog == null) {
            this.findDialog = jFrame != null ? new FindDialog(jFrame, "Find", false, false) : (jDialog != null ? new FindDialog(jDialog, "Find", false, false) : new FindDialog((JFrame)null, "Find", false, false));
            this.findDialog.setFindListener(this);
        }
        if (!this.findDialog.isVisible()) {
            this.findDialog.setLocationRelativeTo(this);
            this.findDialog.open();
            this.findDialog.toFront();
        }
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        if (this.browserComponent != null) {
            this.browserComponent.addMouseListener(mouseListener);
        } else {
            super.addMouseListener(mouseListener);
        }
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
        if (this.browserComponent != null) {
            this.browserComponent.removeMouseListener(mouseListener);
        } else {
            super.removeMouseListener(mouseListener);
        }
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if (this.browserComponent != null) {
            this.browserComponent.addMouseMotionListener(mouseMotionListener);
        } else {
            super.addMouseMotionListener(mouseMotionListener);
        }
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if (this.browserComponent != null) {
            this.browserComponent.removeMouseMotionListener(mouseMotionListener);
        } else {
            super.removeMouseMotionListener(mouseMotionListener);
        }
    }

    @Override
    public void addKeyListener(KeyListener keyListener) {
        if (this.browserComponent != null) {
            this.browserComponent.addKeyListener(keyListener);
        } else {
            super.addKeyListener(keyListener);
        }
    }

    @Override
    public void removeKeyListener(KeyListener keyListener) {
        if (this.browserComponent != null) {
            this.browserComponent.removeKeyListener(keyListener);
        } else {
            super.removeKeyListener(keyListener);
        }
    }

    @Override
    public void addFocusListener(FocusListener focusListener) {
        if (this.browserComponent != null) {
            this.browserComponent.addFocusListener(focusListener);
        } else {
            super.addFocusListener(focusListener);
        }
    }

    @Override
    public void removeFocusListener(FocusListener focusListener) {
        if (this.browserComponent != null) {
            this.browserComponent.removeFocusListener(focusListener);
        } else {
            super.removeFocusListener(focusListener);
        }
    }

    @Override
    public void setFocusable(boolean bl) {
        if (this.browserComponent != null) {
            this.browserComponent.setFocusable(bl);
        } else {
            super.setFocusable(bl);
        }
    }

    @Override
    public boolean isFocusable() {
        if (this.browserComponent != null) {
            return this.browserComponent.isFocusable();
        }
        return super.isFocusable();
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.browserComponent != null) {
            this.browserComponent.setEnabled(bl);
        } else {
            super.setEnabled(bl);
        }
    }

    @Override
    public boolean isEnabled() {
        if (this.browserComponent != null) {
            return this.browserComponent.isEnabled();
        }
        return super.isEnabled();
    }

    @Override
    public void requestFocus() {
        if (this.browserComponent != null) {
            this.browserComponent.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    public boolean canGoBack() {
        return this.browser.navigation().canGoBack();
    }

    public boolean canGoForward() {
        return this.browser.navigation().canGoForward();
    }

    @Override
    public void selectAll() {
        Frame frame = this.getFocusedOrMainFrame();
        if (frame != null) {
            frame.execute(EditorCommand.selectAll());
        }
    }

    @Override
    public void copySelection() {
        Frame frame = this.getFocusedOrMainFrame();
        if (frame != null) {
            frame.execute(EditorCommand.copy());
        }
    }

    @Override
    public String getTitle() {
        return this.browser.title();
    }

    public boolean isDisposed() {
        return this.browser.isClosed();
    }

    public void loadURL(String string) {
        string = this.checkUrl(string);
        this.startNavigationCbEnabled = false;
        if (string.startsWith("file:")) {
            this.browser.navigation().loadUrl(string);
        } else {
            Frame frame = this.getFocusedOrMainFrame();
            if (frame != null) {
                frame.loadUrl(string);
            }
        }
    }

    private String checkUrl(String string) {
        String string2 = string.toLowerCase();
        if (string2.toLowerCase().indexOf("://") < 0 && !string2.startsWith("file:")) {
            string = "http://" + string;
        }
        return string;
    }

    private Frame getFocusedOrMainFrame() {
        if (this.browser.focusedFrame().isPresent()) {
            return (Frame)this.browser.focusedFrame().get();
        }
        if (this.browser.mainFrame().isPresent()) {
            return (Frame)this.browser.mainFrame().get();
        }
        return null;
    }

    private void print() {
        Frame frame = this.getFocusedOrMainFrame();
        if (frame != null) {
            frame.print();
        }
    }

    public void reload(boolean bl) {
        if (bl) {
            this.browser.navigation().reloadAndCheckForRepost();
        } else {
            this.browser.navigation().reload();
        }
    }

    @Override
    public void addCobolEventListener(CobolEventListener cobolEventListener) {
        this.listeners.addElement(cobolEventListener);
    }

    @Override
    public void removeCobolEventListener(CobolEventListener cobolEventListener) {
        this.listeners.removeElement(cobolEventListener);
    }

    @Override
    public void addSearchKeyEventListener(SearchKeyEventListener searchKeyEventListener) {
        if (!this.searchListeners.contains(searchKeyEventListener)) {
            this.searchListeners.addElement(searchKeyEventListener);
        }
    }

    @Override
    public void removeSearchKeyEventListener(SearchKeyEventListener searchKeyEventListener) {
        this.searchListeners.removeElement(searchKeyEventListener);
    }

    @Override
    public URL getURL() {
        if (this.beforeNavigateUrl != null) {
            try {
                return new URL(this.beforeNavigateUrl);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return this.url;
    }

    @Override
    public String getURLString() {
        return this.url != null ? this.url.toString() : "";
    }

    @Override
    public void setURL(URL uRL) {
        this.url = uRL;
        this.loadURL(this.url.toString());
    }

    @Override
    public boolean isBusy() {
        return this.browser.navigation().isLoading();
    }

    @Override
    public String getStatusText() {
        return this.statusText != null ? this.statusText : "";
    }

    @Override
    public String getProgress() {
        return this.progress != null ? this.progress : "0";
    }

    @Override
    public void back() {
        this.browser.navigation().goBack();
    }

    @Override
    public void forward() {
        this.browser.navigation().goForward();
    }

    @Override
    public void refresh() {
        this.browser.navigation().reload();
    }

    @Override
    public void abortOpenURL() {
        this.browser.navigation().stop();
    }

    @Override
    public void doOpenURL() {
        if (this.beforeNavigateUrl != null) {
            try {
                this.setURL(new URL(this.beforeNavigateUrl));
            }
            catch (MalformedURLException malformedURLException) {
                this.loadURL(this.beforeNavigateUrl);
            }
        }
    }

    @Override
    public void destroy() {
        if (!this.browser.isClosed()) {
            this.browser.close();
        }
        if (!this.engine.isClosed()) {
            this.engine.close();
        }
    }

    @Override
    public void printContent(boolean bl) {
        this.print();
    }

    @Override
    public void printNoPrompt(boolean bl) {
        this.print();
    }

    @Override
    public void saveAs(boolean bl) {
        SwingUtilities.invokeLater(() -> {
            File file;
            JFileChooser jFileChooser = new JFileChooser();
            if (jFileChooser.showSaveDialog(this) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                this.browser.saveWebPage(file.toPath(), file.getParentFile().toPath(), SavePageType.COMPLETE_HTML);
            }
        });
    }

    @Override
    public void saveAsNoPrompt(boolean bl) {
        if (this.fileName != null) {
            File file = new File(this.fileName);
            File file2 = file.getParentFile();
            this.browser.saveWebPage(file.toPath(), file2 != null ? file2.toPath() : null, SavePageType.COMPLETE_HTML);
        }
    }

    @Override
    public void setFileName(String string) {
        this.fileName = string;
    }

    @Override
    public void setValue(String string) {
        try {
            this.setURL(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private void setURL() {
        try {
            this.url = new URL(this.browser.url());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    @Override
    public void setNoMsgBeforeNavigate(boolean bl) {
        this.noMsgBeforeNavigate = bl;
    }

    @Override
    public void setActiveAccept(boolean bl) {
        this.activeAccept = bl;
    }

    @Override
    public boolean getActiveAccept() {
        return this.activeAccept;
    }

    @Override
    public void setSelfAct(boolean bl) {
        this.selfAct = bl;
    }

    @Override
    public boolean getSelfAct() {
        return this.selfAct;
    }

    @Override
    public void asyncProcessEvent(AWTEvent aWTEvent) {
    }

    private void pushEvent(int n2) {
        CobolEvent cobolEvent = new CobolEvent(this, 7, n2);
        for (CobolEventListener cobolEventListener : this.listeners) {
            try {
                cobolEventListener.cobolEvent(cobolEvent);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void stop() {
        this.abortOpenURL();
    }

    @Override
    public void find(FindDialog.FindParam findParam) {
        FindOptions.Builder builder = FindOptions.newBuilder();
        builder = builder.matchCase(findParam.matchCase);
        builder = builder.searchBackward(findParam.backSearch);
        this.browser.textFinder().find(findParam.toSearch, builder.build(), findResult -> {});
    }
}

