/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.clientlstnr;

import com.iscobol.rts.Version;
import java.awt.AWTException;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class ManageTray {
    public static final String title = "isCOBOL Client Listener";
    private final String host;
    private final int asPort;
    private final int displayPort;

    public ManageTray(String string, int n2, int n3) {
        this.host = string;
        this.asPort = n2;
        this.displayPort = n3;
        if (SystemTray.isSupported()) {
            SystemTray systemTray = SystemTray.getSystemTray();
            Image image = Toolkit.getDefaultToolkit().getImage(ManageTray.class.getResource("iscobol.png"));
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    System.out.println("Exiting...");
                    System.exit(0);
                }
            };
            PopupMenu popupMenu = new PopupMenu(title);
            MenuItem menuItem = new MenuItem("Info");
            MenuItem menuItem2 = new MenuItem("About");
            MenuItem menuItem3 = new MenuItem("Exit");
            menuItem3.addActionListener(actionListener);
            popupMenu.add(menuItem);
            popupMenu.add(menuItem2);
            popupMenu.addSeparator();
            popupMenu.add(menuItem3);
            final TrayIcon trayIcon = new TrayIcon(image, title, popupMenu);
            menuItem2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    trayIcon.displayMessage(ManageTray.title, "isCOBOL version: " + Version.getVersion(), TrayIcon.MessageType.INFO);
                }
            });
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    trayIcon.displayMessage(ManageTray.title, "Application Server host: " + ManageTray.this.host + "\nApplication Server port: " + ManageTray.this.asPort + "\nDisplay port: " + ManageTray.this.displayPort, TrayIcon.MessageType.INFO);
                }
            });
            trayIcon.setImageAutoSize(true);
            try {
                systemTray.add(trayIcon);
            }
            catch (AWTException aWTException) {
                System.err.println("TrayIcon could not be added.");
            }
        } else {
            System.err.println("Info: system tray is currently not supported.");
        }
    }
}

