/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.cobshell;

import com.iscobol.cobshell.CobolCommand;
import com.iscobol.cobshell.VSExecutor;
import com.veryant.joe.Block;
import com.veryant.joe.BreakCmdException;
import com.veryant.joe.BreakEndException;
import com.veryant.joe.ExecException;
import com.veryant.joe.Executor;
import com.veryant.joe.JOEException;
import com.veryant.joe.Parser;
import com.veryant.joe.ScriptManager;
import com.veryant.joe.Tokenizer;
import com.veryant.joe.WArray;
import com.veryant.joe.Wrapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayDeque;

public class CobShell {
    public static final String usage = " [-tron] program";
    private Block block;

    public CobShell(String string) throws Exception {
        this(string, null);
    }

    public CobShell(String string, Object ... objectArray) throws Exception {
        File file = new File(string).getCanonicalFile();
        CobolCommand cobolCommand = new CobolCommand();
        VSExecutor vSExecutor = new VSExecutor(false);
        ScriptManager scriptManager = new ScriptManager(file.getParentFile(), (Executor)vSExecutor, (Object)cobolCommand);
        Object[] objectArray2 = objectArray != null ? new Object[]{new WArray(objectArray)} : null;
        this.block = scriptManager.newInstance(file.getName(), objectArray2);
    }

    public Object execBlock(String string) throws Exception {
        return this.execBlock(string, null);
    }

    public Object execBlock(String string, Object ... objectArray) throws Exception {
        Object object = this.block.execBlock(string, objectArray);
        if (object instanceof Wrapper) {
            object = ((Wrapper)object).getWrapped();
        }
        return object;
    }

    public static void showException(CobolCommand cobolCommand, Throwable throwable) {
        cobolCommand.display(throwable.getMessage());
        Throwable throwable2 = throwable;
        while ((throwable2 = throwable2.getCause()) != null) {
            cobolCommand.display("Caused by: " + throwable2.toString());
        }
    }

    public static void main(String[] stringArray) {
        CobolCommand cobolCommand = new CobolCommand();
        int n2 = CobShell.imain(cobolCommand, stringArray);
        if (n2 != 0) {
            cobolCommand.accept();
        }
        cobolCommand.stopRun(n2);
    }

    public static int imain(String[] stringArray) {
        return CobShell.imain(new CobolCommand(), stringArray);
    }

    public static int imain(CobolCommand cobolCommand, String[] stringArray) {
        while (true) {
            try {
                return CobShell._main(cobolCommand, stringArray);
            }
            catch (ExecException execException) {
                stringArray = execException.cmds;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int _main(CobolCommand cobolCommand, String[] stringArray) throws ExecException {
        int n2;
        boolean bl = false;
        VSExecutor vSExecutor = new VSExecutor(bl);
        int n3 = 0;
        if (n3 < stringArray.length && "-tron".equals(stringArray[n3])) {
            bl = true;
            ++n3;
        }
        if (n3 < stringArray.length) {
            try {
                File file = new File(stringArray[n3]).getCanonicalFile();
                ScriptManager scriptManager = new ScriptManager(file.getParentFile(), (Executor)vSExecutor, (Object)cobolCommand);
                Object[] objectArray = new Object[]{new WArray((Object[])stringArray)};
                scriptManager.newInstance(file.getName(), objectArray);
            }
            catch (BreakEndException breakEndException) {
                n2 = 0;
            }
            catch (ExecException execException) {
                throw execException;
            }
            catch (BreakCmdException breakCmdException) {
                CobShell.showException(cobolCommand, new BreakCmdException("Block name not found: " + breakCmdException.getMessage()));
                n2 = 2;
            }
            catch (JOEException jOEException) {
                CobShell.showException(cobolCommand, jOEException);
                n2 = 2;
            }
            catch (FileNotFoundException fileNotFoundException) {
                CobShell.showException(cobolCommand, fileNotFoundException);
                n2 = 3;
            }
            catch (IOException iOException) {
                CobShell.showException(cobolCommand, iOException);
                n2 = 4;
            }
            n2 = 0;
        } else {
            n2 = 0;
            File file = new File(System.getProperty("user.dir"));
            ScriptManager scriptManager = new ScriptManager(file, (Executor)vSExecutor, (Object)cobolCommand);
            Object object = cobolCommand;
            String string = "";
            cobolCommand.displayOut(true, "CobShell interactive ready, type 'exit' to exit the session");
            cobolCommand.display();
            Parser parser = new Parser(object, (Executor)vSExecutor, "<stdin>");
            Block block = null;
            while (!"exit".equals(string)) {
                cobolCommand.displayOut(false, "cs> ");
                string = cobolCommand.accept().toString();
                ArrayDeque arrayDeque = new ArrayDeque();
                Tokenizer tokenizer = new Tokenizer();
                tokenizer.tokenize(string.toCharArray(), arrayDeque);
                try {
                    block = parser.compile(arrayDeque);
                    try {
                        block.init();
                        object = parser.getCommand();
                    }
                    catch (JOEException jOEException) {
                        CobShell.showException(cobolCommand, jOEException);
                        n2 = 2;
                    }
                    finally {
                        block.clear();
                    }
                }
                catch (Exception exception) {
                    CobShell.showException(cobolCommand, exception);
                    n2 = 3;
                    break;
                }
            }
        }
        return n2;
    }
}

