/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.cobshell;

import com.iscobol.io.AtEndException;
import com.iscobol.io.CobolFile;
import com.iscobol.io.InvalidKeyException;
import com.iscobol.java.CobolVarHelper;
import com.iscobol.java.EFDHelper;
import com.iscobol.rts.Factory;
import com.iscobol.rts.ICobolVar;

abstract class JFile {
    protected final CobolVarHelper fd;
    protected CobolFile theFile;

    JFile(CobolVarHelper cobolVarHelper) {
        this.fd = cobolVarHelper;
    }

    private ICobolVar[] getKey(String ... stringArray) {
        ICobolVar[] iCobolVarArray;
        if (stringArray.length > 0) {
            iCobolVarArray = new ICobolVar[stringArray.length];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                iCobolVarArray[i2] = this.fd.get(stringArray[i2]);
                if (iCobolVarArray[i2] != null) continue;
                throw new RuntimeException("Field " + stringArray[i2] + " doesn't exist");
            }
        } else {
            iCobolVarArray = null;
        }
        return iCobolVarArray;
    }

    public JFile openIO(String string) {
        this.theFile.open(Factory.getStrLiteral(string), 3, 0);
        return this;
    }

    public JFile openOutput(String string) {
        this.theFile.open(Factory.getStrLiteral(string), 2, 0);
        return this;
    }

    public JFile openInput(String string) {
        this.theFile.open(Factory.getStrLiteral(string), 1, 0);
        return this;
    }

    public JFile close() {
        this.theFile.close();
        return this;
    }

    public JFile keyDuplicates(String ... stringArray) {
        return this.key(true, stringArray);
    }

    public JFile key(String ... stringArray) {
        return this.key(false, stringArray);
    }

    public JFile key(boolean bl, String ... stringArray) {
        this.theFile.key(this.getKey(stringArray), bl);
        return this;
    }

    public JFile keys(EFDHelper.Key[] keyArray) {
        for (int i2 = 0; i2 < keyArray.length; ++i2) {
            this.key(keyArray[i2].duplicates(), keyArray[i2].getFields());
        }
        return this;
    }

    public boolean write() {
        try {
            this.theFile.write(false, 0);
            return true;
        }
        catch (InvalidKeyException invalidKeyException) {
            return false;
        }
    }

    public void rewrite() {
        this.theFile.rewrite(false, 0);
    }

    public boolean delete() {
        try {
            this.theFile.delete();
            return true;
        }
        catch (InvalidKeyException invalidKeyException) {
            return false;
        }
    }

    public boolean readNext() {
        try {
            this.theFile.readNext(false, this.fd.get());
            return true;
        }
        catch (AtEndException atEndException) {
            return false;
        }
    }

    public boolean readPrevious() {
        try {
            this.theFile.readPrev(false, this.fd.get());
            return true;
        }
        catch (AtEndException atEndException) {
            return false;
        }
    }

    public boolean readKey(String ... stringArray) {
        try {
            this.theFile.readKey(this.getKey(stringArray), false, this.fd.get());
            return true;
        }
        catch (AtEndException atEndException) {
            return false;
        }
        catch (InvalidKeyException invalidKeyException) {
            return false;
        }
    }

    public boolean startFIRST(String ... stringArray) {
        return this.start(0, 0, stringArray);
    }

    public boolean startLAST(String ... stringArray) {
        return this.start(1, 0, stringArray);
    }

    public boolean startEQ(String ... stringArray) {
        return this.start(5, 0, stringArray);
    }

    public boolean startGT(String ... stringArray) {
        return this.start(6, 0, stringArray);
    }

    public boolean startGE(String ... stringArray) {
        return this.start(7, 0, stringArray);
    }

    public boolean startLT(String ... stringArray) {
        return this.start(8, 0, stringArray);
    }

    public boolean startLE(String ... stringArray) {
        return this.start(9, 0, stringArray);
    }

    public boolean start(int n2, int n3, String ... stringArray) {
        try {
            this.theFile.start(this.getKey(stringArray), n2, n3);
            return true;
        }
        catch (AtEndException atEndException) {
            return false;
        }
        catch (InvalidKeyException invalidKeyException) {
            return false;
        }
    }

    public String toString() {
        return this.theFile.toString();
    }
}

