/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.BlockException;
import com.iscobol.compiler.ClauseClashException;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.Condition;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.Expression;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.IllegalConditionException;
import com.iscobol.compiler.MyClass;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.ScreenAttribute;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationScreen;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;
import com.iscobol.rts.AcceptException;
import java.util.GregorianCalendar;

public class Accept
extends Verb
implements CobolToken,
ErrorsNumbers {
    public static final int TYPE_OMITTED = 0;
    public static final int TYPE_FROMTIME = 1;
    public static final int TYPE_FROMDATE = 2;
    public static final int TYPE_FROMDAY = 3;
    public static final int TYPE_FROMDAYOFWEEK = 4;
    public static final int TYPE_FROM_CONSOLE = 5;
    public static final int TYPE_FROM_SYSTEMINFO = 6;
    public static final int TYPE_FROM_TERMINALINFO = 7;
    public static final int TYPE_FROM_ENVIRONM = 8;
    public static final int TYPE_FROM_COMMAND_LINE = 9;
    public static final int TYPE_STANDARD_OBJECT = 10;
    public static final int TYPE_FROM_SCREEN = 11;
    public static final int TYPE_FROM_ESCAPE = 12;
    public static final int TYPE_FROM_WINDOW_HDL = 13;
    public static final int TYPE_FROM_CENTURYDATE = 14;
    public static final int TYPE_FROM_CENTURYDAY = 15;
    public static final int TYPE_FROM_CONTROL_HDL = 16;
    public static final int TYPE_FROM_INPUT_STATUS = 17;
    public static final int TYPE_GUI_OR_CONSOLE = 18;
    public static final int TYPE_FROM_LINE_NUMBER = 19;
    public static final int TYPE_FROM_ENVIRONMENT_VALUE = 20;
    public static final int TYPE_FROM_ENVIRONMENT_NAME = 21;
    public static final int TYPE_FROMDATEANDTIME = 22;
    public static final int TYPE_CGI = 23;
    public static final int TYPE_FROM_WINDOW_OF_THREAD = 24;
    public static final int TYPE_FROM_EXCEPTION_STATUS = 25;
    public static final int TYPE_FROM_SYSIN = 26;
    public static final int TYPE_FROM_DATE_COMPILED = 27;
    int type;
    VariableName var;
    private boolean control = false;
    VariableName keyDest;
    BlockException onException;
    Block notOnException;
    Token envToken;
    VariableName envVar;
    Token standardObjectToken;
    VariableName standardObjectVar;
    private boolean not;
    private boolean isscreenname;
    private static int countAccept = 0;
    int currcountAccept = 0;
    ScreenAttribute sa;
    AcceptFromScreen afs;
    Token tk_timeout;
    VariableName vn_timeout;
    Token tk_mouseFlags;
    VariableName vn_mouseFlags;
    private boolean ishandle;
    private boolean beforeTime;
    private Condition untilCond;
    private String onexceptionexit = null;
    private boolean guiWd2UnsupportedLog = this.pc.getOption("-wd2") != null;
    private boolean httpUnsupportedLog = this.pc.getOption("-whttp") != null;
    VariableName threadvar;
    private boolean vansi;
    private boolean endacceptpermitted = true;
    private boolean optionCA = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Accept(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        this.currcountAccept = countAccept++;
        this.onexceptionexit = tokenManager.getOptionList().getOption("-vx");
        this.optionCA = tokenManager.getOptionList().getOption("-ca") != null;
        Token token2 = this.tm.getToken();
        if (token2.getToknum() == 40 && this.pc.getOption("-cms") != null) {
            if (this.guiWd2UnsupportedLog) {
                this.error.print(179, 2, token2, "ACCEPT");
            }
            if (this.httpUnsupportedLog) {
                this.error.print(232, 2, token, token.getWord());
            }
            this.sa = new ScreenAttribute(token, this.parent, null, this.pc, this.tm, this.error, 2);
            this.sa.msLocate();
            token2 = this.tm.getToken();
            if (token2.getToknum() != 10009) {
                throw new UnexpectedTokenException(token2, this.error);
            }
            this.tm.ungetToken();
            this.var = VariableName.get(this.tm, this.error, null, this.pc, true, true, false, true);
            this.loadAcceptToken(this.sa);
            this.type = 18;
        } else if (token2.getToknum() == 10009) {
            Token token3 = token2;
            this.tm.ungetToken();
            this.var = VariableName.get(this.tm, this.error, null, this.pc, true, true, false, true, new GetVarOpts(this, 2));
            if (this.var.getVarDecl().isExternalForm()) {
                this.type = 23;
                return;
            }
            if (this.var.getVarDecl().isControlHandle() || this.var.getVarDecl().isGenericHandle()) {
                this.ishandle = true;
            }
            this.isscreenname = this.isScreenName(this.var);
            if (this.isscreenname && ((VariableDeclarationScreen)this.var.getVarDecl()).isdisplaygroupheader) {
                throw new GeneralErrorException(19, 4, this.var.getNameToken(), this.var.getNameToken().getWord() + " control is group of controls ", this.error);
            }
            token2 = this.tm.getToken();
            if (token2.getToknum() == 498) {
                this.var.setPropTypeSet();
                token2 = this.tm.getToken();
                String string = this.pc.getMnemonicSystem(token2.getWord());
                if (token2.getToknum() == 10009 && string.equalsIgnoreCase("SYSIN")) {
                    this.type = 26;
                } else if (token2.getToknum() == 368) {
                    this.type = 5;
                } else if (token2.getToknum() == 389) {
                    this.endacceptpermitted = false;
                    token2 = this.tm.getToken();
                    if (token2.getToknum() != 821) {
                        this.type = tokenManager.getOptionList().getOption("-zy") != null ? 14 : 2;
                        this.tm.ungetToken();
                    } else {
                        this.type = 14;
                    }
                } else if (token2.getToknum() == 390) {
                    this.type = 27;
                } else if (token2.getWord().equals("CENTURY-DATE")) {
                    this.endacceptpermitted = false;
                    this.type = 14;
                } else if (token2.getToknum() == 392) {
                    this.endacceptpermitted = false;
                    token2 = this.tm.getToken();
                    if (token2.getToknum() != 820) {
                        this.type = tokenManager.getOptionList().getOption("-zy") != null ? 15 : 3;
                        this.tm.ungetToken();
                    } else {
                        this.type = 15;
                    }
                } else if (token2.getWord().equals("CENTURY-DAY")) {
                    this.endacceptpermitted = false;
                    this.type = 15;
                } else if (token2.getWord().equals("DATE-AND-TIME")) {
                    this.endacceptpermitted = false;
                    this.type = 22;
                } else if (token2.getToknum() == 393) {
                    this.endacceptpermitted = false;
                    this.type = 4;
                } else if (token2.getToknum() == 769) {
                    this.endacceptpermitted = false;
                    this.type = 1;
                } else if (token2.getToknum() == 565) {
                    this.endacceptpermitted = false;
                    token2 = this.tm.getToken();
                    if (token2.getToknum() != 602) {
                        this.tm.ungetToken();
                    }
                    this.type = 19;
                } else if (token2.getToknum() == 758) {
                    this.endacceptpermitted = false;
                    this.type = 7;
                    this.pc.useScreen = true;
                } else if (token2.getToknum() == 466) {
                    this.endacceptpermitted = false;
                    this.type = 12;
                    this.pc.useScreen = true;
                    token2 = this.tm.getToken();
                    if (token2.getToknum() != 551) {
                        this.tm.ungetToken();
                    }
                } else {
                    if (token2.getToknum() == 705) {
                        this.endacceptpermitted = false;
                        this.type = 11;
                        this.afs = new AcceptFromScreen(this.keyWord, this.parent, this.pc, this.tm, this.error, token2);
                        return;
                    }
                    if (token2.getToknum() == 763) {
                        this.endacceptpermitted = false;
                        this.type = 763;
                        token2 = this.tm.getToken();
                        if (token2.getToknum() != 510) {
                            this.tm.ungetToken();
                        }
                        this.ishandle = false;
                    } else if (token2.getToknum() == 754) {
                        this.endacceptpermitted = false;
                        this.type = 6;
                    } else if (token2.getToknum() == 340) {
                        this.endacceptpermitted = false;
                        this.type = 9;
                    } else if (token2.getWord().equalsIgnoreCase("ENVIRONMENT-VALUE") || token2.getWord().equalsIgnoreCase(this.tm.getEnvValue())) {
                        this.endacceptpermitted = false;
                        this.type = 20;
                    } else if (token2.getWord().equalsIgnoreCase("ENVIRONMENT-NAME") || token2.getWord().equalsIgnoreCase(this.tm.getEnvName())) {
                        this.type = 21;
                    } else if (token2.getToknum() == 458 || token2.getToknum() == 367) {
                        this.type = 8;
                        token2 = this.tm.getToken();
                        if (token2.getToknum() == 10001) {
                            this.envToken = token2;
                        } else {
                            if (token2.getToknum() != 10009) throw new GeneralErrorException(66, 4, token2, token2.getWord(), this.error);
                            this.envVar = this.localVariableNameGet();
                            if (this.envVar.getVarDecl().isNumeric()) {
                                throw new GeneralErrorException(66, 4, token2, token2.getWord(), this.error);
                            }
                        }
                    } else if (token2.getWord().toUpperCase().equalsIgnoreCase("STANDARD")) {
                        token2 = this.tm.getToken();
                        if (token2.getToknum() != 606) throw new GeneralErrorException(19, 4, token2, token2.getWord(), this.error);
                        this.endacceptpermitted = false;
                        this.acceptFromStandardObject(token2);
                    } else if (token2.getWord().toUpperCase().equalsIgnoreCase("OBJECT")) {
                        this.endacceptpermitted = false;
                        this.acceptFromStandardObject(token2);
                    } else if (token2.getToknum() == 812) {
                        this.endacceptpermitted = false;
                        token2 = this.tm.getToken();
                        if (token2.getToknum() == 609) {
                            this.type = 24;
                            token2 = this.tm.getToken();
                            if (token2.getToknum() == 763 || token2.getToknum() == 10009) {
                                if (token2.getToknum() == 10009) {
                                    this.tm.ungetToken();
                                }
                                this.threadvar = VariableName.get(this.tm, this.error, this.pc);
                                if (this.threadvar == null) {
                                    token2 = this.tm.getToken();
                                    throw new UnexpectedTokenException(token2, this.error);
                                }
                                if (!this.threadvar.getVarDecl().isValidThreadHandle()) {
                                    throw new ClauseClashException(token2, this.error, this.threadvar.getName());
                                }
                            }
                            this.pc.useScreen = true;
                        } else {
                            this.type = 13;
                            this.pc.useScreen = true;
                            if (token2.getToknum() != 510) {
                                this.tm.ungetToken();
                            }
                        }
                    } else if (token2.getToknum() == 373) {
                        this.type = 16;
                        this.pc.useScreen = true;
                        if (this.tm.getToken().getToknum() != 510) {
                            this.tm.ungetToken();
                        }
                    } else if (token2.getToknum() == 534) {
                        this.endacceptpermitted = false;
                        token2 = this.tm.getToken();
                        if (token2.getToknum() != 742) {
                            throw new ExpectedFoundException(token2, this.error, "'STATUS'");
                        }
                        this.type = 17;
                    } else if (token2.getToknum() == 383) {
                        if (this.httpUnsupportedLog) {
                            this.error.print(232, 2, token, token.getWord());
                        }
                        this.type = 18;
                        this.sa = new ScreenAttribute(token, block, null, this.pc, this.tm, errors, 2);
                        this.pc.useScreen = true;
                    } else {
                        if (token2.getToknum() != 472) throw new GeneralErrorException(19, 4, token2, token2.getWord(), this.error);
                        token2 = this.tm.getToken();
                        if (token2.getToknum() != 742) {
                            this.tm.ungetToken();
                        }
                        this.type = 25;
                    }
                }
                if (this.type > 0) {
                    this.ishandle = false;
                }
            } else {
                if (this.httpUnsupportedLog) {
                    this.error.print(232, 2, token, token.getWord());
                }
                if (!this.isscreenname && this.guiWd2UnsupportedLog) {
                    this.error.print(179, 2, token3, "character user interface: " + token3.getWord().toUpperCase() + " in ACCEPT command");
                }
                this.tm.ungetToken();
                this.sa = new ScreenAttribute(token, block, null, this.pc, this.tm, errors, 2);
                this.loadAcceptToken(this.sa);
                this.type = 18;
            }
        } else if (token2.getToknum() == 612 || token2.getToknum() == 468) {
            if (this.httpUnsupportedLog) {
                this.error.print(232, 2, token, token.getWord());
            }
            if (token2.getToknum() == 612 && this.guiWd2UnsupportedLog) {
                this.error.print(179, 2, token2, token2.getWord().toUpperCase() + " in ACCEPT command");
            }
            this.type = 0;
            this.sa = new ScreenAttribute(token, block, null, this.pc, this.tm, errors, 2);
            this.loadAcceptToken(this.sa);
        } else {
            if (token2.getToknum() != 373) throw new GeneralErrorException(19, 4, token, token.getWord(), this.error);
            this.control = true;
            this.sa = new ScreenAttribute(token, block, null, this.pc, this.tm, errors, 2);
            this.loadAcceptToken(this.sa);
        }
        this.loadAcceptToken(this.sa);
        if (!this.optionCA) {
            this.endacceptpermitted = true;
        }
        if ((token2 = this.tm.getToken()).getToknum() == 423 && this.endacceptpermitted) return;
        this.tm.ungetToken();
    }

    private void acceptFromStandardObject(Token token) throws GeneralErrorException, EndOfProgramException {
        this.ishandle = false;
        this.type = 10;
        this.pc.useScreen = true;
        token = this.tm.getToken();
        if (token.getToknum() == 10001) {
            this.standardObjectToken = token;
        } else if (token.getToknum() == 10009) {
            this.standardObjectVar = this.localVariableNameGet();
            if (this.standardObjectVar.getVarDecl().isNumeric()) {
                throw new GeneralErrorException(66, 4, this.standardObjectVar.getNameToken(), this.standardObjectVar.getName(), this.error);
            }
        } else {
            throw new GeneralErrorException(66, 4, token, token.getWord(), this.error);
        }
    }

    private void loadAcceptToken(ScreenAttribute screenAttribute) throws GeneralErrorException, EndOfProgramException {
        boolean bl = true;
        Token token = null;
        while (bl && (token = this.tm.getToken()) != null) {
            if (token.getToknum() == 498) {
                token = this.tm.getToken();
                if (token.getToknum() != 383) {
                    this.tm.ungetToken();
                } else {
                    token = this.tm.getToken();
                    if (token == null) break;
                }
            }
            if (token.getToknum() == 299 && (token = this.tm.getToken()).getToknum() != 769) {
                throw new ExpectedFoundException(token, this.error, "'TIME'");
            }
            if (token.getToknum() == 769) {
                this.beforeTime = true;
                token = this.tm.getToken();
                if (Token.isNumLit(token)) {
                    this.tk_timeout = token;
                } else if (token.getToknum() == 10009) {
                    this.vn_timeout = this.localVariableNameGet();
                } else {
                    throw new GeneralErrorException(22, 4, token, token.getWord(), this.error);
                }
                token = this.tm.getToken();
            }
            if (token.getToknum() == 10009 && token.getWord().equalsIgnoreCase("MOUSE")) {
                token = this.tm.getToken();
                if (token.getToknum() != 10009 || !token.getWord().equalsIgnoreCase("FLAGS")) {
                    throw new ExpectedFoundException(token, this.error, "'FLAGS'");
                }
                token = this.tm.getToken();
                switch (token.getToknum()) {
                    case 10002: 
                    case 10017: {
                        this.tk_mouseFlags = token;
                        break;
                    }
                    case 10009: {
                        this.tm.ungetToken();
                        this.vn_mouseFlags = VariableName.get(this.tm, this.error, this.pc);
                        break;
                    }
                    default: {
                        throw new GeneralErrorException(22, 4, token, token.getWord(), this.error);
                    }
                }
                token = this.tm.getToken();
            }
            if (screenAttribute != null) {
                while (token.getToknum() == 813 || token.getToknum() == 377 || token.getToknum() == 376) {
                    token = this.tm.getToken();
                }
                bl = screenAttribute.tokenIsAttrScreen(token, this.tm, this.keyWord, -1, this.isscreenname);
                this.tm.ungetToken();
            } else {
                this.tm.ungetToken();
                bl = false;
            }
            if (bl || (token = this.tm.getToken()) == null) continue;
            if (token.getToknum() == 373 && (token = this.tm.getToken()).getToknum() != 551) {
                throw new ExpectedFoundException(token, this.error, "'KEY'");
            }
            if (token.getToknum() == 551) {
                token = this.tm.getToken();
                if (token.getToknum() == 526) {
                    token = this.tm.getToken();
                }
                this.keyDest = this.localVariableNameGet();
                if (this.keyDest == null || !this.keyDest.getVarDecl().isNumeric() || this.keyDest.getVarDecl().isEdited()) {
                    throw new GeneralErrorException(23, 4, token, token.getWord(), this.error);
                }
                token = this.tm.getToken();
                bl = true;
            }
            if (token.getToknum() == 791) {
                this.untilCond = new Condition(this.keyWord, this.parent, this.pc, this.tm, this.error);
                if (!this.untilCond.isFullCondition()) {
                    throw new IllegalConditionException(this.keyWord, this.error);
                }
                token = this.tm.getToken();
            }
            if (this.type != 22 && this.type != 2 && this.type != 3 && this.type != 14 && this.type != 15 && this.type != 1 && this.type != 7 && this.type != 6 && this.type != 17 && this.type != 12 && this.type != 19 && this.type != 9 && this.type != 10 && this.type != 763 && this.type != 13 && this.type != 24 && (token.getToknum() == 598 || token.getToknum() == 613 || token.getToknum() == 472 || token.getToknum() == 466)) {
                Token token2;
                this.pc.useScreen = true;
                boolean bl2 = false;
                if (token.getToknum() == 598) {
                    this.not = true;
                    token = this.tm.getToken();
                }
                if (token.getToknum() == 613) {
                    bl2 = true;
                    token = this.tm.getToken();
                }
                if ((token2 = token).getToknum() == 472 || token2.getToknum() == 466) {
                    token = this.tm.getToken();
                    if (token.getToknum() == 10009) {
                        this.keyDest = this.localVariableNameGet();
                    } else {
                        this.tm.ungetToken();
                    }
                    bl = true;
                    if (this.not) {
                        this.notOnException = new Block(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, 2);
                    } else {
                        this.onException = new BlockException(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, MyClass.getInstance(AcceptException.class));
                    }
                    token = this.tm.getToken();
                    if (!this.not && token.getToknum() == 598) {
                        token = this.tm.getToken();
                        if (token.getToknum() == 613) {
                            token = this.tm.getToken();
                        }
                        if (token.getToknum() != token2.getToknum()) {
                            throw new ExpectedFoundException(token, this.error, "'" + token2.getWord() + "'");
                        }
                        this.notOnException = new Block(this.parent, this.parent.parent, this, this.pc, this.tm, this.error, this.parent.nesting + 1);
                        continue;
                    }
                    this.tm.ungetToken();
                    continue;
                }
                this.tm.ungetToken();
                if (this.not) {
                    this.tm.ungetToken();
                }
                if (!bl2) continue;
                this.tm.ungetToken();
                continue;
            }
            if (token.getToknum() == 596) {
                screenAttribute.setAttrNOADVANCING(true);
                bl = true;
                continue;
            }
            this.tm.ungetToken();
        }
    }

    @Override
    public void check() throws GeneralErrorException {
        if (this.sa != null) {
            this.sa.check(this.parent.parent);
        }
    }

    boolean isScreenName(VariableName variableName) throws GeneralErrorException {
        VariableDeclaration variableDeclaration = null;
        if (variableName == null) {
            return false;
        }
        variableDeclaration = this.pc.getVar(variableName);
        return variableDeclaration != null && variableDeclaration instanceof VariableDeclarationScreen;
    }

    boolean isFontHandle(VariableName variableName) throws GeneralErrorException {
        VariableDeclaration variableDeclaration = null;
        if (variableName == null) {
            return false;
        }
        variableDeclaration = this.pc.getVar(variableName);
        if (variableDeclaration != null && variableDeclaration instanceof VariableDeclaration) {
            return variableDeclaration.isFontHandle() || variableDeclaration.isGenericHandle();
        }
        return false;
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        this.getCodeDebug(stringBuffer);
        if (this.type == 23) {
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append("HTTPHandler.cgiAccept (");
            stringBuffer.append(this.var.getCode());
            stringBuffer.append(");");
            stringBuffer.append(eol);
            this.getCodeDebugEnd(stringBuffer);
            return stringBuffer.toString();
        }
        if (this.untilCond != null) {
            stringBuffer.append(this.parent.getIndent() + "do {" + eol);
        }
        boolean bl = this.pc.getOption("-d") != null;
        boolean bl2 = this.vansi = this.pc.getOption("-vansi") != null && !this.isscreenname;
        if (this.vansi && (this.type == 18 || this.type == 0 || this.type == 11 || this.type == 18)) {
            this.type = 5;
        }
        if (!this.vansi && (this.isscreenname || this.ishandle && this.type != 13 && this.type != 24 && this.type != 16)) {
            stringBuffer.append(this.getScreenCode(this.var));
        } else if (this.type == 0 && (this.pc.data != null && this.pc.data.screenSec != null || this.sa != null && this.sa.getOne() || this.pc.useScreen || this.keyDest != null)) {
            stringBuffer.append(this.getScreenCode(null));
        } else if (!this.vansi && this.control && this.pc.data != null) {
            stringBuffer.append(this.getScreenCode(null));
        } else if (this.type == 18) {
            if (this.sa != null && (this.sa.getOne() || this.keyDest != null || this.onexceptionexit != null)) {
                stringBuffer.append(this.getScreenCode(this.var));
            } else {
                stringBuffer.append(this.parent.getIndent());
                stringBuffer.append("ScrFactory.getGUIEnviroment()");
                stringBuffer.append(".setAcceptTimeout(");
                if (this.beforeTime) {
                    if (this.tk_timeout != null) {
                        stringBuffer.append(this.getCodeLiteral(this.tk_timeout));
                    } else {
                        stringBuffer.append(this.vn_timeout.getCode());
                    }
                } else {
                    stringBuffer.append("null");
                }
                stringBuffer.append(");" + eol);
                stringBuffer.append(this.parent.getIndent());
                stringBuffer.append("ScrFactory.getGUIEnviroment().accept (");
                stringBuffer.append(this.pc.getCodeScreenSpecialNames());
                stringBuffer.append(this.getSNCodeCursor());
                stringBuffer.append(this.var.getCode());
                stringBuffer.append(");");
                stringBuffer.append(eol);
            }
        } else if (this.type == 25) {
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append(this.var.getCode());
            stringBuffer.append(".set(0);");
            stringBuffer.append(eol);
        } else {
            String string = this.parent.getIndent();
            boolean bl3 = false;
            if (this.onException != null || this.notOnException != null || (bl3 = (this.type == 8 || this.type == 20) && this.pc.getOption("-cm") != null)) {
                stringBuffer.append(this.parent.getIndent());
                stringBuffer.append("try {");
                stringBuffer.append(eol);
                string = string + "   ";
            }
            stringBuffer.append(string);
            if (this.type == 12) {
                stringBuffer.append("ScrFactory.getGUIEnviroment()");
                stringBuffer.append(".getEscapeKey(");
                stringBuffer.append(this.var.getCode());
                stringBuffer.append(");");
            } else if (this.type == 11) {
                stringBuffer.append(this.afs.getCode());
                stringBuffer.append(this.var.getCode());
                stringBuffer.append(");");
            } else if (this.type == 0) {
                stringBuffer.append("Factory.acceptOmitted(");
                stringBuffer.append(Pcc.getInddProperty());
                stringBuffer.append(");");
            } else if (this.type == 1) {
                stringBuffer.append("Factory.acceptFromTime().moveTo(");
                stringBuffer.append(this.var.getCode());
                stringBuffer.append(");");
            } else if (this.type == 19) {
                stringBuffer.append("Factory.acceptFromLineNumber(");
                stringBuffer.append(this.tm.getDecimalPointIsComma());
                stringBuffer.append(").moveTo(");
                stringBuffer.append(this.var.getCode());
                stringBuffer.append(");");
            } else if (this.type == 2) {
                stringBuffer.append("Factory.acceptFromDate().moveTo(");
                stringBuffer.append(this.var.getCode());
                stringBuffer.append(");");
            } else if (this.type == 14) {
                stringBuffer.append("Factory.acceptFromCenturyDate().moveTo(");
                stringBuffer.append(this.var.getCode());
                stringBuffer.append(");");
            } else if (this.type == 22) {
                stringBuffer.append("Factory.acceptFromTimestamp().moveTo(");
                stringBuffer.append(this.var.getCode());
                stringBuffer.append(");");
            } else if (this.type == 3) {
                stringBuffer.append("Factory.acceptFromDay().moveTo(");
                stringBuffer.append(this.var.getCode());
                stringBuffer.append(");");
            } else if (this.type == 15) {
                stringBuffer.append("Factory.acceptFromCenturyDay().moveTo(");
                stringBuffer.append(this.var.getCode());
                stringBuffer.append(");");
            } else if (this.type == 4) {
                stringBuffer.append("Factory.acceptFromDayOfWeek().moveTo(");
                stringBuffer.append(this.var.getCode());
                stringBuffer.append(");");
            } else if (this.type == 27) {
                stringBuffer.append(this.var.getCode());
                stringBuffer.append(".set(");
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                int n2 = gregorianCalendar.get(1);
                stringBuffer.append(n2);
                n2 = gregorianCalendar.get(2) + 1;
                if (n2 < 10) {
                    stringBuffer.append("0");
                }
                stringBuffer.append(n2);
                n2 = gregorianCalendar.get(5);
                if (n2 < 10) {
                    stringBuffer.append("0");
                }
                stringBuffer.append(n2);
                stringBuffer.append(");");
            } else if (this.type == 763) {
                stringBuffer.append(this.var.getCode());
                stringBuffer.append(".set (Factory.getCurrentThreadId());");
            } else if (this.type == 5) {
                if (this.var == null) {
                    stringBuffer.append("Factory.acceptOmitted(");
                    stringBuffer.append(Pcc.getInddProperty());
                    stringBuffer.append(");");
                } else if (!this.var.isNumeric() && this.var.isEdited()) {
                    stringBuffer.append(this.var.getCode());
                    stringBuffer.append(".setValue(Factory.acceptFromConsole());");
                } else {
                    stringBuffer.append("Factory.acceptFromConsole().moveTo(");
                    stringBuffer.append(this.var.getCode());
                    if (this.var.isNumeric()) {
                        stringBuffer.append(".sub(1)");
                    }
                    stringBuffer.append(");");
                }
            } else if (this.type == 26) {
                if (!this.var.isNumeric() && this.var.isEdited()) {
                    stringBuffer.append(this.var.getCode());
                    stringBuffer.append(".setValue(Factory.acceptFromConsole(");
                    stringBuffer.append(Pcc.getInddProperty());
                    stringBuffer.append("));");
                } else {
                    stringBuffer.append("Factory.acceptFromConsole(");
                    stringBuffer.append(Pcc.getInddProperty());
                    stringBuffer.append(").moveTo(");
                    stringBuffer.append(this.var.getCode());
                    if (this.var.isNumeric()) {
                        stringBuffer.append(".sub(1)");
                    }
                    stringBuffer.append(");");
                }
            } else if (this.type == 9) {
                if (bl) {
                    stringBuffer.append("Factory.acceptFromCommandLine(Debugger.getCommandLineArgs(Factory.get().gArgs))");
                } else {
                    stringBuffer.append("Factory.acceptFromCommandLine(Factory.get().gArgs)");
                }
                stringBuffer.append(".moveTo(");
                stringBuffer.append(this.var.getCode());
                stringBuffer.append(");");
            } else if (this.type == 8) {
                stringBuffer.append(this.var.getCode() + ".set(");
                stringBuffer.append("Factory.acceptFromEnv(");
                if (this.envToken != null) {
                    stringBuffer.append(this.getCodeLiteral(this.envToken));
                } else {
                    stringBuffer.append(this.envVar.getCode());
                }
                stringBuffer.append(".toString()");
                if (this.onException != null || this.notOnException != null || bl3) {
                    stringBuffer.append(", true");
                } else {
                    stringBuffer.append(", false");
                }
                stringBuffer.append("));");
            } else if (this.type == 20) {
                stringBuffer.append(this.var.getCode() + ".set(");
                stringBuffer.append("Factory.acceptFromEnvValue(");
                if (this.onException != null || this.notOnException != null || bl3) {
                    stringBuffer.append("true));");
                } else {
                    stringBuffer.append("false));");
                }
            } else if (this.type == 21) {
                stringBuffer.append(this.var.getCode() + ".set(");
                stringBuffer.append("Factory.acceptFromEnvName(");
                if (this.onException != null || this.notOnException != null) {
                    stringBuffer.append("true));");
                } else {
                    stringBuffer.append("false));");
                }
            } else if (this.type == 10) {
                stringBuffer.append(this.var.getCode() + ".setId(ScrFactory.acceptFromStandardObject(");
                if (this.standardObjectToken != null) {
                    stringBuffer.append(this.getCodeLiteral(this.standardObjectToken));
                } else {
                    stringBuffer.append(this.standardObjectVar.getCode());
                }
                stringBuffer.append("));");
            } else if (this.type == 7) {
                stringBuffer.append("ScrFactory.getGUIEnviroment().acceptFromTerminalInfo(");
                stringBuffer.append(this.var.getCode());
                stringBuffer.append(");");
            } else if (this.type == 6) {
                stringBuffer.append("Factory.acceptFromSystemInfo().moveTo(");
                stringBuffer.append(this.var.getCode());
                stringBuffer.append(");");
            } else if (this.type == 13) {
                stringBuffer.append("ScrFactory.getGUIEnviroment().acceptFromWindowHandle(" + this.var.getCode() + ");");
            } else if (this.type == 16) {
                stringBuffer.append("ScrFactory.getGUIEnviroment().acceptFromControlHandle(" + this.var.getCode() + ");");
            } else if (this.type == 17) {
                stringBuffer.append("ScrFactory.getGUIEnviroment().acceptFromInputStatus(" + this.var.getCode() + ");");
            } else if (this.type == 24) {
                stringBuffer.append(this.var.getCode());
                stringBuffer.append(".set(ScrFactory.getGUIEnviroment().getActiveWindowHandleOfThread(");
                stringBuffer.append(this.threadvar.getCode());
                stringBuffer.append("));");
            }
            if (this.notOnException != null) {
                stringBuffer.append(this.notOnException.getCode());
            }
            if (this.onException != null || this.notOnException != null) {
                stringBuffer.append(this.parent.getIndent());
                stringBuffer.append("} catch (AcceptException ");
                stringBuffer.append(this.parent.getExceptName());
                stringBuffer.append(")");
                if (this.onException != null) {
                    stringBuffer.append(this.onException.getCode());
                } else {
                    stringBuffer.append("{ }");
                }
            } else if (bl3) {
                stringBuffer.append("} catch (AcceptException ");
                stringBuffer.append(this.parent.getExceptName());
                stringBuffer.append(") { }");
            }
            stringBuffer.append(eol);
        }
        if (this.untilCond != null) {
            stringBuffer.append(eol + this.parent.getIndent() + "} while(!(");
            stringBuffer.append(this.untilCond.getCode() + "));" + eol);
        }
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }

    public StringBuffer getScreenCode(VariableName variableName) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.parent.getIndent();
        if ((variableName == null || this.ishandle) && this.control && this.sa != null) {
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append("if (ScrFactory.getGUIEnviroment().getControl(");
            stringBuffer.append(this.sa.getScreenAttributeLINEPOSITION());
            stringBuffer.append(") != null) {" + eol);
        }
        if (this.onException != null || this.notOnException != null || this.onexceptionexit != null || this.keyDest != null) {
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append("try {");
            stringBuffer.append(eol);
            string = string + "   ";
        }
        stringBuffer.append(string);
        stringBuffer.append("CobolRecordAccept __cra_" + this.currcountAccept + " = null;" + eol);
        stringBuffer.append(string);
        stringBuffer.append("ScrFactory.getGUIEnviroment()");
        stringBuffer.append(".setAcceptTimeout(");
        if (this.beforeTime) {
            if (this.tk_timeout != null) {
                stringBuffer.append(this.getCodeLiteral(this.tk_timeout));
            } else {
                stringBuffer.append(this.vn_timeout.getCode());
            }
        } else {
            stringBuffer.append("null");
        }
        stringBuffer.append(");" + eol);
        if (this.tk_mouseFlags != null || this.vn_mouseFlags != null) {
            stringBuffer.append(string);
            stringBuffer.append("ScrFactory.getGUIEnviroment()");
            stringBuffer.append(".setMouseFlags(");
            if (this.tk_mouseFlags != null) {
                stringBuffer.append(this.getCodeLiteral(this.tk_mouseFlags));
            } else {
                stringBuffer.append(this.vn_mouseFlags.getCode());
            }
            stringBuffer.append(");" + eol);
        }
        stringBuffer.append(string);
        stringBuffer.append("do {" + eol);
        string = string + "   ";
        stringBuffer.append(string);
        stringBuffer.append("__cra_" + this.currcountAccept + " = CobolGUIEnvironment.manageAccept(" + this.pc.getCodeScreenSpecialNames() + "ScrFactory.getGUIEnviroment()" + ", " + "ScrFactory.getGUIEnviroment()");
        if (this.sa != null) {
            if (this.sa.vThread != null) {
                stringBuffer.append(".setThread (");
                stringBuffer.append(this.sa.vThread.getCode());
                stringBuffer.append(", false)");
            } else if (this.sa.attrLAST) {
                stringBuffer.append(".setThread (null, true)");
            } else if (this.sa.attrANY) {
                stringBuffer.append(".setThread (null, false)");
            }
        }
        if (variableName == null || this.ishandle) {
            if (this.control && this.sa != null) {
                stringBuffer.append(".accept(" + this.pc.getCodeScreenSpecialNames() + "ScrFactory.getGUIEnviroment()" + ".getControl(");
                stringBuffer.append(this.sa.getScreenAttributeLINEPOSITION());
                stringBuffer.append(")");
                stringBuffer.append(this.sa.getGraphicalScreenAttributeCode(this.keyWord, ".set"));
                stringBuffer.append(",");
            } else if (this.ishandle && this.sa != null) {
                stringBuffer.append(".accept(");
                stringBuffer.append(this.pc.getCodeScreenSpecialNames());
                stringBuffer.append("(");
                stringBuffer.append(variableName.getCode());
                stringBuffer.append(".getId() != null ? (BaseGUIControl) ");
                stringBuffer.append(variableName.getCode());
                stringBuffer.append(".getId() : ScrFactory.getControl(\"FOO\", null, null).setStyle(\"TEMPORARY\").setPrompt(true).endDeclaration())");
                stringBuffer.append(this.sa.getGraphicalScreenAttributeCode(this.keyWord, ".set"));
                stringBuffer.append(",");
            } else if (this.sa != null && this.sa.getOne()) {
                stringBuffer.append(".accept(" + this.pc.getCodeScreenSpecialNames());
                stringBuffer.append(this.getSNCodeCursor());
                stringBuffer.append("NullControl.getInstance()");
                stringBuffer.append(this.sa.getGraphicalScreenAttributeCode(this.keyWord, ".set"));
                stringBuffer.append(",");
            } else {
                stringBuffer.append(".accept(" + this.pc.getCodeScreenSpecialNames());
                stringBuffer.append(this.getSNCodeCursor());
                stringBuffer.append("(BaseGUIControl)null,");
            }
        } else {
            stringBuffer.append(".accept(" + this.pc.getCodeScreenSpecialNames());
            stringBuffer.append(this.getSNCodeCursor());
            if (this.sa != null) {
                if (!this.isscreenname) {
                    stringBuffer.append("ScrFactory.getGUITerminalAccept(" + (this.tm.isRmCompFlag() ? "true, " : "") + variableName.getCode() + ")");
                    stringBuffer.append(this.sa.getGraphicalScreenAttributeCode(this.keyWord, ".set"));
                } else if (this.sa != null && this.sa.getOne()) {
                    stringBuffer.append("ScrFactory.getGUIEnviroment().getControl(");
                    stringBuffer.append(variableName.getCode());
                    stringBuffer.append(")");
                    stringBuffer.append(this.sa.getGraphicalScreenAttributeCode(this.keyWord, ".set", ".reloc", true));
                } else {
                    stringBuffer.append(variableName.getCode());
                }
            } else {
                stringBuffer.append(variableName.getCode());
            }
            stringBuffer.append(",");
        }
        if (this.onException != null || this.notOnException != null || this.keyDest != null) {
            stringBuffer.append("true");
        } else if (this.onexceptionexit != null) {
            stringBuffer.append("true");
        } else {
            stringBuffer.append("false");
        }
        stringBuffer.append(",");
        if (this.keyDest != null) {
            stringBuffer.append(this.keyDest.getCode());
        } else {
            stringBuffer.append("null");
        }
        stringBuffer.append(",__cra_" + this.currcountAccept);
        stringBuffer.append("," + (this.ishandle && this.sa != null));
        if (this.sa != null && this.sa.getAcceptCursor() != null) {
            stringBuffer.append(", " + this.sa.getAcceptCursor());
        }
        stringBuffer.append("),");
        if (this.onException != null || this.notOnException != null || this.keyDest != null) {
            stringBuffer.append("true");
        } else if (this.onexceptionexit != null) {
            stringBuffer.append("true");
        } else {
            stringBuffer.append("false");
        }
        stringBuffer.append("," + (this.ishandle && this.sa != null));
        stringBuffer.append(");" + eol);
        stringBuffer.append(string);
        stringBuffer.append("if(ScrFactory.getGUIEnviroment().getEventActionOfEventStatus(");
        if (this.pc.getSNEventStatus() != null) {
            stringBuffer.append(this.pc.getSNEventStatus().getUnivoqueName());
        } else {
            stringBuffer.append("(CobolVar)null");
        }
        stringBuffer.append(",__cra_" + this.currcountAccept);
        stringBuffer.append(") != 2) {" + eol);
        stringBuffer.append(string + "   ");
        stringBuffer.append("ScrFactory.getGUIEnviroment().responseAccept(" + this.pc.getCodeScreenSpecialNames() + "__cra_" + this.currcountAccept + ");" + eol);
        stringBuffer.append(string + "   ");
        stringBuffer.append("ScrFactory.getGUIEnviroment().manageAcceptException(" + this.pc.getCodeScreenSpecialNames() + "__cra_" + this.currcountAccept + ", ");
        if (this.onException != null || this.notOnException != null || this.keyDest != null) {
            stringBuffer.append("true");
        } else if (this.onexceptionexit != null) {
            stringBuffer.append("true");
        } else {
            stringBuffer.append("false");
        }
        stringBuffer.append(");" + eol);
        stringBuffer.append(string + "}" + eol);
        string = this.parent.getIndent();
        string = string + "   ";
        stringBuffer.append(string);
        stringBuffer.append("} while ( ! ScrFactory.getGUIEnviroment().isAcceptTerminated(" + this.pc.getCodeScreenSpecialNames());
        stringBuffer.append("__cra_" + this.currcountAccept + ", ");
        if (this.onException != null || this.notOnException != null || this.keyDest != null) {
            stringBuffer.append("true");
        } else if (this.onexceptionexit != null) {
            stringBuffer.append("true");
        } else {
            stringBuffer.append("false");
        }
        stringBuffer.append("));" + eol);
        if (this.notOnException != null) {
            stringBuffer.append(this.notOnException.getCode());
        }
        if (this.onException != null || this.notOnException != null || this.onexceptionexit != null || this.keyDest != null) {
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append("} catch (AcceptException ");
            stringBuffer.append(this.parent.getExceptName());
            stringBuffer.append(")");
            if (this.onException != null) {
                stringBuffer.append(this.onException.getCode());
            } else {
                stringBuffer.append("{ }");
            }
        }
        if ((variableName == null || this.ishandle) && this.control && this.sa != null) {
            stringBuffer.append(eol + this.parent.getIndent());
            stringBuffer.append("}" + eol);
        }
        return stringBuffer;
    }

    private VariableName localVariableNameGet() throws GeneralErrorException, EndOfProgramException {
        this.tm.ungetToken();
        VariableName variableName = VariableName.get(this.tm, this.error, null, this.pc, true, true, true, true);
        return variableName;
    }

    private String getSNCodeCursor() {
        String string = this.pc.getCodeCursorSpecialNames();
        if (string == null) {
            string = "null";
        }
        string = string + ", ";
        return string;
    }

    public VariableName getVariableName() {
        return this.var;
    }

    public static void resetCounters() {
        countAccept = 0;
    }

    public int getType() {
        return this.type;
    }

    public VariableName getEnvironmentVariableName() {
        return this.envVar;
    }

    public Token getEnvironmentVariableToken() {
        return this.envToken;
    }

    public BlockException getOnException() {
        return this.onException;
    }

    public Block getNotOnException() {
        return this.notOnException;
    }

    private class AcceptFromScreen
    extends Verb
    implements CobolToken,
    ErrorsNumbers {
        VariableName vn_screen_loc;
        Token tk_screen_loc;
        boolean hasAtPhrase;
        boolean hasLinePhrase;
        boolean hasColumnPhrase;
        boolean hasSize;
        Expression line;
        Expression column;
        Expression length;

        public AcceptFromScreen(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors, Token token2) throws GeneralErrorException, EndOfProgramException {
            super(token, block, pcc, tokenManager, errors);
            token2 = this.tm.getToken();
            if (token2.getToknum() == 284) {
                token2 = this.tm.getToken();
                switch (token2.getToknum()) {
                    case 10001: 
                    case 10002: 
                    case 10017: {
                        this.tk_screen_loc = token2;
                        this.hasAtPhrase = true;
                        break;
                    }
                    case 10009: {
                        this.vn_screen_loc = Accept.this.localVariableNameGet();
                        this.hasAtPhrase = true;
                        break;
                    }
                    case 565: {
                        this.hasLinePhrase = true;
                        this.line = this.lineColumnPhrase(token2);
                        break;
                    }
                    case 334: 
                    case 338: 
                    case 640: 
                    case 641: {
                        this.hasColumnPhrase = true;
                        this.column = this.lineColumnPhrase(token2);
                        break;
                    }
                    default: {
                        throw new UnexpectedTokenException(token2, this.error);
                    }
                }
                token2 = this.tm.getToken();
            }
            while (token2.getToknum() == 498 || token2.getToknum() == 284 || token2.getToknum() == 565 || token2.getToknum() == 334 || token2.getToknum() == 338 || token2.getToknum() == 641 || token2.getToknum() == 640 || token2.getToknum() == 728) {
                if (this.hasAtPhrase && token2.getToknum() != 728) {
                    this.error.print(92, 2, token2, "");
                }
                if (token2.getToknum() == 284 || token2.getToknum() == 498) {
                    token2 = this.tm.getToken();
                }
                switch (token2.getToknum()) {
                    case 565: {
                        if (this.hasLinePhrase) {
                            throw new UnexpectedTokenException(token2, this.error);
                        }
                        this.hasLinePhrase = true;
                        this.line = this.lineColumnPhrase(token2);
                        break;
                    }
                    case 334: 
                    case 338: 
                    case 640: 
                    case 641: {
                        if (this.hasColumnPhrase) {
                            throw new UnexpectedTokenException(token2, this.error);
                        }
                        this.hasColumnPhrase = true;
                        this.column = this.lineColumnPhrase(token2);
                        break;
                    }
                    case 728: {
                        if (this.hasSize) {
                            this.error.print(92, 2, token2, "");
                        }
                        this.hasSize = true;
                        token2 = this.tm.getToken();
                        this.tm.ungetToken();
                        this.length = new Expression(new int[]{0}, this.keyWord, this.parent, this.pc, this.tm, this.error);
                        if (this.length.getType() == 3) break;
                        throw new GeneralErrorException(23, 4, token2, token2.getWord(), this.error);
                    }
                    default: {
                        throw new UnexpectedTokenException(token2, this.error);
                    }
                }
                token2 = this.tm.getToken();
            }
            this.tm.ungetToken();
        }

        Expression lineColumnPhrase(Token token) throws GeneralErrorException, EndOfProgramException {
            Expression expression;
            token = this.tm.getToken();
            if (token.getToknum() != 602) {
                this.tm.ungetToken();
            }
            if ((expression = new Expression(new int[]{0}, this.keyWord, this.parent, this.pc, this.tm, this.error)).getType() != 3) {
                throw new GeneralErrorException(23, 4, token, token.getWord(), this.error);
            }
            return expression;
        }

        @Override
        public String getCode() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("ScrFactory.acceptFromScreen(ScrFactory.getGUIEnviroment(),");
            if (this.hasAtPhrase) {
                if (this.tk_screen_loc != null) {
                    stringBuffer.append(this.getCodeLiteral(this.tk_screen_loc));
                } else {
                    stringBuffer.append(this.vn_screen_loc.getCode());
                }
            } else {
                if (this.hasLinePhrase) {
                    stringBuffer.append(this.line.getCode() + ".intValue()");
                } else {
                    stringBuffer.append("0");
                }
                stringBuffer.append(" , ");
                if (this.hasColumnPhrase) {
                    stringBuffer.append(this.column.getCode() + ".intValue()");
                } else {
                    stringBuffer.append("0");
                }
            }
            stringBuffer.append(" , ");
            if (this.length != null) {
                stringBuffer.append(this.length.getCode() + ".intValue()");
            } else {
                stringBuffer.append(Accept.this.var.getCode() + ".getLength()");
            }
            stringBuffer.append(",");
            return stringBuffer.toString();
        }

        @Override
        public void check() throws GeneralErrorException {
            if (this.line != null) {
                this.line.check();
            }
            if (this.column != null) {
                this.column.check();
            }
            if (this.length != null) {
                this.length.check();
            }
        }
    }
}

