/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.Compute;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.Expression;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.OnSizeError;
import com.iscobol.compiler.OnSizeErrorProvider;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.compiler.Verb;

public class Add
extends Verb
implements CobolToken,
ErrorsNumbers,
OnSizeErrorProvider {
    private TokenList numList = new TokenList();
    private VariableNameList varList = new VariableNameList();
    private VariableNameList varToList = new VariableNameList();
    private VariableNameList varGiving = new VariableNameList();
    private boolean corresponding;
    private boolean corrRounded;
    private boolean giving;
    private OnSizeError ose;

    public Add(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        Token token2 = this.tm.getToken();
        if (token2.getToknum() == 381 || token2.getToknum() == 380) {
            this.addCorr(token2, token, block, pcc, tokenManager, errors);
        } else {
            this.addTo(token2, token, block, pcc, tokenManager, errors);
        }
    }

    private void addTo(Token token, Token token2, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        VariableName variableName;
        VariableName variableName2 = null;
        Token token3 = null;
        block12: while (true) {
            switch (token.getToknum()) {
                case 10001: {
                    if (!token.isNull()) break block12;
                    token.setZero();
                }
                case 10002: 
                case 10017: {
                    this.numList.addItem(token);
                    variableName2 = null;
                    break;
                }
                case 10009: {
                    this.tm.ungetToken();
                    variableName2 = VariableName.getAny(this.tm, this.error, this.parent, this.pc, new GetVarOpts(this, 2));
                    if (variableName2 != null && variableName2.isNumeric() && !variableName2.isEdited()) {
                        this.varList.addItem(variableName2);
                        break;
                    }
                    throw new GeneralErrorException(109, 4, token, token.getWord(), this.error);
                }
                case 702: {
                    if (variableName2 != null) {
                        variableName2.rounded = true;
                        break block12;
                    }
                    throw new UnexpectedTokenException(token, this.error);
                }
                default: {
                    break block12;
                }
            }
            token = this.tm.getToken();
        }
        if (token.getToknum() == 773) {
            block13: while (true) {
                token = this.tm.getToken();
                switch (token.getToknum()) {
                    case 702: {
                        if (variableName2 != null) {
                            variableName2.rounded = true;
                            continue block13;
                        }
                        throw new UnexpectedTokenException(token, this.error);
                    }
                    case 10001: {
                        if (!token.isNull()) break block13;
                        token.setZero();
                    }
                    case 10002: 
                    case 10017: {
                        if (token3 != null) {
                            throw new UnexpectedTokenException(token, this.error);
                        }
                        token3 = token;
                        this.numList.addItem(token3);
                        variableName2 = null;
                        continue block13;
                    }
                    case 10009: {
                        this.tm.ungetToken();
                        variableName2 = VariableName.getAny(this.tm, this.error, this.parent, this.pc, new GetVarOpts(this, 2));
                        if (variableName2 != null && variableName2.isNumeric() && !variableName2.isEdited()) {
                            this.varToList.addItem(variableName2);
                            continue block13;
                        }
                        throw new GeneralErrorException(109, 4, token, token.getWord(), this.error);
                    }
                }
                break;
            }
        }
        if (token.getToknum() == 505) {
            this.giving = true;
            token = this.tm.getToken();
            if (token.getToknum() == 10009) {
                while (token.getToknum() == 10009) {
                    this.tm.ungetToken();
                    variableName2 = VariableName.getAny(this.tm, this.error, this.parent, this.pc, new GetVarOpts(this, 1));
                    if (variableName2 == null || !variableName2.isNumeric()) {
                        throw new GeneralErrorException(109, 4, token, token.getWord(), this.error);
                    }
                    this.varGiving.addItem(variableName2);
                    token = this.tm.getToken();
                    if (token.getToknum() != 702) continue;
                    variableName2.rounded = true;
                    token = this.tm.getToken();
                }
                if (this.varToList.getItemNum() == 1) {
                    this.varList.addItem(this.varToList.getFirst());
                    this.varToList.deleteCurrent();
                } else if (this.varToList.getItemNum() != 0) {
                    throw new GeneralErrorException(11, 4, this.keyWord, this.keyWord.getWord(), this.error);
                }
            } else {
                throw new GeneralErrorException(17, 4, token, token.getWord(), this.error);
            }
            variableName = this.varToList.getFirst();
            while (variableName != null) {
                variableName.setPropTypeGet();
                variableName = this.varToList.getNext();
            }
        } else if (token3 != null) {
            throw new GeneralErrorException(17, 4, token3, token3.getWord(), this.error);
        }
        if (this.varToList.getItemNum() == 0 && this.varGiving.getItemNum() == 0) {
            this.varToList.addItem(this.varList.getLast());
            this.varList.deleteCurrent();
        }
        if (this.varGiving.getItemNum() == 0 && variableName2 == null || this.varList.getItemNum() + this.numList.getItemNum() < 1) {
            throw new GeneralErrorException(11, 4, this.keyWord, this.keyWord.getWord(), this.error);
        }
        variableName = this.varList.getFirst();
        while (variableName != null) {
            variableName.setPropTypeGet();
            variableName = this.varList.getNext();
        }
        if (this.varGiving.getItemNum() == 0) {
            variableName = this.varToList.getFirst();
            while (variableName != null) {
                variableName.checkPropTypeSetGet();
                variableName = this.varToList.getNext();
            }
        }
        this.tm.ungetToken();
        this.ose = new OnSizeError(token2, block, this, pcc, tokenManager, errors);
        token = this.tm.getToken();
        if (token.getToknum() != 424) {
            this.tm.ungetToken();
        } else {
            this.endStmt = true;
        }
    }

    private void addCorr(Token token, Token token2, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        VariableName variableName;
        this.corresponding = true;
        token = this.tm.getToken();
        switch (token.getToknum()) {
            case 10009: {
                this.tm.ungetToken();
                variableName = VariableName.get(this.tm, this.error, this.pc);
                if (variableName != null) {
                    if (variableName.isSetGetProperty()) {
                        throw new GeneralErrorException(75, 4, variableName.getNameToken(), variableName.getNameToken().getWord(), this.error);
                    }
                    this.varList.addItem(variableName);
                    variableName.getVarDecl().setUsedAll();
                    break;
                }
                throw new GeneralErrorException(11, 4, token, token.getWord(), this.error);
            }
            default: {
                throw new GeneralErrorException(11, 4, token, token.getWord(), this.error);
            }
        }
        token = this.tm.getToken();
        if (token.getToknum() != 773) {
            throw new GeneralErrorException(11, 4, token, token.getWord(), this.error);
        }
        token = this.tm.getToken();
        switch (token.getToknum()) {
            case 10009: {
                this.tm.ungetToken();
                variableName = VariableName.get(this.tm, this.error, this.pc);
                if (variableName != null) {
                    if (variableName.isSetGetProperty()) {
                        throw new GeneralErrorException(75, 4, variableName.getNameToken(), variableName.getNameToken().getWord(), this.error);
                    }
                    this.varToList.addItem(variableName);
                    variableName.getVarDecl().setUsedAll();
                    break;
                }
                throw new GeneralErrorException(11, 4, token, token.getWord(), this.error);
            }
            default: {
                throw new GeneralErrorException(11, 4, token, token.getWord(), this.error);
            }
        }
        token = this.tm.getToken();
        switch (token.getToknum()) {
            case 702: {
                variableName.rounded = true;
                this.corrRounded = true;
                break;
            }
            default: {
                this.tm.ungetToken();
            }
        }
        this.ose = new OnSizeError(token2, block, this, pcc, tokenManager, errors);
        token = this.tm.getToken();
        if (token.getToknum() != 424) {
            this.tm.ungetToken();
        } else {
            this.endStmt = true;
        }
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    private String getInitialEvaluation(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.varList.getItemNum() > 0) {
            VariableName variableName = this.varList.getFirst();
            if (bl) {
                int n2;
                stringBuffer.append(variableName.getCode());
                if (variableName.isNumericVar()) {
                    stringBuffer.append(".num().lnUnscValue");
                }
                int n3 = this.varList.getItemNum();
                for (n2 = 1; n2 < n3; ++n2) {
                    variableName = this.varList.getAt(n2);
                    stringBuffer.append(" + ");
                    stringBuffer.append(variableName.getCode());
                    if (!variableName.isNumericVar()) continue;
                    stringBuffer.append(".num().lnUnscValue");
                }
                n3 = this.numList.getItemNum();
                for (n2 = 0; n2 < n3; ++n2) {
                    stringBuffer.append(" + ");
                    stringBuffer.append(Expression.toNum(this.numList.getAt(n2)));
                }
            } else {
                stringBuffer.append(Compute.getCobolNumCode(variableName));
                variableName = this.varList.getNext();
                while (variableName != null) {
                    stringBuffer.append(".add(");
                    stringBuffer.append(Compute.getCobolNumCode(variableName));
                    stringBuffer.append(")");
                    variableName = this.varList.getNext();
                }
                Token token = this.numList.getFirst();
                while (token != null) {
                    stringBuffer.append(".add(");
                    stringBuffer.append(this.getCodeLiteral(token));
                    stringBuffer.append(".num())");
                    token = this.numList.getNext();
                }
            }
        } else if (bl) {
            stringBuffer.append(Expression.toNum(this.numList.getFirst()));
            int n4 = this.numList.getItemNum();
            for (int i2 = 1; i2 < n4; ++i2) {
                stringBuffer.append(" + ");
                stringBuffer.append(Expression.toNum(this.numList.getAt(i2)));
            }
        } else {
            stringBuffer.append(this.getCodeLiteral(this.numList.getFirst()));
            stringBuffer.append(".num()");
            Token token = this.numList.getNext();
            while (token != null) {
                stringBuffer.append(".add(");
                stringBuffer.append(this.getCodeLiteral(token));
                stringBuffer.append(".num())");
                token = this.numList.getNext();
            }
        }
        return stringBuffer.toString();
    }

    boolean isOptimizable() {
        VariableDeclaration variableDeclaration;
        if (!this.ose.hasBlocks() && this.varGiving.getItemNum() == 0 && (this.varList.getItemNum() == 0 && this.numList.getItemNum() == 1 && this.numList.getFirst().getToknum() == 10002 || this.varList.getItemNum() == 1 && this.numList.getItemNum() == 0 && (variableDeclaration = this.varList.getFirst().getVarDecl()).isInteger() && variableDeclaration.getLogicLen() <= 18)) {
            VariableName variableName = this.varToList.getFirst();
            while (variableName != null) {
                variableDeclaration = variableName.getVarDecl();
                if (variableName.rounded && variableDeclaration.getPNumber() != 0 || !variableDeclaration.isInteger() || variableDeclaration.getLogicLen() > 18) {
                    return false;
                }
                variableName = this.varToList.getNext();
            }
            return true;
        }
        return false;
    }

    @Override
    void getCodeCorrEach(StringBuffer stringBuffer, String string, VariableDeclaration variableDeclaration, String string2, VariableDeclaration variableDeclaration2) {
        stringBuffer.append(string2);
        stringBuffer.append(".set(");
        stringBuffer.append(string);
        stringBuffer.append(".num().add(");
        stringBuffer.append(string2);
        stringBuffer.append(".num()),");
        stringBuffer.append(this.corrRounded);
        if (this.ose.hasBlocks()) {
            stringBuffer.append(",true)|");
        } else {
            stringBuffer.append(",false);");
        }
    }

    private boolean canUseNoClone() {
        int n2 = this.varList.getItemNum();
        for (int i2 = 0; i2 < n2; ++i2) {
            VariableDeclaration variableDeclaration = this.varList.getAt(i2).getVarDecl();
            if (variableDeclaration.getDimension() == 0) continue;
            for (int i3 = i2 + 1; i3 < n2; ++i3) {
                VariableDeclaration variableDeclaration2 = this.varList.getAt(i3).getVarDecl();
                if (variableDeclaration != variableDeclaration2) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.corresponding) {
            this.getCodeDebug(stringBuffer);
            stringBuffer.append(this.ose.getCodeBefore());
            this.getCodeCorresponding(stringBuffer, this.varList.getFirst(), this.varToList.getFirst(), true);
            if (this.ose.hasBlocks()) {
                stringBuffer.setLength(stringBuffer.length() - 1);
            } else {
                stringBuffer.append(eol);
            }
            stringBuffer.append(this.ose.getCode());
        } else if (this.isOptimizable()) {
            VariableName variableName = this.varList.getFirst();
            Token token = this.numList.getFirst();
            this.getCodeDebug(stringBuffer);
            VariableName variableName2 = this.varToList.getFirst();
            while (variableName2 != null) {
                stringBuffer.append(this.parent.getIndent());
                stringBuffer.append(variableName2.getCode(true));
                stringBuffer.append(".addToMe(");
                if (token != null) {
                    stringBuffer.append(token.getAsLong());
                } else {
                    stringBuffer.append(variableName.getCode(variableName2.getVarDecl() != variableName.getVarDecl()));
                    stringBuffer.append(".tolong()");
                }
                stringBuffer.append(");");
                stringBuffer.append(eol);
                variableName2 = this.varToList.getNext();
            }
        } else {
            VariableName variableName;
            String string;
            int n2;
            boolean bl = this.canUseNoClone();
            VariableNameList variableNameList = this.varGiving.getItemNum() > 0 ? this.varGiving : this.varToList;
            boolean bl2 = true;
            int n3 = this.varList.getItemNum();
            for (n2 = 0; n2 < n3 && bl2; bl2 &= Expression.couldBeNativeInt(this.varList.getAt(n2).getVarDecl()), ++n2) {
            }
            if (bl2) {
                Token token;
                n3 = this.numList.getItemNum();
                for (n2 = 0; n2 < n3 && bl2; bl2 &= Expression.couldBeNativeInt(token), ++n2) {
                    token = this.numList.getAt(n2);
                }
            }
            if (variableNameList.getItemNum() > 1) {
                string = "add$" + Add.getUniqueId();
                stringBuffer.append(this.parent.getIndent());
                if (bl2) {
                    stringBuffer.append("long ");
                } else {
                    stringBuffer.append("CobolNum ");
                }
                stringBuffer.append(string);
                stringBuffer.append("=");
                stringBuffer.append(this.getInitialEvaluation(bl2));
                stringBuffer.append(";");
                stringBuffer.append(eol);
            } else {
                string = this.getInitialEvaluation(bl2);
            }
            stringBuffer.append(this.parent.getIndent());
            this.getCodeDebug(stringBuffer);
            VariableNameList variableNameList2 = new VariableNameList();
            int n4 = 0;
            while (n4 < variableNameList.getItemNum()) {
                variableName = variableNameList.getAt(n4);
                if (variableName.isPrimitive()) {
                    variableNameList2.addItem(variableName);
                    variableNameList.deleteCurrent();
                    continue;
                }
                ++n4;
            }
            n3 = variableNameList2.getItemNum();
            for (n4 = 0; n4 < n3; ++n4) {
                String string2;
                variableName = variableNameList2.getAt(n4);
                stringBuffer.append(variableName.getCode());
                String string3 = variableName.getType().getName(true);
                stringBuffer.append(" = ");
                if (this.giving) {
                    if (bl2) {
                        stringBuffer.append(Compute.addCast(string3, string));
                    } else {
                        stringBuffer.append(Compute.getConversionMethod(string3, string));
                    }
                } else if (Expression.couldBeNativeInt(variableName.getVarDecl())) {
                    if (bl2) {
                        string2 = string + " + " + variableName.getCode();
                        stringBuffer.append(Compute.addCast(string3, string2));
                    } else {
                        stringBuffer.append(Compute.getConversionMethod(string3, string + ".add(CobolNum.noo((long) " + variableName.getCode() + ", 0))"));
                    }
                } else if (bl2) {
                    string2 = string + " + ";
                    string2 = variableName.isNumericVar() ? string2 + variableName.getCode(bl) + ".tolong()" : string2 + variableName.getCode(bl);
                    stringBuffer.append(Compute.addCast(string3, string2));
                } else {
                    string2 = string + ".add(";
                    string2 = variableName.isNumericVar() ? string2 + variableName.getCode(bl) + ".num())" : string2 + "CobolNum.noo((double) " + variableName.getCode(bl) + "))";
                    stringBuffer.append(Compute.getConversionMethod(string3, string2));
                }
                stringBuffer.append(";");
                if (n4 >= n3 - 1) continue;
                stringBuffer.append(eol);
                stringBuffer.append(this.parent.getIndent());
            }
            n3 = variableNameList.getItemNum();
            if (n3 > 0) {
                if (variableNameList2.getItemNum() > 0) {
                    stringBuffer.append(eol);
                    stringBuffer.append(this.parent.getIndent());
                }
                stringBuffer.append(this.ose.getCodeBefore());
                for (n4 = 0; n4 < n3; ++n4) {
                    variableName = variableNameList.getAt(n4);
                    stringBuffer.append(variableName.getCode(bl));
                    stringBuffer.append(".set(");
                    if (this.giving) {
                        stringBuffer.append(string);
                        if (bl2) {
                            stringBuffer.append(",0");
                        }
                    } else {
                        if (bl2) {
                            stringBuffer.append("CobolNum.noo(");
                            stringBuffer.append(string);
                            stringBuffer.append(",0)");
                        } else {
                            stringBuffer.append(string);
                        }
                        stringBuffer.append(".add(");
                        stringBuffer.append(variableName.getCode(bl));
                        stringBuffer.append(".num())");
                    }
                    stringBuffer.append(",");
                    stringBuffer.append(variableName.rounded);
                    stringBuffer.append(",");
                    stringBuffer.append(this.ose.hasBlocks());
                    stringBuffer.append(")");
                    if (n4 >= n3 - 1) break;
                    stringBuffer.append(this.ose.hasBlocks() ? "|" : ";");
                }
                stringBuffer.append(this.ose.getCode());
            }
        }
        stringBuffer.append(eol);
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }

    public TokenList getNumList() {
        return this.numList;
    }

    public VariableNameList getVarList() {
        return this.varList;
    }

    public VariableNameList getVarToList() {
        return this.varToList;
    }

    public VariableNameList getVarGiving() {
        return this.varGiving;
    }

    public boolean isCorresponding() {
        return this.corresponding;
    }

    @Override
    public OnSizeError getOnSizeError() {
        return this.ose;
    }
}

