/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.interfaces.compiler.IAlphabet;
import com.iscobol.interfaces.compiler.IAlphabetItem;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Alphabet
implements CobolToken,
ErrorsNumbers,
IAlphabet {
    private static final int[] ALPHABET_EBCDIC_I = new int[]{0, 1, 2, 3, 55, 45, 46, 47, 22, 5, 37, 11, 12, 13, 14, 15, 16, 20, 36, 4, 21, 61, 50, 38, 24, 25, 63, 39, 28, 29, 30, 31, 64, 79, 127, 123, 91, 108, 80, 125, 77, 93, 92, 78, 107, 96, 75, 97, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 122, 94, 76, 126, 110, 111, 124, 193, 194, 195, 196, 197, 198, 199, 200, 201, 209, 210, 211, 212, 213, 214, 215, 216, 217, 226, 227, 228, 229, 230, 231, 232, 233, 74, 224, 90, 95, 109, 121, 129, 130, 131, 132, 133, 134, 135, 136, 137, 145, 146, 147, 148, 149, 150, 151, 152, 153, 162, 163, 164, 165, 166, 167, 168, 169, 192, 106, 208, 161, 7, 6, 8, 9, 10, 17, 18, 19, 23, 26, 27, 32, 33, 34, 35, 40, 41, 42, 43, 44, 48, 49, 51, 52, 53, 54, 56, 57, 58, 59, 60, 62, 65, 66, 67, 68, 69, 70, 71, 72, 73, 81, 82, 83, 84, 85, 86, 87, 88, 89, 98, 99, 100, 101, 102, 103, 104, 105, 112, 113, 114, 115, 116, 117, 118, 119, 120, 128, 138, 139, 140, 141, 142, 143, 144, 154, 155, 156, 157, 158, 159, 160, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 202, 203, 204, 205, 206, 207, 218, 219, 220, 221, 222, 223, 225, 234, 235, 236, 237, 238, 239, 250, 251, 252, 253, 254, 255};
    private int[] collSeq = new int[256];
    private int highValue;
    private int lowValue = -1;
    private Token name;
    private String predefinedAlphabetName;
    private List items;
    private final String charsetName = Alphabet.getCharsetName();

    public Alphabet(Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        Token token;
        boolean bl;
        int n2 = 0;
        Arrays.fill(this.collSeq, -1);
        boolean bl2 = bl = !pcc.getRoot().getGenerateCode();
        if (bl) {
            this.items = new ArrayList();
        }
        if ((token = tokenManager.getToken()).getToknum() == 10009) {
            int n3;
            this.name = token;
            token = tokenManager.getToken();
            if (token.getToknum() == 494) {
                token = tokenManager.getToken();
            }
            if (token.getToknum() == 269) {
                token = tokenManager.getToken();
            }
            if (token.getToknum() == 545) {
                token = tokenManager.getToken();
            }
            if (token.getToknum() == 10009 || token.getToknum() == 740) {
                if (token.getWord().equals("EBCDIC") || token.getWord().equals("ASCII") || token.getWord().equals("STANDARD-1") || token.getWord().equals("STANDARD-2") || token.getWord().equals("NATIVE")) {
                    this.predefinedAlphabetName = token.getWord();
                    if (token.getWord().equals("EBCDIC")) {
                        for (int i2 = 0; i2 < this.collSeq.length; ++i2) {
                            this.collSeq[i2] = ALPHABET_EBCDIC_I[i2];
                        }
                    } else {
                        for (int i3 = 0; i3 < this.collSeq.length; ++i3) {
                            this.collSeq[i3] = i3;
                        }
                    }
                } else {
                    throw new GeneralErrorException(15, 4, token, token.getWord(), errors);
                }
                this.highValue = 255;
                this.lowValue = 0;
                return;
            }
            if (token.getToknum() != 10002 && token.getToknum() != 10001) {
                throw new GeneralErrorException(15, 4, token, token.getWord(), errors);
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            while (token.getToknum() == 10002 || token.getToknum() == 10001) {
                int n4;
                Token token2 = tokenManager.getToken();
                if (token2.getToknum() == 768 || token2.getToknum() == 767 || token2.getToknum() == 271) {
                    Token token3 = tokenManager.getToken();
                    if (token3.getToknum() == 10002 || token3.getToknum() == 10001) {
                        int n5;
                        byte[] byArray;
                        if (token.getToknum() == 10001) {
                            byArray = this.getBytes(token);
                            if (byArray.length > 1) {
                                throw new GeneralErrorException(15, 4, token, token.getWord(), errors);
                            }
                            n4 = byArray[0] & 0xFF;
                        } else {
                            n4 = Integer.parseInt(token.getWord()) - 1;
                        }
                        if (n4 < 0 || n4 >= this.collSeq.length) {
                            throw new GeneralErrorException(30, 4, token, token.getWord(), errors);
                        }
                        if (this.collSeq[n4] != -1) {
                            throw new GeneralErrorException(143, 4, token, "" + n4, errors);
                        }
                        this.setPos(n4, n2);
                        if (bl) {
                            arrayList.add(this.getValue(token));
                        }
                        if (token3.getToknum() == 10001) {
                            byArray = this.getBytes(token3);
                            if (byArray.length > 1) {
                                throw new GeneralErrorException(15, 4, token3, token3.getWord(), errors);
                            }
                            n5 = byArray[0] & 0xFF;
                        } else {
                            n5 = Integer.parseInt(token3.getWord()) - 1;
                        }
                        if (n5 < 0 || n5 >= this.collSeq.length) {
                            throw new GeneralErrorException(30, 4, token3, token3.getWord(), errors);
                        }
                        if (token2.getToknum() == 271) {
                            if (this.collSeq[n5] != -1) {
                                throw new GeneralErrorException(143, 4, token3, "" + n5, errors);
                            }
                            this.setPos(n5, n2);
                            if (bl) {
                                arrayList.add(this.getValue(token3));
                            }
                            int n6 = n2 + 2;
                            while (tokenManager.getToken().getToknum() == 271) {
                                token3 = tokenManager.getToken();
                                if (token3.getToknum() == 10001) {
                                    byte[] byArray2 = this.getBytes(token3);
                                    if (byArray2.length > 1) {
                                        throw new GeneralErrorException(15, 4, token3, token3.getWord(), errors);
                                    }
                                    n5 = byArray2[0] & 0xFF;
                                } else {
                                    n5 = Integer.parseInt(token3.getWord()) - 1;
                                }
                                if (n5 < 0 || n5 >= this.collSeq.length) {
                                    throw new GeneralErrorException(30, 4, token3, token3.getWord(), errors);
                                }
                                if (this.collSeq[n5] != -1) {
                                    throw new GeneralErrorException(143, 4, token3, "" + n5, errors);
                                }
                                this.setPos(n5, n2);
                                if (bl) {
                                    arrayList.add(this.getValue(token3));
                                }
                                ++n6;
                            }
                            if (bl) {
                                this.items.add(new Item(1, arrayList));
                                arrayList = new ArrayList();
                            }
                            n2 = n6;
                            tokenManager.ungetToken();
                        } else {
                            this.collSeq[n4] = -1;
                            if (n4 > n5) {
                                for (n3 = n4; n3 >= n5 && n2 < this.collSeq.length; ++n2, --n3) {
                                    if (this.collSeq[n3] != -1) {
                                        throw new GeneralErrorException(143, 4, token3, "" + n3, errors);
                                    }
                                    this.setPos(n3, n2);
                                }
                            } else {
                                for (n3 = n4; n3 <= n5 && n2 < this.collSeq.length; ++n2, ++n3) {
                                    if (this.collSeq[n3] != -1) {
                                        throw new GeneralErrorException(143, 4, token3, "" + n3, errors);
                                    }
                                    this.setPos(n3, n2);
                                }
                            }
                            if (bl) {
                                arrayList.add(this.getValue(token3));
                                this.items.add(new Item(2, arrayList));
                                arrayList = new ArrayList();
                            }
                        }
                        token = tokenManager.getToken();
                        continue;
                    }
                    throw new GeneralErrorException(15, 4, token3, token3.getWord(), errors);
                }
                if (token.getToknum() == 10001) {
                    byte[] byArray = this.getBytes(token);
                    for (n3 = 0; n3 < byArray.length; ++n3) {
                        if (this.collSeq[byArray[n3] & 0xFF] != -1) {
                            throw new GeneralErrorException(143, 4, token, "" + (byArray[n3] & 0xFF), errors);
                        }
                        this.setPos(byArray[n3] & 0xFF, n2++);
                    }
                } else {
                    n4 = Integer.parseInt(token.getWord()) - 1;
                    if (n4 < 0 || n4 >= this.collSeq.length) {
                        throw new GeneralErrorException(30, 4, token, token.getWord(), errors);
                    }
                    if (this.collSeq[n4] != -1) {
                        throw new GeneralErrorException(143, 4, token, "" + n4, errors);
                    }
                    this.setPos(n4, n2++);
                }
                if (bl) {
                    arrayList.add(this.getValue(token));
                    this.items.add(new Item(0, arrayList));
                    arrayList = new ArrayList();
                }
                token = token2;
            }
            tokenManager.ungetToken();
            if (n2 > this.collSeq.length) {
                throw new GeneralErrorException(30, 4, this.name, this.name.getWord(), errors);
            }
            for (n3 = 0; n3 < this.collSeq.length; ++n3) {
                if (this.collSeq[n3] != -1) continue;
                this.setPos(n3, n2++);
            }
        } else {
            throw new GeneralErrorException(17, 4, token, token.getWord(), errors);
        }
    }

    private static String getCharsetName() {
        try {
            return Charset.forName(System.getProperty("file.encoding")).name();
        }
        catch (Exception exception) {
            return Charset.defaultCharset().name();
        }
    }

    private byte[] getBytes(Token token) {
        String string = token.getWord();
        string = string.substring(1, string.length() - 1);
        if (token.isFigurative()) {
            return new byte[]{(byte)string.toCharArray()[0]};
        }
        try {
            return string.getBytes(this.charsetName);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string.getBytes();
        }
    }

    private Object getValue(Token token) {
        if (token.getToknum() == 10001) {
            return token.getWord().substring(1, token.getWord().length() - 1);
        }
        return new Integer(Integer.parseInt(token.getWord()));
    }

    private void setPos(int n2, int n3) {
        this.collSeq[n2] = n3;
        if (this.lowValue == -1) {
            this.lowValue = n2;
        }
        this.highValue = n2;
    }

    @Override
    public Token getName() {
        return this.name;
    }

    protected String getDeclUnivoqueName() {
        String string = "___ALPH_" + this.name.getWord();
        return string.replace('-', Pcc.hyphenRepl);
    }

    protected String getDeclUnivoqueNameBytes() {
        String string = "___ALPH_" + this.name.getWord() + "_bytes";
        return string.replace('-', Pcc.hyphenRepl);
    }

    protected int getLowValue() {
        return this.lowValue;
    }

    protected int getHighValue() {
        return this.highValue;
    }

    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("new int[] {");
        stringBuffer.append(this.collSeq[0]);
        for (int i2 = 1; i2 < this.collSeq.length; ++i2) {
            stringBuffer.append(',');
            stringBuffer.append(this.collSeq[i2]);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public String getCodeBytes() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("new byte[] {");
        stringBuffer.append((byte)this.collSeq[0]);
        for (int i2 = 1; i2 < this.collSeq.length; ++i2) {
            stringBuffer.append(',');
            stringBuffer.append((byte)this.collSeq[i2]);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    @Override
    public int[] getCollatingSequence() {
        return this.collSeq;
    }

    @Override
    public String getPredefinedAlphabetName() {
        return this.predefinedAlphabetName;
    }

    @Override
    public List getItems() {
        return this.items;
    }

    public static class Item
    implements IAlphabetItem {
        public static final int SINGLE = 0;
        public static final int ALSO = 1;
        public static final int THROUGH = 2;
        private int type;
        private List values;

        Item(int n2, List list) {
            this.type = n2;
            this.values = list;
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public List getValues() {
            return this.values;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            switch (this.type) {
                case 0: {
                    stringBuffer.append("SINGLE: ");
                    break;
                }
                case 1: {
                    stringBuffer.append("ALSO: ");
                    break;
                }
                case 2: {
                    stringBuffer.append("THROUGH: ");
                }
            }
            stringBuffer.append(this.values.get(0));
            for (int i2 = 1; i2 < this.values.size(); ++i2) {
                stringBuffer.append(",").append(this.values.get(i2));
            }
            return stringBuffer.toString();
        }
    }
}

