/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolProgram;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Goto;
import com.iscobol.compiler.LabelName;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.Verb;
import com.iscobol.compiler.VerbList;
import java.util.ArrayList;
import java.util.List;

public class Alter
extends Verb
implements CobolToken,
ErrorsNumbers {
    private final List alterElements;

    public Alter(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        LabelName labelName;
        if (!(this.pc instanceof CobolProgram)) {
            throw new GeneralErrorException(194, 4, this.keyWord, null, this.error);
        }
        this.error.print(194, 1, token, null);
        this.alterElements = new ArrayList();
        while ((labelName = LabelName.get(this.parent, this.tm, this.error, this.pc)) != null) {
            LabelName labelName2;
            if (this.tm.getToken().getToknum() != 773) {
                this.tm.ungetToken();
            }
            if (this.tm.getToken().getToknum() == 650) {
                if (this.tm.getToken().getToknum() != 773) {
                    this.tm.ungetToken();
                }
            } else {
                this.tm.ungetToken();
            }
            if ((labelName2 = LabelName.get(this.parent, this.tm, this.error, this.pc)) == null) {
                throw new GeneralErrorException(144, 4, this.keyWord, labelName.toString(), this.error);
            }
            this.alterElements.add(new AlterElement(labelName, labelName2));
        }
    }

    @Override
    public void check() throws GeneralErrorException {
        for (AlterElement alterElement : this.alterElements) {
            LabelName labelName = alterElement.getThingToAlter();
            LabelName labelName2 = alterElement.getNewTarget();
            labelName.check();
            labelName2.check();
            VerbList verbList = labelName.getParagraph().getBlock().getVerbs();
            if (verbList.getItemNum() != 1) {
                throw new GeneralErrorException(315, 4, this.keyWord, labelName.getParagraph().getName(), this.error);
            }
            Verb verb = verbList.getFirst();
            if (!(verb instanceof Goto)) {
                throw new GeneralErrorException(315, 4, this.keyWord, labelName.getParagraph().getName(), this.error);
            }
            alterElement.theGoto = (Goto)verb;
            if (alterElement.theGoto.getDepending() != null) {
                throw new GeneralErrorException(315, 4, this.keyWord, labelName.getParagraph().getName(), this.error);
            }
            alterElement.theGoto.setVariableTarget();
        }
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this.tm.getOptionList().getOption("-d") != null;
        stringBuffer.append(this.parent.getIndent());
        this.getCodeDebug(stringBuffer);
        for (AlterElement alterElement : this.alterElements) {
            stringBuffer.append(eol);
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append(alterElement.theGoto.getAlterVarName());
            stringBuffer.append("=");
            stringBuffer.append(alterElement.newTarget.getParIdNumber());
            stringBuffer.append(";");
        }
        stringBuffer.append(eol);
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }

    public List getAlterElements() {
        return this.alterElements;
    }

    public static class AlterElement {
        private final LabelName thingToAlter;
        private final LabelName newTarget;
        private Goto theGoto;

        public AlterElement(LabelName labelName, LabelName labelName2) {
            this.thingToAlter = labelName;
            this.newTarget = labelName2;
        }

        public LabelName getThingToAlter() {
            return this.thingToAlter;
        }

        public LabelName getNewTarget() {
            return this.newTarget;
        }
    }
}

