/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GenericObject;
import com.iscobol.compiler.MissingClassException;
import com.iscobol.compiler.MyClass;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;

public class As
extends Verb
implements CobolToken,
ErrorsNumbers {
    static final int NULL = 0;
    static final int STRING = 1;
    static final int BOOLEAN = 2;
    static final int BYTE = 3;
    static final int CHAR = 4;
    static final int SHORT = 5;
    static final int INT = 6;
    static final int LONG = 7;
    static final int FLOAT = 8;
    static final int DOUBLE = 9;
    static final int OBJECT = 10;
    static final int BYTE_ARRAY = 11;
    static final int COBOLVAR = 12;
    static final String[] DESC = new String[]{"null", "java.lang.String", "boolean", "byte", "char", "short", "int", "long", "float", "double", "java.lang.Object", "byte[]", "com.iscobol.types.CobolVar"};
    int asType;
    String as;
    GenericObject nameObj;

    public As(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors, GenericObject genericObject) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        this.nameObj = genericObject;
        Token token2 = this.tm.getToken();
        String string = token2.getWord();
        if ("STRING".equalsIgnoreCase(string) || "\"java.lang.String\"".equals(string)) {
            this.asType = 1;
            this.as = "java.lang.String";
        } else if ("BOOLEAN".equalsIgnoreCase(string) || "\"boolean\"".equals(string)) {
            this.asType = 2;
            this.as = "boolean";
        } else if ("BYTE".equalsIgnoreCase(string) || "\"byte\"".equals(string)) {
            this.as = "byte";
            this.asType = 3;
        } else if ("CHAR".equalsIgnoreCase(string) || "\"char\"".equals(string)) {
            this.as = "char";
            this.asType = 4;
        } else if ("SHORT".equalsIgnoreCase(string) || "\"short\"".equals(string)) {
            this.asType = 5;
            this.as = "short";
        } else if ("INT".equalsIgnoreCase(string) || "\"int\"".equals(string)) {
            this.as = "int";
            this.asType = 6;
        } else if ("LONG".equalsIgnoreCase(string) || "\"long\"".equals(string)) {
            this.as = "long";
            this.asType = 7;
        } else if ("FLOAT".equalsIgnoreCase(string) || "\"float\"".equals(string)) {
            this.as = "float";
            this.asType = 8;
        } else if ("DOUBLE".equalsIgnoreCase(string) || "\"double\"".equals(string)) {
            this.as = "double";
            this.asType = 9;
        } else if ("BYTES".equalsIgnoreCase(string)) {
            this.as = "byte[]";
            this.asType = 11;
        } else {
            if (token2.getToknum() == 10001) {
                this.as = token2.getWord().substring(1, token2.getWord().length() - 1);
            } else {
                this.tm.ungetToken();
                VariableName variableName = VariableName.getObject(this.tm, this.error, this.parent, this.pc);
                if (variableName == null || !variableName.getVarDecl().isFactory) {
                    throw new MissingClassException(token2.getWord(), token2, this.error);
                }
                this.as = variableName.getVarDecl().getTypeName();
            }
            this.asType = 10;
        }
    }

    MyClass getType() {
        switch (this.asType) {
            case 1: {
                return MyClass.getInstance(String.class);
            }
            case 2: {
                return MyClass.getInstance(Boolean.TYPE);
            }
            case 3: {
                return MyClass.getInstance(Byte.TYPE);
            }
            case 4: {
                return MyClass.getInstance(Character.TYPE);
            }
            case 5: {
                return MyClass.getInstance(Short.TYPE);
            }
            case 6: {
                return MyClass.getInstance(Integer.TYPE);
            }
            case 7: {
                return MyClass.getInstance(Long.TYPE);
            }
            case 8: {
                return MyClass.getInstance(Float.TYPE);
            }
            case 9: {
                return MyClass.getInstance(Double.TYPE);
            }
            case 11: {
                return MyClass.getInstance(byte[].class);
            }
            case 12: {
                this.as = Pcc.TYPES_PACKAGE + ".CobolVar";
            }
            case 10: {
                try {
                    if (this.as != null) {
                        return this.pc.existsClass(this.as);
                    }
                    return MyClass.getInstance(Pcc.TYPES_PACKAGE + ".CobolVar");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
            }
        }
        return null;
    }

    @Override
    public void check() throws GeneralErrorException {
        if (this.nameObj != null) {
            this.nameObj.check();
            try {
                MyClass myClass = this.nameObj.getCType();
                MyClass myClass2 = this.pc.existsClass(this.as);
                if (!myClass2.isAssignableTo(myClass, false) && !myClass.isAssignableTo(myClass2, false)) {
                    throw new GeneralErrorException(80, 4, this.keyWord, this.keyWord.getWord(), this.error);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new MissingClassException(classNotFoundException.getMessage(), this.keyWord, this.error);
            }
        }
    }

    boolean isPrimitiveOrString() {
        switch (this.asType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getCode() {
        return "(" + this.as + ")";
    }
}

