/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.Condition;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.IllegalConditionException;
import com.iscobol.compiler.MyClass;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;
import java.util.ArrayList;

public class Assert
extends Verb
implements CobolToken,
ErrorsNumbers {
    private Condition cond;
    private ArrayList args = new ArrayList();

    public Assert(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        this.cond = new Condition(this.keyWord, this.parent, this.pc, this.tm, this.error);
        if (!this.cond.isFullCondition()) {
            throw new IllegalConditionException(this.keyWord, this.error);
        }
        Token token2 = this.tm.getToken();
        if (token2.getToknum() != 622) {
            throw new ExpectedFoundException(token2, this.error, "OTHERWISE");
        }
        token2 = this.tm.getToken();
        block4: while (true) {
            switch (token2.getToknum()) {
                case 10001: 
                case 10002: 
                case 10017: 
                case 10022: {
                    this.args.add(token2);
                    break;
                }
                case 10009: {
                    this.tm.ungetToken();
                    VariableName variableName = VariableName.getAny(this.tm, this.error, this.parent, this.pc);
                    MyClass myClass = variableName.getType();
                    if (myClass != null && myClass.getName().equals("void")) {
                        throw new GeneralErrorException(149, 4, this.keyWord, variableName.getName(), this.error);
                    }
                    this.args.add(variableName);
                    break;
                }
                default: {
                    this.tm.ungetToken();
                    break block4;
                }
            }
            token2 = this.tm.getToken();
        }
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.parent.getIndent());
        this.getCodeDebug(stringBuffer);
        stringBuffer.append("assert ");
        stringBuffer.append(this.cond.getCode());
        stringBuffer.append(": \"\"");
        for (Object e2 : this.args) {
            stringBuffer.append("+");
            if (e2 instanceof Token) {
                stringBuffer.append(this.getCodeLiteral((Token)e2));
                continue;
            }
            stringBuffer.append(((VariableName)e2).getCode());
        }
        stringBuffer.append(";");
        stringBuffer.append(eol);
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }

    @Override
    public void check() throws GeneralErrorException {
    }
}

