/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Accept;
import com.iscobol.compiler.Add;
import com.iscobol.compiler.Alter;
import com.iscobol.compiler.Assert;
import com.iscobol.compiler.BlockException;
import com.iscobol.compiler.Call;
import com.iscobol.compiler.Cancel;
import com.iscobol.compiler.Chain;
import com.iscobol.compiler.Close;
import com.iscobol.compiler.CobolMethod;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.Commit;
import com.iscobol.compiler.Compute;
import com.iscobol.compiler.Continue;
import com.iscobol.compiler.DeferredBlock;
import com.iscobol.compiler.Delete;
import com.iscobol.compiler.Destroy;
import com.iscobol.compiler.Display;
import com.iscobol.compiler.Divide;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Entry;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.Evaluate;
import com.iscobol.compiler.EvaluateSuObject;
import com.iscobol.compiler.Examine;
import com.iscobol.compiler.Exec;
import com.iscobol.compiler.Exhibit;
import com.iscobol.compiler.Exit;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Generate;
import com.iscobol.compiler.Goback;
import com.iscobol.compiler.Goto;
import com.iscobol.compiler.If;
import com.iscobol.compiler.Initialize;
import com.iscobol.compiler.Initiate;
import com.iscobol.compiler.InlineInvoke;
import com.iscobol.compiler.Inquire;
import com.iscobol.compiler.Inspect;
import com.iscobol.compiler.Invoke;
import com.iscobol.compiler.Json;
import com.iscobol.compiler.Modify;
import com.iscobol.compiler.Move;
import com.iscobol.compiler.Multiply;
import com.iscobol.compiler.MyClass;
import com.iscobol.compiler.NextSentence;
import com.iscobol.compiler.NextSentenceBlock;
import com.iscobol.compiler.Note;
import com.iscobol.compiler.On;
import com.iscobol.compiler.Open;
import com.iscobol.compiler.Paragraph;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Perform;
import com.iscobol.compiler.Raise;
import com.iscobol.compiler.Read;
import com.iscobol.compiler.Receive;
import com.iscobol.compiler.Release;
import com.iscobol.compiler.Resume;
import com.iscobol.compiler.Return;
import com.iscobol.compiler.Rewrite;
import com.iscobol.compiler.Rollback;
import com.iscobol.compiler.Search;
import com.iscobol.compiler.Send;
import com.iscobol.compiler.Service;
import com.iscobol.compiler.Set;
import com.iscobol.compiler.Sort;
import com.iscobol.compiler.Start;
import com.iscobol.compiler.Stop;
import com.iscobol.compiler.Strings;
import com.iscobol.compiler.Subtract;
import com.iscobol.compiler.Suppress;
import com.iscobol.compiler.Synchronized;
import com.iscobol.compiler.Terminate;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.Transform;
import com.iscobol.compiler.Try;
import com.iscobol.compiler.Unlock;
import com.iscobol.compiler.Unstring;
import com.iscobol.compiler.Use;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.compiler.Verb;
import com.iscobol.compiler.VerbList;
import com.iscobol.compiler.Wait;
import com.iscobol.compiler.Write;
import com.iscobol.compiler.Xml;
import com.iscobol.compiler.Yield;
import com.iscobol.interfaces.compiler.IBlock;
import com.iscobol.interfaces.compiler.VerbNotifier;
import com.iscobol.interfaces.compiler.VerbNotifierExt;
import java.util.Vector;

public class Block
implements CobolToken,
ErrorsNumbers,
IBlock {
    static final int TYPE_NORMAL = 0;
    static final int TYPE_ON_EXCEPTION = 1;
    static final int TYPE_NOT_ON_EXCEPTION = 2;
    static final int TYPE_ON_SIZE_ERROR = 3;
    static final int TYPE_NOT_ON_SIZE_ERROR = 4;
    static final int TYPE_AT_END = 5;
    static final int TYPE_NOT_AT_END = 6;
    static final int TYPE_INVALID_KEY = 7;
    static final int TYPE_NOT_INVALID_KEY = 8;
    static final int TYPE_ON_OVERFLOW = 9;
    static final int TYPE_NOT_ON_OVERFLOW = 10;
    static final int TYPE_END_OF_PAGE = 11;
    static final int TYPE_NOT_END_OF_PAGE = 12;
    private static final String EXCEPT_NAME = "ex$";
    static final String spc = "                                                                                ";
    private static int prog;
    private TokenManager tm;
    private Errors error;
    private Pcc pc;
    private String exceptName = null;
    private Vector catchBlocks = new Vector();
    private VariableNameList raising;
    private Vector children = new Vector();
    private String name;
    private boolean loop;
    private boolean paragraphBlock;
    private int blockType;
    private boolean endRequired;
    VerbList verbs = new VerbList();
    Paragraph parent;
    Verb parentVerb;
    EvaluateSuObject parentSuObj;
    private Block pb;
    private NextSentenceBlock ns;
    int nesting;
    final boolean nextSentAllowed;
    final boolean debug;
    final boolean pt0_2;

    public Block(Block block, Paragraph paragraph, Verb verb, Pcc pcc, TokenManager tokenManager, Errors errors, int n2) throws GeneralErrorException, EndOfProgramException {
        this(paragraph, verb, pcc, tokenManager, errors);
        this.pb = block;
        this.parse(n2);
    }

    public Block(Paragraph paragraph, Verb verb, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        this.pc = pcc;
        this.tm = tokenManager;
        this.error = errors;
        this.parent = paragraph;
        this.parentVerb = verb;
        if (this.parentVerb != null) {
            this.parentVerb.nestedBlocks.addElement(this);
        }
        this.pc.addBlock(this);
        if (this.pb != null) {
            this.pb.children.addElement(this);
        }
        this.nextSentAllowed = this.pc.getOption("-cm") != null || this.pc.getOption("-cr") != null || this.pc.getOption("-ca") != null;
        this.debug = this.pc.getOption("-d") != null;
        this.pt0_2 = this.pc.getOption("-pt0") != null || this.pc.getOption("-pt2") != null;
    }

    public Block(Block block, Paragraph paragraph, Verb verb, Pcc pcc, TokenManager tokenManager, Errors errors, int n2, int n3) throws GeneralErrorException, EndOfProgramException {
        this(paragraph, verb, pcc, tokenManager, errors);
        this.pb = block;
        this.blockType = n3;
        if (this.pb.getBlockType() != 0) {
            switch (n3) {
                case 0: {
                    break;
                }
                case 1: {
                    if (this.pb.getBlockType() != 2) break;
                    this.endRequired = true;
                    break;
                }
                case 2: {
                    if (this.pb.getBlockType() != 1) break;
                    this.endRequired = true;
                    break;
                }
                case 3: {
                    if (this.pb.getBlockType() != 4) break;
                    this.endRequired = true;
                    break;
                }
                case 4: {
                    if (this.pb.getBlockType() != 3) break;
                    this.endRequired = true;
                    break;
                }
                case 5: {
                    if (this.pb.getBlockType() != 6) break;
                    this.endRequired = true;
                    break;
                }
                case 6: {
                    if (this.pb.getBlockType() != 5) break;
                    this.endRequired = true;
                    break;
                }
                case 7: {
                    if (this.pb.getBlockType() != 8) break;
                    this.endRequired = true;
                    break;
                }
                case 8: {
                    if (this.pb.getBlockType() != 7) break;
                    this.endRequired = true;
                    break;
                }
                case 9: {
                    if (this.pb.getBlockType() != 10) break;
                    this.endRequired = true;
                    break;
                }
                case 10: {
                    if (this.pb.getBlockType() != 9) break;
                    this.endRequired = true;
                    break;
                }
                case 11: {
                    if (this.pb.getBlockType() != 12) break;
                    this.endRequired = true;
                    break;
                }
                case 12: {
                    if (this.pb.getBlockType() != 11) break;
                    this.endRequired = true;
                }
            }
        }
        this.parse(n2);
    }

    public Block(Block block, Paragraph paragraph, Verb verb, Pcc pcc, TokenManager tokenManager, Errors errors, int n2, boolean bl) throws GeneralErrorException, EndOfProgramException {
        this(block, paragraph, verb, pcc, tokenManager, errors, n2);
        this.loop = true;
        if (bl) {
            this.name = "blk$" + prog++;
        }
    }

    public String getIndent() {
        int n2 = 6 + this.nesting * 3;
        if (n2 < spc.length()) {
            return spc.substring(0, n2);
        }
        return spc;
    }

    public int getBlockType() {
        return this.blockType;
    }

    private void verbsAddItem(Verb verb) throws EndOfProgramException, GeneralErrorException {
        if (this.ns != null) {
            this.verbs.addItem(this.ns);
        }
        this.verbs.addItem(verb);
        VerbNotifier verbNotifier = Pcc.getVerbNotifier();
        if (verbNotifier != null) {
            boolean bl = true;
            if (verbNotifier instanceof VerbNotifierExt) {
                bl = ((VerbNotifierExt)verbNotifier).foundVerb(verb);
            }
            if (bl) {
                this.tm.ungetToken();
                if (!verbNotifier.foundVerb(verb.getKeyWord(), this.tm.getToken(), this.tm.getLastRemovedToken())) {
                    throw new EndOfProgramException();
                }
            }
        }
    }

    public Block[] getCatchBlocks() {
        Block[] blockArray = new Block[this.catchBlocks.size()];
        this.catchBlocks.toArray(blockArray);
        return blockArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parse(int n2) throws GeneralErrorException, EndOfProgramException {
        CobolToken cobolToken;
        block251: {
            cobolToken = null;
            boolean bl = false;
            this.nesting = n2;
            block225: while (true) {
                CobolToken cobolToken2;
                CobolToken cobolToken3;
                try {
                    cobolToken3 = this.tm.getToken();
                }
                catch (EndOfProgramException endOfProgramException) {
                    break block251;
                }
                if (((Token)cobolToken3).getToknum() != 10009 && ((Token)cobolToken3).getToknum() != 10002 && ((Token)cobolToken3).getToknum() != 10018) {
                    cobolToken = cobolToken3;
                    switch (((Token)cobolToken3).getToknum()) {
                        case 590: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Move((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 408: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Display((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 475: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Exhibit((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 402: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Destroy((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 524: {
                            bl = false;
                            try {
                                this.verbsAddItem(new If((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                                if (this.pc.getOption("-lfo") == null) continue block225;
                                while (cobolToken3 != null && ((Token)cobolToken3).getToknum() != 10006 && cobolToken3 != null && ((Token)cobolToken3).getToknum() != -102) {
                                    cobolToken3 = this.tm.getToken();
                                }
                                bl = false;
                            }
                            continue block225;
                        }
                        case 467: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Evaluate((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 743: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Stop((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 503: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Goto((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 504: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Goback((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 476: {
                            bl = false;
                            try {
                                cobolToken2 = new Exit((Token)cobolToken3, this, this.pc, this.tm, this.error);
                                if (!this.debug && ((Exit)cobolToken2).isExitPlain()) continue block225;
                                this.verbsAddItem((Verb)cobolToken2);
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 632: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Perform((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 613: {
                            bl = false;
                            try {
                                this.verbsAddItem(new On((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 544: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Invoke((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 313: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Call((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 314: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Cancel((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 321: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Chain((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 615: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Open((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 332: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Close((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 816: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Write((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 699: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Rewrite((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 666: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Read((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 741: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Start((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 397: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Delete((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 786: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Unlock((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 701: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Rollback((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 341: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Commit((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 581: 
                        case 732: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Sort((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 678: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Release((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 693: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Return((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 713: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Send((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 669: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Receive((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 809: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Wait((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 752: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Synchronized((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 457: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Entry((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 779: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Try((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 662: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Raise((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 282: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Assert((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 798: {
                            if (!this.pc.inDeclaratives) {
                                this.error.print(15, 4, (Token)cobolToken3, "<" + ((Token)cobolToken3).getWord() + ">");
                            }
                            bl = false;
                            try {
                                this.verbsAddItem(new Use((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 692: {
                            if (!this.pc.inDeclaratives) {
                                this.error.print(15, 4, (Token)cobolToken3, "<" + ((Token)cobolToken3).getWord() + ">");
                            }
                            bl = false;
                            try {
                                this.verbsAddItem(new Resume((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 10006: {
                            if (bl) {
                                bl = false;
                            }
                            if (this.nesting != 0) {
                                this.tm.ungetToken();
                                this.pc.popBlock();
                                return;
                            }
                            if (this.ns == null) continue block225;
                            this.verbsAddItem(this.ns.getEnd());
                            this.ns = null;
                            continue block225;
                        }
                        case 422: {
                            if (this.pc instanceof CobolMethod) {
                                this.tm.ungetToken();
                                this.pc.popBlock();
                                return;
                            }
                            if (!this.pc.inDeclaratives) {
                                cobolToken2 = cobolToken3;
                                cobolToken3 = this.tm.getToken();
                                if (cobolToken3 != null && ((Token)cobolToken3).getToknum() != 653) {
                                    this.tm.ungetToken();
                                    cobolToken3 = cobolToken2;
                                    this.error.print(15, 4, (Token)cobolToken3, "<" + ((Token)cobolToken3).getWord() + ">");
                                    continue block225;
                                }
                                cobolToken3 = this.tm.getToken();
                                if (cobolToken3 != null && (((Token)cobolToken3).getToknum() == 10009 || ((Token)cobolToken3).getToknum() == 10001)) {
                                    cobolToken3 = this.tm.getToken();
                                }
                                if (cobolToken3 == null || ((Token)cobolToken3).getToknum() == 10006) continue block225;
                                this.tm.ungetToken();
                                continue block225;
                            }
                            this.pc.popBlock();
                            return;
                        }
                        case 315: 
                        case 417: 
                        case 423: 
                        case 424: 
                        case 425: 
                        case 426: 
                        case 427: 
                        case 428: 
                        case 429: 
                        case 430: 
                        case 431: 
                        case 433: 
                        case 434: 
                        case 435: 
                        case 436: 
                        case 437: 
                        case 438: 
                        case 440: 
                        case 441: 
                        case 442: 
                        case 443: 
                        case 444: 
                        case 445: 
                        case 446: 
                        case 447: 
                        case 448: 
                        case 449: 
                        case 450: 
                        case 451: 
                        case 452: 
                        case 453: 
                        case 454: 
                        case 455: 
                        case 488: 
                        case 598: 
                        case 622: 
                        case 810: {
                            if (bl) {
                                bl = false;
                            }
                            if (this.nesting != 0) {
                                this.tm.ungetToken();
                                this.pc.popBlock();
                                return;
                            }
                            this.error.print(45, 4, (Token)cobolToken3, "<" + ((Token)cobolToken3).getWord() + ">");
                        }
                        case 372: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Continue((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 258: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Add((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 746: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Subtract((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 272: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Alter((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 592: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Multiply((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 409: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Divide((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 366: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Compute((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 532: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Initialize((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 744: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Strings((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 790: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Unstring((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 537: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Inspect((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 470: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Examine((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 778: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Transform((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 667: 
                        case 689: {
                            bl = false;
                            cobolToken3 = this.tm.getToken();
                            if (((Token)cobolToken3).getWord().equals("TRACE")) {
                                try {
                                    this.verbsAddItem(new Continue((Token)cobolToken3, this, this.pc, this.tm, this.error));
                                }
                                catch (GeneralErrorException generalErrorException) {
                                    bl = true;
                                }
                                continue block225;
                            }
                            this.error.print(15, 4, (Token)cobolToken3, "<" + ((Token)cobolToken3).getWord() + ">");
                            continue block225;
                        }
                        case 708: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Search((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 719: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Set((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 256: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Accept((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 589: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Modify((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 536: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Inquire((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 819: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Yield((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 599: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Note((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 474: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Exec((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 718: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Service((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 33: 
                        case 595: {
                            if (this.nextSentAllowed) {
                                if (this.tm.getToken().getToknum() == 714) {
                                    bl = false;
                                    this.verbsAddItem(new NextSentence((Token)cobolToken3, this, this.pc, this.tm, this.error));
                                    continue block225;
                                }
                                this.tm.ungetToken();
                            }
                        }
                        case 533: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Initiate((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 759: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Terminate((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 501: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Generate((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 748: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Suppress((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 818: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Xml((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 546: {
                            bl = false;
                            try {
                                this.verbsAddItem(new Json((Token)cobolToken3, this, this.pc, this.tm, this.error));
                            }
                            catch (GeneralErrorException generalErrorException) {
                                bl = true;
                            }
                            continue block225;
                        }
                        case 521: 
                        case 522: {
                            throw new GeneralErrorException(19, 4, (Token)cobolToken3, "", this.error);
                        }
                        case 1: {
                            bl = false;
                            continue block225;
                        }
                    }
                    if (bl) continue;
                    this.error.print(15, 4, (Token)cobolToken3, "<" + ((Token)cobolToken3).getWord() + ">");
                    continue;
                }
                if (((Token)cobolToken3).getToknum() == 10009 || ((Token)cobolToken3).getToknum() == 10018) {
                    Object object;
                    cobolToken2 = null;
                    if (((Token)cobolToken3).getToknum() == 10009) {
                        Token token = this.tm.getToken();
                        this.tm.ungetToken();
                        if (token.getToknum() == 10018) {
                            this.tm.ungetToken();
                            cobolToken2 = VariableName.getAny(this.tm, this.error, this, this.pc);
                        } else if (token.getToknum() == 40) {
                            object = this.tm.getMarker();
                            this.tm.setMarker((TokenManager.Marker)object);
                            this.tm.ungetToken();
                            boolean bl2 = this.error.ignoreErrors;
                            try {
                                this.error.ignoreErrors = true;
                                cobolToken2 = VariableName.getAny(this.tm, this.error, this, this.pc);
                            }
                            catch (GeneralErrorException generalErrorException) {
                                this.tm.rewindToMarker((TokenManager.Marker)object);
                            }
                            catch (EndOfProgramException endOfProgramException) {
                                this.tm.rewindToMarker((TokenManager.Marker)object);
                            }
                            finally {
                                this.error.ignoreErrors = bl2;
                            }
                        }
                    } else {
                        this.tm.ungetToken();
                        cobolToken2 = VariableName.getAny(this.tm, this.error, this, this.pc);
                    }
                    if (cobolToken2 != null) {
                        object = ((VariableName)cobolToken2).getVarDecl();
                        if (object instanceof InlineInvoke) {
                            Invoke invoke = ((InlineInvoke)object).getInvoke();
                            invoke.unsetInLine();
                            this.verbsAddItem(invoke);
                        } else {
                            this.error.print(81, 4, (Token)cobolToken3, ((VariableDeclaration)object).name.getWord());
                        }
                        cobolToken = cobolToken3;
                        continue;
                    }
                }
                if (!bl) break;
            }
            this.tm.ungetToken();
        }
        if (cobolToken != null) {
            switch (cobolToken.getToknum()) {
                case 476: {
                    this.error.print(188, 3, (Token)cobolToken, "");
                    break;
                }
                case 10006: {
                    break;
                }
                default: {
                    this.error.print(13, 4, (Token)cobolToken, "");
                }
            }
        }
        this.pc.popBlock();
    }

    public static void resetCounters() {
        prog = 0;
    }

    public void check() {
        Verb verb = this.verbs.getFirst();
        while (verb != null) {
            try {
                verb.check();
            }
            catch (GeneralErrorException generalErrorException) {
                // empty catch block
            }
            verb = this.verbs.getNext();
        }
        if (!(!this.endRequired || this.parentVerb == null || this.parentVerb.endStmt || this.parentVerb instanceof Invoke && ((Invoke)this.parentVerb).lambdaExpr)) {
            this.error.print(154, 3, this.parentVerb.getKeyWord(), Block.getEndKeyWord(this.parentVerb.getKeyWord().getToknum()));
        }
    }

    private static String getEndKeyWord(int n2) {
        switch (n2) {
            case 256: {
                return "END-ACCEPT";
            }
            case 258: {
                return "END-ADD";
            }
            case 313: {
                return "END-CALL";
            }
            case 321: {
                return "END-CHAIN";
            }
            case 366: {
                return "END-COMPUTE";
            }
            case 397: {
                return "END-DELETE";
            }
            case 408: {
                return "END-DISPLAY";
            }
            case 409: {
                return "END-DIVIDE";
            }
            case 467: {
                return "END-EVALUATE";
            }
            case 474: {
                return "END-EXEC";
            }
            case 524: {
                return "END-IF";
            }
            case 544: {
                return "END-INVOKE";
            }
            case 546: {
                return "END-JSON";
            }
            case 589: {
                return "END-MODIFY";
            }
            case 590: {
                return "END-MOVE";
            }
            case 592: {
                return "END-MULTIPLY";
            }
            case 632: {
                return "END-PERFORM";
            }
            case 666: {
                return "END-READ";
            }
            case 669: {
                return "END-RECEIVE";
            }
            case 693: {
                return "END-RETURN";
            }
            case 699: {
                return "END-REWRITE";
            }
            case 708: {
                return "END-SEARCH";
            }
            case 719: {
                return "END-SET";
            }
            case 741: {
                return "END-START";
            }
            case 744: {
                return "END-STRING";
            }
            case 746: {
                return "END-SUBTRACT";
            }
            case 752: {
                return "END-SYNCHRONIZED";
            }
            case 779: {
                return "END-TRY";
            }
            case 790: {
                return "END-UNSTRING";
            }
            case 809: {
                return "END-WAIT";
            }
            case 816: {
                return "END-WRITE";
            }
            case 818: {
                return "END-XML";
            }
        }
        return "END-";
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean getNotClosedCode(StringBuffer stringBuffer) {
        if (this.name != null) {
            stringBuffer.append(this.name + ":");
        }
        stringBuffer.append("{" + eol);
        if (this.isExceptionBlock()) {
            stringBuffer.append(this.getIndent());
            stringBuffer.append(Verb.getExceptionObject(this.pc.capitalizeNames));
            stringBuffer.append(" = ");
            stringBuffer.append(this.getParentExceptName());
            stringBuffer.append(";");
            stringBuffer.append(eol);
        }
        int n2 = 0;
        if (this.parentSuObj != null && this.parentSuObj.getDeferredMethodId() != 0) {
            n2 = this.parentSuObj.getDeferredMethodId();
        } else if (this.parentVerb != null) {
            n2 = this.parentVerb.getDeferredMethodId();
        } else if (this.verbs.getFirst() != null) {
            n2 = this.verbs.getFirst().getDeferredMethodId();
        }
        int n3 = 0;
        Verb verb = this.verbs.getFirst();
        while (verb != null) {
            if (this.parent.getParagraphCodeLimit() > 0) {
                if (verb.getDeferredMethodId() != n2) {
                    if (!(verb instanceof NextSentenceBlock)) {
                        DeferredBlock deferredBlock = this.parent.getDeferredBlock(verb.getDeferredMethodId());
                        deferredBlock.setVerbs(this.verbs, n3);
                        this.parent.deferredBlockList.add(deferredBlock);
                        stringBuffer.append(deferredBlock.getCallCode(n2, this.debug, this.pt0_2) + eol);
                        return false;
                    }
                    stringBuffer.append(verb.getCode());
                } else {
                    DeferredBlock.setNextSentenceDeferredMethodName(verb, this.getParent(), n2);
                    stringBuffer.append(verb.getCode());
                }
            } else {
                stringBuffer.append(this.tm.getCommentCode(verb.getKeyWord(), this.getIndent()));
                stringBuffer.append(verb.getCode());
            }
            verb = this.verbs.getNext();
            ++n3;
        }
        return true;
    }

    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        this.getNotClosedCode(stringBuffer);
        if (this.nesting == 0) {
            stringBuffer.append(this.getIndent());
            stringBuffer.append("return 0;");
            stringBuffer.append(eol);
        }
        --this.nesting;
        stringBuffer.append(this.getIndent() + "}");
        ++this.nesting;
        return stringBuffer.toString();
    }

    public String getExitPerformCycle() {
        if (this.loop) {
            if (this.name == null) {
                return "if (true) continue;";
            }
            return "if (true) break " + this.name + ";";
        }
        if (this.pb == null) {
            return "if (true) continue;";
        }
        return this.pb.getExitPerformCycle();
    }

    @Override
    public String getExceptName() {
        if (this.exceptName == null) {
            this.exceptName = EXCEPT_NAME + this.nesting;
        }
        return this.exceptName;
    }

    public String getParentExceptName() {
        return EXCEPT_NAME + (this.nesting - 1);
    }

    @Override
    public boolean isExceptionBlock() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.verbs == null || this.verbs.getItemNum() == 0;
    }

    @Override
    public boolean isParagraphBlock() {
        return this.paragraphBlock;
    }

    public void setParagraphBlock(boolean bl) {
        this.paragraphBlock = bl;
    }

    public boolean isCaughtExcpt(MyClass myClass) {
        for (int i2 = 0; i2 < this.catchBlocks.size(); ++i2) {
            BlockException blockException = (BlockException)this.catchBlocks.elementAt(i2);
            if (blockException.excpt.isAssignableFrom(myClass)) {
                blockException.someoneRaises = true;
                return true;
            }
            if (!blockException.excpt.isAssignableTo(myClass)) continue;
            blockException.someoneRaises = true;
        }
        if (this.raising != null) {
            VariableName variableName = this.raising.getFirst();
            while (variableName != null) {
                if (variableName.getType().isAssignableFrom(myClass)) {
                    return true;
                }
                variableName = this.raising.getNext();
            }
        }
        if (this.pb != null) {
            return this.pb.isCaughtExcpt(myClass);
        }
        return false;
    }

    public void setCatchBlock(BlockException blockException) {
        this.catchBlocks.addElement(blockException);
    }

    public void setRaising(VariableNameList variableNameList) {
        this.raising = variableNameList;
    }

    public NextSentenceBlock getNextSentenceBlock(Token token) {
        if (this.pb == null) {
            if (this.ns == null) {
                this.ns = new NextSentenceBlock(token, this, this.pc, this.tm, this.error);
            }
            return this.ns;
        }
        return this.pb.getNextSentenceBlock(token);
    }

    @Override
    public VerbList getVerbs() {
        return this.verbs;
    }

    @Override
    public Paragraph getParent() {
        return this.parent;
    }

    @Override
    public Verb getParentVerb() {
        return this.parentVerb;
    }
}

